/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.sip;

import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMediaServer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMediaServerInfoShared;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMsMonitorServlet;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSessionFactory;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcMsMonitor
implements Serializable {
    static Long MAX_ALLOWED_TIMER_STALE_TIME = 20000L;
    static Long MONITOR_TIMER_INSTANCE_ID = 0L;
    private static final long serialVersionUID = 1L;
    private static int timerInterval = 5000;
    private static int timerIntervalOffset = 0;
    private ReentrantLock accessLock;
    private static boolean isStarted = false;
    private static Integer activeMediaServerIndex;
    private static Integer mediaServerCount;
    private static DlgcSessionFactory sessionFactory;
    private static final String mediaServerDisplayName;
    public static Map<Integer, DlgcMediaServer> MediaServerMap;
    private static Logger log;
    static DlgcMsMonitorServlet monitorServlet;
    static String redundancyTurnOn;

    public DlgcMsMonitor(Properties properties, DlgcMsMonitorServlet mservlet) {
        log.debug("Entering DlgcMsMonitor");
        isStarted = false;
        mediaServerCount = 0;
        sessionFactory = null;
        MediaServerMap = new Hashtable<Integer, DlgcMediaServer>();
        this.accessLock = new ReentrantLock();
        monitorServlet = mservlet;
        MONITOR_TIMER_INSTANCE_ID = System.currentTimeMillis();
        log.debug("DlgcMsMonitor:: MONITOR TIMER INSTANCE ID: " + MONITOR_TIMER_INSTANCE_ID);
        sessionFactory = new DlgcSessionFactory(properties, DlgcMsMonitorServlet.getInstance());
        activeMediaServerIndex = 0;
        if (DlgcMsMonitorServlet.bDynamicConnectorConfiguration) {
            log.debug("DlgcMonitor CTOR .. in configuration mode...");
            return;
        }
        String myApplicationServerAddress = properties.getProperty("connector.sip.address");
        String mediaServerCountValue = properties.getProperty("mediaserver.count");
        if (mediaServerCountValue != null) {
            mediaServerCount = Integer.valueOf(mediaServerCountValue);
        }
        log.debug("DlgcMsMonitor got mediaServerCount property");
        String s = properties.getProperty("mediaserver.redundancy.check.interval");
        if (s != null) {
            timerInterval = Integer.valueOf(s);
        }
        String clockCyclePropVal = properties.getProperty("mediaserver.redundancy.nonprimary.discover.clock.cycle");
        Integer clockCycle = 1;
        if (clockCyclePropVal != null) {
            clockCycle = new Integer(clockCyclePropVal);
        }
        log.debug("mediaserver.redundancy.nonprimary.discover.clock.cycle set to: " + clockCycle.toString());
        SipFactory sipFactory = DlgcMsMonitorServlet.getSipFactory();
        int msIndex = 0;
        log.debug("mediaServerCount= " + mediaServerCount);
        DlgcMediaServer primaryMS = null;
        for (int i = 1; i <= mediaServerCount; ++i) {
            String msIpString = "mediaserver." + i + ".sip.address";
            String msPortString = "mediaserver." + i + ".sip.port";
            String msIp = properties.getProperty(msIpString);
            if (msIp != null) {
                Integer msPort = 5060;
                String msPortValue = properties.getProperty(msPortString);
                if (msPortValue != null) {
                    msPort = (int)Integer.valueOf(msPortValue);
                } else {
                    log.debug("Media Server Port not defined in property file...SIP port is defaulted to 5060");
                }
                SipApplicationSession sas = sipFactory.createApplicationSession();
                DlgcIpmsSession ses = sessionFactory.createSession(msIp, msPort, "Monitor", mediaServerDisplayName, sas);
                try {
                    DlgcMediaServer ms = new DlgcMediaServer(ses, this, ++msIndex, myApplicationServerAddress, false, false);
                    log.debug(">>>>>>>>>> DlgcMediaServer - Monitoring Media Server: " + msIp.toString() + " :" + msPort.toString());
                    ms.clockCycle = clockCycle;
                    if (msIndex == 1) {
                        primaryMS = ms;
                    }
                    MediaServerMap.put(msIndex, ms);
                }
                catch (Exception ex) {
                    log.debug("Exception ex " + ex.toString());
                    ex.printStackTrace();
                }
            } else {
                log.debug("msIP = NULL");
            }
            log.debug("Leaving DlgcMsMonitor");
        }
        mediaServerCount = msIndex;
        if (mediaServerCount == 0) {
            redundancyTurnOn = "off";
            log.debug("No Media Server defined in property file.");
            return;
        }
        redundancyTurnOn = properties.getProperty("mediaserver.redundancy");
        if (redundancyTurnOn == null) {
            primaryMS.msStatus.isActive = true;
            primaryMS.msStatus.isAlive = true;
            activeMediaServerIndex = primaryMS.serverIndex;
        } else if (redundancyTurnOn.compareToIgnoreCase("off") == 0) {
            primaryMS.msStatus.isActive = true;
            primaryMS.msStatus.isAlive = true;
            activeMediaServerIndex = primaryMS.serverIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DlgcMediaServer getActiveMediaServer() {
        DlgcMediaServer ms = null;
        try {
            this.accessLock.lock();
            log.debug("getActiveMediaServer activeMediaServerIndex is " + activeMediaServerIndex.toString());
            ms = MediaServerMap.get(activeMediaServerIndex);
            log.debug("getActiveMediaServer returning active media server with ipAddress:" + ms.sMediaServerIP + " ms.serverIndex: " + new Integer(ms.serverIndex).toString());
        }
        catch (Exception e) {
            log.error("getActiveMediaServer:: could get lock - " + e.toString());
        }
        finally {
            this.accessLock.unlock();
        }
        return ms;
    }

    public DlgcMediaServer getActiveMediaServerNoLock() {
        DlgcMediaServer ms = null;
        try {
            ms = MediaServerMap.get(activeMediaServerIndex);
        }
        catch (Exception e) {
            log.error("getActiveMediaServer:: could get lock - " + e.toString());
        }
        return ms;
    }

    public DlgcMediaServerInfoShared getMediaServerServerInfo(int index) {
        DlgcMediaServer ms = null;
        DlgcMediaServerInfoShared minfo = null;
        try {
            ms = MediaServerMap.get(index);
            minfo = ms.infoShared;
        }
        catch (Exception e) {
            log.error("getActiveMediaServer:: could get lock - " + e.toString());
        }
        return minfo;
    }

    public DlgcMediaServerInfoShared setAssociatedComponent(int index, String key, DlgcSipConnectorContentIdsProxy val) {
        DlgcMediaServer ms = null;
        DlgcMediaServerInfoShared minfo = null;
        try {
            ms = MediaServerMap.get(index);
            ms.infoShared.associatedContainer.put(key, val);
            log.debug("setAssociatedComponent Count after settting: " + ms.infoShared.associatedContainer.size());
        }
        catch (Exception e) {
            log.error("getActiveMediaServer:: could get lock - " + e.toString());
        }
        return minfo;
    }

    public void removeAssociatedComponent(int index, String key) {
        DlgcMediaServer ms = null;
        try {
            ms = MediaServerMap.get(index);
            ms.infoShared.associatedContainer.remove(key);
            log.debug("removeAssociatedComponent Count after removal: " + ms.infoShared.associatedContainer.size());
        }
        catch (Exception e) {
            log.error("getActiveMediaServer:: could get lock - " + e.toString());
        }
    }

    public int getAssociatedContainerCount(int index) {
        DlgcMediaServer ms = null;
        int cnt = -1;
        try {
            ms = MediaServerMap.get(index);
            cnt = ms.infoShared.associatedContainer.size();
            log.debug("removeAssociatedComponent Count after removal: " + cnt);
        }
        catch (Exception e) {
            log.error("getActiveMediaServer:: could get lock - " + e.toString());
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectNewActiveServerBecauseRemove(DlgcMediaServer serverNotAlive) {
        boolean msFound = false;
        try {
            this.accessLock.lock();
            log.debug("Entering selectNewActiveServerBecauseRemove of serverNotAlive::msIP: " + serverNotAlive.sMediaServerIP + " serverNotAlive:msID: " + serverNotAlive.serverIndex);
            for (int i = 0; i < mediaServerCount; ++i) {
                int nextMS = i % mediaServerCount + 1;
                if (nextMS != serverNotAlive.serverIndex) {
                    DlgcMediaServer msNextCandidate = MediaServerMap.get(nextMS);
                    if (!msNextCandidate.msStatus.isAlive) continue;
                    DlgcMsMonitor.MediaServerMap.get((Object)Integer.valueOf((int)msNextCandidate.serverIndex)).msStatus.isActive = true;
                    activeMediaServerIndex = msNextCandidate.serverIndex;
                    log.debug("Entering selectNewActiveServerBecauseRemove msNextCandidate.isActive to true for msNextCandidate::msIP: " + msNextCandidate.sMediaServerIP + " msNextCandidate:msID: " + msNextCandidate.serverIndex);
                    log.debug("selectNewActiveServerBecauseRemove: setting overall Monitor activeMediaServerIndex from msNextCandidate:msIP: " + msNextCandidate.sMediaServerIP + " msNextCandidate:msID: " + msNextCandidate.serverIndex);
                    msFound = true;
                    break;
                }
                msFound = false;
            }
        }
        catch (Exception e) {
            log.error("selectNewActiveServer:: could access  lock - " + e.toString());
        }
        finally {
            if (!msFound) {
                activeMediaServerIndex = 0;
            }
            log.debug("Leaving selectNewActiveServerBecauseRemove of serverNotAlive::msIP: " + serverNotAlive.sMediaServerIP + " serverNotAlive:msID: " + serverNotAlive.serverIndex);
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectNewActiveServerBecauseFoundAlive(DlgcMediaServer serverAlive) {
        DlgcMediaServer activeMS = null;
        try {
            this.accessLock.lock();
            log.debug("Entering selectNewActiveServerBecauseFoundAlive - serverAlive::msIP: " + serverAlive.sMediaServerIP + " serverAlive:msID: " + serverAlive.serverIndex);
            for (int i = 0; i < mediaServerCount; ++i) {
                int nextMS = i % mediaServerCount + 1;
                DlgcMediaServer msNextCandidate = MediaServerMap.get(nextMS);
                if (!msNextCandidate.msStatus.isActive) continue;
                activeMS = msNextCandidate;
                log.debug("selectNewActiveServerBecauseFoundAlive: found activeMS msIP: " + activeMS.sMediaServerIP + " msID: " + activeMS.serverIndex);
                break;
            }
            if (activeMS == null) {
                log.debug("selectNewActiveServerBecauseFoundAlive: activeMS == null..no active media server found selecting  msIP: " + serverAlive.sMediaServerIP + " msID: " + serverAlive.serverIndex);
                serverAlive.msStatus.isActive = true;
                activeMediaServerIndex = serverAlive.serverIndex;
            } else if (activeMS.serverIndex == serverAlive.serverIndex) {
                log.debug("selectNewActiveServerBecauseFoundAlive: nothing to change ... activeMS.serverIndex == serverAlive.serverIndex  msIP: " + serverAlive.sMediaServerIP + " msID: " + serverAlive.serverIndex);
            } else if (activeMS.serverIndex != serverAlive.serverIndex) {
                log.debug("selectNewActiveServerBecauseFoundAlive: nothing to change ...activeMS.serverIndex != serverAlive.serverIndex  msIP: " + activeMS.sMediaServerIP + " msID: " + activeMS.serverIndex);
            }
        }
        catch (Exception e) {
            log.error("selectNewActiveServer:: could access  lock - " + e.toString());
        }
        finally {
            log.debug("Leaving selectNewActiveServerBecauseFoundAlive - serverAlive::msIP: " + serverAlive.sMediaServerIP + " serverAlive:msID: " + serverAlive.serverIndex);
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromLiveState(Integer msID) {
        try {
            this.accessLock.lock();
            DlgcMediaServer ms = MediaServerMap.get(msID);
            log.debug("removeFromLiveState:: msIP: " + ms.myAppServerIP);
            ms.msStatus.isActive = false;
            ms.msStatus.isAlive = false;
            ms.aliveTransition = DlgcMediaServer.AliveTransitionEnum.AT_DOWN;
            this.selectNewActiveServerBecauseRemove(ms);
        }
        catch (Exception e) {
            log.error("removeFromLiveState:: could access  lock - " + e.toString());
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToAliveState(Integer msID) {
        try {
            this.accessLock.lock();
            log.debug("DlgcMsMonitor::setToAliveStatus MediaSession ID passed in: " + msID.toString());
            DlgcMediaServer ms = MediaServerMap.get(msID);
            ms.msStatus.isAlive = true;
            ms.aliveTransition = DlgcMediaServer.AliveTransitionEnum.AT_UP;
            log.debug("setToAliveState:: callin Test to see if selectNewActiveServerBecauseFoundAlive - msIP: " + ms.sMediaServerIP + " msID: " + msID.toString());
            this.selectNewActiveServerBecauseFoundAlive(ms);
        }
        catch (Exception e) {
            log.error("setToAliveState:: could access  lock - " + e.toString());
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAliveMapValue(Integer msID, boolean status) {
        try {
            this.accessLock.lock();
            log.debug("DlgcMsMonitor::setAliveMapValue MediaSession ID passed in: " + msID.toString());
            DlgcMediaServer ms = MediaServerMap.get(msID);
            log.debug("setAliveMapValue:: msIP: " + ms.sMediaServerIP);
            ms.msStatus.isAlive = status;
        }
        catch (Exception e) {
            log.error("setAliveMapValue:: could access  lock - " + e.toString());
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveMapValue(Integer msID, boolean status) {
        try {
            this.accessLock.lock();
            log.debug("DlgcMsMonitor::setActiveMapValue MediaSession ID passed in: " + msID.toString());
            DlgcMediaServer ms = MediaServerMap.get(msID);
            log.debug("setActiveMapValue:: msIP: " + ms.sMediaServerIP);
            ms.msStatus.isActive = status;
        }
        catch (Exception e) {
            log.error("setActiveMapValue:: could access  lock - " + e.toString());
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getActiveAndAliveMapValues(Integer msID, DlgcMediaServer.DlgcMediaServerStatus msStatus) {
        try {
            this.accessLock.lock();
            log.debug("DlgcMsMonitor::getActiveAndAliveMapValues MediaSession ID passed in: " + msID.toString());
            DlgcMediaServer ms = MediaServerMap.get(msID);
            log.debug("getActiveMapValues:: msIP: " + ms.sMediaServerIP);
            msStatus.isActive = ms.msStatus.isActive;
            msStatus.isAlive = ms.msStatus.isAlive;
        }
        catch (Exception e) {
            log.error("getActiveMapValues:: could access  lock - " + e.toString());
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAliveAndActiveMapValues(Integer msID, DlgcMediaServer.DlgcMediaServerStatus msStatus) {
        try {
            this.accessLock.lock();
            log.debug("DlgcMsMonitor::setAliveAndActiveMapValues MediaSession ID passed in: " + msID.toString());
            DlgcMediaServer ms = MediaServerMap.get(msID);
            log.debug("setAliveAndActiveMapValues:: msIP: " + ms.sMediaServerIP);
            ms.msStatus.isAlive = msStatus.isAlive;
            ms.msStatus.isActive = msStatus.isActive;
        }
        catch (Exception e) {
            log.error("setAliveAndActiveMapValues:: could access  lock - " + e.toString());
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMediaServerMap(String from, String msName) {
        try {
            this.accessLock.lock();
            log.debug("------------------------------ Media Server MAP DUMP initiated by " + from + "for media server: " + msName + " ------------------------------------------");
            DlgcMediaServer ms = null;
            for (int i = 1; i <= mediaServerCount; ++i) {
                ms = MediaServerMap.get(i);
                log.debug("MS number: " + ms.serverIndex + " isAlive: " + ms.msStatus.isAlive + " isActive: " + ms.msStatus.isActive + " IP: " + ms.sMediaServerIP);
            }
        }
        catch (Exception e) {
            log.error("isAnyMediaServerActive:: could access  lock - " + e.toString());
        }
        finally {
            log.debug("------------------------------         END           ------------------------------------------");
            this.accessLock.unlock();
        }
    }

    public void startMediaServers() {
        log.debug("Entering DlgcMsMonitor::startMediaServers");
        if (redundancyTurnOn.compareToIgnoreCase("on") == 0) {
            log.debug("Media Server Redeundancy is turned on...Starting Media Server(s) Polling Timers.");
            this.start();
        } else {
            log.debug("Media Server Redeundancy is turned off...Not Starting Media Server(s) Polling Timers.");
        }
        log.debug("Leaving DlgcMsMonitor::startMediaServers");
    }

    public void start() {
        log.debug("DlgcMsMonitor::start()::isStarted: " + new Boolean(isStarted).toString());
        if (!isStarted) {
            for (int i = 1; i <= mediaServerCount; ++i) {
                log.debug(">>>>>>>>>> DlgcMsMonitor::start() getting MediaServerMap[ " + i + " ]");
                DlgcMediaServer ms = MediaServerMap.get(i);
                if (ms == null) {
                    log.debug(">>>>>>>>>> DlgcMsMonitor::start() retrieved MediaServer is NULL");
                }
                if (i > 1) {
                    ms.adjustedInterval = timerInterval + timerIntervalOffset;
                    log.debug("Using Adjusted Timer Interval set to: " + ms.adjustedInterval);
                } else {
                    ms.adjustedInterval = timerInterval;
                    log.debug("Using Based Timer Interval set to: " + ms.adjustedInterval);
                }
                log.debug(">>>>>>>>>> STARTING REDUNDANCY TIMER AT INTERVAL OF " + new Integer(ms.adjustedInterval).toString() + " for Media Server: " + ms.sMediaServerIP + " ms.serverIndex = " + ms.serverIndex);
                SipApplicationSession sas = ms.getSAS();
                log.debug("Starting media Server: Id: " + ms.sMediaServerIP + " with SASId: " + sas.getId());
                ms.sendPingRequestAndStartTimer(null);
                log.debug("DlgcMsMonitor::start timers (initial condition) Media Server: " + ms.sMediaServerIP + " timerID: " + ms.timerId);
            }
            isStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCleanMediaServers() {
        DlgcMediaServer ms = null;
        try {
            this.accessLock.lock();
            Set<Map.Entry<Integer, DlgcMediaServer>> serverList = MediaServerMap.entrySet();
            if (serverList == null) {
                log.debug("DlgcMsMonitor::stopCleanMediaServers: server list found to be null skipping server cleanup.");
            } else {
                Iterator<Map.Entry<Integer, DlgcMediaServer>> it = serverList.iterator();
                if (it != null) {
                    while (it.hasNext()) {
                        Map.Entry<Integer, DlgcMediaServer> mapEntry = it.next();
                        if (mapEntry != null) {
                            ms = mapEntry.getValue();
                            if (ms != null) {
                                log.debug("DlgcMsMonitor::stopCleanMediaServers:  calling media server terminateCleanSession and cleanup(): " + ms.myAppServerIP + " " + ms.infoShared.serverName);
                                ms.terminateCleanSession();
                                ms.cleanup();
                                continue;
                            }
                            log.debug("DlgcMsMonitor::stopCleanMediaServers: media server found to be null skipping server cleanup.");
                            continue;
                        }
                        log.debug("DlgcMsMonitor::stopCleanMediaServers: mapEntry found to be null");
                    }
                } else {
                    log.debug("DlgcMsMonitorServlet::contextDestroyed: server list iterator found to be null skipping server cleanup.");
                }
            }
            log.debug("DlgcMsMonitorServlet::stopCleanMediaServers: clearing Media Server Map.");
            MediaServerMap = null;
        }
        catch (Exception e) {
            log.error("stopCleanMediaServers:: could access  lock - " + e.toString());
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.accessLock.lock();
            if (isStarted) {
                isStarted = false;
            }
        }
        catch (Exception e) {
            log.error("stop:: could access  lock - " + e.toString());
        }
        finally {
            this.accessLock.unlock();
        }
    }

    int getTimerInterval() {
        return timerInterval;
    }

    int getTimerIntervalOffset() {
        return timerIntervalOffset;
    }

    static {
        mediaServerDisplayName = new String("MediaServer");
        log = LoggerFactory.getLogger(DlgcMsMonitor.class);
        monitorServlet = null;
    }
}

