/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.sip;

import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapter;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMediaServerInfoShared;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMsMonitor;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMsMonitorServlet;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcServletTimer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSessionAttributeProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.resource.AllocationEvent;
import javax.media.mscontrol.resource.ResourceEvent;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcMediaServer
implements DlgcServletTimer {
    private static final long serialVersionUID = 1L;
    protected String msmlVal = null;
    protected boolean validUserNamePattern = false;
    private static final String IP_ADDR_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final String URI_PATTERN = "sip:([\\w=]+)\\@(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}):(\\d{1,7})";
    private DlgcIpmsSession ipmsSession = null;
    public String timerId = null;
    DlgcMediaServerStatus msStatus = null;
    int adjustedInterval = 5000;
    protected ETimerStatus timerStatus;
    protected AliveTransitionEnum aliveTransition;
    String mySasId = null;
    DlgcMediaServerInfoShared infoShared;
    public String sMediaServerIP;
    public Integer iMediaServerPort;
    String sASConnectorIP;
    Integer iASConnectorPort;
    int detectionDelay;
    int clockCycle;
    String userName;
    int groupLenFound;
    boolean dynamicConfigured;
    static DlgcMsMonitor myMonitor;
    int serverIndex = 0;
    String myAppServerIP = null;
    private static Logger log;

    public String getMsmlVal() {
        return this.msmlVal;
    }

    public void setMsmlVal(String msmlVal) {
        this.msmlVal = msmlVal;
    }

    public boolean isValidUserNamePattern() {
        return this.validUserNamePattern;
    }

    public DlgcMediaServer(DlgcIpmsSession session, DlgcMsMonitor msMonitor, int index, String myApplicationServerAddress, boolean alive, boolean active) {
        log.debug("DlgcMediaServer CTOR for SERVELET MODE");
        this.ipmsSession = session;
        this.timerStatus = ETimerStatus.T_INITIAL;
        this.dynamicConfigured = false;
        this.detectionDelay = 0;
        this.clockCycle = 1;
        this.mySasId = session.getMonitorAppSession().getId();
        myMonitor = msMonitor;
        this.serverIndex = index;
        this.msStatus = new DlgcMediaServerStatus(alive, active);
        String mediaServerLookupName = new String("DlgcMediaServer-") + new Integer(this.serverIndex);
        this.sMediaServerIP = session.getMediaServerIp();
        this.iMediaServerPort = session.getMediaServerPort();
        this.sASConnectorIP = null;
        this.iASConnectorPort = 5060;
        this.myAppServerIP = myApplicationServerAddress;
        this.infoShared = new DlgcMediaServerInfoShared(this.mySasId, index, mediaServerLookupName, this.sMediaServerIP);
        this.aliveTransition = AliveTransitionEnum.AT_INIT;
        this.userName = null;
        this.groupLenFound = 0;
    }

    public DlgcMediaServer(String mediaServerUri) {
        log.debug("DlgcMediaServer CTOR supporting MEDIA_SERVE_URI: " + mediaServerUri);
        Pattern testPattern = Pattern.compile(URI_PATTERN);
        Matcher testMatcher = testPattern.matcher(mediaServerUri);
        boolean USERNAME_GROUP = true;
        int IP_GROUP = 2;
        int PORT_GROUP = 3;
        this.sASConnectorIP = null;
        this.iASConnectorPort = 5060;
        this.dynamicConfigured = false;
        int i = 0;
        block0: while (testMatcher.find()) {
            this.groupLenFound = testMatcher.groupCount();
            if (this.groupLenFound != 0) {
                log.debug("DlgcMediaServer:CTOR::regex group: " + testMatcher.group().trim());
                log.debug("DlgcMediaServer:CTOR::regex groupLenFound " + new Integer(this.groupLenFound).toString());
            }
            for (i = 1; i <= this.groupLenFound; ++i) {
                String groupValue = testMatcher.group(i);
                if (groupValue != null) {
                    log.debug("DlgcMediaServer:CTOR::regex group(" + new Integer(i).toString() + ") = " + groupValue);
                    if (i == 1) {
                        this.userName = groupValue;
                        if (this.userName.contains("msml=")) {
                            log.debug("DlgcMediaServer:CTOR Valid Username contains msml= as username");
                            this.validUserNamePattern = true;
                            continue;
                        }
                        log.error("DlgcMediaServer:CTOR Invalid Username does not contain msml= as username");
                        this.validUserNamePattern = false;
                        continue;
                    }
                    if (i == 2) {
                        this.sMediaServerIP = groupValue;
                        continue;
                    }
                    if (i != 3) continue;
                    this.iMediaServerPort = (int)new Integer(groupValue);
                    continue;
                }
                log.debug("DlgcMediaServer:CTOR::regex group(" + new Integer(i).toString() + ") = NULL");
                continue block0;
            }
        }
        if (this.groupLenFound != 3) {
            log.debug("DlgcMediaServer:CTOR::regex Invalid MEDIA_SERVER_URI: Major error..aborting");
        } else {
            this.msmlVal = this.userName;
            log.debug("Setting msmlVal= " + this.msmlVal);
        }
    }

    public DlgcMediaServer(Properties props) {
        log.debug("DlgcMediaServer CTOR supporting Dynamic Configuration: ");
        this.dynamicConfigured = true;
        this.userName = "msml=";
        this.sMediaServerIP = props.getProperty("mediaserver.sip.ipaddress");
        String sport = props.getProperty("mediaserver.sip.port");
        this.iMediaServerPort = (int)new Integer(sport);
        this.sASConnectorIP = props.getProperty("connector.sip.address");
        this.iASConnectorPort = new Integer(props.getProperty("connector.sip.port"));
        this.msmlVal = this.userName;
        myMonitor = DlgcMsMonitorServlet.mediaServerMonitor;
        log.debug("DlgcMediaServer CTOR using the following XMS SIP Values:  username: " + this.userName + " Media Server IP: " + this.sMediaServerIP + " Media Server SIP Port: " + new Integer(this.iMediaServerPort).toString());
        log.debug("DlgcMediaServer CTOR using the following XMS Connector AS SIP Values: AS Server IP: " + this.sASConnectorIP + " Connector AS SIP Port: " + this.iASConnectorPort.toString());
        DlgcSipB2BUA.sessionFactory.setJmcIP(this.sASConnectorIP);
        DlgcSipB2BUA.sessionFactory.setJmcPort(this.iASConnectorPort);
    }

    public boolean isDynamicConfigured() {
        return this.dynamicConfigured;
    }

    public boolean is_MS_URI_DEFINED() {
        return this.groupLenFound == 3;
    }

    public Address getAddress() {
        return this.ipmsSession.getMediaServerAddress();
    }

    public Address getAddress(String user) {
        Address address = this.ipmsSession.getMediaServerAddress();
        ((SipURI)address.getURI()).setUser(user);
        return address;
    }

    public void setAliveFlag(boolean bAlive) {
        myMonitor.setAliveMapValue(this.serverIndex, bAlive);
    }

    public void setActiveFlag(boolean bActive) {
        myMonitor.setActiveMapValue(this.serverIndex, bActive);
    }

    public synchronized void processResponse(SipServletResponse resp) {
        log.debug("DlgcMediaServer::processResponse():: this media Server with ipAddress: " + this.sMediaServerIP + " and serverIndex: " + this.serverIndex);
        if (this.myAppServerIP == null) {
            log.debug("DlgcMediaServer::processResponse() -> myAppServerIP is null");
        } else {
            log.debug("DlgcMediaServer::processResponse() -> myAppServerIP is :" + this.myAppServerIP);
        }
        if (this.myAppServerIP.compareToIgnoreCase(this.myAppServerIP) != 0) {
            log.debug("DlgcMediaServer::processResponse():: Terminating 3 - Ignore... " + this.sMediaServerIP + " having originated from " + this.myAppServerIP);
            return;
        }
        int respStatus = 0;
        try {
            respStatus = resp.getStatus();
            String responseMethod = resp.getRequest().getMethod();
            log.debug("DlgcMediaServer::processResponse():: sip response: " + new Integer(respStatus).toString());
            log.debug("DlgcMediaServer::processResponse():: sip response: " + resp.toString());
            log.debug("DlgcMediaServer::processResponse():: sip response:request:method: " + responseMethod);
            log.debug("DlgcMediaServer::processResponse():: This Media Server Index " + new Integer(this.serverIndex).toString());
            if (responseMethod.compareToIgnoreCase("OPTIONS") == 0) {
                log.debug("DlgcMediaServer::processResponse():: Received ping response with status: " + new Integer(respStatus).toString() + " for Media Server: " + this.sMediaServerIP);
                if (respStatus == 200) {
                    log.debug("DlgcMediaServer::processResponse():: DlgcMediaServer:processResponse Got OPTION Response 200 OK");
                    this.timerStatus = ETimerStatus.T_200_OK;
                    this.aliveTransition = AliveTransitionEnum.AT_UP;
                    myMonitor.setToAliveState(this.serverIndex);
                    log.debug("DlgcMediaServer::processResponse():: MEDIA SERVER : " + this.sMediaServerIP + " is ALIVE " + " origin: " + this.myAppServerIP);
                } else {
                    this.timerStatus = ETimerStatus.T_ERROR;
                    log.debug("DlgcMediaServer::processResponse():: Received Option response error status: " + new Integer(respStatus).toString() + " for Media Server: " + this.sMediaServerIP);
                    this.aliveTransition = AliveTransitionEnum.AT_DOWN;
                    myMonitor.removeFromLiveState(this.serverIndex);
                    log.debug("DlgcMediaServer::processResponse():: MediaServer DOWN: " + this.sMediaServerIP);
                }
            } else {
                this.timerStatus = ETimerStatus.T_200_OK;
                this.aliveTransition = AliveTransitionEnum.AT_UP;
                myMonitor.setToAliveState(this.serverIndex);
                log.debug("DlgcMediaServer::processResponse()::T_ERROR: 12-17 Received Invalid response method expecting Option response - error status: " + new Integer(respStatus).toString() + " for Media Server: " + this.sMediaServerIP + " Response Method: " + responseMethod);
                log.debug("DlgcMediaServer::processResponse():: T_ERROR: MediaServer DOWN: " + this.sMediaServerIP);
                log.debug("DlgcMediaServer::processResponse():: sip response: " + resp.toString());
                log.debug("DlgcMediaServer::processResponse():: sip response:request: " + resp.getRequest().toString());
                log.debug("DlgcMediaServer::processResponse():: sip response:request:method " + resp.getRequest().getMethod());
            }
        }
        catch (Exception e) {
            log.debug("DlgcMediaServer::processResponse():: DlgcMediaServer:processResponse exception: " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void processTimeout(ServletTimer timer) {
        try {
            String timerID = timer.getId();
            SipApplicationSession timerSAS = timer.getApplicationSession();
            Long timerInstanceID = (Long)timerSAS.getAttribute(timerID);
            log.debug("Entering processTimeout: MediaServer: " + this.sMediaServerIP + " timerId: " + timerID);
            log.debug("TimerSAS: ID: " + timerSAS.getId());
            SipApplicationSession thisSAS = this.infoShared.retrieveSAS();
            log.debug("infoShared SAS: ID: " + this.infoShared.sasId);
            if (timerInstanceID.compareTo(DlgcMsMonitor.MONITOR_TIMER_INSTANCE_ID) != 0) {
                log.debug("processTimeout -> receive timer stale timer.. assuming this timer is a left over...ignoring it...returning:  MediaServer: " + this.sMediaServerIP);
                log.debug("processTimeout -> received Timer Instance ID  : " + timerInstanceID.toString());
                log.debug("processTimeout -> present Timer Instance ID : " + DlgcMsMonitor.MONITOR_TIMER_INSTANCE_ID.toString());
                return;
            }
            log.debug("processTimeout -> Accepting this Timer Instance ID  : " + timerInstanceID.toString());
            SipSession mySipSession = this.infoShared.retrieveSipSession();
            if (mySipSession == null) {
                log.debug("processTimeout -> SIPSESSION was found to be NULL MediaServer: " + this.sMediaServerIP);
            } else {
                log.debug("processTimeout -> SIPSESSION was found  MediaServer: " + this.sMediaServerIP + " SipSessinId: " + mySipSession.getId());
            }
            log.debug("[ Enter DlgcMediaServer:processTimeout timerID: ] " + timerID + " Media Server: " + this.sMediaServerIP);
            if (this.myAppServerIP == null) {
                log.debug("processTimeout -> myAppServerIP is null MediaServer: " + this.sMediaServerIP);
            } else {
                log.debug("processTimeout -> myAppServerIP is :" + this.myAppServerIP + " MediaServer: " + this.sMediaServerIP);
            }
            log.debug("processTimeout Timer Request initiated from this Engine: Media Server: " + this.sMediaServerIP + " removing timerID: " + timer.getId());
            if (this.timerStatus == ETimerStatus.T_INITIAL) {
                if (this.serverIndex > 1 && this.detectionDelay <= this.clockCycle) {
                    log.debug("processTimeout:: calling sendStartTimer() still based on ETimerStatus.T_INITIAL... delaying detection to non-primary MRB");
                    ++this.detectionDelay;
                    this.sendStartTimer();
                } else {
                    this.timerStatus = ETimerStatus.T_PINGING;
                    log.debug("processTimeout:: calling sendPingRequestAndStartTimer() based on ETimerStatus.T_INITIAL");
                    this.sendPingRequestAndStartTimer(null);
                }
            } else if (this.timerStatus == ETimerStatus.T_PINGING) {
                myMonitor.logMediaServerMap("DlgcMediaServer::ProcessTimeout()", this.sMediaServerIP);
                log.debug("processTimeout:: call handleTimeoutPingErrorCondition() based on ETimerStatus.T_PINGING - still wait from ping when this timeout happened.");
                this.handleTimeoutPingErrorCondition(mySipSession);
            } else if (this.timerStatus == ETimerStatus.T_200_OK) {
                myMonitor.logMediaServerMap("DlgcMediaServer::ProcessTimeout()", this.sMediaServerIP);
                this.timerStatus = ETimerStatus.T_PINGING;
                log.debug("processTimeout:: Pinged was previously received - calling sendPingRequestAndStartTimer() based on ETimerStatus.T_200_OK");
                this.sendPingRequestAndStartTimer(mySipSession);
            } else {
                myMonitor.logMediaServerMap("DlgcMediaServer::ProcessTimeout()", this.sMediaServerIP);
                log.debug("processTimeout:: call handleTimeoutPingErrorCondition() based on else");
                this.handleTimeoutPingErrorCondition(mySipSession);
            }
        }
        catch (Exception e) {
            log.error("Failed to process SIP request: ", (Throwable)e);
        }
    }

    protected void handleTimeoutPingErrorCondition(SipSession mySipSession) {
        if (mySipSession == null) {
            log.debug("handleTimeoutPingErrorCondition:: media session SIPSESSION NULL...ignoring invalidation ping request for Media Server: " + this.myAppServerIP);
        } else {
            log.debug("handleTimeoutPingErrorCondition:: media session SIPSESSION INVALIDATING ping request for Media Server: " + this.sMediaServerIP + " SipSessionId: " + mySipSession.getId());
            try {
                mySipSession.invalidate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.infoShared.setSipSessionId(null, "From handleTimeoutPingErrorCondition setting to null due to explicit Invalidate()");
            mySipSession = null;
        }
        log.warn("processTimeout::Waiting too long for Option Response from Media Server: " + this.sMediaServerIP + " ... calling monitor removeFromLiveState()");
        myMonitor.removeFromLiveState(this.serverIndex);
        this.terminateCleanSession();
        this.aliveTransition = AliveTransitionEnum.AT_DOWN;
        this.timerStatus = ETimerStatus.T_PINGING;
        this.sendPingRequestAndStartTimer(mySipSession);
    }

    public boolean sendPingRequestAndStartTimer(SipSession mySipSession) {
        boolean status = true;
        log.debug("Entering sendPingRequestAndStartTimer:: for media Server with ipAddress: " + this.sMediaServerIP + " and serverIndex: " + this.serverIndex);
        if (this.timerStatus == ETimerStatus.T_INITIAL) {
            ServletTimer ts = DlgcMsMonitorServlet.getTimerService().createTimer(this.getSAS(), (long)this.adjustedInterval, false, (Serializable)this);
            this.timerId = ts.getId();
            ts.getApplicationSession().setAttribute(this.timerId, (Object)DlgcMsMonitor.MONITOR_TIMER_INSTANCE_ID);
            log.debug("sendPingRequestAndStartTimer ETimerStatus.T_INITIAL  Media Server: " + this.sMediaServerIP + " adding timerID: " + this.timerId);
            log.debug("sendPingRequestAndStartTimer: ETimerStatus.T_INITIAL   -> OUT FROM Starting Intitial TIMER new timerID: " + this.timerId + " MediaServer: " + this.sMediaServerIP);
            return status;
        }
        try {
            SipServletRequest req = this.createRequest("OPTIONS", mySipSession);
            if (req == null) {
                log.debug("sendPingRequestAndStartTimer:: CAN'T SEND OPTION PING REQ IS NULL");
            } else {
                log.debug("sendPingRequestAndStartTimer -> Sending OPTION PING Request to Media Server: " + this.sMediaServerIP);
                req.send();
            }
            ServletTimer ts = DlgcMsMonitorServlet.getTimerService().createTimer(this.infoShared.retrieveSAS(), (long)this.adjustedInterval, false, (Serializable)this);
            this.timerId = ts.getId();
            ts.getApplicationSession().setAttribute(this.timerId, (Object)DlgcMsMonitor.MONITOR_TIMER_INSTANCE_ID);
            log.debug("sendPingRequestAndStartTimer START NEW PING  Media Server: " + this.sMediaServerIP + " adding timerID: " + this.timerId);
            log.debug("DlgcMediaServer::sendPingRequestAndStartTimer -> OUT FROM RESETTING TIMER new timerID: " + this.timerId + " MediaServer: " + this.sMediaServerIP);
        }
        catch (Exception e) {
            status = false;
            log.warn("sendPingRequestAndStartTimer-> Exception Sending OPTION request to Media Server: " + this.sMediaServerIP);
            e.printStackTrace();
            log.error("sendPingRequestAndStartTimer -> RESETTING TIMER for: " + this.sMediaServerIP);
        }
        return status;
    }

    public boolean sendStartTimer() {
        boolean status = true;
        try {
            ServletTimer ts = DlgcMsMonitorServlet.getTimerService().createTimer(this.getSAS(), (long)this.adjustedInterval, false, (Serializable)this);
            this.timerId = ts.getId();
            ts.getApplicationSession().setAttribute(this.timerId, (Object)DlgcMsMonitor.MONITOR_TIMER_INSTANCE_ID);
            log.debug("DlgcMediaServer::sendStartTimer -> adding a new timerID: " + this.timerId + " MediaServer: " + this.sMediaServerIP);
            log.debug("DlgcMediaServer::sendStartTimer -> OUT FROM RESETTING TIMER new timerID: " + this.timerId + " MediaServer: " + this.sMediaServerIP);
        }
        catch (Exception e) {
            status = false;
            log.warn("DlgcMsMonitor::sendStartTimer -> Exception Sending OPTION request to Media Server: " + this.sMediaServerIP);
            e.printStackTrace();
            log.error("DlgcMsMonitor::sendStartTimer -> RESETTING TIMER for: " + this.sMediaServerIP);
        }
        return status;
    }

    protected SipServletRequest createRequest(String sipMethod, SipSession mySipSession) {
        SipServletRequest request = null;
        DlgcMediaServerStatus mstat = new DlgcMediaServerStatus(false, false);
        myMonitor.getActiveAndAliveMapValues(this.serverIndex, mstat);
        if (!mstat.isAlive) {
            log.debug("DlgcMediaServer::CreateRequest mediaServer is not alive check ipmsSipSession: " + this.sMediaServerIP);
            if (mySipSession != null) {
                log.debug("DlgcMediaServer::CreateRequest mediaServer is not alive invalidating ipmsSipSession: " + this.sMediaServerIP);
                try {
                    log.debug("createRequest:: media session SIPSESSION INVALIDATING ping request for Media Server: " + this.sMediaServerIP);
                    mySipSession.invalidate();
                    mySipSession = null;
                    this.infoShared.setSipSessionId(null, "From createRequest() setting the session to null because explicit invalidate() ");
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (mySipSession == null) {
            log.debug("DlgcMediaServer::CreateRequest creating a new Sip Session to send PING: " + this.sMediaServerIP);
            request = this.generateRequest(sipMethod);
        } else if (mySipSession.isValid()) {
            log.debug("DlgcMediaServer::CreateRequest ipmsSipSesion still Valid using the SAME SIPSESSION to send PING: " + this.sMediaServerIP);
            try {
                request = mySipSession.createRequest(sipMethod);
            }
            catch (IllegalStateException stEx) {
                log.warn("DlgcMediaServer::CreateRequest : " + this.sMediaServerIP + " Cant create request because the session has either terminated or is in a invalid state: " + stEx.toString());
            }
        } else {
            log.debug("DlgcMediaServer::CreateRequest ipmsSipSesion IS NOT VALID after all - creating a new request to send PING: " + this.sMediaServerIP);
            request = this.generateRequest(sipMethod);
        }
        return request;
    }

    protected SipServletRequest generateRequest(String sipMethod) {
        log.debug("generateRequest:: CREATING BRAND NEW OPTION REQUEST FOR Media Server: " + this.sMediaServerIP);
        SipServletRequest request = null;
        Address connectorAddress = this.ipmsSession.getSessionAttributeProxy().getConnectorAddress(sipMethod);
        Address mediaServerAddress = this.ipmsSession.getSessionAttributeProxy().getMSAddress(sipMethod);
        SipApplicationSession sasCreation = this.infoShared.retrieveSAS();
        log.debug("generateRequest():: SAS use to create request id: " + sasCreation.getId());
        request = DlgcMsMonitorServlet.getSipFactory().createRequest(sasCreation, sipMethod, connectorAddress, mediaServerAddress);
        if (request != null) {
            try {
                SipSession ss = request.getSession();
                SipApplicationSession sasLocal = ss.getApplicationSession();
                log.debug("generateRequest:: Generating new SIP SESSION  for Media Server: " + this.sMediaServerIP + " sipSessionId: " + ss.getId());
                log.debug("generateRequest:: Generating new SIP SESSION  for Media Server: " + this.sMediaServerIP + " SASID: " + sasLocal.getId());
                this.infoShared.setSipSessionId(ss.getId(), "From generateRequest() GENERATING A NEW SIPSESSION SipSessionId: " + ss.getId());
                ss.setAttribute("MediaServerObj", (Object)this);
                this.ipmsSession.setSipSession(ss);
                this.infoShared.retrieveSAS().setAttribute(ss.getId(), (Object)ss);
                ss.setHandler(this.ipmsSession.getSessionAttributeProxy().sipHandler);
            }
            catch (ServletException e) {
                // empty catch block
            }
        }
        if (request != null) {
            log.debug("PING REQUEST: " + request.toString());
        }
        return request;
    }

    DlgcSessionAttributeProxy getSessionAttributeProxy() {
        DlgcSessionAttributeProxy sessionAttrProxy = this.ipmsSession.getSessionAttributeProxy();
        return sessionAttrProxy;
    }

    protected void terminateCleanSession() {
        log.debug(">>>>>>>>>> DlgcMediaServer:terminateCleanSession - For Media server " + this.ipmsSession.getMediaServerIp());
        if (this.aliveTransition == AliveTransitionEnum.AT_DOWN) {
            return;
        }
        try {
            this.infoShared = myMonitor.getMediaServerServerInfo(this.serverIndex);
            if (this.infoShared.associatedContainer == null) {
                log.debug("terminateCleanSession:: associatedContainer is null - NO MediaErr.CALL_DROPPED event to sent to Application");
            } else if (this.infoShared.associatedContainer.isEmpty()) {
                log.debug("terminateCleanSession:: associatedContainer is EMPTY");
            } else {
                log.debug("terminateCleanSession:: associatedContainer has event targets - count: " + new Integer(this.infoShared.associatedContainer.size()).toString());
                int cnt = this.infoShared.associatedContainer.size();
                String[] keys = new String[cnt];
                DlgcSipConnectorContentIdsProxy[] callbackObj = new DlgcSipConnectorContentIdsProxy[cnt];
                int index = 0;
                for (Map.Entry<String, DlgcSipConnectorContentIdsProxy> eset : this.infoShared.associatedContainer.entrySet()) {
                    keys[index] = eset.getKey();
                    callbackObj[index] = eset.getValue();
                    myMonitor.removeAssociatedComponent(this.serverIndex, keys[index]);
                    ++index;
                }
                log.debug("Total of callbackObj to send a cleanup event to is : " + new Integer(cnt).toString());
                for (int i = 0; i < cnt; ++i) {
                    log.debug("DlgcMediaServer::terminateCleanSession Enter Sending Event to Application");
                    DlgcSipConnectorContentIdsProxy targetProxy = callbackObj[i];
                    if (targetProxy != null) {
                        log.debug("DlgcMediaServer::terminateCleanSession Retrieved event target..loading target");
                        targetProxy.Load();
                        log.debug("DlgcMediaServer::terminateCleanSession Target loaded getting target container ");
                        DlgcJoinableContainer target = targetProxy.getContainer();
                        if (target != null) {
                            log.debug("terminateCleanSession:: associatedContainer calling sendEvent to send Event to App using worker thread: MediaErr.CALL_DROPPED target: " + target.toString());
                            log.debug("callbackObj sendEvent() : object cnt: " + new Integer(i + 1).toString());
                            this.sendEvent(target, this);
                            continue;
                        }
                        log.debug("terminateCleanSession:: target is null NOT calling sendEvent to send Event to App using worker thread: MediaErr.CALL_DROPPED");
                        continue;
                    }
                    log.debug("DlgcMediaServer::terminateCleanSession Retrieved event target is NULL...ignoring");
                }
            }
        }
        catch (Exception e) {
            log.error("terminateCleanSession exception: " + e.toString());
        }
    }

    protected void sendEvent(DlgcJoinableContainer jc, DlgcMediaServer mediaServer) {
        DlgcMonitorTask jobNew = new DlgcMonitorTask(jc, mediaServer);
        jobNew.run();
    }

    public void setAssociatedComponent(DlgcJoinableContainer jc) {
        log.debug("Entering setAssociatedComponent Entry: " + jc.getURI().toString());
        if (this.is_MS_URI_DEFINED()) {
            log.debug("DlgcMediaServer::setAssociatedComponent:: not calling setAssociatedComponent method because we are using MEDIA_SERVER_URI");
        } else {
            DlgcSipConnectorContentIdsProxy containerProxy = new DlgcSipConnectorContentIdsProxy(jc, null);
            myMonitor.setAssociatedComponent(this.serverIndex, jc.getURI().toString(), containerProxy);
        }
        log.debug("Leaving AssociatedContainer Entry: ");
    }

    public void removeAssociatedComponent(DlgcJoinableContainer jc) {
        log.debug("DlgcMediaServer::Entering removeAssociatedComponent Entry: " + jc.getURI().toString());
        if (this.is_MS_URI_DEFINED()) {
            log.debug("DlgcMediaServer::removeAssociatedComponent:: not calling removeAssociatedComponent method because we are using MEDIA_SERVER_URI");
        } else {
            myMonitor.removeAssociatedComponent(this.serverIndex, jc.getURI().toString());
        }
        log.debug("DlgcMediaServer:: Leaving  removeAssociatedComponent Entry:  ");
    }

    SipApplicationSession getSAS() {
        try {
            if (this.mySasId != null) {
                log.debug("DlgcMediaServer:;getSAS() mySasID: " + this.mySasId);
                return DlgcMsMonitorServlet.getSSU().getApplicationSessionById(this.mySasId);
            }
            log.warn("DlgcMediaServer::getSAS() mySasID is NULL...");
            return null;
        }
        catch (Exception exc) {
            log.debug("DlgcMediaServer:: getSAS() found no SipApplicationSession.");
            return null;
        }
    }

    protected void cancelTimer() {
        if (this.timerId == null) {
            log.debug("cancelTimer():: Ping Timer is null can't cancel timer for Media Server: " + this.sMediaServerIP);
        } else {
            log.debug("cancelTimer():: Associated Ping Timer found; cancel timer for Media Server: " + this.sMediaServerIP + " timerId: " + this.timerId);
            ServletTimer t = this.getTimer(this.timerId, this.infoShared.sasId);
            t.cancel();
        }
    }

    protected ServletTimer getTimer(String tId, String sasid) {
        ServletTimer st = null;
        try {
            SipApplicationSession sas = DlgcMsMonitorServlet.getSSU().getApplicationSessionById(sasid);
            if (sas != null) {
                st = sas.getTimer(tId);
            }
        }
        catch (Exception ex) {
            log.debug("DlgcMediaServer::get timer from SAS Found Exception: " + ex);
        }
        return st;
    }

    protected void printActiveMediaSessionsForThisMediaServer() {
        log.debug(">>>>>>>>>> DlgcMediaServer:printActiveMediaSessionsForThisMediaServer - For Media server " + this.ipmsSession.getMediaServerIp());
        try {
            if (this.infoShared.associatedContainer == null) {
                log.debug("DlgcMediaServer::printActiveMediaSessionsForThisMediaServer associatedContainer is null - nothing to print.");
            } else if (this.infoShared.associatedContainer.isEmpty()) {
                log.debug("printActiveMediaSessionsForThisMediaServer associatedContainer is EMPTY nothing to print.");
            } else {
                log.debug("DlgcMediaServer::printActiveMediaSessionsForThisMediaServer associatedContainer has entry the count is: " + new Integer(this.infoShared.associatedContainer.size()).toString());
                for (DlgcSipConnectorContentIdsProxy targetProxy : this.infoShared.associatedContainer.values()) {
                    targetProxy.Load();
                    DlgcJoinableContainer target = targetProxy.getContainer();
                    log.debug("DlgcMediaServer:: Association Entry is : " + target.toString());
                }
            }
        }
        catch (Exception e) {
            log.debug("DlgcMediaServer::printActiveMediaSessionsForThisMediaServer Exception: " + e.toString());
            e.printStackTrace();
        }
    }

    public void cleanup() {
        log.debug("Entering DlgcMediaServer::cleanup(): " + this.infoShared.serverName + " IP:" + this.myAppServerIP);
        SipApplicationSession sas = this.getSAS();
        if (sas == null) {
            log.debug("DlgcMsMonitor::stopCleanMediaServers:  no SAS found no need to cancel timers");
        } else {
            ServletTimer timer = this.getTimer(this.timerId, this.mySasId);
            if (timer != null) {
                try {
                    timer.cancel();
                    if (sas != null) {
                        log.debug("DlgcMsMonitor::stopCleanMediaServers:  cancelling timer: " + timer.getId());
                        if (sas.isValid()) {
                            log.debug("Removing MediaSession from SAS: " + sas.toString() + " for media server: " + this.myAppServerIP);
                            sas.removeAttribute(this.infoShared.serverName);
                            log.debug("Invalidating SAS: " + sas.toString() + " for media server: " + this.myAppServerIP);
                            sas.invalidate();
                            log.debug("SAS HAS BEEN INVALIDATED: " + sas.toString() + " for media server: " + this.myAppServerIP);
                        } else {
                            log.debug("SAS HAS BEEN ALREADY INVALIDATED: " + sas.toString() + " for media server: " + this.myAppServerIP);
                        }
                    } else {
                        log.debug("Could not invalidate SAS most likely was already released" + this.mySasId + " for media server: " + this.myAppServerIP);
                    }
                    log.debug("Leaving DlgcMediaServer::cleanup(): " + this.infoShared.serverName + " IP:" + this.myAppServerIP);
                }
                catch (Exception e) {
                    log.debug("DlgcMsMonitor::stopCleanMediaServers capturing cancelling timer.");
                }
            } else {
                log.debug("DlgcMsMonitor::stopCleanMediaServers:  no valid timer no need to cancel timers");
            }
        }
    }

    public void loadContextInfo() {
        this.infoShared = this.infoShared;
    }

    static {
        log = LoggerFactory.getLogger(DlgcMediaServer.class);
    }

    static enum AliveTransitionEnum {
        AT_INIT,
        AT_UP,
        AT_DOWN;

    }

    static enum ETimerStatus {
        T_INITIAL,
        T_PINGING,
        T_200_OK,
        T_ERROR;

    }

    public class DlgcMediaServerStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public boolean isAlive;
        public boolean isActive;

        public DlgcMediaServerStatus(boolean alive, boolean active) {
            this.isAlive = alive;
            this.isActive = active;
        }
    }

    protected class DlgcMonitorTask {
        protected DlgcJoinableContainer jContainer = null;
        protected DlgcMediaServer myMediaServer = null;

        public DlgcMonitorTask(DlgcJoinableContainer jc, DlgcMediaServer mediaServer) {
            this.jContainer = jc;
            this.myMediaServer = mediaServer;
        }

        public void run() {
            String errMsg = "MRB DOWN";
            try {
                if (this.jContainer instanceof DlgcNetworkConnection) {
                    DlgcSdpPortManager sdp = (DlgcSdpPortManager)((DlgcNetworkConnection)this.jContainer).getSdpPortManager();
                    sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, sdp.getMediaServerSessionDescription(), MediaErr.CALL_DROPPED, errMsg, ResourceEvent.NO_QUALIFIER);
                } else if (this.jContainer instanceof DlgcMediaMixer) {
                    DlgcMediaMixer mx = (DlgcMediaMixer)this.jContainer;
                    mx.postAllocationEvent(AllocationEvent.IRRECOVERABLE_FAILURE, MediaErr.CALL_DROPPED, errMsg);
                } else if (this.jContainer instanceof DlgcMixerAdapter) {
                    DlgcMediaMixer mx = ((DlgcMixerAdapter)this.jContainer).getMixer();
                    mx.postAllocationEvent(AllocationEvent.IRRECOVERABLE_FAILURE, MediaErr.CALL_DROPPED, errMsg);
                }
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        }
    }
}

