/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.sip;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaEvent;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMsMonitorServlet;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSessionAttributeProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServletRequestProxy;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcIpmsSession
implements Serializable {
    public static final String MSML_DIALOG_NAME = "MSC309";
    private static Logger log = LoggerFactory.getLogger(DlgcIpmsSession.class);
    private static final long serialVersionUID = 127865309871L;
    private DlgcSipConnectorContentIdsProxy taskOwner;
    private DlgcSipConnectorContentIdsProxy masterOwner;
    private DlgcSessionAttributeProxy mySessionAttributeProxy;
    private int requestCount = 0;
    private transient SipSession ipmsSipSession;
    private Integer debugId;
    private String ipmsSipSessionNameId;
    private String sasID;
    private DlgcSipMessage msgToXmit;
    private String mediaSessionObjId;
    private String sipTag;
    private String dialogId;
    private String appLogId;
    private String networkConnectionObjId;
    private Map<String, DlgcSipConnectorContentIdsProxy> MediaEventNotifierMap;
    private Map<String, String> activeDialogMapKeyDlgId;
    private Map<String, String> activeDialogMapKeyResourceId;
    private Queue<DlgcSipServletRequestProxy> requestQueue;
    private Queue<DlgcMediaEvent<?>> eventQue;
    private Queue<String> payloadQue;

    public DlgcIpmsSession(SipApplicationSession sas, String sipHandler, String lmsIp, Integer lmsPort, String user, String mediaServerDisplayName, String ljmcIP, Integer ljmcPort, String ljmcUserName, String ljmcDisplayName, boolean sessionTimerSwitch, int sessionTimerMaxTimeout, int sessionTimerMinTimeout, DlgcJoinableContainer owner, DlgcJoinableContainer master) {
        Random randomGenerator = new Random();
        this.debugId = new Integer(randomGenerator.nextInt(100000));
        this.ipmsSipSession = null;
        this.taskOwner = null;
        this.masterOwner = null;
        this.ipmsSipSessionNameId = null;
        this.sasID = sas.getId();
        this.msgToXmit = null;
        this.sipTag = null;
        this.dialogId = null;
        this.MediaEventNotifierMap = new Hashtable<String, DlgcSipConnectorContentIdsProxy>();
        this.activeDialogMapKeyDlgId = new Hashtable<String, String>();
        this.activeDialogMapKeyResourceId = new Hashtable<String, String>();
        this.requestQueue = new ConcurrentLinkedQueue<DlgcSipServletRequestProxy>();
        this.eventQue = new ConcurrentLinkedQueue();
        this.payloadQue = new ConcurrentLinkedQueue<String>();
        log.debug("*15 DlgcIpmsSession:: ObjectID; " + this.getIpmsSipSessionObjectID());
        this.mySessionAttributeProxy = new DlgcSessionAttributeProxy(sas, sipHandler, lmsIp, lmsPort, user, mediaServerDisplayName, ljmcIP, ljmcPort, ljmcUserName, ljmcDisplayName, sessionTimerSwitch, sessionTimerMaxTimeout, sessionTimerMinTimeout, owner, master);
    }

    public String calculateDialogTargetField() {
        String dialogTarget = null;
        dialogTarget = "conn:" + this.sipTag;
        return dialogTarget;
    }

    public void setXmitMsg(DlgcSipMessage msg) {
        this.msgToXmit = msg;
    }

    public DlgcSipMessage getXmitMsg() {
        DlgcSipMessage tmp = this.msgToXmit;
        return tmp;
    }

    public void addRequest(DlgcSipServletRequestProxy request) {
        if (request != null) {
            this.requestQueue.add(request);
        }
    }

    public void addRequest(DlgcMediaEvent<?> event) {
        if (event != null) {
            this.eventQue.add(event);
        }
    }

    public void addRequest(String cmd) {
        if (cmd != null) {
            this.payloadQue.add(cmd);
        }
    }

    public void setResourceContainerOwner(DlgcJoinableContainer container) {
        this.taskOwner = new DlgcSipConnectorContentIdsProxy(container, null);
        this.taskOwner.Load();
        this.mySessionAttributeProxy.setSipAppSession(this.taskOwner.getSAS());
        this.appLogId = this.taskOwner.getMediaSession().getAppCallLogId();
    }

    public void setMasterContainerOwner(DlgcJoinableContainer container) {
        this.masterOwner = new DlgcSipConnectorContentIdsProxy(container, null);
        this.taskOwner.Load();
        this.mySessionAttributeProxy.setSipAppSession(this.masterOwner.getSAS());
        this.appLogId = this.taskOwner.getMediaSession().getAppCallLogId();
    }

    public void setSAS(SipApplicationSession sas) {
        this.mySessionAttributeProxy.setSipAppSession(sas);
    }

    public DlgcJoinableContainer getResourceContainerOwner() {
        DlgcMediaSession ms = this.taskOwner.getMediaSession();
        return this.taskOwner.getContainer(ms);
    }

    public DlgcJoinableContainer getMasterContainerOwner() {
        DlgcMediaSession ms = this.masterOwner.getMediaSession();
        return this.masterOwner.getContainer(ms);
    }

    public void clearMediaEventNotifierList() {
        this.MediaEventNotifierMap.clear();
    }

    public SipServletRequest getSipServletRequest(DlgcSipServletRequestProxy requestProxy, DlgcSipMessage message, DlgcIpmsSession session) {
        SipServletRequest request = null;
        Address connectorAddress = null;
        Address mediaServerAddress = null;
        boolean fLogXmit = DlgcInstrumentPropertyMgr.bInstrumentXmit;
        DlgcSessionAttributeProxy rpa = requestProxy.sessionAttrProxy;
        DlgcMediaSession ms = (DlgcMediaSession)session.getMasterContainerOwner().getMediaSession();
        log.debug("*15 Entering getSipServletRequest  Method = " + message.method + " MyID: " + this.getIpmsSipSessionObjectID());
        if (this.isFirstRequest()) {
            if (!this.appLogId.equalsIgnoreCase("Not Defined -")) {
                this.appLogId = ms.getAppCallLogId();
            }
            log.debug("appLogId+** *15 getSipServletRequest:: Creating a new Sip Request to be sent to MS with Method = " + requestProxy.sipMethod + " MyID: " + this.getIpmsSipSessionObjectID());
            connectorAddress = rpa.getConnectorAddress(requestProxy.sipMethod);
            mediaServerAddress = rpa.getMSAddress(requestProxy.sipMethod);
            log.debug("*15 getSipServletRequest::  using SipAppSession: " + rpa.getSipAppSession().getId());
            request = DlgcSipServlet.getSipFactory().createRequest(rpa.getSipAppSession(), requestProxy.sipMethod, connectorAddress, mediaServerAddress);
            if (request != null) {
                log.debug(this.appLogId + "APRIL 2013 - DlgcIpmsSession:getSipServletRequest():INVITE: SASID: " + request.getApplicationSession().getId() + " SIPID: " + request.getSession().getId());
                DlgcXNetworkConnection ncx = (DlgcXNetworkConnection)session.getMasterContainerOwner();
                DlgcNetworkConnection.RTP_SECURITY_E rtpSecurity = ncx.getRtpSecurity();
                if (rtpSecurity == DlgcNetworkConnection.RTP_SECURITY_E.SDES) {
                    log.debug("Setting Supported srtp");
                    request.setHeader("Supported", "srtp");
                }
                this.ipmsSipSession = request.getSession();
                try {
                    log.debug("mySessionAttributeProxy.sipHandler: using getSipFactory() instead of static value from DlgcSipServlet " + this.mySessionAttributeProxy.sipHandler);
                    this.ipmsSipSession.setHandler(this.mySessionAttributeProxy.sipHandler);
                    log.debug("*15 getSipServletRequest:: sip request created with MyID: " + this.getIpmsSipSessionObjectID() + " SipSession ID: " + this.ipmsSipSession.getId());
                    if (rpa.sessionTimerSwitch) {
                        log.debug("Enabling sip request SIP session timeout for MSML Server");
                        String timerHeader = new Integer(rpa.sessionTimerMaxTimeout).toString() + ";refresher=uas";
                        request.setHeader("Session-Expires", timerHeader);
                        request.setHeader("Supported", "timer");
                        request.setHeader("Allow", "UPDATE,ACK,BYE,CANCEL,OPTIONS,INFO");
                    }
                    this.ipmsSipSessionNameId = this.ipmsSipSession.getId();
                    SipApplicationSession sas = DlgcSipServlet.getSSU().getApplicationSessionById(this.sasID);
                    this.ipmsSipSession.setAttribute("CONNECTOR_SAS", (Object)sas.getId());
                    ++this.requestCount;
                }
                catch (ServletException e) {
                    log.debug("Exception: " + e.toString());
                    e.printStackTrace();
                }
            }
        } else {
            this.loadSS();
            if (fLogXmit) {
                log.debug(this.appLogId + "** Using already created sip session to create request using Method = " + requestProxy.sipMethod);
            }
            try {
                log.debug("*15 getSipServletRequest:: sip using existing SipSession with MyID: " + this.getIpmsSipSessionObjectID() + " SipSession ID: " + this.ipmsSipSession.getId() + " CallId: " + this.ipmsSipSession.getCallId());
                request = this.ipmsSipSession.createRequest(requestProxy.sipMethod);
                log.debug("*15 DlgcIpmsSession:getSipServletRequest():NOT INVITE: SASID: " + request.getApplicationSession().getId() + " SIPID: " + request.getSession().getId());
                ++this.requestCount;
                this.ipmsSipSessionNameId = this.ipmsSipSession.getId();
            }
            catch (IllegalStateException stEx) {
                log.warn(this.appLogId + "Cant create request because the session has either terminated or is in a invalid state");
            }
        }
        if (request != null) {
            try {
                if (requestProxy.myContent != null) {
                    if (requestProxy.myContentType.contains("multipart/mixed")) {
                        String newContentType;
                        requestProxy.myContentType = newContentType = requestProxy.myContentType.replace("\r\n\t", "");
                    }
                    request.setContent((Object)requestProxy.myContent.getBytes(), requestProxy.myContentType);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            requestProxy.setSipSessionContainerAttributes(this.ipmsSipSession);
            request.setAttribute(request.getHeader("CSeq"), (Object)requestProxy);
            if (!request.isInitial() && message.method.equals("INVITE")) {
                request.setRequestURI((URI)session.getMediaServerURI());
            }
        }
        return request;
    }

    public DlgcSipServletRequestProxy createRequestProxy(String sipMethod) {
        DlgcSipServletRequestProxy requestProxy = null;
        requestProxy = new DlgcSipServletRequestProxy(this.mySessionAttributeProxy, sipMethod, true);
        return requestProxy;
    }

    public SipServletRequest createRequest(String sipMethod) {
        log.debug("** Calling get createRequest by msMonitor **");
        SipServletRequest request = null;
        if (this.isFirstRequest()) {
            Address connectorAddress = this.mySessionAttributeProxy.getConnectorAddress(sipMethod);
            Address mediaServerAddress = this.mySessionAttributeProxy.getMSAddress(sipMethod);
            request = DlgcMsMonitorServlet.getSipFactory().createRequest(this.mySessionAttributeProxy.getSipAppSession(), sipMethod, connectorAddress, mediaServerAddress);
            if (request != null) {
                this.ipmsSipSession = request.getSession();
                try {
                    this.ipmsSipSessionNameId = this.ipmsSipSession.getId();
                    request.getSession().setHandler(this.mySessionAttributeProxy.sipHandler);
                    ++this.requestCount;
                }
                catch (ServletException e) {}
            }
        } else {
            this.loadSS();
            try {
                request = this.ipmsSipSession.createRequest(sipMethod);
            }
            catch (IllegalStateException stEx) {
                log.warn("Cant create request because the session has either terminated or is in a invalid state");
            }
        }
        return request;
    }

    public Address getConnectorAddress() {
        return this.mySessionAttributeProxy.getConnectorAddress();
    }

    public Address getMediaServerAddress() {
        return this.mySessionAttributeProxy.getMSAddress();
    }

    public String getMediaServerIpAddress() {
        return this.mySessionAttributeProxy.msIp;
    }

    public SipURI getConnectorURI() {
        return this.mySessionAttributeProxy.getConnectorURI();
    }

    public SipURI getMediaServerURI() {
        return this.mySessionAttributeProxy.getMSURI();
    }

    public String getMediaServerIp() {
        return this.mySessionAttributeProxy.msIp;
    }

    public int getMediaServerPort() {
        return this.mySessionAttributeProxy.msPort;
    }

    public String getJMCIp() {
        return this.mySessionAttributeProxy.jmcIp;
    }

    public int getJMCPort() {
        return this.mySessionAttributeProxy.jmcPort;
    }

    public boolean getConnectorTimerSwitch() {
        return this.mySessionAttributeProxy.sessionTimerSwitch;
    }

    public int getConnectorTimerMaxTimeout() {
        return this.mySessionAttributeProxy.sessionTimerMaxTimeout;
    }

    public int getConnectorTimerMinTimeout() {
        return this.mySessionAttributeProxy.sessionTimerMinTimeout;
    }

    public SipApplicationSession getAppSession() {
        return DlgcSipServlet.getSSU().getApplicationSessionById(this.sasID);
    }

    public SipApplicationSession getMonitorAppSession() {
        return DlgcMsMonitorServlet.getSSU().getApplicationSessionById(this.sasID);
    }

    public void setSipSession(SipSession ss) {
        if (this.ipmsSipSession == null) {
            log.debug("DlgcSipSession::setSipSession found ipmsSipSession to be null...setting it to ss=" + ss.getId());
            this.ipmsSipSession = ss;
        } else if (ss.getId().equals(this.ipmsSipSession.getId())) {
            log.debug("setSipSession ss string id ARE THE SAME...  ipmsSipSession = " + this.ipmsSipSession.getId());
        } else {
            log.debug("*16 setSipSession ss string id ARE NOTE THE SAME...");
            log.debug("*16 setSipSession ipmsSipSession = " + this.ipmsSipSession.getId() + " setSipSession passed in sipSession = " + ss.getId());
            log.debug("*16 setSipSession Not setting SS");
        }
    }

    public void loadSS() {
        if (this.ipmsSipSession == null) {
            if (this.ipmsSipSessionNameId != null) {
                SipApplicationSession sas = DlgcSipServlet.getSSU().getApplicationSessionById(this.sasID);
                this.ipmsSipSession = sas.getSipSession(this.ipmsSipSessionNameId);
                if (this.ipmsSipSession != null) {
                    log.debug("loadSS() retrieve sipSession from the Application Session ssId=" + this.ipmsSipSession.getId());
                } else {
                    log.error("loadSS() could not retrieve sipSession from the Application Session ssId= null");
                }
            } else {
                log.warn("ZZZ loadSS() could not retrieve sipSession from the Application Session because sipSessionNameId is null");
            }
        } else {
            log.debug("loadSS() sipSession already loaded... no problem");
        }
    }

    public SipSession getSipSession() {
        this.loadSS();
        return this.ipmsSipSession;
    }

    public boolean isFirstRequest() {
        return this.requestCount == 0;
    }

    public void addMediaEventNotifier(String id, DlgcSipConnectorContentIdsProxy notifier) {
        this.MediaEventNotifierMap.put(id, notifier);
    }

    public DlgcSipConnectorContentIdsProxy getMediaEventNotifier(String id) {
        return this.MediaEventNotifierMap.get(id);
    }

    public void addActiveDialogId(String fullDialogId, String resourceId) {
        log.debug("ACTIVE DIALOG - IN addActiveDialogId() fullIdalogId = " + fullDialogId + " sourceId = " + resourceId);
        this.activeDialogMapKeyDlgId.put(fullDialogId, resourceId);
        this.activeDialogMapKeyResourceId.put(resourceId, fullDialogId);
        log.debug("OUT  addActiveDialogId()");
    }

    public String getActiveDialogId(String resourceId) {
        return this.activeDialogMapKeyResourceId.get(resourceId);
    }

    public String getActiveDialogResourceId(String fullDialogId) {
        return this.activeDialogMapKeyDlgId.get(fullDialogId);
    }

    public String removeActiveDialog(String fullDialogId) {
        log.debug("IN DlgcIpmsSession::removeActiveDialog...");
        if (fullDialogId == null) {
            log.debug("PROBLEM DlgcIpmsSession: removing activeDialogMapKeyDlgId fullDialogId is null ");
        } else {
            log.debug("IN DlgcIpmsSession: removing activeDialogMapKeyDlgId with fullDialogId = " + fullDialogId);
        }
        String resourceId = this.activeDialogMapKeyDlgId.remove(fullDialogId);
        if (resourceId != null) {
            log.debug("IN DlgcIpmsSession: removing activeDialogMapKeyResourceId with resourceId = " + resourceId);
            String thisfullDialogId = this.activeDialogMapKeyResourceId.remove(resourceId);
            log.debug("ACTIVE DIALOG - IN removeActiveDialog() fullIdalogId = " + thisfullDialogId + " sourceId = " + resourceId);
        } else {
            log.debug("ACTIVE DIALOG Note could not find the dialog to remove in DlgcIpmsSession::removeActiveDialog..ignoring most likely already removed...");
        }
        log.debug("OUT DlgcIpmsSession::removeActiveDialog...");
        return resourceId;
    }

    public String removeActiveResourceId(String resourceId) {
        log.debug("IN DlgcIpmsSession:;removeActiveResourceId...");
        if (resourceId == null) {
            log.debug("PROBLEM DlgcIpmsSession: removing activeDialogMapKeyResourceId resourceId is null ");
        } else {
            log.debug("IN DlgcIpmsSession: removing activeDialogMapKeyResourceId with resourceId = " + resourceId);
        }
        String dialogId = this.activeDialogMapKeyResourceId.remove(resourceId);
        if (dialogId != null) {
            log.debug("IN DlgcIpmsSession: removing activeDialogMapKeyResourceId with dialogId = " + dialogId);
            log.debug("ACTIVE DIALOG - IN removeActiveResourceId() fullIdalogId = " + dialogId + " sourceId = " + resourceId);
            this.activeDialogMapKeyDlgId.remove(dialogId);
        } else {
            log.debug("ACTIVE DIALOG - IN removeActiveResourceId() fullIdalogId = NULL sourceId = " + resourceId);
            log.debug("Note could not find the dialog to remove in DlgcIpmsSession::activeDialogMapKeyResourceId...ignoring most likely already removed...");
        }
        log.debug("OUT DlgcIpmsSession::removeActiveResourceId...");
        return dialogId;
    }

    public Collection<DlgcSipConnectorContentIdsProxy> getMediaEventNotifierList() {
        return this.MediaEventNotifierMap.values();
    }

    public DlgcSipConnectorContentIdsProxy removeMediaEventNotifier(String id) {
        log.debug("DlgcSession::removeMediaEventNotifier based on the following key=" + id);
        DlgcSipConnectorContentIdsProxy notifierContainer = this.MediaEventNotifierMap.remove(id);
        if (notifierContainer == null) {
            log.error("DlgcSession::removeMediaEventNotifier: notifierContainer IS NULL");
            this.printDebugEventNotifierMap();
        } else {
            log.debug("DlgcSession::removeMediaEventNotifier: notifierContainer WAS FOUND");
        }
        return notifierContainer;
    }

    public DlgcSipServletRequestProxy removeRequest() {
        DlgcSipServletRequestProxy req = this.requestQueue.poll();
        return req;
    }

    public String removePayloadRequest() {
        String cmd = this.payloadQue.poll();
        return cmd;
    }

    public String getPayloadRequest() {
        String cmd = this.payloadQue.peek();
        return cmd;
    }

    public DlgcMediaEvent<?> removeEvent() {
        DlgcMediaEvent<?> event = this.eventQue.poll();
        return event;
    }

    public DlgcSessionAttributeProxy getSessionAttributeProxy() {
        return this.mySessionAttributeProxy;
    }

    public void setMediaSessionObjId(String id) {
        this.mediaSessionObjId = id;
    }

    public String getMediaSessionObjId() {
        return this.mediaSessionObjId;
    }

    public String getSipTag() {
        return this.sipTag;
    }

    public void setSipTag(String tag) {
        this.sipTag = tag;
    }

    public String getDialogId() {
        return this.dialogId;
    }

    public void setDialogId(String id) {
        this.dialogId = id;
    }

    public static String getNewDialogName() {
        int randomInt = (int)System.nanoTime() & 0xFFFFFF;
        Integer dialogIdVal = new Integer(randomInt);
        log.debug("getNewDialogName dialogId name: " + dialogIdVal.toString());
        String name = MSML_DIALOG_NAME + dialogIdVal.toString();
        log.debug("getNewDialogName composed dialogId name: " + name);
        return name;
    }

    public static String getNewNotifierId(String tID, String name) {
        String notifierId = null;
        notifierId = name == null ? tID : tID + "/dialog:" + name;
        return notifierId;
    }

    public void printDebugEventNotifierMap() {
        log.debug("PRINT DEBUG - Session printDebugEventNotifierMap ");
        if (!this.MediaEventNotifierMap.isEmpty()) {
            Set<Map.Entry<String, DlgcSipConnectorContentIdsProxy>> sEntry = this.MediaEventNotifierMap.entrySet();
            Iterator<Map.Entry<String, DlgcSipConnectorContentIdsProxy>> it = sEntry.iterator();
            Map.Entry<String, DlgcSipConnectorContentIdsProxy> e = null;
            while (it.hasNext()) {
                e = it.next();
                log.debug(" TransId key = " + e.getKey() + "  DlgcSipConnectorContentIdsProxy Value = " + e.getValue());
            }
        }
        log.debug("PRINT DEBUG - DONE printDebugEventNotifierMap ");
    }

    public String toDebug() {
        String retStr = new String();
        retStr = retStr + "\n $$$$$$ JMC Object DlgcSession =  \n";
        retStr = retStr + "Debug ID = " + this.debugId.toString() + " \n";
        retStr = retStr + (this.taskOwner != null ? "taskOwner = " + this.taskOwner.toDebug() + " \n" : "Null \n");
        retStr = retStr + (this.masterOwner != null ? "masterOwner = " + this.masterOwner.toDebug() + " \n" : "Null \n");
        this.printDebugEventNotifierMap();
        retStr = retStr + "$$$$$$";
        return retStr;
    }

    public String getIpmsSipSessionObjectID() {
        return this.debugId.toString();
    }

    public String getSipSessionID() {
        this.loadSS();
        if (this.ipmsSipSession != null) {
            return this.ipmsSipSession.toString();
        }
        return "NotFound";
    }

    public String getNetworkConnectionObjId() {
        return this.networkConnectionObjId;
    }

    public void setNetworkConnectionObjId(String networkConnectionObjId) {
        this.networkConnectionObjId = networkConnectionObjId;
    }
}

