/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.sip;

import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSessionFactory;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcAppStorageMgr
implements Serializable {
    private static final String DLGC_SAS_APP_ID = "DlgcAppStorage";
    private static final String SAS_SESSION_MAP_ID = "SessionManagerMap";
    private static Logger log = LoggerFactory.getLogger(DlgcAppStorageMgr.class);
    private static String SESSION_MGRFACTORY_ATTRIBUTE = new String("SESSION_MGRFACTORY_ATTRIBUTE");
    private static final long serialVersionUID = 94039821895478376L;

    public synchronized SipApplicationSession loadSas() throws DlgcAppStorageMgrException {
        try {
            SipApplicationSession sas = DlgcSipServlet.getSSU().getApplicationSessionByKey(DLGC_SAS_APP_ID, true);
            if (sas.getExpirationTime() != 0L) {
                log.debug("DlgcAppStorageMgr::loadSas() setting SAS EXPIRATION TIME TO ZERO");
                sas.setExpires(0);
            }
            log.debug("DlgcAppStorageMgr::loadSas() returing sas = " + sas.getId());
            return sas;
        }
        catch (NullPointerException nullEx) {
            throw new DlgcAppStorageMgrException(DlgcAppStorageMgrExceptionTypes.NULL_APP_SESSION_FOUND, "loadSas() Exception: Could Nof find ApplicationSession Key call to sessionUtil returns null.");
        }
    }

    public synchronized void saveSessionMap(Map<String, DlgcIpmsSession> sessionMap) throws DlgcAppStorageMgrException {
        SipApplicationSession sas = this.loadSas();
        sas.setAttribute(SAS_SESSION_MAP_ID, sessionMap);
    }

    public synchronized Map<String, DlgcIpmsSession> getSessionMap() throws DlgcAppStorageMgrException {
        SipApplicationSession sas = this.loadSas();
        Map sessionMap = (Map)sas.getAttribute(SAS_SESSION_MAP_ID);
        return sessionMap;
    }

    public synchronized void saveSessionFactory(DlgcSessionFactory sessionFactory) throws DlgcAppStorageMgrException {
        SipApplicationSession sas = this.loadSas();
        sas.setAttribute(SESSION_MGRFACTORY_ATTRIBUTE, (Object)sessionFactory);
    }

    public synchronized DlgcSessionFactory getSessionFactory() throws DlgcAppStorageMgrException {
        SipApplicationSession sas = this.loadSas();
        DlgcSessionFactory sessionFactory = (DlgcSessionFactory)sas.getAttribute(SESSION_MGRFACTORY_ATTRIBUTE);
        return sessionFactory;
    }

    class DlgcAppStorageMgrException
    extends Exception {
        private static final long serialVersionUID = 29838349501L;
        protected DlgcAppStorageMgrExceptionTypes exType;

        public DlgcAppStorageMgrException(DlgcAppStorageMgrExceptionTypes t, String message) {
            super(message);
            this.exType = t;
        }

        public DlgcAppStorageMgrExceptionTypes getType() {
            return this.exType;
        }
    }

    public static enum DlgcAppStorageMgrExceptionTypes {
        NULL_APP_SESSION_FOUND,
        EMPTY_MAP_FOUND;

    }
}

