/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.sip;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIB2BUAReceiverBridge;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServletRequestProxy;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DlgcAbstractB2BUAReceiver
implements DlgcIB2BUAReceiverBridge {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcAbstractB2BUAReceiver.class);
    private String receiverName = "UnDefined";

    public void setReceiverName(String name) {
        this.receiverName = name;
    }

    public String getReceiverName() {
        return this.receiverName;
    }

    protected abstract void processSipRequestInfo(SipServletRequest var1);

    @Override
    public void processSipRequestDoAction(SipServletRequest request) {
        if (request.getMethod().equals("INFO")) {
            this.processSipRequestInfo(request);
        } else if (request.getMethod().equals("INVITE")) {
            this.processSipRequestInvite(request);
        } else if (request.getMethod().equals("BYE")) {
            this.processSipRequestBye(request);
        } else if (request.getMethod().equals("UPDATE")) {
            this.processSipRequestUpdate(request);
        }
    }

    protected void processSipRequestInvite(SipServletRequest request) {
        DlgcMediaSession ms;
        log.debug("** XMS Processing MS Sip Invite Request inside DlgcSipB2BUA:processSipRequestInvite **");
        SipSession reqSipSession = request.getSession();
        DlgcSipConnectorContentIdsProxy inviteReqProxy = (DlgcSipConnectorContentIdsProxy)request.getSession().getAttribute("container");
        inviteReqProxy.Load();
        DlgcJoinableContainer container = inviteReqProxy.getCachedContainer();
        DlgcXNetworkConnection dlgcXNetworkConnection = null;
        if (container instanceof DlgcXNetworkConnection) {
            dlgcXNetworkConnection = (DlgcXNetworkConnection)container;
        }
        if ((ms = (DlgcMediaSession)container.getMediaSession()) == null) {
            log.error("XMS Major Issue found: DlgcMediaSession returned as null from mrequest.getSession().getAttribute(container)");
        }
        DlgcIpmsSession dlgsession = dlgcXNetworkConnection.getDlgIpmsSession();
        dlgsession.setSipSession(reqSipSession);
        log.debug("XMS SIP-TIMER: processSipInvite Request due to MS SIP SESSION TIMER Request -> INVITE calling container.processsSipInvite() SIP-TIMER");
        container.processSipInvite(request);
        log.debug("XMS Returned from processing SIP Inviter Timer Request.");
        if (DlgcInstrumentPropertyMgr.bRcvSerialize && inviteReqProxy != null) {
            log.debug("XMS SaveMediaSession inside dlgSipB2BUA:processSipRequestInvite SIP INVITE Request from MS");
            inviteReqProxy.saveMediaSession();
        }
        log.debug("** XMS Returning from DlgcSipB2BUA:processSipRequestInvite IPMS SIP SESSION TIMER request **");
    }

    protected void processSipRequestBye(SipServletRequest request) {
        log.debug("**XMS Processing  MS Sip Bye Request inside DlgcSipB2BUA:processSipRequestBye **");
        SipSession reqSipSession = request.getSession();
        DlgcSipConnectorContentIdsProxy inviteReqProxy = (DlgcSipConnectorContentIdsProxy)request.getSession().getAttribute("container");
        log.debug("XMS The Media Server has Issued a BYE.... go ahead an find the JSR container to process the BYE");
        inviteReqProxy.Load();
        DlgcJoinableContainer container = inviteReqProxy.getCachedContainer();
        DlgcMediaSession ms = (DlgcMediaSession)container.getMediaSession();
        DlgcXNetworkConnection dlgcXNetworkConnection = null;
        if (container instanceof DlgcXNetworkConnection) {
            dlgcXNetworkConnection = (DlgcXNetworkConnection)container;
        }
        if (ms == null) {
            log.error("XMS Major Issue: DlgcMediaSession returned as null from mrequest.getSession().getAttribute(container) BYE");
        }
        DlgcIpmsSession dlgsession = dlgcXNetworkConnection.getDlgIpmsSession();
        dlgsession.setSipSession(reqSipSession);
        container.processSipBye(request);
        dlgcXNetworkConnection.setDlgIpmsSession(null);
        if (DlgcInstrumentPropertyMgr.bRcvSerialize && inviteReqProxy != null) {
            log.debug("XMS SaveMediaSession inside dlgSipB2BUA::processSipRequestBye");
            inviteReqProxy.saveMediaSession();
        }
        log.debug("**XMS Returning from DlgcSipB2BUA:processSipRequestBye request **");
    }

    @Override
    public void processSipResponseDoAction(SipServletResponse response) {
        SipServletRequest request = response.getRequest();
        DlgcSipServletRequestProxy sipServletRequestProxy = (DlgcSipServletRequestProxy)request.getAttribute(response.getHeader("CSeq"));
        log.debug(this.receiverName + " **Processing  MS Sip Response inside DlgcSipB2BUA:processSipResponseDoAction **");
        DlgcSipConnectorContentIdsProxy reqMasterContainerProxy = sipServletRequestProxy.getMasterContainerReqProxyResponse();
        reqMasterContainerProxy.Load();
        DlgcJoinableContainer container = reqMasterContainerProxy.getCachedContainer();
        String sipRequestMethod = response.getRequest().getMethod();
        if (sipRequestMethod.equals("INVITE")) {
            this.processSipResponseInvite(response, container);
        } else if (sipRequestMethod.equals("BYE")) {
            this.processSipResponseBye(response, container);
        } else if (sipRequestMethod.equals("INFO")) {
            this.processSipResponseInfo(response, container, sipServletRequestProxy);
        }
        if (DlgcInstrumentPropertyMgr.bRcvSerialize && reqMasterContainerProxy != null) {
            log.debug(this.receiverName + " SaveMediaSession inside dlgSipB2BUA:processSipResponseDoAction");
            reqMasterContainerProxy.saveMediaSession();
        }
    }

    protected void processSipResponseInvite(SipServletResponse response, DlgcJoinableContainer container) {
        log.debug(this.receiverName + " Processing Sip Invite Response inside processSipResponseInvite(INVITE)");
        Address toAddr = response.getTo();
        String tag = toAddr.getParameter("tag");
        log.debug(this.receiverName + " processSipResponseInvite(response) SIP Tag = " + tag);
        DlgcNetworkConnection dlgcXNetworkConnection = null;
        if (container instanceof DlgcXNetworkConnection) {
            dlgcXNetworkConnection = (DlgcXNetworkConnection)container;
        }
        DlgcIpmsSession msSession = dlgcXNetworkConnection.getDlgIpmsSession();
        msSession.setSipTag(tag);
        log.info("+++++++++++++++++++++++++++++++INVITE RESPONSE RECEIVER BEGINS++++++++++++++++++++++++++++++++++++++++++");
        log.info("JSR309:SIP-INVITE-RESPONSE-RECEIVER() : SIP MSG RECEIVED: " + response.toString());
        log.info("JSR309:SIP-INVITE-RESPONSE-RECEIVER() : SIP MSG OWNER Media OBJID: " + container.getMediaObject());
        log.info("JSR309:SIP-INVITE-RESPONSE-RECEIVER() : JSR309 Container ObjectID: " + container.getMediaObject());
        log.info("+++++++++++++++++++++++++++++++INVITE RESPONSE RECEIVER ENDS++++++++++++++++++++++++++++++++++++++++++++");
        container.processSipInvite(response);
        log.debug(this.receiverName + " Returning  processSipResponseInvite(INVITE)");
    }

    protected void processSipResponseInfo(SipServletResponse response, DlgcJoinableContainer container, DlgcSipServletRequestProxy sipServletRequestProxy) {
        log.debug("** XMS Processing Sip Info Response inside processSipResponseInfo **");
        SipServletRequest request = response.getRequest();
        SipSession requestSipSession = request.getSession();
        log.debug("Received processSipResponseDoAction(INFO) ");
        int stat = response.getStatus();
        if (stat != 200) {
            log.error("XMS processSipResponseInfo INFO Response status not OK ..not ignoring - trying to generate the event up to the applicationERROR = " + response.getStatus());
        }
        DlgcSipConnectorContentIdsProxy reqResourceProxy = sipServletRequestProxy.GetResourceReqProxyResponse();
        if (DlgcSipB2BUA.getMediaServerType().compareToIgnoreCase("XMS") == 0) {
            if (reqResourceProxy == null) {
                log.debug("XMS Major Issue: - reqProxy is NULL ");
            }
            reqResourceProxy.Load();
        } else {
            DlgcSipConnectorContentIdsProxy reqMasterContainerProxy = sipServletRequestProxy.getMasterContainerReqProxyResponse();
            reqMasterContainerProxy.Load();
        }
        container = reqResourceProxy.getCachedContainer();
        DlgcMediaSession ms = (DlgcMediaSession)container.getMediaSession();
        if (ms == null) {
            log.error("XMS DlgcMediaSession returned as null from reqResourceProxy.getCachedContainer(); during INFO Request");
        }
        DlgcNetworkConnection dlgcXNetworkConnection = null;
        if (container instanceof DlgcXNetworkConnection) {
            dlgcXNetworkConnection = (DlgcXNetworkConnection)container;
        }
        dlgcXNetworkConnection.getDlgIpmsSession().setSipSession(requestSipSession);
        log.debug("XMS calling container.processSipInfo(response, reqProxy) container= " + container.getMediaObject());
        container.processSipInfo(response, reqResourceProxy);
        if (DlgcSipServlet.APP_SERVER_PLATFORM.compareToIgnoreCase("IBM") != 0) {
            response.removeAttribute(response.getHeader("CSeq"));
        }
        log.debug("** XMS Returning from  DlgcSipB2BUA:processSipResponseInfo **");
    }

    protected void processSipResponseBye(SipServletResponse response, DlgcJoinableContainer container) {
        log.debug("** XMS Processing  MS Sip Bye Response inside DlgcSipB2BUA:processSipResponseBye **");
        log.debug("XMS processSipResponseBye: calling sessionManager removeSession container = " + container.toDebug());
        DlgcMediaSession ms = (DlgcMediaSession)container.getMediaSession();
        if (ms == null) {
            log.error("XMS Severe Issue: DlgcMediaSession returned as null from masterContainerReqProxy.getCachedContainer() during BYE Request");
        }
        DlgcXNetworkConnection dlgcXNetworkConnection = null;
        if (container instanceof DlgcXNetworkConnection) {
            dlgcXNetworkConnection = (DlgcXNetworkConnection)container;
        }
        log.debug("XMS DlgcSipB2BUA:processSipResponseBye RemoveDlgcSession because BYE");
        dlgcXNetworkConnection.setDlgIpmsSession(null);
        log.debug("XMS Calling container.processSipBye(response) were continer = " + container.getMediaObject());
        log.info("+++++++++++++++++++++++++++++++BYE RESPONSE RECEIVER BEGINS++++++++++++++++++++++++++++++++++++++++++");
        log.info("JSR309:SIP-BYE-RESPONSE-RECEIVER() : SIP MSG RECEIVED: " + response.toString());
        log.info("JSR309:SIP-BYE-RESPONSE-RECEIVER() : SIP MSG OWNER Media OBJID: " + container.getMediaObject());
        log.info("JSR309:SIP-BYE-RESPONSE-RECEIVER() : JSR309 Container ObjectID: " + container.getMediaObject());
        log.info("+++++++++++++++++++++++++++++++BYE RESPONSE RECEIVER ENDS++++++++++++++++++++++++++++++++++++++++++++");
        container.processSipBye(response);
        if (response.getSession().isValid()) {
            log.debug("XMS Invalidating SipSession...due to BYE");
            response.getSession().invalidate();
        }
        log.debug("** XMS Returning from DlgcSipB2BUA:processSipResponseBye **");
    }

    protected void processSipRequestUpdate(SipServletRequest request) {
        log.debug("** XMS Processing MS Sip UPDATE Request inside DlgcAbstractB2BUAReceiver:processSipRequestUpdate **");
        SipSession reqSipSession = request.getSession();
        DlgcSipConnectorContentIdsProxy inviteReqProxy = (DlgcSipConnectorContentIdsProxy)request.getSession().getAttribute("container");
        inviteReqProxy.Load();
        DlgcJoinableContainer container = inviteReqProxy.getCachedContainer();
        DlgcXNetworkConnection dlgcXNetworkConnection = null;
        if (container instanceof DlgcXNetworkConnection) {
            dlgcXNetworkConnection = (DlgcXNetworkConnection)container;
            DlgcMediaSession ms = (DlgcMediaSession)container.getMediaSession();
            if (ms == null) {
                log.error("DlgcAbstractB2BUAReceiver::processSipRequesUpdate: XMS Major Issue found: DlgcMediaSession returned as null from mrequest.getSession().getAttribute(container)");
            }
            DlgcIpmsSession dlgsession = dlgcXNetworkConnection.getDlgIpmsSession();
            dlgsession.setSipSession(reqSipSession);
            log.debug("DlgcAbstractB2BUAReceiver::processSipRequesUpdate:  XMS SIP-TIMER: Request due to MS SIP SESSION TIMER Request -> INVITE calling container.processsSipInvite() SIP-TIMER");
            log.info("+++++++++++++++++++++++++++++++INVITE PING UPDATE REQUEST RECEIVER BEGINS++++++++++++++++++++++++++++++++++++++++++");
            log.info("JSR309:SIP-PING-UPDATE-RECEIVER() : SIP MSG RECEIVED: " + request.toString());
            log.info("JSR309:SIP-PING-UPDATE-RECEIVER() : SIP MSG OWNER Media OBJID: " + container.getMediaObject());
            log.info("JSR309:SIP-PING-UPDATE-RECEIVER() : JSR309 Container ObjectID: " + container.getMediaObject());
            log.info("+++++++++++++++++++++++++++++++INVITE PING UPDATE REQUEST RECEIVER ENDS++++++++++++++++++++++++++++++++++++++++++++");
            container.processSipUpdate(request);
            log.debug("DlgcAbstractB2BUAReceiver::processSipRequesUpdate: XMS Returned from processing SIP Inviter Timer Request.");
            if (DlgcInstrumentPropertyMgr.bRcvSerialize && inviteReqProxy != null) {
                log.debug("DlgcAbstractB2BUAReceiver::processSipRequesUpdate: XMS SaveMediaSession inside SIP UPDATE Request from MS");
                inviteReqProxy.saveMediaSession();
            }
            log.debug("** XMS Returning from lgcAbstractB2BUAReceiver::processSipRequesUpdate XMS SIP SESSION TIMER request **");
        }
    }
}

