/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.signals;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.msmlProtocol.DlgcMsmlDialogEventExitStatus;
import com.vendor.dialogic.javax.media.mscontrol.msmlProtocol.DlgcMsmlProtocolMessageMappingAssistance;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSigDetectorFSM;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSigDetectorStates;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetectorEvent;
import java.io.IOException;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.mediagroup.signals.SignalDetectorEvent;
import javax.servlet.sip.SipServletResponse;

class DlgcStopPendingState
extends DlgcSigDetectorStates {
    public DlgcStopPendingState() {
        this.stateName = "DlgcStopPendingState";
    }

    @Override
    public void evSipInfo(DlgcFSM fsm, SipServletResponse response) throws MsControlException {
        if (response.getStatus() == 200) {
            log.debug(" DTMF STOP Pending State - Media Server acknowledge the Stop request waiting for completion");
        } else {
            fsm.setState(initialState);
            log.debug("Response error code received ");
        }
    }

    @Override
    public void evSipInfo(DlgcFSM fsm, MsmlDocument.Msml message) throws MsControlException {
        DlgcSignalDetector sd = ((DlgcSigDetectorFSM)fsm).getSignalDetector();
        DlgcMediaGroup mg = (DlgcMediaGroup)sd.getContainer();
        String appLogId = ((DlgcMediaSession)mg.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "Inside DlgcStopPendingState evSipInfo...Dialog Exit");
        String eventName = new String("undefine");
        MsmlDocument.Msml.Event msmlEvent = message.getEvent();
        if (msmlEvent != null) {
            eventName = msmlEvent.getName2();
        } else {
            log.error(appLogId + "MSML EVENT IS NULL");
        }
        if (eventName.equalsIgnoreCase("msml.dialog.exit")) {
            fsm.setState(initialState);
            log.debug(appLogId + "Receive Dialog Exit Event");
            DlgcMsmlDialogEventExitStatus dlgExitEventStatus = DlgcMsmlProtocolMessageMappingAssistance.getExitDialogEventStatus(message);
            if (dlgExitEventStatus.status == null) {
                log.debug(appLogId + "DlgcStopPendingState evSipInfo...sending DlgcSignalDetectorEvent.RECEIVE_SIGNALS_COMPLETED Qualifier is STOPPED");
                DlgcSignalDetectorEvent sdEvent = new DlgcSignalDetectorEvent(sd);
                sdEvent.setEventType(DlgcSignalDetectorEvent.RECEIVE_SIGNALS_COMPLETED);
                sdEvent.setQualifier(SignalDetectorEvent.STOPPED);
                sd.postMediaEvent(sdEvent);
                if (mg.getActiveResources() > 0) {
                    log.warn("DlgcStopPendingState evSipInfo: sending response 200 OK back to Media Server");
                    log.debug("DlgcStopPendingState evSipInfo XMS processSipRequestInfo(): DONE sending response 200 OK back to Media Server");
                    SipServletResponse response = sd.getServletResponse();
                    try {
                        response.send();
                    }
                    catch (IOException e) {
                        log.debug(e.toString());
                    }
                    log.debug("DlgcSigDetectorStates::DlgcStopPendingState - calling media group resourceStopNotifier() ");
                    DlgcSignalDetector.SIGNAL_TYPES detectionType = sd.getSignalingType();
                    if (detectionType == DlgcSignalDetector.SIGNAL_TYPES.ASYNC_COLLECT) {
                        log.debug("DlgcSigDetectorStates::DlgcStopPendingState - ASYNC_COLLECT calling media group resourceStopNotifier(DETECTOR) ");
                        mg.resourceStopNotifier("DETECTOR");
                    } else if (detectionType == DlgcSignalDetector.SIGNAL_TYPES.PLAY_AND_COLLECT) {
                        log.debug("DlgcSigDetectorStates::DlgcStopPendingState - PLAY_AND_COLLEC calling media group resourceStopNotifier(PLAYER) ");
                        mg.resourceStopNotifier("PLAYER");
                    } else if (detectionType == DlgcSignalDetector.SIGNAL_TYPES.COLLECT) {
                        log.debug("DlgcSigDetectorStates::DlgcStopPendingState - SIGNAL_TYPES.COLLECT calling media group resourceStopNotifier(DETECTOR) ");
                        mg.resourceStopNotifier("DETECTOR");
                    }
                }
            } else {
                log.debug(appLogId + "DlgcStopPendingState evSipInfo...sending ERROR DlgcSignalDetectorEvent.RECEIVE_SIGNALS_COMPLETED Qualifier is STOPPED");
                mg.joinedWithNetworkConnection().getDlgIpmsSession().removeEvent();
                DlgcSignalDetectorEvent sdEvent = new DlgcSignalDetectorEvent(sd);
                sdEvent.setErrorText(dlgExitEventStatus.description);
                sdEvent.setError(MediaErr.RESOURCE_UNAVAILABLE);
                sd.postMediaEvent(sdEvent);
            }
        } else {
            log.debug(appLogId + "DTMF ASYNC STOP REPLY FROM Media SERVER - Expecting msml dialog exit but eventName is not of this type...doing nothing");
        }
    }
}

