/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.signals;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynCallbackImpl;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynDispatcher;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalGenerator;
import java.io.Serializable;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.signals.SignalGenerator;
import javax.media.mscontrol.mediagroup.signals.SignalGeneratorEvent;
import javax.media.mscontrol.resource.RTC;
import javax.media.mscontrol.resource.ResourceContainer;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcSignalGeneratorProxy
extends DlgcProxy
implements SignalGenerator,
Serializable {
    private static final long serialVersionUID = 76598576498398774L;
    private static Logger log = LoggerFactory.getLogger(DlgcSignalGeneratorProxy.class);

    public DlgcSignalGeneratorProxy(String id, String mediaSessionId, String objectId) {
        super(id, mediaSessionId, objectId);
    }

    public void emitSignals(Value[] arg0, RTC[] arg1, Parameters arg2) throws MsControlException {
        log.debug("DlgcSignalGeneratorProxy::emitSignals  using emitSignalsAsync");
        this.emitSignalsAsync(arg0, arg1, arg2);
    }

    public void emitSignalsAsync(final Value[] arg0, final RTC[] arg1, final Parameters arg2) throws MsControlException {
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        DlgcSignalGenerator sg = (DlgcSignalGenerator)mg.getSignalGenerator();
                        sg.emitSignals(arg0, arg1, arg2);
                        DlgcSignalGeneratorProxy pproxy = sg.getProxy();
                        pproxy.saveMediaSession(appSession, session);
                    }
                    catch (MsControlException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to get SignalGenerator. emitSignals failed", (Throwable)e);
            throw new MsControlException("Failed to get SignalGenerator. emitSignals failed", (Throwable)e);
        }
    }

    public void emitSignals(String arg0, RTC[] arg1, Parameters arg2) throws MsControlException {
        log.debug("DlgcSignalGeneratorProxy::emitSignals  using emitSignalsAsync");
        this.emitSignalsAsync(arg0, arg1, arg2);
    }

    public void emitSignalsAsync(final String arg0, final RTC[] arg1, final Parameters arg2) throws MsControlException {
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        DlgcSignalGenerator sg = (DlgcSignalGenerator)mg.getSignalGenerator();
                        sg.emitSignals(arg0, arg1, arg2);
                        DlgcSignalGeneratorProxy pproxy = sg.getProxy();
                        pproxy.saveMediaSession(appSession, session);
                    }
                    catch (MsControlException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to get SignalGenerator. emitSignals failed", (Throwable)e);
            throw new MsControlException("Failed to get SignalGenerator. emitSignals failed", (Throwable)e);
        }
    }

    public void stop() {
        log.debug("DlgcSignalGeneratorProxy::stop  using stopAsync");
        this.stopAsync();
    }

    public void stopAsync() {
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        DlgcSignalGenerator sg = (DlgcSignalGenerator)mg.getSignalGenerator();
                        sg.stop();
                        DlgcSignalGeneratorProxy pproxy = sg.getProxy();
                        pproxy.saveMediaSession(appSession, session);
                    }
                    catch (MsControlException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to get SignalGenerator. stop failed", (Throwable)e);
        }
    }

    public ResourceContainer getContainer() {
        DlgcMediaGroup mgImpl = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            mgImpl = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
        }
        catch (Exception e) {
            log.error("Failed to getContainer", (Throwable)e);
        }
        return (MediaGroup)mgImpl.getProxy();
    }

    public void addListener(MediaEventListener<SignalGeneratorEvent> arg0) {
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
            DlgcSignalGenerator sg = (DlgcSignalGenerator)mg.getSignalGenerator();
            sg.addListener(arg0);
            DlgcSignalGeneratorProxy pproxy = sg.getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to get addListener. stop failed", (Throwable)e);
        }
    }

    public MediaSession getMediaSession() {
        DlgcMediaSession ms = null;
        SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
        String mediaId = this.getMsObjectId();
        try {
            ms = (DlgcMediaSession)appSession.getAttribute(mediaId);
        }
        catch (Exception e) {
            log.error("Failed to GetProxyMediaSession", (Throwable)e);
        }
        return ms.getProxy();
    }

    public void removeListener(MediaEventListener<SignalGeneratorEvent> arg0) {
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
            DlgcSignalGenerator sg = (DlgcSignalGenerator)mg.getSignalGenerator();
            sg.removeListener(arg0);
            DlgcSignalGeneratorProxy pproxy = sg.getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to get removeListener. stop failed", (Throwable)e);
        }
    }
}

