/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.signals;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSupportedFeatures;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayer;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResource;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalGeneratorProxy;
import com.vendor.dialogic.javax.media.mscontrol.signals.parameters.DlgcSGSignalLengthParameter;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.signals.SignalGenerator;
import javax.media.mscontrol.mediagroup.signals.SignalGeneratorEvent;
import javax.media.mscontrol.resource.RTC;
import javax.media.mscontrol.resource.ResourceContainer;
import javax.servlet.sip.SipServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcSignalGenerator
extends DlgcResource<ResourceContainer, SignalGeneratorEvent>
implements SignalGenerator {
    private static final long serialVersionUID = 1L;
    private static DlgcParameters supportedParameters;
    private static Logger log;
    private DlgcPlayer thePlayer;
    private static DlgcSupportedFeatures supportedFeatures;

    public DlgcSignalGenerator(MediaGroup mg) {
        super(mg);
        try {
            this.thePlayer = (DlgcPlayer)mg.getPlayer();
        }
        catch (MsControlException e) {
            log.error("Exception creating Signal Generator: ", (Throwable)e);
        }
    }

    public void emitSignals(Value[] signals, RTC[] rtcs, Parameters params) throws MsControlException {
        Parameters executionParams = null;
        try {
            this.verifyParameterSupport(params);
            executionParams = this.getParameters(params);
            this.verifyRTCSupport(rtcs);
        }
        catch (MsControlException mex) {
            log.error("Rejecting emitSignal method because: ", (Throwable)mex);
            throw mex;
        }
        this.emitSignals(signals.toString(), rtcs, executionParams);
    }

    public void emitSignals(String signals, RTC[] rtcs, Parameters params) throws MsControlException {
        this.thePlayer.playDtmfSignals(this, signals, rtcs, params);
    }

    public void stop() {
        this.thePlayer.stop(false);
    }

    @Override
    protected DlgcParameters getSupportedParameters() {
        return supportedParameters;
    }

    @Override
    public void processSipInfoResponse(SipServletResponse sipResponse, DlgcSipConnectorContentIdsProxy proxy) {
    }

    protected void verifyParameterSupport(Parameters params) throws MsControlException {
        if (params == Parameters.NO_PARAMETER) {
            return;
        }
        Set entries = params.entrySet();
        for (Map.Entry val : entries) {
            if (supportedParameters.containsKey(val.getKey())) continue;
            throw new MsControlException("The following passed in parameter is not supported: " + val.getValue().toString());
        }
    }

    protected void verifyRTCSupport(RTC[] rtcs) throws MsControlException {
    }

    public static DlgcParameters loadSupportedParameters() {
        return supportedParameters;
    }

    public static void loadSupportedFeatures(DlgcSupportedFeatures sf) {
        sf.appendSfParameters(supportedFeatures.getSupportedParameters());
        sf.appendSfEventTypes(supportedFeatures.getSupportedEventTypes());
        sf.appendSfValues(supportedFeatures.getSupportedValues());
        sf.appendSfQualifiers(supportedFeatures.getSupportedQualifiers());
    }

    @Override
    public DlgcSignalGeneratorProxy getProxy() {
        DlgcResourceContainer container = (DlgcResourceContainer)this.container;
        String componentProxyId = container.getProxyId();
        String sasId = ((DlgcMediaSession)container.getMediaSession()).getProxyId();
        String msObjId = ((DlgcMediaSession)container.getMediaSession()).getMediaObject();
        return new DlgcSignalGeneratorProxy(sasId, componentProxyId, msObjId);
    }

    static {
        log = LoggerFactory.getLogger(DlgcSignalGenerator.class);
        supportedFeatures = new DlgcSupportedFeatures();
        supportedParameters = new DlgcParameters();
        supportedParameters.put(SignalGenerator.SIGNAL_LENGTH, DlgcSGSignalLengthParameter.instance);
        HashSet<Parameter> sp = new HashSet<Parameter>();
        sp.add(SignalGenerator.SIGNAL_LENGTH);
        supportedFeatures.setSfParameters(sp);
        HashSet<EventType> sev = new HashSet<EventType>();
        sev.add(SignalGeneratorEvent.EMIT_SIGNALS_COMPLETED);
        supportedFeatures.setSfEventTypes(sev);
        HashSet<Qualifier> sq = new HashSet<Qualifier>();
        sq.add(SignalGeneratorEvent.STOPPED);
        supportedFeatures.setSfQualifiers(sq);
    }
}

