/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.signals;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynCallbackImpl;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynDispatcher;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcXSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import java.io.Serializable;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.UnsupportedException;
import javax.media.mscontrol.join.JoinException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.mediagroup.signals.SignalDetectorEvent;
import javax.media.mscontrol.resource.RTC;
import javax.media.mscontrol.resource.ResourceContainer;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcSignalDetectorProxy
extends DlgcProxy
implements SignalDetector,
Serializable {
    private static final long serialVersionUID = 76598576498398774L;
    private static Logger log = LoggerFactory.getLogger(DlgcSignalDetector.class);

    public DlgcSignalDetectorProxy(String id, String mediaSessionId, String objectId) {
        super(id, mediaSessionId, objectId);
    }

    public void flushBuffer() throws MsControlException {
        if (this.isTCKEnabled()) {
            log.debug("SignalDetector : flushBuffer() is not supported in this version of the connector.");
            throw new MsControlException("SignalDetector : flushBuffer() is not supported in this version of the connector.");
        }
        log.debug("DlgcSignalDetectorProxy::flushBuffer  using flushBufferAsync");
        this.flushBufferSync();
    }

    protected void flushBufferSync() {
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
            DlgcSignalDetector sd = (DlgcSignalDetector)mg.getSignalDetector();
            sd.flushBuffer();
            DlgcSignalDetectorProxy pproxy = sd.getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to execute flushBuffer synchronously", (Throwable)e);
        }
    }

    public void flushBufferAsync() throws MsControlException {
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        DlgcSignalDetector sd = (DlgcSignalDetector)mg.getSignalDetector();
                        sd.flushBuffer();
                        DlgcSignalDetectorProxy pproxy = sd.getProxy();
                        pproxy.saveMediaSession(appSession, session);
                    }
                    catch (MsControlException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to get signalDetector. flushBuffer failed", (Throwable)e);
            throw new MsControlException("Failed to get signalDetector. flushBuffer failed", (Throwable)e);
        }
    }

    public void receiveSignals(int arg0, Parameter[] arg1, RTC[] arg2, Parameters arg3) throws MsControlException {
        if (null != arg2 && arg2.length > 0) {
            if (arg2[0].getAction() == Player.STOP && arg2[0].getTrigger() == Player.PLAY_START) {
                throw new UnsupportedException("SignalDetector : RTC combination RTC(Player.PLAY_START, Player.STOP) is not supported.");
            }
            if ((arg2.length != 2 || arg2[0].getAction() != SignalDetector.CANCEL || arg2[0].getTrigger() != SignalDetector.PATTERN_MATCH[1] || arg2[1].getAction() != SignalDetector.STOP || arg2[1].getTrigger() != SignalDetector.PATTERN_MATCH[0]) && arg2[0] != MediaGroup.SIGDET_STOPPLAY && arg2[0].getAction() != Player.STOP) {
                throw new MsControlException("SignalDetector : RTC is not supported in this version of the connector.");
            }
        }
        log.debug("DlgcSignalDetectorProxy::receiveSignals  using receiveSignalsAsync");
        this.receiveSignalsAsync(arg0, arg1, arg2, arg3);
    }

    public void receiveSignalsAsync(final int arg0, final Parameter[] arg1, final RTC[] arg2, final Parameters arg3) throws MsControlException {
        final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("SignalDetector:receiveSignal Request");
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        DlgcSignalDetector sd = (DlgcSignalDetector)mg.getSignalDetector();
                        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                            sd.setMonitor(monitor);
                        }
                        sd.receiveSignals(arg0, arg1, arg2, arg3);
                        DlgcSignalDetectorProxy pproxy = sd.getProxy();
                        pproxy.saveMediaSession(appSession, session);
                    }
                    catch (MsControlException e) {
                        // empty catch block
                    }
                }
            });
            if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("SYNC_2_ASYNC: receiveSignalsAsync:: OUTSIDE Waiting synchronously for ReceiveSignal request to return");
                monitor.waitForRequestCompletion();
                log.debug("SYNC_2_ASYNC: receiveSignalsAsync: OUTSIDE ReceiveSignal Monitor returned with the following status: " + monitor.getStatusString());
                boolean status = monitor.getStatus();
                String statusMsg = monitor.getStatusString();
                DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS extype = monitor.getExceptionType();
                DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                ((DlgcXSignalDetector)mg.getSignalDetector()).setMonitor(null);
                if (!status) {
                    if (extype.compareTo(DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS.JOIN_EXCEPTION) == 0) {
                        log.debug("DlgcSignalDetectorProxy-Exception ... executing Monitor Notify JOIN method");
                        throw new JoinException(statusMsg);
                    }
                    if (extype.compareTo(DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS.UNSUPPORTED_EXCEPTION) == 0) {
                        log.debug("DlgcSignalDetectorProxy-Exception ... executing Monitor Notify UNSUPPORTED method");
                        throw new UnsupportedException(statusMsg);
                    }
                    log.debug("DlgcSignalDetectorProxy-Exception ... executing Monitor Notify MsControl method");
                    throw new MsControlException(statusMsg);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof UnsupportedException) {
                throw new UnsupportedException(e.getMessage());
            }
            if (e instanceof JoinException) {
                throw new JoinException(e.getMessage());
            }
            throw new MsControlException(e.getMessage());
        }
    }

    public void stop() {
        log.debug("DlgcSignalDetectorProxy::stop  using stopDontWait");
        this.stopDontWait();
    }

    public void stopAsync() {
        try {
            log.debug("DlgcSignalDetectorProxyEntering stopAsync()");
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("SignalDetector:Stop Request");
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("DlgcSignalDetectorProxyEntering stopAsync(): inside the Run Async Work Action");
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        DlgcSignalDetector sd = (DlgcSignalDetector)mg.getSignalDetector();
                        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                            sd.setMonitor(monitor);
                        }
                        log.debug("SYNC_2_ASYNC DlgcSignalDetectorProxy Entering stopAsync(): inside the Run Async Work Action callin sd.stop()");
                        sd.stop();
                        log.debug("SYNC_2_ASYNCDlgcSignalDetectorProxy Entering stopAsync(): returned from sd.stop()");
                        DlgcSignalDetectorProxy pproxy = sd.getProxy();
                        log.debug("SYNC_2_ASYNC DlgcSignalDetectorProxyEntering stopAsync(): calling saveMediaSession");
                        pproxy.saveMediaSession(appSession, session);
                        log.debug("SYNC_2_ASYNC DlgcSignalDetectorProxyEntering stopAsync(): rturned from saveMediaSession");
                    }
                    catch (MsControlException e) {
                        log.debug(e.toString());
                        e.printStackTrace();
                    }
                    log.debug("DlgcSignalDetectorProxyEntering stopAsync(): out of the Run Async Work Action");
                }
            });
            if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("SYNC_2_ASYNC SignalDetectorProxy stopAsync: OUTSIDE Waiting synchronously for Signal Detector Stop request to return");
                monitor.waitForRequestCompletion();
                String statusDesc = monitor.getStatusString();
                log.debug("SYNC_2_ASYNC SignalDetectorProxy stopAsync: OUTSIDE Signal Detector Stop Monitor returned with the following status: " + statusDesc);
                DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                ((DlgcXSignalDetector)mg.getSignalDetector()).setMonitor(null);
            }
        }
        catch (Exception e) {
            log.error("Failed to get signalDetector. stop failed", (Throwable)e);
        }
        log.debug("Leaving DlgcSignalDetectorProxyEntering stopAsync()");
    }

    public void stopDontWait() {
        try {
            log.debug("DlgcSignalDetectorProxyEntering stopDontWait()");
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("DlgcSignalDetectorProxyEntering stopDontWait(): inside the Run Async Work Action");
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        DlgcSignalDetector sd = (DlgcSignalDetector)mg.getSignalDetector();
                        log.debug("SYNC_2_ASYNC DlgcSignalDetectorProxy Entering stopDontWait(): inside the Run Async Work Action callin sd.stop()");
                        sd.stop();
                        log.debug("SYNC_2_ASYNCDlgcSignalDetectorProxy Entering stopDontWait(): returned from sd.stop()");
                        DlgcSignalDetectorProxy pproxy = sd.getProxy();
                        log.debug("SYNC_2_ASYNC DlgcSignalDetectorProxyEntering stopDontWait(): calling saveMediaSession");
                        pproxy.saveMediaSession(appSession, session);
                        log.debug("SYNC_2_ASYNC DlgcSignalDetectorProxyEntering stopDontWait(): rturned from saveMediaSession");
                    }
                    catch (MsControlException e) {
                        log.debug(e.toString());
                        e.printStackTrace();
                    }
                    log.debug("DlgcSignalDetectorProxyEntering stopDontWait(): out of the Run Async Work Action");
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to get signalDetector. stopDontWait failed", (Throwable)e);
        }
        log.debug("Leaving DlgcSignalDetectorProxyEntering stopDontWait()");
    }

    public ResourceContainer getContainer() {
        DlgcMediaGroup mgImpl = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            mgImpl = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
        }
        catch (Exception e) {
            log.error("Failed to getContainer", (Throwable)e);
        }
        return (MediaGroup)mgImpl.getProxy();
    }

    public void addListener(MediaEventListener<SignalDetectorEvent> arg0) {
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
            DlgcSignalDetector sd = (DlgcSignalDetector)mg.getSignalDetector();
            sd.addListener(arg0);
            DlgcSignalDetectorProxy pproxy = sd.getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to get addListener. stop failed", (Throwable)e);
        }
    }

    public MediaSession getMediaSession() {
        DlgcMediaSession ms = null;
        SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
        String mediaId = this.getMsObjectId();
        try {
            ms = (DlgcMediaSession)appSession.getAttribute(mediaId);
        }
        catch (Exception e) {
            log.error("Failed to GetProxyMediaSession", (Throwable)e);
        }
        return ms.getProxy();
    }

    public void removeListener(MediaEventListener<SignalDetectorEvent> arg0) {
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
            DlgcSignalDetector sd = (DlgcSignalDetector)mg.getSignalDetector();
            sd.removeListener(arg0);
            DlgcSignalDetectorProxy pproxy = sd.getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to get removeListener. stop failed", (Throwable)e);
        }
    }

    protected boolean isTCKEnabled() {
        String tckFlag = System.getenv("TCK_ENABLED");
        log.debug("Value of TCK_ENABLED flag is :" + tckFlag);
        boolean isTCKEnabled = false;
        if (null == tckFlag || tckFlag.equalsIgnoreCase("NO")) {
            log.warn("Environment Variable: " + "TCK_ENABLED" + " not set");
            log.warn("Assuming TCK is not enabled");
            isTCKEnabled = false;
        } else if (tckFlag.equalsIgnoreCase("YES")) {
            isTCKEnabled = true;
        }
        log.debug("Value of TCK_ENABLED flag is :" + isTCKEnabled);
        return isTCKEnabled;
    }
}

