/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.signals;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSupportedFeatures;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcAudioCodecParameter;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResource;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSigDetectorFSM;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetectorProxy;
import com.vendor.dialogic.javax.media.mscontrol.signals.parameters.DlgcSDBufferSizeParameter;
import com.vendor.dialogic.javax.media.mscontrol.signals.parameters.DlgcSDBufferingParameter;
import com.vendor.dialogic.javax.media.mscontrol.signals.parameters.DlgcSDEnableEventParameter;
import com.vendor.dialogic.javax.media.mscontrol.signals.parameters.DlgcSDInitTimeoutParameter;
import com.vendor.dialogic.javax.media.mscontrol.signals.parameters.DlgcSDMaxDurationParameter;
import com.vendor.dialogic.javax.media.mscontrol.signals.parameters.DlgcSDPatternParameter;
import com.vendor.dialogic.javax.media.mscontrol.signals.parameters.DlgcSDPromptParameter;
import com.vendor.dialogic.javax.media.mscontrol.signals.parameters.DlgcSDSigTimeoutParameter;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.UnsupportedException;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.join.JoinException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.signals.SignalConstants;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.mediagroup.signals.SignalDetectorEvent;
import javax.media.mscontrol.resource.RTC;
import javax.media.mscontrol.resource.ResourceContainer;
import javax.media.mscontrol.resource.Trigger;
import javax.servlet.sip.SipServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcSignalDetector
extends DlgcResource<ResourceContainer, SignalDetectorEvent>
implements SignalDetector {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcSignalDetector.class);
    private static DlgcParameters supportedParameters;
    private static DlgcSupportedFeatures supportedFeatures;
    protected DlgcSigDetectorFSM myFSM = null;
    protected boolean detectorCreatedInMediaServer;
    protected boolean filterPatterns;
    protected boolean clearBufferFlag;
    public static HashMap<String, Value> SignalConstantTable;
    public static HashMap<String, String> SignalConstantNameTable;
    public static boolean useHackDetector;
    public static final int Pattern_Count = 32;
    protected SIGNAL_TYPES signalType = SIGNAL_TYPES.NONE;

    public DlgcSignalDetector(MediaGroup mg) {
        super(mg);
        this.myFSM = new DlgcSigDetectorFSM((DlgcResourceContainer)mg);
        this.detectorCreatedInMediaServer = false;
        this.filterPatterns = false;
    }

    public void flushBuffer() throws MsControlException {
        if (this.isTCKEnabled()) {
            String exceptionMsg = "SignalDetector:flushBuffer() is not supported in this version of the connector.";
            log.warn("Throwing Exception: " + exceptionMsg);
            throw new MsControlException(exceptionMsg);
        }
        log.debug("DlgcSignalDetector::flushBuffer: clear Buffer flag has been set");
        this.clearBufferFlag = true;
    }

    protected void monitorNotify(String cmd, String statusMsg, boolean bStatus, DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS extype) {
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            DlgcSync2AsyncMonitor monitor = this.getMonitor();
            if (monitor == null) {
                log.info("SYNC_2_ASYNC DlgcSignalDetector:: " + cmd + " in a synchronous mode but note DlgcSync2AsyncMonitor is NULL");
            } else {
                monitor.setExceptionType(extype);
                log.debug("SYNC_2_ASYNC DlgcSignalDetector:: " + cmd + " calling Monitor notifyRequestCompleted");
                monitor.notifyRequestCompleted(bStatus, statusMsg);
                log.debug("SYNC_2_ASYNC DlgcSignalDetector:: " + cmd + " returning from Monitor notifyRequestCompleted");
            }
        }
    }

    public void receiveSignals(int numSignals, Parameter[] patterns, RTC[] rtcs, Parameters params) throws MsControlException {
        block6: {
            Parameters executionParams = null;
            try {
                this.verifyParameterSupport(params);
                this.logPassedInPatterns(patterns);
                executionParams = this.getParameters(params);
                String result = this.verifyRTCSupport(rtcs);
                if (result == null) {
                    try {
                        String errorMsg = "Record Aborted..not joined to either a Network Connection or Mixer";
                        boolean isJOINED = ((DlgcMediaGroup)this.container).isJoinedToNetworkConectionOrMixer();
                        if (!isJOINED) {
                            this.monitorNotify("record", errorMsg, false, DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS.JOIN_EXCEPTION);
                            throw new JoinException(errorMsg);
                        }
                        log.info("JSR309 API REQUEST:SignalDetector receiveSignals() : MG MEDIA OBJID: " + ((DlgcMediaGroup)this.container).getMediaObject());
                        this.myFSM.evReceiveSignals(numSignals, patterns, rtcs, executionParams);
                        break block6;
                    }
                    catch (MsControlException msex) {
                        log.debug("signal detector-Exception ... Inside Signal Detector Re-Throw");
                        throw msex;
                    }
                }
                log.info(result);
                this.monitorNotify("SignalDetecgtor", result, false, DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS.UNSUPPORTED_EXCEPTION);
                throw new UnsupportedException(result);
            }
            catch (MsControlException mex) {
                String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
                log.error(appLogId + "signal detector-Exception Rejecting receiveSignals method because: ", (Throwable)mex);
                throw mex;
            }
        }
    }

    private void logPassedInPatterns(Parameter[] patterns) {
        log.debug("DlgcSignalDetector: The Following patterns have been passed to the receiveSignals Method:");
        if (patterns == null) {
            log.debug("DlgcSignalDetector: No patterns were passed in");
        } else {
            for (Parameter p : patterns) {
                log.debug("Passed In Pattern: " + p.toString());
            }
        }
    }

    public void stop() {
        log.debug("Entering DlgcSignalDetector::stop()");
        try {
            log.debug("DlgcSignalDetector:: calling myFSM.evStop()");
            log.info("JSR309 API REQUEST:SignalDetector stop(): MG MEDIA OBJID: " + ((DlgcMediaGroup)this.container).getMediaObject());
            this.myFSM.evStop();
            log.debug("DlgcSignalDetector:: return from myFSM.evStop()");
        }
        catch (MsControlException mse) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.error(appLogId + "Can't stop: ", (Throwable)mse);
        }
        log.debug("Leaving DlgcSignalDetector::stop()");
    }

    protected void verifyParameterSupport(Parameters params) throws MsControlException {
        if (params == Parameters.NO_PARAMETER) {
            return;
        }
        Set entries = params.entrySet();
        Iterator it = entries.iterator();
        this.setFilterPatterns(false);
        while (it.hasNext()) {
            Map.Entry val = (Map.Entry)it.next();
            log.debug("Passed In Parameter: " + ((Parameter)val.getKey()).toString());
            if (!supportedParameters.containsKey(val.getKey())) {
                String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
                throw new MsControlException(appLogId + "The following passed in parameter is not supported: " + ((Parameter)val.getKey()).toString());
            }
            Parameter parmKeyValName = (Parameter)val.getKey();
            if (!parmKeyValName.equals(SignalDetector.FILTERED_PATTERNS)) continue;
            log.debug("FILTERED_PATTERNS ACTIVE");
            this.setFilterPatterns(true);
        }
    }

    public void setFilterPatterns(boolean b) {
        this.filterPatterns = b;
    }

    public boolean getFilterPatterns() {
        return this.filterPatterns;
    }

    protected String verifyRTCSupport(RTC[] rtcs) throws MsControlException {
        String result = null;
        if (rtcs == null) {
            return result;
        }
        for (RTC aRtc : rtcs) {
            if (aRtc.getAction() == Player.STOP && aRtc.getTrigger() == SignalDetector.DETECTION_OF_ONE_SIGNAL) continue;
            result = "RTC not supported: " + aRtc.getAction().toString();
            break;
        }
        return result;
    }

    protected void verifyPatternSupport(Parameters patterns) throws MsControlException {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        throw new MsControlException(appLogId + "Rejecting request because passed in patterns are not supported by this release.");
    }

    @Override
    protected DlgcParameters getSupportedParameters() {
        return supportedParameters;
    }

    public static DlgcParameters loadSupportedParameters() {
        return supportedParameters;
    }

    @Override
    public void processSipInfoResponse(SipServletResponse sipResponse, DlgcSipConnectorContentIdsProxy sipReqProxy) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        try {
            this.myFSM.evSipInfo(sipResponse);
            if (useHackDetector) {
                log.debug(appLogId + "**************************** RESOURCE setAttribute enabled *********************");
                sipResponse.getRequest().getSession().setAttribute("RESOURCE", (Object)sipReqProxy);
            }
        }
        catch (MsControlException ex) {
            log.error(appLogId + "processSipInfoResponse fail for Async Dtmf due to : ", (Throwable)ex);
        }
    }

    @Override
    public DlgcSignalDetectorProxy getProxy() {
        DlgcResourceContainer container = (DlgcResourceContainer)this.container;
        String componentProxyId = container.getProxyId();
        String sasId = ((DlgcMediaSession)container.getMediaSession()).getProxyId();
        String msObjId = ((DlgcMediaSession)container.getMediaSession()).getMediaObject();
        return new DlgcSignalDetectorProxy(sasId, componentProxyId, msObjId);
    }

    public boolean getCreatedInMediaServer() {
        return this.detectorCreatedInMediaServer;
    }

    public void setCreatedInMediaServer(boolean created) {
        this.detectorCreatedInMediaServer = created;
    }

    public boolean isClearBufferFlag() {
        return this.clearBufferFlag;
    }

    public void setClearBufferFlag(boolean clearBufferFlag) {
        this.clearBufferFlag = clearBufferFlag;
    }

    public DlgcSigDetectorFSM getDetectorFSM() {
        return this.myFSM;
    }

    protected boolean isTCKEnabled() {
        String tckFlag = System.getenv("TCK_ENABLED");
        log.debug("Value of TCK_ENABLED flag is :" + tckFlag);
        boolean isTCKEnabled = false;
        if (null == tckFlag || tckFlag.equalsIgnoreCase("NO")) {
            log.warn("Environment Variable: " + "TCK_ENABLED" + " not set");
            log.warn("Assuming TCK is not enabled");
            isTCKEnabled = false;
        } else if (tckFlag.equalsIgnoreCase("YES")) {
            isTCKEnabled = true;
        }
        log.debug("Value of TCK_ENABLED flag is :" + isTCKEnabled);
        return isTCKEnabled;
    }

    public static void loadSupportedFeatures(DlgcSupportedFeatures sf) {
        sf.appendSfParameters(supportedFeatures.getSupportedParameters());
        sf.appendSfEventTypes(supportedFeatures.getSupportedEventTypes());
        sf.appendSfValues(supportedFeatures.getSupportedValues());
        sf.appendSfQualifiers(supportedFeatures.getSupportedQualifiers());
    }

    public void setSignalingType(SIGNAL_TYPES st) {
        this.signalType = st;
    }

    public SIGNAL_TYPES getSignalingType() {
        return this.signalType;
    }

    static {
        supportedFeatures = new DlgcSupportedFeatures();
        supportedParameters = new DlgcParameters();
        supportedParameters.put(SignalDetector.INITIAL_TIMEOUT, DlgcSDInitTimeoutParameter.instance);
        supportedParameters.put(SignalDetector.INTER_SIG_TIMEOUT, DlgcSDSigTimeoutParameter.instance);
        supportedParameters.put(SignalDetector.PROMPT, DlgcSDPromptParameter.instance);
        supportedParameters.put(SignalDetector.ENABLED_EVENTS, DlgcSDEnableEventParameter.instance);
        supportedParameters.put(SignalDetector.BUFFER_SIZE, DlgcSDBufferSizeParameter.instance);
        supportedParameters.put(SignalDetector.BUFFERING, DlgcSDBufferingParameter.instance);
        supportedParameters.put(SignalDetector.MAX_DURATION, DlgcSDMaxDurationParameter.instance);
        supportedParameters.put(SignalDetector.FILTERED_PATTERNS, DlgcSDMaxDurationParameter.instance);
        supportedParameters.put(Player.AUDIO_CODEC, DlgcAudioCodecParameter.instance);
        HashSet<Parameter> sp = new HashSet<Parameter>();
        sp.add(SignalDetector.INITIAL_TIMEOUT);
        sp.add(SignalDetector.INTER_SIG_TIMEOUT);
        sp.add(SignalDetector.BUFFER_SIZE);
        sp.add(SignalDetector.BUFFERING);
        sp.add(SignalDetector.PROMPT);
        sp.add(SignalDetector.ENABLED_EVENTS);
        sp.add(SignalDetector.MAX_DURATION);
        for (int i = 0; i < 32; ++i) {
            supportedParameters.put(SignalDetector.PATTERN[i], DlgcSDPatternParameter.instance);
            sp.add(SignalDetector.PATTERN[i]);
        }
        supportedFeatures.setSfParameters(sp);
        HashSet<EventType> sev = new HashSet<EventType>();
        sev.add(SignalDetectorEvent.FLUSH_BUFFER_COMPLETED);
        sev.add(SignalDetectorEvent.SIGNAL_DETECTED);
        sev.add(SignalDetectorEvent.RECEIVE_SIGNALS_COMPLETED);
        sev.add(SignalDetectorEvent.OVERFLOWED);
        supportedFeatures.setSfEventTypes(sev);
        HashSet<Trigger> trig = new HashSet<Trigger>();
        trig.add(SignalDetector.DETECTION_OF_ONE_SIGNAL);
        supportedFeatures.setSfTriggers(trig);
        HashSet<Qualifier> sq = new HashSet<Qualifier>();
        sq.add(SignalDetectorEvent.PROMPT_FAILURE);
        sq.add(SignalDetectorEvent.DURATION_EXCEEDED);
        sq.add(SignalDetectorEvent.NUM_SIGNALS_DETECTED);
        sq.add(SignalDetectorEvent.INITIAL_TIMEOUT_EXCEEDED);
        sq.add(SignalDetectorEvent.INTER_SIG_TIMEOUT_EXCEEDED);
        sq.add(SignalDetectorEvent.PROMPT_FAILURE);
        supportedFeatures.setSfQualifiers(sq);
        SignalConstantTable = null;
        SignalConstantNameTable = null;
        useHackDetector = true;
        SignalConstantTable = new HashMap();
        SignalConstantTable.put("0", SignalConstants.DTMF_0);
        SignalConstantTable.put("1", SignalConstants.DTMF_1);
        SignalConstantTable.put("2", SignalConstants.DTMF_2);
        SignalConstantTable.put("3", SignalConstants.DTMF_3);
        SignalConstantTable.put("4", SignalConstants.DTMF_4);
        SignalConstantTable.put("5", SignalConstants.DTMF_5);
        SignalConstantTable.put("6", SignalConstants.DTMF_6);
        SignalConstantTable.put("7", SignalConstants.DTMF_7);
        SignalConstantTable.put("8", SignalConstants.DTMF_8);
        SignalConstantTable.put("9", SignalConstants.DTMF_9);
        SignalConstantTable.put("A", SignalConstants.DTMF_A);
        SignalConstantTable.put("B", SignalConstants.DTMF_B);
        SignalConstantTable.put("C", SignalConstants.DTMF_C);
        SignalConstantTable.put("D", SignalConstants.DTMF_D);
        SignalConstantTable.put("#", SignalConstants.DTMF_HASH);
        SignalConstantTable.put("*", SignalConstants.DTMF_STAR);
        SignalConstantNameTable = new HashMap();
        SignalConstantNameTable.put(SignalDetector.PATTERN[0].toString(), "0");
        SignalConstantNameTable.put(SignalDetector.PATTERN[1].toString(), "1");
        SignalConstantNameTable.put(SignalDetector.PATTERN[2].toString(), "2");
        SignalConstantNameTable.put(SignalDetector.PATTERN[3].toString(), "3");
        SignalConstantNameTable.put(SignalDetector.PATTERN[4].toString(), "4");
        SignalConstantNameTable.put(SignalDetector.PATTERN[5].toString(), "5");
        SignalConstantNameTable.put(SignalDetector.PATTERN[6].toString(), "6");
        SignalConstantNameTable.put(SignalDetector.PATTERN[7].toString(), "7");
        SignalConstantNameTable.put(SignalDetector.PATTERN[8].toString(), "8");
        SignalConstantNameTable.put(SignalDetector.PATTERN[9].toString(), "9");
        SignalConstantNameTable.put(SignalDetector.PATTERN[10].toString(), "A");
        SignalConstantNameTable.put(SignalDetector.PATTERN[11].toString(), "B");
        SignalConstantNameTable.put(SignalDetector.PATTERN[12].toString(), "C");
        SignalConstantNameTable.put(SignalDetector.PATTERN[13].toString(), "D");
        SignalConstantNameTable.put(SignalDetector.PATTERN[14].toString(), "#");
        SignalConstantNameTable.put(SignalDetector.PATTERN[15].toString(), "*");
    }

    public static enum SIGNAL_TYPES {
        NONE,
        PLAY_AND_COLLECT,
        ASYNC_COLLECT,
        COLLECT;

    }
}

