/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.signals;

import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcState;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXPlayer;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcInitialState;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcPlayAndCollectPendingState;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcPlayAndCollectRdyState;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcReceivingPendingState;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcReceivingRdyState;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSigDetectorFSM;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcStopPendingState;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcWaitForFlushBufferState;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.mediagroup.signals.SignalDetectorEvent;
import javax.media.mscontrol.resource.AllocationEvent;
import javax.media.mscontrol.resource.RTC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DlgcSigDetectorStates
extends DlgcState {
    private static final long serialVersionUID = -7419769244482569474L;
    public static DlgcInitialState initialState = new DlgcInitialState();
    public static DlgcReceivingPendingState receivingPendingState = new DlgcReceivingPendingState();
    public static DlgcReceivingRdyState receivingRdyState = new DlgcReceivingRdyState();
    public static DlgcStopPendingState stopPendingState = new DlgcStopPendingState();
    public static DlgcWaitForFlushBufferState waitForFlushBufferState = new DlgcWaitForFlushBufferState();
    public static DlgcPlayAndCollectPendingState playAndCollectPendingState = new DlgcPlayAndCollectPendingState();
    public static DlgcPlayAndCollectRdyState playAndCollectRdyState = new DlgcPlayAndCollectRdyState();
    public static Logger log = LoggerFactory.getLogger(DlgcSigDetectorStates.class);

    DlgcSigDetectorStates() {
    }

    public void evReceiveSignals(DlgcFSM fsm, int numOfSignals, Parameter[] patterns, RTC[] rtcs, Parameters params) throws MsControlException {
        String msg = "evReceiveSignal  event request not supported in the present state: Request is rejected/ignored because a previous request still in progress";
        log.debug(msg);
    }

    public void evFlushBuffer(DlgcFSM fsm) throws MsControlException {
        log.debug("evFlushBuffer event request not supported in the present state");
    }

    public void evStop(DlgcFSM fsm) throws MsControlException {
        log.debug("evStop event request not supported in the present state");
    }

    protected boolean IsBargeInEnabled(RTC[] rtcs) {
        boolean bargeIn = false;
        if (rtcs != null) {
            for (int r = 0; r < rtcs.length; ++r) {
                if (rtcs[r] == MediaGroup.SIGDET_STOPPLAY) {
                    bargeIn = true;
                    continue;
                }
                if (rtcs[r].getTrigger() == SignalDetector.DETECTION_OF_ONE_SIGNAL && rtcs[r].getAction() == Player.STOP) {
                    bargeIn = true;
                    break;
                }
                if (rtcs[r] != MediaGroup.SIGDET_STOPPLAY) continue;
                bargeIn = true;
                break;
            }
        }
        return bargeIn;
    }

    protected void sendStop(DlgcFSM fsm) throws MsControlException {
        log.debug("DlgcSigDetectorState: sendStop ");
        DlgcSignalDetector sd = ((DlgcSigDetectorFSM)fsm).getSignalDetector();
        DlgcMediaGroup mg = (DlgcMediaGroup)((DlgcResourceContainerFSM)fsm).getResourceContainer();
        this.sendMsmlStop(mg, sd);
        fsm.setState(stopPendingState);
    }

    protected void sendMsmlStop(DlgcMediaGroup mg, DlgcSignalDetector sd) throws MsControlException {
        log.debug("MSML DlgcSigDetectorState: sendMsmlStop ");
        DlgcIpmsSession sess = mg.joinedWithNetworkConnection().getDlgIpmsSession();
        DlgcXPlayer player = (DlgcXPlayer)mg.getPlayer();
        String fullDialogId = null;
        DlgcSignalDetector.SIGNAL_TYPES collectionType = sd.getSignalingType();
        if (collectionType == DlgcSignalDetector.SIGNAL_TYPES.ASYNC_COLLECT) {
            log.debug("DlgcSigDetectorState::sendMsmlStop:: In ASYNC_COLLECT");
            fullDialogId = sess.removeActiveResourceId(sd.getResourceId());
        } else if (collectionType == DlgcSignalDetector.SIGNAL_TYPES.PLAY_AND_COLLECT) {
            log.debug("DlgcSigDetectorState::sendMsmlStop:: In PLAY_AND_COLLECT");
            fullDialogId = sess.removeActiveResourceId(player.getResourceId());
        } else if (collectionType == DlgcSignalDetector.SIGNAL_TYPES.COLLECT) {
            log.debug("DlgcSigDetectorState::sendMsmlStop:: In COLLECT");
            fullDialogId = sess.removeActiveResourceId(sd.getResourceId());
        } else {
            log.error("DlgcSigDetectorState::sendMsmlStop invalid DlgcSignalDetector.SIGNAL_TYPES");
        }
        String dialogTarget = sess.calculateDialogTargetField();
        log.debug("MSC-129 dialogTarget " + dialogTarget);
        log.debug("MSC-129 fullDialogId " + fullDialogId);
        String requestStr = DlgcSipServlet.getProtocolBridge().createDtmfAsyncContionousStopDetectionMsg(fullDialogId);
        log.debug("MSC-129 MSML Request " + requestStr);
        sd.sendSipMessage(new DlgcSipMessage(mg, "INFO", null, "msml", requestStr, dialogTarget));
    }

    protected boolean isRequestaPlayAndCollect(DlgcFSM fsm, int numOfSignals, Parameter[] patterns, RTC[] rtcs, Parameters params) {
        Object oPrompt = params.get((Object)SignalDetector.PROMPT);
        if (oPrompt instanceof URI) {
            URI prompts = (URI)params.get((Object)SignalDetector.PROMPT);
            if (prompts != null) {
                log.debug("isRequestaPlayAndCollect():: This request is Play and Collect only");
                return true;
            }
            log.debug("isRequestaPlayAndCollect():: This request is collect only");
            return false;
        }
        if (oPrompt instanceof URI[]) {
            URI[] prompts = (URI[])params.get((Object)SignalDetector.PROMPT);
            if (prompts != null) {
                log.debug("isRequestaPlayAndCollect():: This request is Play and Collect only");
                return true;
            }
            log.debug("isRequestaPlayAndCollect():: This request is collect only");
            return false;
        }
        log.debug("isRequestaPlayAndCollect():: This request is collect only");
        return false;
    }

    protected boolean isRequestDetectingContinously(DlgcFSM fsm, int numOfSignals, Parameter[] patterns, RTC[] rtcs, Parameters params) {
        EventType[] evTypes;
        if (numOfSignals == -1 && params.containsKey((Object)SignalDetector.ENABLED_EVENTS) && null != (evTypes = (EventType[])params.get((Object)SignalDetector.ENABLED_EVENTS))) {
            for (int i = 0; i < evTypes.length; ++i) {
                if (evTypes[i] != SignalDetectorEvent.SIGNAL_DETECTED) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isRequestCollectOnly(DlgcFSM fsm, int numOfSignals, Parameter[] patterns, RTC[] rtcs, Parameters params) {
        Object oPrompt = params.get((Object)SignalDetector.PROMPT);
        if (oPrompt instanceof URI) {
            URI prompts = (URI)params.get((Object)SignalDetector.PROMPT);
            return numOfSignals > 0 && prompts == null;
        }
        if (oPrompt instanceof URI[]) {
            URI[] prompts = (URI[])params.get((Object)SignalDetector.PROMPT);
            return numOfSignals > 0 && prompts == null;
        }
        return oPrompt == null;
    }

    protected String getDtmfReasonForCompletion(MsmlDocument.Msml.Event digitEvent) {
        List nameList = digitEvent.getNameList();
        List valueList = digitEvent.getValueList();
        Iterator nameIt = nameList.iterator();
        String reason = null;
        int index = 0;
        while (nameIt.hasNext()) {
            String name = (String)nameIt.next();
            if (name.compareToIgnoreCase("dtmf.end") == 0) {
                reason = (String)valueList.get(index);
                break;
            }
            ++index;
        }
        return reason;
    }

    protected String getDtmfDigits(MsmlDocument.Msml.Event digitEvent) {
        List nameList = digitEvent.getNameList();
        List valueList = digitEvent.getValueList();
        Iterator nameIt = nameList.iterator();
        String digitsDetected = null;
        int index = 0;
        while (nameIt.hasNext()) {
            String name = (String)nameIt.next();
            if (name.compareToIgnoreCase("dtmf.digits") == 0) {
                digitsDetected = (String)valueList.get(index);
                break;
            }
            ++index;
        }
        return digitsDetected;
    }

    protected String getLastDtmf(MsmlDocument.Msml.Event digitEvent) {
        List nameList = digitEvent.getNameList();
        List valueList = digitEvent.getValueList();
        Iterator nameIt = nameList.iterator();
        String lastDtmfDigit = null;
        int index = 0;
        while (nameIt.hasNext()) {
            String name = (String)nameIt.next();
            if (name.compareToIgnoreCase("dtmf.last") == 0) {
                lastDtmfDigit = (String)valueList.get(index);
                break;
            }
            ++index;
        }
        return lastDtmfDigit;
    }

    protected String getDigitBufferLength(MsmlDocument.Msml.Event digitEvent) {
        List nameList = digitEvent.getNameList();
        List valueList = digitEvent.getValueList();
        Iterator nameIt = nameList.iterator();
        String dtmfDigitLen = null;
        int index = 0;
        while (nameIt.hasNext()) {
            String name = (String)nameIt.next();
            if (name.compareToIgnoreCase("dtmf.len") == 0) {
                dtmfDigitLen = (String)valueList.get(index);
                break;
            }
            ++index;
        }
        return dtmfDigitLen;
    }

    protected String getDtmfDigit(MsmlDocument.Msml.Event digitEvent) {
        List nameList = digitEvent.getNameList();
        List valueList = digitEvent.getValueList();
        Iterator nameIt = nameList.iterator();
        String digitDetected = null;
        int index = 0;
        while (nameIt.hasNext()) {
            String name = (String)nameIt.next();
            if (name.compareToIgnoreCase("dtmf.last") == 0) {
                digitDetected = (String)valueList.get(index);
                break;
            }
            ++index;
        }
        return digitDetected;
    }

    protected String chopOfLastDigit(String digits) {
        String chopDigit = null;
        chopDigit = digits.substring(0, digits.length() - 1);
        return chopDigit;
    }

    public void sendDtmfCreationConfirmEvent(DlgcSignalDetector sig) {
        DlgcMediaGroup mg = (DlgcMediaGroup)sig.getContainer();
        log.debug("SignalDetector sendDtmfCreationConfirmEvent via postAllocationEvent() to Application");
        mg.postAllocationEvent(AllocationEvent.ALLOCATION_CONFIRMED, "Media Server successfully allocating a Signal Detector", MediaErr.NO_ERROR);
    }

    public void sendDtmfCreationConfirmErrorEvent(DlgcSignalDetector sig) {
        DlgcMediaGroup mg = (DlgcMediaGroup)sig.getContainer();
        log.debug("SignalDetector sendDtmfCreationConfirmEvent via postAllocationEvent() to Application");
        mg.postAllocationEvent(AllocationEvent.ALLOCATION_CONFIRMED, "Media Server could allocate a Signal Detector ", MediaErr.UNKNOWN_ERROR);
    }
}

