/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.signals;

import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayer;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSigDetectorFSM;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSigDetectorStates;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.UnsupportedException;
import javax.media.mscontrol.resource.RTC;

class DlgcInitialState
extends DlgcSigDetectorStates {
    public DlgcInitialState() {
        this.stateName = "DlgcInitialState";
    }

    @Override
    public void evReceiveSignals(DlgcFSM fsm, int numOfSignals, Parameter[] patterns, RTC[] rtcs, Parameters params) throws MsControlException {
        DlgcSignalDetector sd = ((DlgcSigDetectorFSM)fsm).getSignalDetector();
        sd.setSignalingType(DlgcSignalDetector.SIGNAL_TYPES.NONE);
        if (this.isRequestaPlayAndCollect(fsm, numOfSignals, patterns, rtcs, params)) {
            log.debug("Calling sendPlayCollect");
            sd.setSignalingType(DlgcSignalDetector.SIGNAL_TYPES.PLAY_AND_COLLECT);
            this.sendPlayCollect(fsm, numOfSignals, patterns, rtcs, params);
        } else if (this.isRequestDetectingContinously(fsm, numOfSignals, patterns, rtcs, params)) {
            log.debug("Calling sendDetectContinously");
            sd.setSignalingType(DlgcSignalDetector.SIGNAL_TYPES.ASYNC_COLLECT);
            this.sendDetectContinously(fsm, numOfSignals, patterns, rtcs, params);
        } else if (this.isRequestCollectOnly(fsm, numOfSignals, patterns, rtcs, params)) {
            log.debug("Calling sendCollectOnly");
            sd.setSignalingType(DlgcSignalDetector.SIGNAL_TYPES.COLLECT);
            this.sendCollectOnly(fsm, numOfSignals, patterns, rtcs, params);
        } else {
            log.error("DlgcInitialState::evReceiveSignals:: Not sure what type of DTMF collection application wants to do...");
        }
    }

    private void sendCollectOnly(DlgcFSM fsm, int numOfSignals, Parameter[] patterns, RTC[] rtcs, Parameters params) throws MsControlException {
        DlgcMediaGroup mg = (DlgcMediaGroup)((DlgcResourceContainerFSM)fsm).getResourceContainer();
        DlgcPlayer myPlayer = (DlgcPlayer)mg.getPlayer();
        if (myPlayer == null) {
            String msg = "The Dialogic Connector can't execute this collect request since the related Media Group was created only with a Signal Detector Configuration...It requires both a Signal Dector and Player Configuration";
            log.debug(msg);
            DlgcSignalDetector sd = ((DlgcSigDetectorFSM)fsm).getSignalDetector();
            sd.getMonitor().notifyRequestCompleted(false, msg);
            throw new UnsupportedException(msg);
        }
        DlgcSignalDetector sd = ((DlgcSigDetectorFSM)fsm).getSignalDetector();
        sd.setCreatedInMediaServer(false);
        myPlayer.setMonitor(sd.getMonitor());
        myPlayer.collectOnly((DlgcSigDetectorFSM)fsm, numOfSignals, patterns, params, this.IsBargeInEnabled(rtcs));
        fsm.setState(playAndCollectPendingState);
    }

    private void sendPlayCollect(DlgcFSM fsm, int numOfSignals, Parameter[] patterns, RTC[] rtcs, Parameters params) throws MsControlException {
        DlgcMediaGroup mg = (DlgcMediaGroup)((DlgcResourceContainerFSM)fsm).getResourceContainer();
        DlgcPlayer myPlayer = (DlgcPlayer)mg.getPlayer();
        DlgcSignalDetector sd = ((DlgcSigDetectorFSM)fsm).getSignalDetector();
        sd.setCreatedInMediaServer(false);
        myPlayer.setMonitor(sd.getMonitor());
        myPlayer.playCollect((DlgcSigDetectorFSM)fsm, numOfSignals, patterns, params, this.IsBargeInEnabled(rtcs));
        fsm.setState(playAndCollectPendingState);
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            DlgcSync2AsyncMonitor monitor = sd.getMonitor();
            if (monitor == null) {
                log.debug("SYNC_2_ASYNC SignalDetector::sendPlayCollect:running Signal Detector ReceiveSignal in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
            } else {
                boolean bStatus = true;
                log.debug("SYNC_2_ASYNC SignalDetector::sendPlayCollect: ReceiveSignal 200 OK hand shake calling Monitor notifyRequestCompleted");
                monitor.notifyRequestCompleted(bStatus, "Signal Detector Started");
                log.debug("SYNC_2_ASYNC SignalDetector::sendPlayCollect: ReceiveSignal 200 OK return from Monitor notifyRequestCompleted");
            }
        }
    }

    private void sendDetectContinously(DlgcFSM fsm, int numOfSignals, Parameter[] patterns, RTC[] rtcs, Parameters params) throws MsControlException {
        DlgcSignalDetector sd = ((DlgcSigDetectorFSM)fsm).getSignalDetector();
        sd.setCreatedInMediaServer(false);
        this.sendDetectMsmlContinously(fsm, numOfSignals, patterns, rtcs, params);
        fsm.setState(receivingPendingState);
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            DlgcSync2AsyncMonitor monitor = sd.getMonitor();
            if (monitor == null) {
                log.debug("SYNC_2_ASYNC SignalDetector::sendDetectContinously: running Signal Detector ReceiveSignal in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
            } else {
                boolean bStatus = true;
                log.debug("SYNC_2_ASYNC SignalDetector::sendDetectContinously: ReceiveSignal 200 OK hand shake calling Monitor notifyRequestCompleted");
                monitor.notifyRequestCompleted(bStatus, "Signal Detector Started");
                log.debug("SYNC_2_ASYNC SignalDetector::sendDetectContinously: ReceiveSignal 200 OK return from Monitor notifyRequestCompleted");
            }
        }
    }

    private void sendDetectMsmlContinously(DlgcFSM fsm, int numOfSignals, Parameter[] patterns, RTC[] rtcs, Parameters params) throws MsControlException {
        DlgcMediaGroup mg = (DlgcMediaGroup)((DlgcResourceContainerFSM)fsm).getResourceContainer();
        DlgcSignalDetector sd = ((DlgcSigDetectorFSM)fsm).getSignalDetector();
        String dialogTarget = mg.joinedWithNetworkConnection().getDlgIpmsSession().calculateDialogTargetField();
        String dlgName = DlgcIpmsSession.getNewDialogName();
        String request = DlgcSipServlet.getProtocolBridge().createDtmfAsyncContionousDetectionMsg(dialogTarget, dlgName, (DlgcParameters)params);
        DlgcSipMessage message = new DlgcSipMessage(mg, "INFO", null, "msml", request, dialogTarget);
        message.dialogName = dlgName;
        message.useHack = DlgcSignalDetector.useHackDetector;
        sd.sendSipMessage(message);
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            DlgcSync2AsyncMonitor monitor = sd.getMonitor();
            if (monitor == null) {
                log.debug("SYNC_2_ASYNC SignalDetector::sendDetectMsmlContinously: running Signal Detector ReceiveSignal in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
            } else {
                boolean bStatus = true;
                log.debug("SYNC_2_ASYNC SignalDetector::sendDetectMsmlContinously: ReceiveSignal 200 OK hand shake calling Monitor notifyRequestCompleted");
                monitor.notifyRequestCompleted(bStatus, "Signal Detector Started");
                log.debug("SYNC_2_ASYNC SignalDetector::sendDetectMsmlContinously: ReceiveSignal 200 OK return from Monitor notifyRequestCompleted");
            }
        }
    }

    @Override
    public void evStop(DlgcFSM fsm) throws MsControlException {
        log.debug("DlgcInitialState:evStop - calling sendStop on prompt and collect");
        this.sendStop(fsm);
    }
}

