/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.resource;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaObject;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcAllocationEvent;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcServletTimer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventNotifier;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.AllocationEvent;
import javax.media.mscontrol.resource.AllocationEventListener;
import javax.media.mscontrol.resource.Resource;
import javax.media.mscontrol.resource.ResourceContainer;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DlgcResourceContainer
extends DlgcMediaObject
implements ResourceContainer,
DlgcServletTimer {
    private static final long serialVersionUID = -2650303821618418722L;
    protected String proxyId;
    protected String sasId;
    private static Logger log = LoggerFactory.getLogger(DlgcResourceContainer.class);
    private ConcurrentLinkedQueue<AllocationEventListener> allocEventListenerList = new ConcurrentLinkedQueue();
    private int timeout;
    private MediaSession mediaSession;
    private String sessionTimerId;
    protected Map<Class<?>, Resource<? extends ResourceContainer>> resourceMap = new HashMap();
    protected MediaConfig config;
    protected DlgcResourceContainerFSM myFSM = null;
    protected boolean isConfirmed = false;
    protected boolean sendConfirmation = false;
    protected EventType allocEventType = null;
    DlgcSync2AsyncMonitor monitor = null;

    protected DlgcResourceContainer(MediaSession ms, String prefix) {
        super(prefix);
        this.mediaSession = ms;
        this.sessionTimerId = null;
    }

    @Override
    protected void buildUri(String container) {
        String uriString = this.mediaSession.getURI().toString() + "/" + container + "." + this.mediaObjectID;
        try {
            this.uri = new URI(uriString);
            this.proxyId = this.getMediaObject();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void confirm() throws MsControlException {
        if (this.isReleased()) {
            throw new IllegalStateException("Resource container has been released");
        }
        this.sendConfirmation = true;
        this.postAllocationEvent();
    }

    public MediaConfig getConfig() {
        return this.config;
    }

    public <R> R getResource(Class<R> res) throws MsControlException {
        Resource<? extends ResourceContainer> aResource = this.resourceMap.get(res);
        return (R)aResource;
    }

    public DlgcSdpPortManager getSdpPortMgrResource() throws MsControlException {
        DlgcSdpPortManager sdpMgr = this.getResource(DlgcSdpPortManager.class);
        return sdpMgr;
    }

    public void triggerAction(Action action) {
        if (this.isReleased()) {
            throw new IllegalStateException();
        }
    }

    public void addListener(AllocationEventListener listener) {
        this.allocEventListenerList.add(listener);
    }

    public MediaSession getMediaSession() {
        return this.mediaSession;
    }

    public void removeListener(AllocationEventListener listener) {
        this.allocEventListenerList.remove(listener);
    }

    protected void postAllocationEvent() {
        if (this.sendConfirmation && !this.allocEventListenerList.isEmpty() && this.isConfirmed) {
            Iterator<AllocationEventListener> iter = this.allocEventListenerList.iterator();
            while (iter.hasNext()) {
                iter.next().onEvent((AllocationEvent)new DlgcAllocationEvent(this.allocEventType, this));
            }
            if (this.allocEventType == AllocationEvent.IRRECOVERABLE_FAILURE) {
                this.isConfirmed = false;
            }
        }
    }

    protected void postAllocationEvent(EventType event) {
        if (!this.released && this.allocEventListenerList != null && !this.allocEventListenerList.isEmpty()) {
            Iterator<AllocationEventListener> iter = this.allocEventListenerList.iterator();
            if (iter == null) {
                return;
            }
            while (iter.hasNext()) {
                iter.next().onEvent((AllocationEvent)new DlgcAllocationEvent(event, this));
            }
        }
    }

    public void postAllocationEvent(EventType event, String msg) {
        if (!this.released && this.allocEventListenerList != null && !this.allocEventListenerList.isEmpty()) {
            Iterator<AllocationEventListener> iter = this.allocEventListenerList.iterator();
            if (iter == null) {
                return;
            }
            while (iter.hasNext()) {
                DlgcAllocationEvent allocEvent = new DlgcAllocationEvent(event, this);
                allocEvent.setErrorText(msg);
                if (msg.compareToIgnoreCase("Conference Allocated") == 0) {
                    allocEvent.setError(MediaErr.NO_ERROR);
                } else {
                    allocEvent.setError(MediaErr.UNKNOWN_ERROR);
                }
                iter.next().onEvent((AllocationEvent)allocEvent);
            }
        }
    }

    public void postAllocationEvent(EventType event, String msg, MediaErr status) {
        if (!this.released && this.allocEventListenerList != null && !this.allocEventListenerList.isEmpty()) {
            Iterator<AllocationEventListener> iter = this.allocEventListenerList.iterator();
            if (iter == null) {
                return;
            }
            while (iter.hasNext()) {
                DlgcAllocationEvent allocEvent = new DlgcAllocationEvent(event, this);
                allocEvent.setErrorText(msg);
                allocEvent.setError(status);
                iter.next().onEvent((AllocationEvent)allocEvent);
            }
        }
    }

    public void postAllocationEvent(EventType event, MediaErr status, String msg) {
        if (!this.released && this.allocEventListenerList != null && !this.allocEventListenerList.isEmpty()) {
            Iterator<AllocationEventListener> iter = this.allocEventListenerList.iterator();
            if (iter == null) {
                return;
            }
            while (iter.hasNext()) {
                DlgcAllocationEvent allocEvent = new DlgcAllocationEvent(event, this);
                allocEvent.setErrorText(msg);
                allocEvent.setError(status);
                iter.next().onEvent((AllocationEvent)allocEvent);
            }
        }
    }

    public void processSipResponse(SipServletResponse response, DlgcSipConnectorContentIdsProxy proxy) {
    }

    public void processSipBye(SipServletRequest request) {
        try {
            this.stopSessionTimer();
            request.createResponse(200).send();
            this.postAllocationEvent(AllocationEvent.IRRECOVERABLE_FAILURE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void processSipBye(SipServletResponse response) {
        log.debug("DlgcResourceContainer::processSipBye empty execution invalid override");
    }

    public void processSipInvite(SipServletRequest request) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + ">>>>>>>>>> DlgcResourceContainer - processSipInvite [REQUEST] due to IPMS SIP SESSION TIMER");
        this.stopSessionTimer();
        try {
            log.debug(appLogId + ">>>>>>>>>> DlgcResourceContainer - processSipInvite [REQUEST] due to IPMS SIP SESSION TIMER sending 200 OK back to IPMS");
            request.createResponse(200).send();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.startSessionTimer(request.getApplicationSession());
    }

    public void processSipInvite(SipServletResponse response) {
        try {
            if (response.getStatus() == 200) {
                this.allocEventType = AllocationEvent.ALLOCATION_CONFIRMED;
                response.createAck().send();
                this.startSessionTimer(response);
            } else {
                this.allocEventType = AllocationEvent.IRRECOVERABLE_FAILURE;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.isConfirmed = true;
        this.postAllocationEvent();
    }

    public void processSipInfo(SipServletResponse response, DlgcSipConnectorContentIdsProxy proxy) {
    }

    @Override
    public void release() {
        this.stopSessionTimer();
        super.release();
    }

    public void sendSipMessage(DlgcSipMessage message) {
        if (message != null) {
            try {
                DlgcSipServlet.sipB2BUA.scheduleTask(message, null);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendSipMessage(DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
        if (message != null) {
            try {
                DlgcSipServlet.sipB2BUA.scheduleTask(message, notifier);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        }
    }

    public void setFSM(DlgcResourceContainerFSM fsm) {
        this.myFSM = fsm;
    }

    public DlgcResourceContainerFSM getFSM() {
        return this.myFSM;
    }

    public void startSessionTimer(SipApplicationSession session) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "Entering DlgcResourceContainer:SipApplicationSession startSessionTimer() ");
        log.debug(appLogId + "Leaving DlgcResourceContainer startSessionTimer() ");
    }

    public void startSessionTimer(SipServletResponse response) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "Entering DlgcResourceContainer:SipServletResponse SESSION SIP TIMER startSessionTimer()");
        log.debug(appLogId + "LEAVING DlgcResourceContainer:SipServletResponse SESSION SIP TIMER startSessionTimer()");
    }

    public void stopSessionTimer() {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "ENTERING DlgcResourceContainer SESSION SIP TIMER stopSessionTimer()");
        log.debug(appLogId + "LEAVING DlgcResourceContainer SESSION SIP TIMER stopSessionTimer()");
    }

    protected ServletTimer getSASTimer() {
        ServletTimer st = null;
        SipApplicationSession sas = ((DlgcMediaSession)this.getMediaSession()).getSAS();
        if (sas != null && this.sessionTimerId != null && !this.sessionTimerId.isEmpty()) {
            st = sas.getTimer(this.sessionTimerId);
        }
        return st;
    }

    public void processSipUpdate(SipServletRequest request) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + ">>>>>>>>>> DlgcResourceContainer - processSipUpdate [REQUEST] due to IPMS SIP SESSION TIMER");
        this.stopSessionTimer();
        try {
            log.debug(appLogId + ">>>>>>>>>> DlgcResourceContainer - processSipUpdate [REQUEST] due to IPMS SIP SESSION TIMER sending 200 OK back to IPMS");
            request.createResponse(200).send();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.startSessionTimer(request.getApplicationSession());
    }

    public DlgcProxy getProxy() {
        return null;
    }

    public String getProxyId() {
        return this.proxyId;
    }

    public void setProxyId(String id) {
        this.proxyId = id;
    }

    public DlgcSync2AsyncMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(DlgcSync2AsyncMonitor monitor) {
        this.monitor = monitor;
    }
}

