/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.resource;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameter;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynCallbackImpl;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynDispatcher;
import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcState;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaEventNotifier;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.resource.Resource;
import javax.media.mscontrol.resource.ResourceContainer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletResponse;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DlgcResource<T extends ResourceContainer, N extends MediaEvent<?>>
implements Resource<T>,
MediaEventNotifier<N>,
Serializable {
    private String resourceId;
    private static Logger log = LoggerFactory.getLogger(DlgcResource.class);
    protected DlgcState state;
    protected T container;
    private List<MediaEventListener<N>> mediaEventListenerList = new ArrayList<MediaEventListener<N>>();
    DlgcSync2AsyncMonitor monitor = null;
    private SipServletResponse servletResponse = null;

    protected DlgcResource(T container) {
        this.container = container;
        container.setParameters(this.getDefaultParameters());
        Random randomGenerator = new Random();
        this.resourceId = new Integer(randomGenerator.nextInt(100000)).toString();
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public T getContainer() {
        return this.container;
    }

    public void addListener(MediaEventListener<N> listener) {
        if (this.mediaEventListenerList.contains(listener)) {
            log.debug("DlgcResource::addListener: already in list...ignoring it : " + listener.toString());
        } else {
            this.mediaEventListenerList.add(listener);
            log.debug("DlgcResource::addListener: " + listener.toString());
        }
    }

    public MediaSession getMediaSession() {
        return this.container.getMediaSession();
    }

    public Parameters getDefaultParameters() {
        DlgcParameters parameters = new DlgcParameters();
        DlgcParameters supportedParameters = this.getSupportedParameters();
        for (Parameter param : supportedParameters.keySet()) {
            parameters.put(param, ((DlgcParameter)supportedParameters.get(param)).getValue());
        }
        return parameters;
    }

    public Parameters getParameters(Parameters params) {
        DlgcParameters supportedParams = this.getSupportedParameters();
        Iterator paramIter = supportedParams.keySet().iterator();
        DlgcParameters resourceParams = new DlgcParameters();
        Parameters resourceContainerParams = this.container.getParameters(null);
        while (paramIter.hasNext()) {
            Object value;
            Parameter param = (Parameter)paramIter.next();
            if (params != null && params.containsKey((Object)param)) {
                value = params.get((Object)param);
                if (value != null && value.equals(Resource.FOR_EVER)) {
                    value = -1;
                }
            } else {
                value = resourceContainerParams.get((Object)param);
            }
            resourceParams.put(param, value);
        }
        return resourceParams;
    }

    protected abstract DlgcParameters getSupportedParameters();

    public void postMediaEvent(N event) {
        if (this.mediaEventListenerList == null) {
            log.debug("*18 DlgcResource::postMediaEvent:: mediaEventListener IS NULL for EventType: " + event.getEventType().toString());
            return;
        }
        DlgcMediaSession session = (DlgcMediaSession)this.getMediaSession();
        String appSasId = session.getAppSasId();
        if (appSasId != null) {
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(appSasId, new DlgcAsynCallbackImpl((MediaEvent)event){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ MediaEvent val$event;
                {
                    this.val$event = mediaEvent;
                }

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("*18 DlgcResource::postMediaEvent Task run() => Sending Event to Application via Async API QUEUE");
                    ArrayList copyList = new ArrayList(DlgcResource.this.mediaEventListenerList);
                    Iterator iter = copyList.iterator();
                    if (iter == null) {
                        log.debug("DlgcResource::postMediaEvent Task run() no event to send to the application since iterator was found to be null");
                        return;
                    }
                    while (iter.hasNext()) {
                        MediaEventListener meListener = (MediaEventListener)iter.next();
                        log.debug("DlgcResource::postMediaEvent Task run() sending the following event type to the application: " + this.val$event.getEventType().toString());
                        log.debug("DlgcResource::postMediaEvent Task run() sending the following event type to this application listener: " + meListener.toString());
                        meListener.onEvent(this.val$event);
                    }
                }
            });
        } else {
            log.debug("*18 Entering DlgcResource::postMediaEvent Task run() => Sending Event to Application without using the Async API QUEUE");
            Iterator<MediaEventListener<N>> iter = this.mediaEventListenerList.iterator();
            if (iter == null) {
                log.debug("DlgcResource::postMediaEvent Task run() no event to send to the application since iterator was found to be null");
                return;
            }
            while (iter.hasNext()) {
                log.debug("*18 DlgcResource::postMediaEvent Task run() sending the following event type to the application: " + event.getEventType().toString());
                iter.next().onEvent(event);
            }
        }
    }

    public void processSipInfoRequest(MsmlDocument.Msml message, DlgcSipConnectorContentIdsProxy proxy) {
    }

    public void processSipInfoResponse(SipServletResponse message, DlgcSipConnectorContentIdsProxy proxy) {
    }

    public void removeListener(MediaEventListener<N> listener) {
        log.debug("removeListener: " + listener.toString());
        this.mediaEventListenerList.remove(listener);
    }

    public void sendSipMessage(String method) {
        this.sendSipMessage(new DlgcSipMessage((JoinableContainer)this.container, null, method, "none", null));
    }

    public void sendSipMessage(String user, String method, String contentType, String content) {
        this.sendSipMessage(new DlgcSipMessage((JoinableContainer)this.container, method, user, contentType, content));
    }

    public void sendSipMessage(DlgcSipMessage message) {
        this.sendSipMessage(message, this);
    }

    public void sendSipMessage(DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
        if (message != null) {
            try {
                DlgcSipServlet.sipB2BUA.scheduleTask(message, notifier);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        }
    }

    protected MsmlDocument.Msml extractMsmlResponseMessage(SipServletResponse response) {
        MsmlDocument.Msml message = null;
        try {
            StringReader xmlContent = new StringReader(new String(response.getRawContent()));
            MsmlDocument msmlDoc = MsmlDocument.Factory.parse((Reader)xmlContent);
            message = msmlDoc.getMsml();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
        return message;
    }

    protected MsmlDocument.Msml extractMsmlResonseRequestMessage(SipServletResponse response) {
        MsmlDocument.Msml message = null;
        try {
            StringReader xmlContent = new StringReader(new String(response.getRequest().getRawContent()));
            MsmlDocument msmlDoc = MsmlDocument.Factory.parse((Reader)xmlContent);
            message = msmlDoc.getMsml();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
        return message;
    }

    protected synchronized <T extends DlgcState> void setState(T state) {
        this.state = state;
    }

    protected synchronized <T extends DlgcState> T getState() {
        return (T)this.state;
    }

    public abstract DlgcProxy getProxy();

    public void setMonitor(DlgcSync2AsyncMonitor mon) {
        this.monitor = mon;
    }

    public DlgcSync2AsyncMonitor getMonitor() {
        return this.monitor;
    }

    public void setServletResponse(SipServletResponse response) {
        this.servletResponse = response;
    }

    public SipServletResponse getServletResponse() {
        return this.servletResponse;
    }
}

