/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcXMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcActiveTalker;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.servlet.sip.SipServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcXSdpPortManager
extends DlgcSdpPortManager {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcXSdpPortManager.class);

    public DlgcXSdpPortManager(NetworkConnection nc) {
        super(nc);
        this.myFSM = new DlgcXSdpPortManagerFSM((DlgcResourceContainer)nc);
    }

    @Override
    public void processSipInvite(SipServletResponse response) {
        log.debug("Entering XMS DlgcXSpdPortManager::processSipInvite(response) nothing to do");
    }

    @Override
    public void generateSdpOffer() throws SdpPortManagerException {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "Calling generateSdpOffer");
        DlgcXNetworkConnection nc = (DlgcXNetworkConnection)this.getContainer();
        log.debug("Calling generateSdpOffer() NCID: " + nc.toString());
        log.info("JSR309:generateSdpOffer() : NC MEDIA OBJID: " + nc.getMediaObject() + " remoteSDP: NULL");
        this.myFSM = new DlgcXSdpPortManagerFSM((DlgcResourceContainer)this.container);
        this.myFSM.evProcessSdpOffer();
    }

    @Override
    public void rejectSdpOffer() throws SdpPortManagerException {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "Calling evRejectSdpOffer");
        DlgcXNetworkConnection nc = (DlgcXNetworkConnection)this.getContainer();
        log.info("JSR309:rejectSdpOffer() : NC MEDIA OBJID: " + nc.getMediaObject());
        super.rejectSdpOffer();
    }

    public void processActiveTalker(MsmlDocument.Msml msmlMsg) {
        DlgcXNetworkConnection myContainer = (DlgcXNetworkConnection)this.container;
        DlgcXMediaMixer myMixer = (DlgcXMediaMixer)myContainer.getMixerIfJoined();
        if (myMixer != null) {
            log.debug("DlgcXSdpPortManager:: Processing ActiveTalker Request found corresponding Media Mixer");
            DlgcXMediaMixer.MixerState presentMixerState = myMixer.getMixerState();
            MsmlDocument.Msml.Event theEvent = msmlMsg.getEvent();
            if (theEvent != null) {
                List eventNameList = theEvent.getNameList();
                List eventValueList = theEvent.getValueList();
                if (eventNameList != null && eventValueList != null) {
                    Vector<DlgcActiveTalker> activeTalkerList = new Vector<DlgcActiveTalker>();
                    activeTalkerList = new Vector();
                    for (String speaker : eventValueList) {
                        DlgcActiveTalker at = new DlgcActiveTalker(theEvent.getId(), speaker, myMixer);
                        activeTalkerList.add(at);
                    }
                    log.debug("DlgcXSdpPortManager::processAcctiveTalker:: call presentMixerState: " + presentMixerState.name());
                    presentMixerState.handleASNEvent(myMixer, activeTalkerList);
                }
            }
        } else {
            log.error("DlgcXSdpPortManager:: Cant process ActiveTalker Request could not find associated Media Mixer");
        }
    }

    public void processCPA(MsmlDocument.Msml msmlMessage) {
        log.debug("Entering processCPA method");
        String cpaValue = null;
        MsmlDocument.Msml.Event ev = msmlMessage.getEvent();
        List valList = ev.getValueList();
        Iterator it = valList.iterator();
        if (it != null) {
            if (it.hasNext()) {
                cpaValue = (String)it.next();
                log.debug("CPA Value Received in CPA Event is : " + cpaValue);
            }
            DlgcXNetworkConnection nc = (DlgcXNetworkConnection)this.container;
            DlgcXMediaSession ms = (DlgcXMediaSession)nc.getMediaSession();
            ms.setCPAValue(cpaValue);
            log.debug("Sending CPA Event using UNSOLICITED_OFFER_GENERATED Event Type Extension to the Application - CPA Value:  " + cpaValue);
            this.sendApplicationEvent(SdpPortManagerEvent.UNSOLICITED_OFFER_GENERATED, null, SdpPortManagerEvent.NO_ERROR, null, null);
        } else {
            log.error("Received CPA Event From XMS but no value found in MSML payload");
        }
        log.debug("Leaving processCPA method");
    }
}

