/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import java.io.IOException;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;

class DlgcXReinvitePendingState
extends DlgcXSdpPortManagerStates {
    private static final long serialVersionUID = 1L;

    public DlgcXReinvitePendingState() {
        this.stateName = "DlgcXReinvitePendingState";
    }

    @Override
    public void evSipInfo(DlgcFSM fsm, MsmlDocument.Msml msmlMsg) throws MsControlException {
        log.debug("STATE [DlgcXReinvitePendingState] EVENT =>  evSipInfo");
        log.debug("DlgcXReinvitePendingState::evSipInfo - ignoring info message from XMS: " + msmlMsg.toString());
    }

    @Override
    public void evRelease(DlgcSdpPortManagerFSM fsm) {
        log.debug("STATE [DlgcXReinvitePendingState] EVENT =>  evRelease");
        log.debug("DlgcXReinvitePendingState::evRelease - ignoring release request while waiting for reinvite to be answerd by XMS");
    }

    @Override
    public void evSipInvite(DlgcFSM fsm, SipServletResponse response) throws MsControlException {
        block13: {
            log.debug("STATE [DlgcXReinvitePendingState] EVENT =>  evSipInvite response");
            DlgcSdpPortManager portMgr = null;
            byte[] content = null;
            try {
                portMgr = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
            }
            catch (MsControlException e) {
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                DlgcSdpPortManagerStates.log.error("Error getting Sdp Port Manager Resource object from NetworkConnection Resource Container", (Throwable)e);
                throw new SdpPortManagerException("Error getting Sdp Port Manager Resource object from NetworkConnection Resource Container " + e.getMessage(), (Throwable)e);
            }
            try {
                int sipStatus = response.getStatus();
                content = response.getRawContent();
                if (sipStatus == 180) {
                    log.debug("DlgcXSdpPortManagerState::DlgcXReinvitePendingState->evSipInvite() - ignoring Ringing");
                    return;
                }
                if (sipStatus == 183) {
                    log.debug("DlgcXSdpPortManagerState::DlgcXReinvitePendingState->evSipInvite(183) - ignoring 183 - Note the connector does not expect SIP 183 Message from the Media Server...");
                    SipSession ss = response.getSession();
                    if (ss == null) {
                        log.error("DlgcXSdpPortManagerState::DlgcXReinvitePendingState->evSipInvite(183) - Sip Session is NULL... ");
                    }
                    return;
                }
                if (sipStatus >= 400 && sipStatus <= 599) {
                    portMgr.setEM(DlgcSdpPortManager.EARLY_MEDIA_TYPE.NO_EM);
                    String SipStatusString = Integer.toString(sipStatus);
                    log.debug("DlgcXSdpPortManagerState::DlgcXReinvitePendingState Invite Response -> Setting state to privous state name: " + fsm.getBasePreviousStateName());
                    log.debug("DlgcXSdpPortManagerState::DlgcXReinvitePendingState Invite Response -> Setting state to privous state object: " + fsm.getBasePreviousState().toString());
                    fsm.setState(((DlgcSdpPortManagerFSM)fsm).getBasePreviousState());
                    DlgcSdpPortManagerStates.log.error("SIP Response return error: " + SipStatusString);
                    String errMsg = "Fail to establish a reinvite to the XMS - SIP error: " + SipStatusString;
                    portMgr.sendApplicationEvent(SdpPortManagerEvent.ANSWER_GENERATED, content, SdpPortManagerEvent.RESOURCE_UNAVAILABLE, errMsg, null);
                    log.debug(" DlgcXReinvitePendingState::evSipInvite SipStatus Error =  " + errMsg);
                    response.removeAttribute(response.getHeader("CSeq"));
                    break block13;
                }
                log.debug(" DlgcXReinvitePendingState::evSipInvite successful reinvite to XMS");
                portMgr.setLocalSessionDescription(content);
                portMgr.setMSSessionDesc(content);
                try {
                    response.removeAttribute(response.getHeader("CSeq"));
                    byte[] ouaSipEndpoint = portMgr.getUserAgentSessionDescription();
                    if (ouaSipEndpoint != null) {
                        DlgcXNetworkConnection xnc = (DlgcXNetworkConnection)portMgr.getContainer();
                        SipSession s = xnc.getDlgIpmsSession().getSipSession();
                        log.debug("DLgcXSdpPortManagerState::DlgcXReinvitePendingState::evSipInvite SipSession.getId() = " + s.getId());
                        SipServletRequest ackRequest = response.createAck();
                        ackRequest.send();
                        log.debug("DlgcXSdpPortManagerState::DlgcXReinvitePendingState Invite Response -> Setting state to privous state name: " + fsm.getBasePreviousStateName());
                        log.debug("DlgcXSdpPortManagerState::DlgcXReinvitePendingState Invite Response -> Setting state to privous state object: " + fsm.getBasePreviousState().toString());
                        fsm.setState(((DlgcSdpPortManagerFSM)fsm).getBasePreviousState());
                        log.debug("DlgcXSdpPortManagerState::DlgcXReinvitePendingState calling sendApplicationEvent Event = ANSWER_GENERATED due to a reinvite");
                        portMgr.sendApplicationEvent(SdpPortManagerEvent.ANSWER_GENERATED, content, null, null, null);
                        log.debug("DlgcXSdpPortManagerState::DlgcXReinvitePendingState returning from sendApplicationEvent Event = ANSWER_GENERATED due to a reinvite");
                    } else {
                        log.debug("DlgcXSdpPortManagerState::DlgcXReinvitePendingState not handling the case of generateSdpOffer reinvite type...");
                    }
                }
                catch (IOException ioe) {
                    fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                    log.error("Exception error sending ACK back to the IPMS", (Throwable)ioe);
                    portMgr.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, "Error Sending ACK to the Media Server", null);
                    throw new SdpPortManagerException("Exception Error Sending ACK to the Media Server: " + ioe.getMessage(), (Throwable)ioe);
                }
            }
            catch (MsControlException e) {
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                log.error("Exception generated by sendSIPMsg call while trying to send a SdpOffer request", (Throwable)e);
                portMgr.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, "SDP Not Acceptable Error", null);
                throw new SdpPortManagerException("Exception generated by sendSIPMsg call while trying to send a SdpOffer request: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                log.error(e.toString());
            }
        }
    }

    @Override
    public void evSipInvite(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        log.debug("STATE [DlgcXReinvitePendingState] EVENT =>  evSipInvite request");
        log.debug("Handling XMS SIP SESSION TIMER");
        DlgcXReinvitePendingState.evSipInviteSipTimerSendOK(fsm, request);
        log.debug("Returning from handling XMS SIP SESSION TIMER");
    }
}

