/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMsControlFactory;
import com.vendor.dialogic.javax.media.mscontrol.DlgcXMediaConfig;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.msmlProtocol.DlgcSipB2BUAMSMLProtocol;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMediaServer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Random;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.mixer.MixerAdapter;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManager;
import javax.media.mscontrol.resource.Resource;
import javax.servlet.sip.SipServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcXNetworkConnection
extends DlgcNetworkConnection {
    private static final long serialVersionUID = 7078089054331L;
    private static Logger log = LoggerFactory.getLogger(DlgcXNetworkConnection.class);
    private DlgcXNetworkConnection ncBridgePartner = null;
    public boolean destroyConferenceReply = false;
    private boolean sdpWebRtcType = false;

    public DlgcXNetworkConnection(MediaConfig cfg, MediaSession ms, Parameters params) {
        super(cfg, ms, params, "XNC-");
        Integer msmlId = 0;
        DlgcMsControlFactory f = (DlgcMsControlFactory)((DlgcMediaSession)ms).getFactory();
        if (!f.isMediaServerBasedOnMS_URI()) {
            Random randomGenerator = new Random();
            msmlId = new Integer(randomGenerator.nextInt(100000));
            this.sipReqUri = new String("msml=" + msmlId.toString());
            log.debug("Using Random generated MSML= " + msmlId.toString());
        } else {
            DlgcMediaServer mserver = f.getMediaServer();
            if (mserver.isValidUserNamePattern()) {
                this.sipReqUri = mserver.getMsmlVal();
                log.debug("Using User define MSML= " + this.sipReqUri);
            } else {
                Random randomGenerator = new Random();
                msmlId = new Integer(randomGenerator.nextInt(100000));
                this.sipReqUri = new String("msml=" + msmlId.toString());
                log.debug("Using Random generated due to invalid username passed in via the URL - using MSML= " + msmlId.toString());
            }
        }
        log.debug("DlgXNetworkConnection::mediaObjectID: " + this.mediaObjectID);
        log.debug("DlgXNetworkConnection::proxyId: " + this.proxyId);
        this.initNetworkConnectionResourceTypes(cfg, ms, params);
    }

    @Override
    protected void initNetworkConnectionResourceTypes(MediaConfig cfg, MediaSession ms, Parameters params) {
        Iterator<Class<?>> iter = ((DlgcXMediaConfig)cfg).getResourceList();
        while (iter.hasNext()) {
            try {
                Class<?> resourceClass = iter.next();
                Constructor<?> ctr = resourceClass.getConstructor(NetworkConnection.class);
                Resource resource = (Resource)ctr.newInstance(this);
                this.resourceMap.put(resourceClass, resource);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
                log.error(appLogId + "InvocationTargetException cause by " + cause.getMessage());
                e.printStackTrace();
            }
        }
        this.setDefaultParameters(this.getDefaultParameters());
        if (params != null) {
            this.setParameters(params);
        }
    }

    @Override
    public DlgcSdpPortManager getSdpPortMgrResource() {
        DlgcSdpPortManager sdpMgr = null;
        try {
            sdpMgr = this.getResource(DlgcXSdpPortManager.class);
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
        return sdpMgr;
    }

    @Override
    public SdpPortManager getSdpPortManager() throws MsControlException {
        return this.getResource(DlgcXSdpPortManager.class);
    }

    @Override
    public void unjoin(Joinable joinee) throws MsControlException {
        Joinable j = joinee;
        if (joinee instanceof MediaGroup) {
            super.unjoin(joinee);
        } else if (joinee instanceof MixerAdapter || joinee instanceof MediaMixer) {
            super.unjoin(j);
        } else if (joinee instanceof NetworkConnection) {
            this.unjoinFromConference();
        } else {
            throw new MsControlException("Unjoin failed invalid joinne");
        }
    }

    @Override
    public void processSipInfo(SipServletResponse response, DlgcSipConnectorContentIdsProxy proxy) {
        log.debug("DlgcXNetworkConnection::processSipInfo response from XMS");
        log.debug("DlgcXNetworkConnection::processSipInfo response this mediaObjectID: " + this.mediaObjectID);
        log.debug("DlgcXNetworkConnection::processSipInfo response this toString: " + this.toString());
        try {
            MsmlDocument.Msml msmlResponse = DlgcSipB2BUAMSMLProtocol.extractMsmlResponseMessage(response);
            ((DlgcXSdpPortManagerFSM)this.myFSM).evSipInfo(msmlResponse);
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean validate(Joinable.Direction direction, Joinable joinee) {
        boolean result = true;
        if (this instanceof NetworkConnection) {
            if (joinee instanceof NetworkConnection) {
                result = true;
            } else if (joinee instanceof MediaMixer) {
                result = false;
                result = true;
            }
        } else if (this instanceof MediaGroup) {
            if (joinee instanceof MediaGroup) {
                result = false;
            } else if (joinee instanceof MediaMixer) {
                if (direction.equals((Object)Joinable.Direction.SEND)) {
                    result = false;
                }
            } else if (!direction.equals((Object)Joinable.Direction.DUPLEX) && joinee instanceof NetworkConnection) {
                result = false;
            }
        } else if (this instanceof MediaMixer) {
            if (joinee instanceof MediaMixer) {
                result = false;
            } else if (direction.equals((Object)Joinable.Direction.RECV)) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public void join(Joinable.Direction direction, Joinable joinee) throws MsControlException {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        if (joinee instanceof MixerAdapter || joinee instanceof MediaMixer || joinee instanceof MediaGroup) {
            log.debug(appLogId + " - " + "calling super join based on Mixer and MixerAdapter");
            super.join(direction, joinee);
        } else {
            log.debug(appLogId + " - " + "bridging network connection");
            if (this.isNewJoinee((JoinableContainer)joinee)) {
                super.join(direction, joinee);
                ((DlgcSdpPortManagerFSM)this.myFSM).evJoin(direction, joinee, null);
            }
        }
    }

    public DlgcXNetworkConnection getBridgePartner() {
        return this.ncBridgePartner;
    }

    public void setBridgePartner(DlgcXNetworkConnection partner) {
        this.ncBridgePartner = partner;
    }

    @Override
    public String toDebug() {
        String retStr = new String();
        retStr = retStr + "\n $$$$$$ JMC Object DlgcXNetworkConnection =  \n";
        retStr = retStr + "Debug ID = " + this.debugId.toString() + " \n";
        retStr = retStr + "$$$$$$";
        return retStr;
    }

    public boolean decodeSdpWebRtcType(String sdp) {
        this.sdpWebRtcType = false;
        if (this.webRtcExternallyEnabled) {
            log.debug("webrtc was enabled by application");
            this.sdpWebRtcType = true;
        } else if (sdp == null) {
            if (this.webRtcExternallyEnabled) {
                this.sdpWebRtcType = true;
            }
        } else if (sdp.contains("fingerprint")) {
            this.sdpWebRtcType = true;
        }
        log.debug("decodeSdpWebRtcType::Remote SDP WebRTC Type is: " + new Boolean(this.sdpWebRtcType).toString());
        return this.sdpWebRtcType;
    }

    public boolean getSdpWebRtcType() {
        return this.sdpWebRtcType;
    }

    public void setSdpWebRtcType(boolean b) {
        this.sdpWebRtcType = b;
    }
}

