/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayerEvent;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetectorEvent;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.util.Queue;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventNotifier;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.servlet.sip.SipServletRequest;

class DlgcUnparkingState
extends DlgcSdpPortManagerStates {
    private static final long serialVersionUID = 1L;
    private boolean pendingPark = false;

    public DlgcUnparkingState() {
        this.stateName = "DlgcUnparkingState";
    }

    @Override
    public void evSipInvite(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        log.debug(" Entering DlgcUnparkingState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
        DlgcUnparkingState.evSipInviteSipTimerSendOK(fsm, request);
        log.debug(" Returning DlgcUnparkingState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
    }

    @Override
    public void sendMediaMessage(DlgcSdpPortManagerFSM fsm, DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
        try {
            DlgcSdpPortManager portMgr = fsm.getResourceContainer().getSdpPortMgrResource();
            Queue<DlgcSdpPortManager.DlgcMediaMessage> queue = portMgr.messageQueue;
            DlgcSdpPortManager dlgcSdpPortManager = portMgr;
            dlgcSdpPortManager.getClass();
            queue.add(dlgcSdpPortManager.new DlgcSdpPortManager.DlgcMediaMessage(message, notifier));
            fsm.evPark();
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void evPark(DlgcSdpPortManagerFSM fsm) {
        try {
            Joinable[] joinees;
            DlgcSdpPortManager sdp = fsm.getResourceContainer().getSdpPortMgrResource();
            for (Joinable j : joinees = ((NetworkConnection)sdp.getContainer()).getJoinees()) {
                if (!(j instanceof MediaMixer)) continue;
                DlgcMediaMixer mx = (DlgcMediaMixer)j;
                mx.parkLeg(sdp);
                this.pendingPark = true;
            }
        }
        catch (MsControlException e) {
            log.error("Error to park", (Throwable)e);
        }
    }

    @Override
    public void evSipInfo(DlgcFSM fsm, MsmlDocument.Msml message) throws MsControlException {
        DlgcSignalDetector sd;
        DlgcSdpPortManager sdp = null;
        byte[] content = null;
        log.debug("Entering DlgcSdpPortManagerState::DlgcUnparkingState:evSipInfo");
        try {
            sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
        }
        catch (MsControlException ex) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Error getting Sdp Port Manager", (Throwable)ex);
            throw new SdpPortManagerException(ex.getMessage());
        }
        String resultResponse = message.getResult().getResponse();
        Integer iResult = new Integer(resultResponse);
        log.debug("CXMS - DlgcUnparkingState:evSipInfo GOT Msml Result of: " + iResult.toString());
        if (iResult > 200) {
            DlgcSdpPortManagerStates.log.error("Fail to join back the leg to conference. SIP Response return error: " + resultResponse);
            String errMsg = "Fail to join back the leg to conference...SIP error: " + resultResponse;
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, errMsg, null);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            String msg = "Fail to join back the leg to conference. SIP Response return error: " + resultResponse;
            throw new SdpPortManagerException(msg);
        }
        fsm.setState(((DlgcSdpPortManagerFSM)fsm).getConfLegRdy());
        log.debug("DlgcSdpPortManager:DlgcUnparkingState:evSipInfo  setting next state to confLegRdy");
        DlgcMediaSession ms = (DlgcMediaSession)((DlgcResourceContainer)sdp.getContainer()).getMediaSession();
        DlgcIpmsSession dlgsession = ((DlgcNetworkConnection)sdp.getContainer()).getDlgIpmsSession();
        DlgcPlayerEvent playerEv = (DlgcPlayerEvent)dlgsession.getSipSession().getAttribute("DlgcPlayerEvent");
        DlgcSignalDetectorEvent sdEv = (DlgcSignalDetectorEvent)dlgsession.getSipSession().getAttribute("DlgcSignalDetectorEvent");
        if (playerEv != null) {
            log.debug("Entering DlgcSdpPortManagerState::DlgcUnparkingState:evSipInfo processing and sending DlgcPlayerEvent");
            DlgcPlayer player = (DlgcPlayer)dlgsession.getSipSession().getAttribute("DlgcPlayer");
            if (player != null) {
                DlgcSync2AsyncMonitor monitor = player.getMonitor();
                if (monitor == null) {
                    log.debug("Entering DlgcSdpPortManagerState::DlgcUnparkingState:evSipInfo found DlgcPlayerEvent");
                    if (DlgcSipServlet.APP_SERVER_PLATFORM.compareToIgnoreCase("IBM") != 0) {
                        dlgsession.getSipSession().removeAttribute("DlgcPlayerEvent");
                        dlgsession.getSipSession().removeAttribute("DlgcPlayer");
                    }
                    log.debug("Entering DlgcSdpPortManagerState::DlgcUnparkingState:evSipInfo sending play event");
                    player.postMediaEvent(playerEv);
                } else {
                    boolean bStatus = true;
                    String sStatus = "Leg was placed back in conference...Unparked Successfully";
                    log.debug("SYNC_2_ASYNC DlgcSdpPortManagerState::DlgcUnparkingStateevSipInfo -  calling Monitor notifyRequestCompleted");
                    monitor.notifyRequestCompleted(bStatus, sStatus);
                    log.debug("SYNC_2_ASYNC DlgcSdpPortManagerState::DlgcUnparkingStateevSipInfo -  returned from Monitor notifyRequestCompleted");
                }
            }
        } else if (sdEv != null && (sd = (DlgcSignalDetector)dlgsession.getSipSession().getAttribute("DlgcSignalDetector")) != null) {
            log.debug("Entering DlgcSdpPortManagerState::DlgcUnparkingState:evSipInfo found DlgcSignalDetectorEvent");
            if (DlgcSipServlet.APP_SERVER_PLATFORM.compareToIgnoreCase("IBM") != 0) {
                dlgsession.getSipSession().removeAttribute("DlgcSignalDetector");
                dlgsession.getSipSession().removeAttribute("DlgcSignalDetectorEvent");
            }
            log.debug("Entering DlgcSdpPortManagerState::DlgcUnparkingState:evSipInfo sending DlgcSignalDetectorEvent");
            sd.postMediaEvent(sdEv);
        }
    }
}

