/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcState;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapter;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcConfImmediatelyPendingState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcConfLegNoDspPendState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcConfLegNoDspState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcConfLegPendState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcConfLegRdyState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcConfTransitionState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcCreatedState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcFailState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcIvrLegNoDspState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcIvrLegPendState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcIvrLegPendWithNoDspState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcIvrRdyState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcModifyingLegState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcParkTransitionState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcParkedState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcRejectingSdpOfferState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcReleasingState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcUnparkingState;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventNotifier;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.mixer.MixerAdapter;
import javax.media.mscontrol.networkconnection.SdpException;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.sdp.SdpFactory;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.sip.message.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DlgcSdpPortManagerStates
extends DlgcState {
    private static final long serialVersionUID = 1L;
    public static DlgcCreatedState createdState = new DlgcCreatedState();
    protected static DlgcConfImmediatelyPendingState confImmediatelyPendingState = new DlgcConfImmediatelyPendingState();
    protected static DlgcIvrLegPendState ivrLegPendingState = new DlgcIvrLegPendState();
    protected static DlgcIvrLegPendWithNoDspState ivrLegPendWithNoDspState = new DlgcIvrLegPendWithNoDspState();
    protected static DlgcIvrLegNoDspState ivrLegNoDspState = new DlgcIvrLegNoDspState();
    protected static DlgcIvrRdyState ivrLegRdyState = new DlgcIvrRdyState();
    protected static DlgcConfLegPendState confLegPendState = new DlgcConfLegPendState();
    protected static DlgcConfLegNoDspPendState confLegNoDspPendState = new DlgcConfLegNoDspPendState();
    protected static DlgcConfLegNoDspState confLegNoDsp = new DlgcConfLegNoDspState();
    protected static DlgcConfLegRdyState confLegRdy = new DlgcConfLegRdyState();
    protected static DlgcParkTransitionState parkTransitionState = new DlgcParkTransitionState();
    protected static DlgcParkedState parkedState = new DlgcParkedState();
    protected static DlgcUnparkingState unparkingState = new DlgcUnparkingState();
    protected static DlgcConfTransitionState confTransitionState = new DlgcConfTransitionState();
    protected static DlgcFailState failState = new DlgcFailState();
    protected static DlgcReleasingState releasingState = new DlgcReleasingState();
    protected static DlgcModifyingLegState modifyingLegState = new DlgcModifyingLegState();
    protected static DlgcRejectingSdpOfferState rejectingSdpOfferState = new DlgcRejectingSdpOfferState();
    public static Logger log = LoggerFactory.getLogger(DlgcSdpPortManagerStates.class);
    protected static SdpFactory sdpFactory = SdpFactory.getInstance();

    public void evSdpAnswer(DlgcSdpPortManagerFSM dlgcSdpPortManagerFSM, String remoteSD) {
        log.debug("evSdpAnswer (With SDP) event request not supported in the present state");
    }

    public void evSdpOffer(DlgcFSM fsm, String remoteSD) throws SdpException, SdpPortManagerException {
        log.debug("evSdpOffer (With SDP) event request not supported in the present state");
    }

    public void evSdpOffer(DlgcFSM fsm) throws SdpException, SdpPortManagerException {
        log.debug("evSdpOffer (Not SDP) event request not supported in the present state");
    }

    public void evGenerateOffer(DlgcFSM fsm) throws SdpException, SdpPortManagerException {
        log.debug("evGenerateOffer event request not supported in the present state");
    }

    public void evRejectSdpOffer(DlgcFSM fsm) throws SdpException, SdpPortManagerException {
        log.debug("DlgcXSdpPortManagerStates::evRejectSdpOffer event request not supported in the present state");
    }

    public void evJoin(DlgcFSM fsm, Joinable.Direction direction, Joinable joinee, MixerAdapter mxa) {
        log.debug("evJoin event request not supported in the present state");
    }

    public void evOnUnjoin(DlgcFSM fsm) throws SdpException, SdpPortManagerException {
        log.debug("evOnUnjoin event request not supported in the present state");
    }

    public void evConnectToConference(DlgcFSM fsm, String confId) throws SdpException, SdpPortManagerException {
        log.debug("evConnectToConference event request not supported in the present state");
    }

    public void evPark(DlgcSdpPortManagerFSM fsm) {
        log.debug("evPark event request not supported in the present state");
    }

    public void evRelease(DlgcSdpPortManagerFSM dlgcSdpPortManagerFSM) {
        log.debug("evRelease event request not supported in the present state");
    }

    public void evSipInvite(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        log.debug("evSipInvite request - maybe due to IPMS SIP SESSION TIMER event request not supported in the present state");
    }

    public void evSipInvite(DlgcSdpPortManagerFSM fsm, Request request) {
        log.debug("evSipInvite Standalone request - maybe due to IPMS SIP SESSION TIMER event request not supported in the present state");
    }

    public void evUnpark(DlgcSdpPortManagerFSM fsm) {
    }

    public DlgcXSdpPortManagerStates.DlGC_MIXER_JOIN_STATE determineMixerState(DlgcXNetworkConnection nc) {
        DlgcNetworkConnection activeControlLeg;
        DlgcXSdpPortManagerStates.DlGC_MIXER_JOIN_STATE ms = DlgcXSdpPortManagerStates.DlGC_MIXER_JOIN_STATE.MIXER_JOIN_STATE_UNKNOWN;
        log.debug("DlgcSdpPortManagerState::determineMixerState() calling getMixerIfJoined with NC OBJID: " + nc.getMediaObject().toString());
        DlgcXMediaMixer mixer = (DlgcXMediaMixer)nc.getMixerIfJoined();
        if (mixer == null) {
            log.debug("DlgcSdpPortManagerState::determineMixerState() MIXER NULL ISSUE = [MIXER OPMODE]: NONE - returning join state: DlGC_MIXER_JOIN_STATE.NOT_JOIN_TO_MIXER");
            return DlgcXSdpPortManagerStates.DlGC_MIXER_JOIN_STATE.NOT_JOIN_TO_MIXER;
        }
        DlgcXMediaMixer.MixerOperationalMode mixerMode = mixer.getMixerControlMode();
        log.debug("DlgcSdpPortManagerState::determineMixerState()-[MIXER OPMODE]::" + mixerMode.toString());
        ms = mixerMode == DlgcXMediaMixer.MixerOperationalMode.CONTROL_LEG_MODE_CONFIGURED ? DlgcXSdpPortManagerStates.DlGC_MIXER_JOIN_STATE.JOIN_TO_MIXER_CTL_LEG : (mixerMode == DlgcXMediaMixer.MixerOperationalMode.CONTROL_LEG_MODE_CONFIRMED ? DlgcXSdpPortManagerStates.DlGC_MIXER_JOIN_STATE.JOIN_TO_MIXER_CTL_LEG_CREATED_AND_CONFIRMED : (mixerMode == DlgcXMediaMixer.MixerOperationalMode.NON_CONTROL_LEG_RDY_MODE ? ((activeControlLeg = mixer.getActiveControlLeg()) == null ? DlgcXSdpPortManagerStates.DlGC_MIXER_JOIN_STATE.JOIN_TO_MIXER_CREATED_AND_NOT_CONFIRMED_CONF_NOTRDY : DlgcXSdpPortManagerStates.DlGC_MIXER_JOIN_STATE.JOIN_TO_MIXER_CREATED_AND_NOT_CONFIRMED_CONF_RDY) : DlgcXSdpPortManagerStates.DlGC_MIXER_JOIN_STATE.JOIN_TO_MIXER_CREATED_AND_NOT_CONFIRMED_CONF_NOTRDY));
        log.debug("DlgcSdpPortManagerState::determineMixerState()-[JOIN STATE]:: returning join state: " + ms.toString());
        return ms;
    }

    public void sendMediaMessage(DlgcSdpPortManagerFSM fsm, DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
        try {
            DlgcSdpPortManager portMgr = fsm.getResourceContainer().getSdpPortMgrResource();
            portMgr.sendSipMessage(message, notifier);
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    protected void connectToConference(DlgcMediaMixer mixer, DlgcFSM fsm, DlgcState nextState, DlgcMixerAdapter mxa) throws SdpException, SdpPortManagerException {
        DlgcSdpPortManagerFSM sdppm_fsm = (DlgcSdpPortManagerFSM)fsm;
        DlgcNetworkConnection nc = (DlgcNetworkConnection)sdppm_fsm.getResourceContainer();
        try {
            DlgcSdpPortManager sdppm = (DlgcSdpPortManager)nc.getSdpPortManager();
            mixer.addLeg(sdppm, mxa);
            fsm.setState(nextState);
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    protected void connectToConferenceImmediately(DlgcXMediaMixer mixer, DlgcFSM fsm, DlgcState nextState, DlgcMixerAdapter mxa) throws SdpException, SdpPortManagerException {
        DlgcSdpPortManagerFSM sdppm_fsm = (DlgcSdpPortManagerFSM)fsm;
        DlgcNetworkConnection nc = (DlgcNetworkConnection)sdppm_fsm.getResourceContainer();
        try {
            DlgcSdpPortManager sdppm = (DlgcSdpPortManager)nc.getSdpPortManager();
            log.warn("In effort to remove control I have removed the following line: mixer.addLegToConferenceImmediately( sdppm,mxa)");
            fsm.setState(nextState);
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    protected void connectToConference(DlgcFSM fsm, DlgcState nextState) throws SdpException, SdpPortManagerException {
        boolean[] confirmed = new boolean[1];
        String[] conferenceId = new String[1];
        DlgcSdpPortManagerFSM pmgrFSM = (DlgcSdpPortManagerFSM)fsm;
        DlgcNetworkConnection nc = (DlgcNetworkConnection)pmgrFSM.getResourceContainer();
        if (nc.isJoinedWithMixer(conferenceId, confirmed)) {
            try {
                DlgcSdpPortManager sdpMgr = (DlgcSdpPortManager)nc.getSdpPortManager();
                String sipUser = null;
                sipUser = DlgcSipB2BUA.isMediaTypeXMS() ? "msml=" + conferenceId[0] : "conf=" + conferenceId[0];
                String remoteSD = sdpMgr.getUserAgentSessionDescription().toString();
                sdpMgr.sendSipMessage(sipUser, "INVITE", "sdp", remoteSD);
                fsm.setState(nextState);
            }
            catch (MsControlException e) {
                log.error("Exception during connecting leg to a conference: ", (Throwable)e);
            }
        }
    }

    protected void releaseSAS(DlgcProxy proxy, String source) {
        SipApplicationSession sas = proxy.getProxySAS();
        if (sas != null) {
            if (sas.isValid()) {
                log.debug("Invalidating SipApplicationSession due to " + source + " request.");
                sas.invalidate();
            } else {
                log.warn("Cant Invalidate SipApplicationSession during " + source + " because is already invalid.");
            }
        } else {
            log.warn("Cant Invalidate SipApplicationSession during " + source + " because SAS is null ie not found.");
        }
    }

    public static void sendSipMessage(DlgcFSM fsm, String method) throws MsControlException {
        DlgcSdpPortManagerStates.sendSipMessage(fsm, null, method, "none", null);
    }

    public static void evSipInviteSipTimerSendOK(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        try {
            log.debug("evSipInviteSipTimerSendOK() handling IPMS SIP SESSION TIMER- calling ProtMgr.processSipINvite(request) to send 200 ok");
            DlgcSdpPortManager portMgr = fsm.getResourceContainer().getSdpPortMgrResource();
            portMgr.processSipInvite(request);
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    public static void sendSipMessage(DlgcFSM fsm, String user, String method, String contentType, String content) throws MsControlException {
        DlgcNetworkConnection nc = (DlgcNetworkConnection)((DlgcResourceContainerFSM)fsm).getResourceContainer();
        DlgcSipMessage sipMessage = new DlgcSipMessage(nc, method, user, contentType, content);
        try {
            DlgcSipServlet.sipB2BUA.scheduleTask(sipMessage, null);
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }
}

