/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynCallbackImpl;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynDispatcher;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnectionProxy;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.networkconnection.CodecPolicy;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManager;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcSdpPortManagerProxy
extends DlgcProxy
implements SdpPortManager,
Serializable {
    private static final long serialVersionUID = 33364758237220987L;
    private static Logger log = LoggerFactory.getLogger(DlgcNetworkConnectionProxy.class);

    public DlgcSdpPortManagerProxy(String id, String mediaSessionId, String msId) {
        super(id, mediaSessionId, msId);
    }

    public void generateSdpOffer() throws SdpPortManagerException {
        log.debug("DlgcSdpPortManagerProxy::generateSdpOffer  using generateSdpOfferAsync");
        this.generateSdpOfferAsync();
    }

    protected void generateSdpOfferAsync() throws SdpPortManagerException {
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("Generate SDP Request");
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering SdpPortManagerProxy::generateSdpOfferAsync Task run() => Media Server");
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        DlgcSdpPortManager sdpMgr = (DlgcSdpPortManager)nc.getSdpPortManager();
                        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                            ((DlgcXSdpPortManager)sdpMgr).setMonitor(monitor);
                        }
                        sdpMgr.generateSdpOffer();
                        DlgcSdpPortManagerProxy pproxy = sdpMgr.getProxy();
                        pproxy.saveMediaSession(appSession, session);
                    }
                    catch (MsControlException e) {
                        log.debug(e.toString());
                    }
                    log.debug("Exiting SdpPortManagerProxy::generateSdpOfferAsync Task run() => Media Server");
                }
            });
            if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("SYNC_2_ASYNC generateSdpOffer:: Waiting synchronously for generateSdpOffer request to return");
                monitor.waitForRequestCompletion();
                log.debug("SYNC_2_ASYNC generateSdpOffer returned with the following status: " + monitor.getStatusString());
                DlgcXNetworkConnection xnc = (DlgcXNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
                ((DlgcXSdpPortManager)xnc.getSdpPortManager()).setMonitor(null);
            }
        }
        catch (Exception e) {
            log.error("Failed to get generateSdpOffer. generateSdpOffer failed", (Throwable)e);
        }
    }

    public CodecPolicy getCodecPolicy() {
        CodecPolicy cp = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
            DlgcSdpPortManager sdpMgr = (DlgcSdpPortManager)nc.getSdpPortManager();
            cp = sdpMgr.getCodecPolicy();
        }
        catch (Exception e) {
            log.error("Failed to get getCodecPolicy. getCodecPolicy failed", (Throwable)e);
        }
        return cp;
    }

    public byte[] getMediaServerSessionDescription() throws SdpPortManagerException {
        byte[] sdp = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
            DlgcSdpPortManager sdpMgr = (DlgcSdpPortManager)nc.getSdpPortManager();
            sdp = sdpMgr.getMediaServerSessionDescription();
        }
        catch (Exception e) {
            log.error("Failed to get getMediaServerSessionDescription. getMediaServerSessionDescription failed", (Throwable)e);
        }
        return sdp;
    }

    public byte[] getUserAgentSessionDescription() throws SdpPortManagerException {
        byte[] sdp = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
            DlgcSdpPortManager sdpMgr = (DlgcSdpPortManager)nc.getSdpPortManager();
            sdp = sdpMgr.getUserAgentSessionDescription();
        }
        catch (Exception e) {
            log.error("Failed to get getUserAgentSessionDescription. getUserAgentSessionDescription failed", (Throwable)e);
        }
        return sdp;
    }

    public void processSdpAnswer(byte[] arg0) throws SdpPortManagerException {
        log.debug("DlgcSdpPortManagerProxy::processSdpAnswer  using processSdpAnswerAsync");
        this.processSdpAnswerAsync(arg0);
    }

    protected void processSdpAnswerAsync(final byte[] arg0) throws SdpPortManagerException {
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering SdpPortManagerProxy::processSdpAnswerAsync Task run() => Media Server");
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        DlgcSdpPortManager sdpMgr = (DlgcSdpPortManager)nc.getSdpPortManager();
                        sdpMgr.processSdpAnswer(arg0);
                        DlgcSdpPortManagerProxy pproxy = sdpMgr.getProxy();
                        pproxy.saveMediaSession(appSession, session);
                    }
                    catch (MsControlException e1) {
                        log.debug(e1.toString());
                    }
                    log.debug("Exiting SdpPortManagerProxy::processSdpAnswerAsync Task run() => Media Server");
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to get processSdpAnswer. processSdpAnswer failed", (Throwable)e);
            throw new SdpPortManagerException("Failed to get processSdpAnswer. processSdpAnswer failed", (Throwable)e);
        }
    }

    public void processSdpOffer(byte[] arg0) throws SdpPortManagerException {
        log.debug("DlgcSdpPortManagerProxy::processSdpOffer  using processSdpOffer");
        this.processSdpOfferAsync(arg0);
    }

    protected void processSdpOfferAsync(final byte[] arg0) throws SdpPortManagerException {
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("Process SDP OFFER Request");
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering SdpPortManagerProxy::processSdpOfferAsync Task run() => Media Server");
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        DlgcSdpPortManager sdpMgr = (DlgcSdpPortManager)nc.getSdpPortManager();
                        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                            ((DlgcXSdpPortManager)sdpMgr).setMonitor(monitor);
                        }
                        sdpMgr.processSdpOffer(arg0);
                        DlgcSdpPortManagerProxy pproxy = sdpMgr.getProxy();
                        pproxy.saveMediaSession(appSession, session);
                    }
                    catch (MsControlException e) {
                        log.debug(e.toString());
                    }
                    log.debug("Exiting SdpPortManagerProxy::processSdpOfferAsync Task run() => Media Server");
                }
            });
            if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("SYNC_2_ASYNC processSdpOffer:: Waiting synchronously for processSdpOffer request to return");
                monitor.waitForRequestCompletion();
                log.debug("SYNC_2_ASYNC processSdpOffer returned with the following status: " + monitor.getStatusString());
                DlgcXNetworkConnection xnc = (DlgcXNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
                ((DlgcXSdpPortManager)xnc.getSdpPortManager()).setMonitor(null);
            }
        }
        catch (Exception e) {
            log.error("Failed to get processSdpOffer. processSdpOffer failed", (Throwable)e);
            throw new SdpPortManagerException("Failed to get processSdpOffer. processSdpOffer failed", (Throwable)e);
        }
    }

    public void rejectSdpOffer() throws SdpPortManagerException {
        log.debug("DlgcSdpPortManagerProxy::rejectSdpOffer  using rejectSdpOfferSync");
        this.rejectSdpOfferAsync();
    }

    protected void rejectSdpOfferAsync() throws SdpPortManagerException {
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering SdpPortManagerProxy::rejectSdpOfferAsync Task run() => Media Server");
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        DlgcSdpPortManager sdpMgr = (DlgcSdpPortManager)nc.getSdpPortManager();
                        sdpMgr.rejectSdpOffer();
                        DlgcSdpPortManagerProxy pproxy = sdpMgr.getProxy();
                        pproxy.saveMediaSession(appSession, session);
                    }
                    catch (MsControlException e) {
                        e.printStackTrace();
                    }
                    log.debug("Exiting SdpPortManagerProxy::rejectSdpOfferAsync Task run() => Media Server");
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to get rejectSdpOffer. rejectSdpOffer failed", (Throwable)e);
            throw new SdpPortManagerException("Failed to get rejectSdpOffer. rejectSdpOffer failed", (Throwable)e);
        }
    }

    public void setCodecPolicy(CodecPolicy arg0) throws SdpPortManagerException {
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
            DlgcSdpPortManager sdpMgr = (DlgcSdpPortManager)nc.getSdpPortManager();
            sdpMgr.setCodecPolicy(arg0);
            if (null != arg0) {
                if (null != arg0.getExcludedCodecs() && arg0.getExcludedCodecs().length >= 0 && null != arg0.getCodecCapabilities() && arg0.getCodecCapabilities().length >= 0 && !Collections.disjoint(Arrays.asList(arg0.getExcludedCodecs()), Arrays.asList(arg0.getCodecCapabilities()))) {
                    throw new SdpPortManagerException("SdpPortManager : Cannot overlap between Excluded Codecs and Codec Capabilities. ");
                }
                if (null != arg0.getExcludedCodecs() && arg0.getExcludedCodecs().length >= 0 && null != arg0.getRequiredCodecs() && arg0.getRequiredCodecs().length >= 0 && !Collections.disjoint(Arrays.asList(arg0.getExcludedCodecs()), Arrays.asList(arg0.getRequiredCodecs()))) {
                    throw new SdpPortManagerException("SdpPortManager : Cannot overlap between Excluded Codecs and Required Codecs. ");
                }
                if (null != arg0.getExcludedCodecs() && arg0.getExcludedCodecs().length >= 0 && null != arg0.getCodecPreferences() && arg0.getCodecPreferences().length >= 0 && !Collections.disjoint(Arrays.asList(arg0.getCodecPreferences()), Arrays.asList(arg0.getExcludedCodecs()))) {
                    throw new SdpPortManagerException("SdpPortManager : Cannot overlap between Excluded Codecs and Codec Preferences. ");
                }
                if (null != arg0.getExcludedCodecs() && arg0.getExcludedCodecs().length > 0) {
                    ArrayList<String> b = new ArrayList<String>();
                    b.add("EVRC0");
                    b.add("G723");
                    String[] bogusRtcs = new String[]{"fmtp", "AS", "sendrecv", "audio", "IP4"};
                    if ((arg0.getExcludedCodecs().length != 2 || !Arrays.asList(arg0.getExcludedCodecs()).containsAll(b)) && Collections.disjoint(Arrays.asList(arg0.getExcludedCodecs()), Arrays.asList(bogusRtcs))) {
                        throw new SdpPortManagerException("SdpPortManager : Codec exclusion is not supported in this version of the connector.");
                    }
                }
            }
            DlgcSdpPortManagerProxy pproxy = sdpMgr.getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SdpPortManagerException(e.getMessage());
        }
    }

    public NetworkConnection getContainer() {
        DlgcNetworkConnection nc = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
        }
        catch (Exception e) {
            log.error("Failed to getContainer", (Throwable)e);
        }
        return (NetworkConnection)nc.getProxy();
    }

    public void addListener(MediaEventListener<SdpPortManagerEvent> arg0) {
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
            DlgcSdpPortManager sdp = (DlgcSdpPortManager)nc.getSdpPortManager();
            sdp.addListener(arg0);
            DlgcSdpPortManagerProxy pproxy = sdp.getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to addListener", (Throwable)e);
        }
    }

    public MediaSession getMediaSession() {
        DlgcMediaSession ms = null;
        SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
        String mediaId = this.getMsObjectId();
        try {
            ms = (DlgcMediaSession)appSession.getAttribute(mediaId);
        }
        catch (Exception e) {
            log.error("Failed to GetProxyMediaSession", (Throwable)e);
        }
        return ms.getProxy();
    }

    public void removeListener(MediaEventListener<SdpPortManagerEvent> arg0) {
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
            DlgcSdpPortManager sdp = (DlgcSdpPortManager)nc.getSdpPortManager();
            sdp.removeListener(arg0);
            DlgcSdpPortManagerProxy pproxy = sdp.getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to removeListener", (Throwable)e);
        }
    }
}

