/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSupportedFeatures;
import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcState;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinEvent;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcCodecMediator;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerEvent;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerProxy;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpSipHeaderParameter;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResource;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventNotifier;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.networkconnection.CodecPolicy;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManager;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.sdp.SdpFactory;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcSdpPortManager
extends DlgcResource<NetworkConnection, SdpPortManagerEvent>
implements SdpPortManager {
    private static final long serialVersionUID = 1895467890L;
    public Queue<DlgcMediaMessage> messageQueue = new ConcurrentLinkedQueue<DlgcMediaMessage>();
    public Queue<DlgcMediaMixerMessage> mediaMixerMessageQueue = new ConcurrentLinkedQueue<DlgcMediaMixerMessage>();
    private transient SessionDescription localSessionDesc;
    private transient SessionDescription remoteSessionDesc;
    private byte[] msSessionDesc;
    private byte[] uaSessionDesc;
    protected DlgcSdpPortManagerFSM myFSM = null;
    private static DlgcParameters supportedParameters;
    private static DlgcSupportedFeatures supportedFeatures;
    private static Logger log;
    protected DlgcCodecMediator myPolicyCodecMediator;
    protected SipServletResponse responseToSoftPhoneFutureAck;
    private EARLY_MEDIA_TYPE emt;

    public DlgcSdpPortManager(NetworkConnection nc) {
        super(nc);
        this.myFSM = new DlgcSdpPortManagerFSM((DlgcResourceContainer)nc);
        this.myPolicyCodecMediator = new DlgcCodecMediator();
        this.msSessionDesc = null;
        this.uaSessionDesc = null;
        this.responseToSoftPhoneFutureAck = null;
        this.emt = EARLY_MEDIA_TYPE.NO_EM;
    }

    public void forceStateChangeToIVR_RDY_STATE() {
        DlgcSdpPortManagerStates ivrRdyState = this.myFSM.getIvrLegRdyState();
        DlgcNetworkConnection nc = (DlgcNetworkConnection)this.getContainer();
        String presentStateName = this.myFSM.getPresentState().getName();
        log.debug("forceStateChangeToIVR_RDY_STATE: presentState before changing  to IVR RDY is: " + presentStateName + " for NC ID: " + nc.getMediaObject());
        this.myFSM.setState(ivrRdyState);
    }

    public CodecPolicy getCodecPolicy() {
        return this.myPolicyCodecMediator.getPolicy();
    }

    public byte[] getMediaServerSessionDescription() throws SdpPortManagerException {
        return this.msSessionDesc;
    }

    @Override
    protected DlgcParameters getSupportedParameters() {
        return supportedParameters;
    }

    public byte[] getUserAgentSessionDescription() throws SdpPortManagerException {
        return this.uaSessionDesc;
    }

    public void processSdpAnswer(byte[] sdp) throws SdpPortManagerException {
        try {
            this.remoteSessionDesc = SdpFactory.getInstance().createSessionDescription(new String(sdp));
            log.debug("processSdpAnswer sdp to send to XMS: " + this.remoteSessionDesc.toString());
            DlgcXNetworkConnection nc = (DlgcXNetworkConnection)this.getContainer();
            log.info("JSR309 API REQUEST:processSdpAnswer() : NC MEDIA OBJID: " + nc.getMediaObject() + " remoteSDP: " + sdp.toString());
            this.myFSM.evProcessSdpAnswer(new String(sdp));
        }
        catch (SdpParseException e) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            throw new SdpPortManagerException(appLogId + "Exception Sending SDP Invite", (Throwable)e);
        }
    }

    public void processSdpOffer(byte[] sdp) throws SdpPortManagerException {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        DlgcXNetworkConnection nc = (DlgcXNetworkConnection)this.getContainer();
        log.info("*15 JSR309 API REQUEST:processSdpOffer() : NC MEDIA OBJID: " + nc.getMediaObject() + "NC Id by String:  " + nc.toString());
        try {
            this.remoteSessionDesc = SdpFactory.getInstance().createSessionDescription(new String(sdp));
            log.debug(appLogId + "Calling processSdpOffer");
            this.myFSM.evProcessSdpOffer(new String(sdp));
        }
        catch (SdpParseException e) {
            throw new SdpPortManagerException(appLogId + "Exception Sending SDP Invite", (Throwable)e);
        }
    }

    public void generateSdpOffer() throws SdpPortManagerException {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        DlgcXNetworkConnection nc = (DlgcXNetworkConnection)this.getContainer();
        log.debug("Calling processSdpOffer() NCID: " + nc.toString());
        log.info(appLogId + "JSR309 API REQUEST:generateSdpOffer() : NC MEDIA OBJID: " + nc.getMediaObject() + " remoteSDP: NULL");
        this.myFSM.evProcessSdpOffer();
    }

    public void processSipInvite(SipServletResponse response) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "Nothing to do by design in IPMS DlgcSpdPortManager::processSipInvite(response) invite response");
    }

    public void processSipInvite(SipServletRequest request) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "==> DlgcSdpPortManager - processSipInvite [REQUEST] due to IPMS SIP SESSION TIMER sending 200 OK back to XMS");
        try {
            String supportedTimer = request.getHeader("Supported");
            String sessionExpires = request.getHeader("Session-Expires");
            if (supportedTimer == null) {
                log.debug("DlgcSdpPortManager::processSipInvite - Supported is NULL setting response to default Supported: timer");
            } else {
                log.debug("DlgcSdpPortManager::processSipInvite - Supported: " + supportedTimer);
            }
            if (sessionExpires == null) {
                String val = DlgcSipB2BUA.myProperties.getProperty("mediaserver.sessionTimer.maxTimeout");
                if (val == null) {
                    sessionExpires = "1800;refresher=uas";
                    log.debug("DlgcSdpPortManager::processSipInvite - sessionExpires Timer is NULL setting response to default sessionExpires: " + sessionExpires);
                } else {
                    sessionExpires = val + ";refresher=uas";
                    log.debug("DlgcSdpPortManager::processSipInvite - sessionExpires Timer is NULL setting response to default sessionExpires: " + sessionExpires);
                }
            } else {
                log.debug("DlgcSdpPortManager::processSipInvite - sessionExpires: " + sessionExpires);
            }
            SipServletResponse resp200_OK = request.createResponse(200);
            resp200_OK.setHeader("Session-Expires", sessionExpires);
            resp200_OK.setHeader("Supported", "timer");
            log.debug("DlgcSdpPortManager::processSipInvite - Sending Timer Refresh Update response to XMS: " + resp200_OK.toString());
            resp200_OK.send();
        }
        catch (IOException e) {
            log.debug("Exception: " + e.toString());
        }
        log.debug(appLogId + "==> Leaving DlgcSdpPortManager - processSipInvite [REQUEST] due to IPMS SIP SESSION TIMER sending 200 OK back to XMS");
    }

    public void processSipUpdate(SipServletRequest request) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "==> DlgcSdpPortManager - processSipUpdate [REQUEST] due to SIP SESSION TIMER sending 200 OK back to end point");
        try {
            String requireTimer = request.getHeader("Require");
            String supportedTimer = request.getHeader("Supported");
            String sessionExpires = request.getHeader("Session-Expires");
            if (requireTimer == null) {
                log.debug("DlgcSdpPortManager::processSipUpdate - Require Timer is NULL setting response to default requireTimer: timer");
            } else {
                log.debug("DlgcSdpPortManager::processSipUpdate - Require: " + requireTimer);
            }
            if (supportedTimer == null) {
                log.debug("DlgcSdpPortManager::processSipUpdate - Supported is NULL setting response to default Supported: timer");
            } else {
                log.debug("DlgcSdpPortManager::processSipUpdate - Supported: " + supportedTimer);
            }
            if (sessionExpires == null) {
                String val = DlgcSipB2BUA.myProperties.getProperty("mediaserver.sessionTimer.maxTimeout");
                if (val == null) {
                    sessionExpires = "1800;refresher=uas";
                    log.debug("DlgcSdpPortManager::processSipUpdate - sessionExpires Timer is NULL setting response to default sessionExpires: " + sessionExpires);
                } else {
                    sessionExpires = val + ";refresher=uas";
                    log.debug("DlgcSdpPortManager::processSipUpdate - sessionExpires Timer is NULL setting response to default sessionExpires: " + sessionExpires);
                }
            } else {
                log.debug("DlgcSdpPortManager::processSipUpdate - sessionExpires: " + sessionExpires);
            }
            SipServletResponse resp200_OK = request.createResponse(200);
            resp200_OK.setHeader("Session-Expires", sessionExpires);
            resp200_OK.setHeader("Supported", "timer");
            resp200_OK.setHeader("Require", "timer");
            log.debug("DlgcSdpPortManager::processSipUpdate - Sending Timer Refresh Update response to XMS: " + resp200_OK.toString());
            resp200_OK.send();
        }
        catch (IOException e) {
            log.debug("Exception: " + e.toString());
        }
        log.debug(appLogId + "==> Leaving DlgcSdpPortManager - processSipUpdate [REQUEST] due to IPMS SIP SESSION TIMER sending 200 OK back to XMS");
    }

    public void rejectSdpOffer() throws SdpPortManagerException {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.info(appLogId + "JSR309 API REQUEST:evRejectSdpOffer() : NC MEDIA OBJID: " + ((DlgcXNetworkConnection)this.container).getMediaObject());
        this.myFSM.evRejectSdpOffer();
    }

    @Override
    public void sendSipMessage(String method) {
        this.sendSipMessage(null, method, "none", null);
    }

    @Override
    public void sendSipMessage(String user, String method, String contentType, String content) {
        DlgcSipMessage sipMessage = new DlgcSipMessage((JoinableContainer)this.getContainer(), method, user, contentType, content);
        try {
            DlgcSipServlet.sipB2BUA.scheduleTask(sipMessage, this);
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    public void setCodecPolicy(CodecPolicy policy) throws SdpPortManagerException {
        this.myPolicyCodecMediator.setPolicy(policy);
    }

    public void setLocalSessionDescription(byte[] content) {
        try {
            if (content != null) {
                this.msSessionDesc = content;
                this.localSessionDesc = SdpFactory.getInstance().createSessionDescription(new String(content));
            } else {
                log.debug("DlgcSdpPortManager::setLocalSessionDescription content of response is null..ignoring");
            }
        }
        catch (SdpParseException e) {
            e.printStackTrace();
        }
    }

    public void setRemoteSessionDescription(SessionDescription desc) {
        this.remoteSessionDesc = desc;
    }

    public void setUASessionDesc(byte[] desc) {
        this.uaSessionDesc = desc;
    }

    public void setMSSessionDesc(byte[] desc) {
        this.msSessionDesc = desc;
    }

    public void setResponseToAck(SipServletResponse msg) {
        this.responseToSoftPhoneFutureAck = msg;
    }

    public SipServletResponse getResponseToAck() {
        return this.responseToSoftPhoneFutureAck;
    }

    public void sendApplicationEvent(EventType evType, byte[] msSdp, MediaErr mError, String errorText, Qualifier q) {
        DlgcSdpPortManagerEvent sdpEvent = new DlgcSdpPortManagerEvent(evType, msSdp, this);
        if (mError != null) {
            sdpEvent.setError(mError);
            sdpEvent.setErrorText(errorText);
            sdpEvent.setQualifier(q);
        }
        if (null == sdpEvent.getError()) {
            sdpEvent.setError(MediaErr.NO_ERROR);
        }
        if (log.isDebugEnabled()) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.debug(appLogId + "Calling Application Event Handler via Notifier with event: " + sdpEvent.toString());
        }
        this.postMediaEvent(sdpEvent);
    }

    public void sendApplicationJoinEvent(EventType evType, MediaErr mError, String errorText) {
        log.debug("Entering sendApplicationJoinEvent() ");
        DlgcXNetworkConnection nc = (DlgcXNetworkConnection)this.getContainer();
        DlgcJoinEvent joinEv = new DlgcJoinEvent(evType, (Joinable)nc);
        if (mError != null) {
            joinEv.setError(mError);
            joinEv.setErrorText(errorText);
        }
        if (null == joinEv.getError()) {
            joinEv.setError(MediaErr.NO_ERROR);
        }
        if (log.isDebugEnabled()) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.debug(appLogId + "sendApplicationJoinEvent - Calling Application Event Handler via Notifier with event: " + joinEv.toString());
        }
        nc.postJoinEvent(joinEv);
    }

    @Override
    public DlgcSdpPortManagerProxy getProxy() {
        DlgcResourceContainer container = (DlgcResourceContainer)this.container;
        String componentProxyId = container.getProxyId();
        String sasId = ((DlgcMediaSession)container.getMediaSession()).getProxyId();
        String msObjId = ((DlgcMediaSession)container.getMediaSession()).getMediaObject();
        return new DlgcSdpPortManagerProxy(sasId, componentProxyId, msObjId);
    }

    public String getSipReqUri() {
        return ((DlgcNetworkConnection)this.container).getSipReqUri();
    }

    public Boolean getToneClamping() {
        return ((DlgcNetworkConnection)this.container).getToneClamping();
    }

    public EARLY_MEDIA_TYPE getEM() {
        return this.emt;
    }

    public void setEM(EARLY_MEDIA_TYPE et) {
        this.emt = et;
    }

    public static DlgcParameters loadSupportedParameters() {
        return supportedParameters;
    }

    public void setMyState(DlgcState state) {
        this.myFSM.setState(state);
    }

    public DlgcSdpPortManagerFSM getMyFSM() {
        return this.myFSM;
    }

    static {
        log = LoggerFactory.getLogger(DlgcSdpPortManager.class);
        supportedParameters = new DlgcParameters();
        supportedParameters.put(SIP_HEADERS, DlgcSdpSipHeaderParameter.instance);
        supportedFeatures = new DlgcSupportedFeatures();
        HashSet<EventType> sev = new HashSet<EventType>();
        sev.add(SdpPortManagerEvent.ANSWER_GENERATED);
        sev.add(SdpPortManagerEvent.OFFER_GENERATED);
        supportedFeatures.setSfEventTypes(sev);
        supportedFeatures.setSfParameters(supportedParameters.keySet());
    }

    public static enum EARLY_MEDIA_TYPE {
        NO_EM,
        PRE_EM,
        RDY_EM;

    }

    public class DlgcMediaMixerMessage
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public DlgcMediaMixer mixer;
        public String message;

        DlgcMediaMixerMessage(DlgcMediaMixer mixer, String message) {
            this.mixer = mixer;
            this.message = message;
        }
    }

    public class DlgcMediaMessage
    implements Serializable {
        private static final long serialVersionUID = 74446573899L;
        public DlgcSipMessage message;
        public MediaEventNotifier<? extends MediaEvent<?>> notifier;

        DlgcMediaMessage(DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
            this.message = message;
            this.notifier = notifier;
        }
    }
}

