/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.JoinEvent;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.mixer.MixerAdapter;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;

class DlgcParkedState
extends DlgcSdpPortManagerStates {
    public DlgcParkedState() {
        this.stateName = "DlgcParkedState";
    }

    @Override
    public void evSipInvite(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        log.debug(" Entering DlgcParkedState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
        DlgcParkedState.evSipInviteSipTimerSendOK(fsm, request);
        log.debug(" Returning DlgcParkedState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
    }

    @Override
    public void evJoin(DlgcFSM fsm, Joinable.Direction direction, Joinable joinee, MixerAdapter mxa) {
        log.debug("DlgcSdpPortManagerState: [DlgcParkedState] (evJoin) ");
        if (joinee instanceof MediaMixer) {
            try {
                DlgcSdpPortManager sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
                DlgcMediaMixer mx = (DlgcMediaMixer)joinee;
                log.debug("DlgcSdpPortManagerState: [DlgcParkedState] (evJoin) - calling mx.unparked() ");
                mx.unparkLeg(sdp, mxa);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void evSipInfo(DlgcFSM fsm, MsmlDocument.Msml message) throws MsControlException {
        log.debug("DlgcSdpPortManagerState: [DlgcParkedState] (evSipInfo) ");
        DlgcSdpPortManager sdp = null;
        byte[] content = null;
        try {
            sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
        }
        catch (MsControlException e) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Error getting Sdp Port Manager while in DlgcParkedState::evSipInfo Msml method.", (Throwable)e);
            throw new SdpPortManagerException(e.getMessage());
        }
        String resultResponse = message.getResult().getResponse();
        Integer iResult = new Integer(resultResponse);
        log.debug("CXMS - DlgcParkedState:evSipInfo GOT Msml Result of: " + iResult.toString());
        DlgcNetworkConnection nc = (DlgcNetworkConnection)sdp.getContainer();
        DlgcSync2AsyncMonitor monitor = nc.getMonitor();
        if (iResult > 200) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            if (monitor == null) {
                DlgcSdpPortManagerStates.log.error("SIP Response return error: " + resultResponse);
                String errMsg = "Fail to establish SIP Session...SIP error: " + resultResponse;
                sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, errMsg, null);
                String msg = "SIP Response return error: " + resultResponse;
                throw new SdpPortManagerException(msg);
            }
            boolean bStatus = false;
            String sStatus = "Join Unsuccessfully";
            log.debug("SYNC_2_ASYNC DlgcParkedState::evSipInfo -  calling Monitor notifyRequestCompleted");
            monitor.notifyRequestCompleted(bStatus, sStatus);
            log.debug("SYNC_2_ASYNC DlgcParkedState::evSipInfo -  returned from Monitor notifyRequestCompleted");
        } else {
            log.debug("DlgcSdpPortManagerState: [DlgcParkedState] (evSipInfo) => [DlgcConfLegRedy] ");
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getConfLegRdy());
            if (monitor == null) {
                log.debug("DlgcSdpPortManagerState: [DlgcParkedState] (evSipInfo) monitor not found not unlocking but sending JOINED event");
                sdp.sendApplicationEvent(JoinEvent.JOINED, null, MediaErr.NO_ERROR, "Join Success", null);
            } else {
                boolean bStatus = true;
                String sStatus = "Join Successfully";
                log.debug("SYNC_2_ASYNC DlgcParkedState::evSipInfo -  calling Monitor notifyRequestCompleted");
                monitor.notifyRequestCompleted(bStatus, sStatus);
                log.debug("SYNC_2_ASYNC DlgcParkedState::evSipInfo -  returned from Monitor notifyRequestCompleted");
            }
        }
    }

    @Override
    public void evUnpark(DlgcSdpPortManagerFSM fsm) {
        try {
            Joinable[] joinees;
            DlgcSdpPortManager sdp = fsm.getResourceContainer().getSdpPortMgrResource();
            for (Joinable j : joinees = ((NetworkConnection)sdp.getContainer()).getJoinees()) {
                if (!(j instanceof MediaMixer)) continue;
                fsm.setState(fsm.getUnparkingState());
                DlgcMediaMixer mx = (DlgcMediaMixer)j;
                mx.unparkLeg(sdp);
            }
        }
        catch (MsControlException e) {
            log.error("Error to park", (Throwable)e);
        }
    }

    @Override
    public void evRelease(DlgcSdpPortManagerFSM fsm) {
        try {
            DlgcSdpPortManager portMgr = fsm.getResourceContainer().getSdpPortMgrResource();
            DlgcSipMessage message = new DlgcSipMessage((JoinableContainer)portMgr.getContainer(), "BYE", null, "none", null);
            portMgr.sendSipMessage(message);
            fsm.setState(fsm.getReleasingState());
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void evSipBye(DlgcFSM fsm, SipServletResponse response) throws MsControlException {
        DlgcSdpPortManager sdp = null;
        byte[] content = null;
        DlgcNetworkConnection nc = (DlgcNetworkConnection)((DlgcResourceContainerFSM)fsm).getResourceContainer();
        try {
            sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
        }
        catch (MsControlException ex) {
            log.error("Error getting Sdp Port Manager", (Throwable)ex);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            throw new SdpPortManagerException(ex.getMessage());
        }
        int sipStatus = response.getStatus();
        if (sipStatus >= 400 && sipStatus <= 599) {
            String SipStatusString = Integer.toString(sipStatus);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            DlgcSdpPortManagerStates.log.error("SIP Response return error: " + SipStatusString);
            String errMsg = "Fail to establish SIP Session...SIP error: " + SipStatusString;
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, errMsg, null);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
            String msg = "SIP Response return error: " + SipStatusString;
            throw new SdpPortManagerException(msg);
        }
        String byeUser = ((SipURI)response.getTo().getURI()).getUser();
        nc.stopSessionTimer();
        if (byeUser.equals("ivr")) {
            try {
                String[] confId = new String[1];
                boolean[] confirmed = new boolean[1];
                if (nc.isJoinedWithMixer(confId, confirmed)) {
                    this.connectToConference(fsm, ((DlgcSdpPortManagerFSM)fsm).getConfLegPendState());
                    return;
                }
                log.error("transition: semantics error: joined mixer is not confirmed");
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            }
            catch (MsControlException e) {
                log.error("Exception can not trasition to conference: ", (Throwable)e);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            }
        } else {
            log.warn("Receive ivr bye while in transition state: ");
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
        }
    }

    @Override
    public void evSipInvite(DlgcFSM fsm, SipServletResponse response) throws MsControlException {
        log.debug("JJJJJJJJJJJJJJJJ DlgcParkedState:: Entering CCCCCCCCCCCC");
        DlgcSdpPortManager sdp = null;
        DlgcNetworkConnection nc = (DlgcNetworkConnection)((DlgcResourceContainerFSM)fsm).getResourceContainer();
        try {
            sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
        }
        catch (MsControlException ex) {
            log.error("Error getting Sdp Port Manager", (Throwable)ex);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            throw new SdpPortManagerException(ex.getMessage());
        }
        String byeUser = ((SipURI)response.getTo().getURI()).getUser();
        String sipUserTestString = null;
        sipUserTestString = DlgcSipB2BUA.isMediaTypeXMS() ? "msml=" : "conf=";
        if (byeUser.contains(sipUserTestString)) {
            try {
                String[] confId = new String[1];
                boolean[] confirmed = new boolean[1];
                if (nc.isJoinedWithMixer(confId, confirmed)) {
                    String remoteSD = sdp.getUserAgentSessionDescription().toString();
                    sdp.sendSipMessage("ivr", "INVITE", "sdp", remoteSD);
                    fsm.setState(((DlgcSdpPortManagerFSM)fsm).getIvrLegPendingState());
                    return;
                }
                log.error("transition: semantics error: joined mixer is not confirmed");
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
            }
            catch (MsControlException e) {
                log.error("Exception can not trasition to ivr: ", (Throwable)e);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
            }
        } else {
            log.warn("Receive ivr conf= while in transition state: ");
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
        }
    }
}

