/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxyHelper;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynCallbackImpl;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynDispatcher;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerProxy;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import java.io.Serializable;
import java.net.URI;
import java.util.Iterator;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.JoinEventListener;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableStream;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManager;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.AllocationEventListener;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcNetworkConnectionProxy
extends DlgcProxy
implements NetworkConnection,
Serializable {
    private static final long serialVersionUID = 2101092873625L;
    private static Logger log = LoggerFactory.getLogger(DlgcNetworkConnectionProxy.class);

    public DlgcNetworkConnectionProxy(String id, String mediaSessionId, String msId) {
        super(id, mediaSessionId, msId);
    }

    public SdpPortManager getSdpPortManager() throws MsControlException {
        DlgcSdpPortManagerProxy pproxy = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String containerProxyId = this.getContainerProxyId();
            String mediaId = this.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxyId);
            DlgcSdpPortManager sdpMgr = (DlgcSdpPortManager)nc.getSdpPortManager();
            pproxy = sdpMgr.getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to create getSdpPortManager", (Throwable)e);
            throw new MsControlException("Failed to create getSdpPortManager", (Throwable)e);
        }
        return pproxy;
    }

    public JoinableStream getJoinableStream(JoinableStream.StreamType arg0) throws MsControlException {
        return DlgcProxyHelper.getJoinableStream(this, arg0);
    }

    public JoinableStream[] getJoinableStreams() throws MsControlException {
        return DlgcProxyHelper.getJoinableStreams(this);
    }

    public Joinable[] getJoinees() throws MsControlException {
        return DlgcProxyHelper.getJoinees(this);
    }

    public Joinable[] getJoinees(Joinable.Direction arg0) throws MsControlException {
        return DlgcProxyHelper.getJoinees(this, arg0);
    }

    public void join(Joinable.Direction arg0, Joinable arg1) throws MsControlException {
        log.debug("Entering DlgcNetworkConnectionProxy::join");
        if (arg1 == null) {
            log.debug("Entering DlgcNetworkConnectionProxy::join component value is null");
        } else {
            log.debug("Entering DlgcNetworkConnectionProxy::join component value is:" + arg1.toString());
        }
        DlgcProxyHelper.join(this, arg0, arg1);
    }

    public void joinInitiate(Joinable.Direction arg0, Joinable arg1, Serializable arg2) throws MsControlException {
        log.debug("DlgcNetworkConnectionProxy::joinInitiate(): MediaObjectF(msContainerProxyId): " + this.msContainerProxyId);
        log.debug("DlgcNetworkConnectionProxy::joinInitiate(): OBJID: " + this.toString());
        log.debug("DlgcNetworkConnectionProxy::joinInitiate(): PROXYID: " + this.getProxyId());
        DlgcProxyHelper.joinInitiate(this, arg0, arg1, arg2);
    }

    public void unjoin(Joinable arg0) throws MsControlException {
        DlgcProxyHelper.unjoin(this, arg0);
    }

    public void unjoinInitiate(Joinable arg0, Serializable arg1) throws MsControlException {
        DlgcProxyHelper.unjoinInitiate(this, arg0, arg1);
    }

    public void addListener(JoinEventListener arg0) {
        DlgcProxyHelper.addListener((DlgcProxy)this, arg0);
    }

    public MediaSession getMediaSession() {
        return DlgcProxyHelper.getMediaSession(this);
    }

    public void removeListener(JoinEventListener arg0) {
        DlgcProxyHelper.removeListener((DlgcProxy)this, arg0);
    }

    public void confirm() throws MsControlException {
        DlgcProxyHelper.confirm(this);
    }

    public MediaConfig getConfig() {
        return DlgcProxyHelper.getConfig(this);
    }

    public <R> R getResource(Class<R> arg0) throws MsControlException {
        return DlgcProxyHelper.getResource(this, arg0);
    }

    public void triggerAction(Action arg0) {
        DlgcProxyHelper.triggerAction(this, arg0);
    }

    public Parameters createParameters() {
        return DlgcProxyHelper.createParameters(this);
    }

    public Iterator<MediaObject> getMediaObjects() {
        return DlgcProxyHelper.getMediaObjects(this);
    }

    public <T extends MediaObject> Iterator<T> getMediaObjects(Class<T> arg0) {
        return DlgcProxyHelper.getMediaObjects(this, arg0);
    }

    public Parameters getParameters(Parameter[] arg0) {
        return DlgcProxyHelper.getParameters(this, arg0);
    }

    public URI getURI() {
        return DlgcProxyHelper.getURI(this);
    }

    public void release() {
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            log.debug("Entering DlgcNetworkConnectionProxy::release using Synchronous Release Method Task run() => Media Server");
            this.releaseAsync();
            log.debug("Leaving DlgcNetworkConnectionProxy::release using Synchronous Release Method Task run() => Media Server");
        } else {
            log.debug("Entering DlgcNetworkConnectionProxy::release using Asynchronous Release Method Task run() => Media Server");
            DlgcProxyHelper.release(this);
            log.debug("Leaving DlgcNetworkConnectionProxy::release using Asynchronous Release Method Task run() => Media Server");
        }
    }

    protected void releaseAsync() {
        final String mediaId = this.getMsObjectId();
        String sasId = this.getProxyId();
        String containerProxId = this.getContainerProxyId();
        DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
        final DlgcXNetworkConnection nc = (DlgcXNetworkConnection)session.getMediaObjectByProxyId(containerProxId);
        final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("Netework Connection:Release Request");
        try {
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering DlgcNetworkConnectionProxy::releaseAsync Task run() => Media Server");
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setMonitor(monitor);
                    session.setRequestTypeToProxy();
                    nc.release();
                    log.debug("Leaving DlgcNetworkConnectionProxy::releaseAsync Task run() => Media Server");
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to release Network Connection", (Throwable)e);
        }
        log.debug("SYNC_2_ASYNC DlgcNetworkConnectionProxy::release calling monitor.waitForRequestCompletion() ");
        monitor.waitForRequestCompletion();
        session.removeMediaObject(nc);
        log.debug("SYNC_2_ASYNC DlgcNetworkConnectionProxy::release returned from monitor.waitForRequestCompletion():  " + monitor.getStatusString());
    }

    public void setParameters(Parameters arg0) {
        DlgcProxyHelper.setParameters(this, arg0);
    }

    public void addListener(AllocationEventListener arg0) {
        DlgcProxyHelper.addListener((DlgcProxy)this, arg0);
    }

    public void removeListener(AllocationEventListener arg0) {
        DlgcProxyHelper.removeListener((DlgcProxy)this, arg0);
    }
}

