/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaConfig;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameter;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.asip.DlgcaSipSession;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapter;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXConferenceControlLeg;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnectionProxy;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMediaServer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventNotifier;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.JoinException;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.mixer.MixerAdapter;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpException;
import javax.media.mscontrol.networkconnection.SdpPortManager;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.media.mscontrol.resource.AllocationEvent;
import javax.media.mscontrol.resource.Resource;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.sip.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcNetworkConnection
extends DlgcJoinableContainer
implements NetworkConnection {
    private static final long serialVersionUID = 11L;
    protected DlgcIpmsSession dlgIpmsSession;
    private boolean cpaEnabled = false;
    protected RTP_SECURITY_E rtpSecurity = RTP_SECURITY_E.RTP;
    protected NAT_E nat = NAT_E.NONE;
    protected String sipReqUri;
    protected boolean webRtcExternallyEnabled = false;
    public Map<String, String> sipReqAttributeMap;
    protected Boolean toneClamping;
    protected JoinableStreamMode joinableStreamMode;
    protected Integer regionId;
    protected String regionName;
    protected Boolean freeRangeRegion;
    DlgcMixerAdapter myMixerAdapter;
    private static DlgcParameters supportedParameters;
    private static Logger log;
    DlgcXConferenceControlLeg mixControlLeg = null;

    public RTP_SECURITY_E getRtpSecurity() {
        return this.rtpSecurity;
    }

    public void setRtpSecurity(RTP_SECURITY_E rtpSecurity) {
        this.rtpSecurity = rtpSecurity;
    }

    public NAT_E getNat() {
        return this.nat;
    }

    public void setNat(NAT_E nat) {
        this.nat = nat;
    }

    public boolean isCpaEnabled() {
        return this.cpaEnabled;
    }

    public DlgcNetworkConnection(MediaConfig cfg, MediaSession ms, Parameters params) {
        super(ms, "NC-");
        this.buildUri(this.getClass().getName());
        this.joinMasterPriority = 2;
        this.dlgIpmsSession = null;
        this.myMixerAdapter = null;
        this.sipReqUri = null;
        this.toneClamping = false;
        this.regionId = 0;
        this.regionName = null;
        this.freeRangeRegion = true;
        this.joinableStreamMode = JoinableStreamMode.AUDIO_VIDEO;
        this.mixControlLeg = null;
        this.initNetworkConnectionResourceTypes(cfg, ms, params);
    }

    protected void initNetworkConnectionResourceTypes(MediaConfig cfg, MediaSession ms, Parameters params) {
        Iterator<Class<?>> iter = ((DlgcMediaConfig)cfg).getResourceList();
        while (iter.hasNext()) {
            try {
                Class<?> resourceClass = iter.next();
                Constructor<?> ctr = resourceClass.getConstructor(NetworkConnection.class);
                Resource resource = (Resource)ctr.newInstance(this);
                this.resourceMap.put(resourceClass, resource);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
                log.error(appLogId + "InvocationTargetException cause by " + cause.getMessage());
                e.printStackTrace();
            }
        }
        this.setDefaultParameters(this.getDefaultParameters());
        if (params != null) {
            this.setParameters(params);
        }
    }

    public DlgcNetworkConnection(MediaConfig cfg, MediaSession ms, Parameters params, String prefix) {
        super(ms, prefix);
        String mediaObjectId = null;
        if (null != params && !params.isEmpty()) {
            Set paramSet = params.entrySet();
            Iterator paramIt = paramSet.iterator();
            Map.Entry pair = null;
            while (paramIt.hasNext()) {
                pair = (Map.Entry)paramIt.next();
                if (!((Parameter)pair.getKey()).toString().equalsIgnoreCase("MEDIAOBJECT_ID")) continue;
                mediaObjectId = pair.getValue().toString();
            }
        }
        if (null != mediaObjectId) {
            String mId = this.mediaObjectID;
            this.mediaObjectID = this.mediaObjectID + mediaObjectId;
        }
        this.buildUri(this.getClass().getName());
        this.dlgIpmsSession = null;
        this.joinMasterPriority = 2;
        this.myMixerAdapter = null;
        this.regionId = 0;
        this.regionName = null;
        this.freeRangeRegion = true;
        this.joinableStreamMode = JoinableStreamMode.AUDIO_VIDEO;
    }

    public DlgcIpmsSession getDlgIpmsSession() {
        return this.dlgIpmsSession;
    }

    public void setDlgIpmsSession(DlgcIpmsSession dlgIpmsSession) {
        this.dlgIpmsSession = dlgIpmsSession;
    }

    public void removeDlgcSession() {
        this.dlgIpmsSession = null;
    }

    public Parameters getDefaultParameters() {
        DlgcParameters parameters = new DlgcParameters();
        for (Parameter param : supportedParameters.keySet()) {
            parameters.put(param, ((DlgcParameter)supportedParameters.get(param)).getValue());
        }
        return parameters;
    }

    public SdpPortManager getSdpPortManager() throws MsControlException {
        return this.getResource(DlgcSdpPortManager.class);
    }

    @Override
    public void join(Joinable.Direction direction, Joinable joinee) throws MsControlException {
        boolean bTrace = DlgcInstrumentPropertyMgr.bTraceJoin;
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        if (bTrace) {
            log.debug(appLogId + "Entering DlgcNetworkConnection:: join(Direction, Joinee)");
        }
        if (joinee instanceof MixerAdapter) {
            DlgcMediaMixer mxj;
            if (bTrace) {
                log.debug(appLogId + "Passed in Joinee is instanceOf MixerAdapter => NC Join MXA");
            }
            if (this.isNewJoinee(mxj = ((DlgcMixerAdapter)joinee).getMixer())) {
                if (bTrace) {
                    log.debug(appLogId + "New Entry in NC joinee table... setting DTMFCLAMP to YES");
                }
                this.myMixerAdapter = (DlgcMixerAdapter)joinee;
                if (bTrace) {
                    log.debug(appLogId + "calling super.join(direction,mx) ");
                    log.debug(appLogId + "direction = " + direction.name());
                }
                super.join(direction, (Joinable)mxj);
                if (bTrace) {
                    log.debug(appLogId + "Calling evJoin(direction, mx, mxa)");
                }
                ((DlgcSdpPortManagerFSM)this.myFSM).evJoin(direction, (Joinable)mxj, (MixerAdapter)joinee);
            }
        } else if (joinee instanceof MediaMixer) {
            if (bTrace) {
                log.debug(appLogId + "Passed in Joinee is instanceOf MediaMixer NC Join MX");
            }
            if (this.isNewJoinee((JoinableContainer)joinee)) {
                if (bTrace) {
                    log.debug(appLogId + "New Entry in NC joinee table");
                }
                if (bTrace) {
                    log.debug(appLogId + "calling super.join(direction,mx) ");
                    log.debug(appLogId + "direction = " + direction.name());
                }
                super.join(direction, joinee);
                if (bTrace) {
                    log.debug(appLogId + "Calling evJoin(direction, mx, mxa=null)");
                }
                ((DlgcSdpPortManagerFSM)this.myFSM).evJoin(direction, joinee, null);
            }
        } else {
            if (bTrace) {
                log.debug(appLogId + "Neither Mixer nor MixerAdapter calling super.join(direction,joinee) ");
                log.debug(appLogId + "direction = " + direction.name());
            }
            super.join(direction, joinee);
        }
    }

    @Override
    public void joinNotify(Joinable.Direction direction, Joinable joinee) throws MsControlException {
        if (joinee instanceof MixerAdapter) {
            DlgcMediaMixer mxj = ((DlgcMixerAdapter)joinee).getMixer();
            if (this.isNewJoinee(mxj)) {
                this.myMixerAdapter = (DlgcMixerAdapter)joinee;
                super.joinNotify(direction, (Joinable)mxj);
                ((DlgcSdpPortManagerFSM)this.myFSM).evJoin(direction, (Joinable)mxj, (MixerAdapter)joinee);
            }
        } else if (joinee instanceof MediaMixer) {
            if (this.isNewJoinee((JoinableContainer)joinee)) {
                super.joinNotify(direction, joinee);
                ((DlgcSdpPortManagerFSM)this.myFSM).evJoin(direction, joinee, null);
            }
        } else {
            super.joinNotify(direction, joinee);
        }
    }

    @Override
    public void unjoin(Joinable joinee) throws MsControlException {
        Object j = joinee;
        if (joinee instanceof MixerAdapter) {
            j = ((DlgcMixerAdapter)joinee).getMixer();
            this.myMixerAdapter = null;
            if (DlgcSipB2BUA.isMediaTypeIPMS()) {
                this.park();
            } else {
                this.unjoinFromConference();
            }
        } else if (joinee instanceof MediaMixer) {
            if (DlgcSipB2BUA.isMediaTypeIPMS()) {
                this.park();
            } else {
                this.unjoinFromConference();
            }
        }
        super.unjoin((Joinable)j);
    }

    @Override
    public void unjoinNotify(Joinable joinee) throws MsControlException {
        Object j = joinee;
        if (joinee instanceof MixerAdapter) {
            j = ((DlgcMixerAdapter)joinee).getMixer();
            this.park();
            this.myMixerAdapter = null;
        } else if (joinee instanceof MediaMixer) {
            this.park();
        }
        super.unjoin((Joinable)j);
    }

    public void park() {
        ((DlgcSdpPortManagerFSM)this.myFSM).evPark();
    }

    public void unjoinFromConference() {
        try {
            DlgcSdpPortManagerFSM.DlgcFSMAssociatedComponents c = DlgcSdpPortManagerFSM.getAssociatedComponents((DlgcSdpPortManagerFSM)this.myFSM, "DlgcNetworkConnection:  unjoinFromConference");
            DlgcXMediaMixer mx = (DlgcXMediaMixer)c.mx;
            ((DlgcSdpPortManagerFSM)this.myFSM).evOnUnjoin();
        }
        catch (SdpException e) {
            e.printStackTrace();
        }
        catch (SdpPortManagerException e) {
            e.printStackTrace();
        }
    }

    public void unpark() {
        ((DlgcSdpPortManagerFSM)this.myFSM).evUnpark();
    }

    @Override
    public void processSipBye(SipServletRequest request) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "==> Entering DlgcNetworkConnection: processSipBye SipServletRequest");
        this.getFSM().setState(DlgcSdpPortManagerStates.createdState);
        if (!this.released) {
            super.processSipBye(request);
            try {
                DlgcSdpPortManager sdp = (DlgcSdpPortManager)this.getSdpPortManager();
                sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, null, SdpPortManagerEvent.RESOURCE_UNAVAILABLE, "Media Server Disconnected Stream", SdpPortManagerEvent.STOPPED);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        } else {
            super.processSipBye(request);
        }
        log.debug(appLogId + "==> Leaving DlgcNetworkConnection: processSipBye SipServletRequest");
    }

    @Override
    public void processSipBye(SipServletResponse response) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "==> Entering DlgcNetworkConnection: processSipBye SipServletResponse");
        try {
            ((DlgcSdpPortManagerFSM)this.myFSM).evSipBye(response);
        }
        catch (MsControlException e) {
            log.error(appLogId + "Exception thrown by processSipBye: ", (Throwable)e);
        }
        log.debug(appLogId + "==> Leaving DlgcNetworkConnection: processSipBye SipServletRequest");
    }

    @Override
    public void processSipInvite(SipServletRequest request) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "==> Entering DlgcNetworkConnection: processSipInvite SipServletRequest");
        ((DlgcSdpPortManagerFSM)this.myFSM).evSipInvite(request);
        log.debug(appLogId + "==> Leaving DlgcNetworkConnection: processSipInvite SipServletRequest");
    }

    @Override
    public void processSipUpdate(SipServletRequest request) {
        log.debug("Entering DlgcNetworkConnection: processSipUpdate SipServletRequest: " + request.toString());
        ((DlgcSdpPortManagerFSM)this.myFSM).evSipUpdate(request);
        log.debug("Leaving DlgcNetworkConnection: processSipUpdate SipServletRequest");
    }

    public void processSipInvite(Response response, DlgcaSipSession session) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        try {
            log.debug(appLogId + "==> Entering DlgcNetworkConnection: processSipInvite Standalone Invite Response from XMS");
            ((DlgcSdpPortManagerFSM)this.myFSM).evSipInvite(response, session);
        }
        catch (MsControlException e) {
            log.error(appLogId + "Exception thrown by evSipInvite: ", (Throwable)e);
        }
        log.debug(appLogId + "==> Leaving DlgcNetworkConnection: processSipInvite Standalone Invite Response from XMS");
    }

    @Override
    public void processSipInvite(SipServletResponse response) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        try {
            log.debug(appLogId + "==> Entering DlgcNetworkConnection: processSipInvite SipServletResponse");
            ((DlgcSdpPortManagerFSM)this.myFSM).evSipInvite(response);
        }
        catch (MsControlException e) {
            log.error(appLogId + "Exception thrown by evSipInvite: ", (Throwable)e);
        }
        log.debug(appLogId + "==> Leaving DlgcNetworkConnection: processSipInvite SipServletResponse");
    }

    @Override
    public void processSipInfo(SipServletResponse response, DlgcSipConnectorContentIdsProxy proxy) {
    }

    public String getPresentState() {
        return this.getFSM().getPresentStateName();
    }

    @Override
    public void processTimeout(ServletTimer timer) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "Enter CONNECTOR SIP SESSION TIMER DlgcNetworkConnection::processTimeout");
        if (!this.released) {
            log.debug(appLogId + "DlgcNetworkConnection::processTimeout calling sendSipMessage to IPMS with bye");
            this.sendSipMessage(new DlgcSipMessage(this, "BYE", null, "none", null));
            this.getFSM().setState(DlgcSdpPortManagerStates.releasingState);
            log.debug(appLogId + "DlgcNetworkConnection::processTimeout sending IRRECOVERABLE_FAILUER Event to the APPLICATION");
            this.postAllocationEvent(AllocationEvent.IRRECOVERABLE_FAILURE);
            try {
                DlgcSdpPortManager sdp = (DlgcSdpPortManager)this.getSdpPortManager();
                log.debug(appLogId + "DlgcNetworkConnection::processTimeout also sending ETWORK_STREAM_FAILURE Event to the APPLICATION");
                sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, null, SdpPortManagerEvent.RESOURCE_UNAVAILABLE, "Media Server Not Responding", SdpPortManagerEvent.NO_QUALIFIER);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void release() {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.info(appLogId + " *15 JSR309 API REQUEST:NetworkConnection release(): NC MEDIA OBJID: " + this.getMediaObject() + " NC ID String: " + this.toString());
        DlgcMediaServer mediaServer = ((DlgcMediaSession)this.getMediaSession()).getMediaServer();
        if (mediaServer != null) {
            log.debug("DlgcMediaObject::release(): calling removeAssociatedComponent() on: " + this.getMediaObject());
            mediaServer.removeAssociatedComponent(this);
        }
        super.release();
        ((DlgcSdpPortManagerFSM)this.myFSM).evRelease();
        log.debug(appLogId + "Leaving DlgcNetworkConnection: release network connection");
    }

    @Override
    public JoinableContainer getMasterJoinable() {
        return this;
    }

    public JoinableContainer getPrimaryJoinee() {
        DlgcJoinableContainer primaryJoinee = null;
        try {
            Joinable[] joinees;
            for (Joinable joinee : joinees = this.getJoinees()) {
                if (primaryJoinee == null) {
                    primaryJoinee = (DlgcJoinableContainer)joinee;
                    continue;
                }
                if (primaryJoinee.getJoinMasterPriority() <= ((DlgcJoinableContainer)joinee).getJoinMasterPriority()) continue;
                primaryJoinee = (DlgcJoinableContainer)joinee;
            }
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
        return primaryJoinee;
    }

    public DlgcMediaMixer getMixerIfJoined() {
        try {
            Joinable[] joinees;
            for (Joinable joinee : joinees = this.getJoinees()) {
                if (joinee instanceof DlgcMixerAdapter) {
                    DlgcMediaMixer mxj = ((DlgcMixerAdapter)joinee).getMixer();
                    return mxj;
                }
                if (!(joinee instanceof DlgcMediaMixer)) continue;
                return (DlgcMediaMixer)joinee;
            }
        }
        catch (JoinException e) {
            log.warn("\n " + "JoinException thrown in isJoinedWithMixer()");
            return null;
        }
        catch (MsControlException ms) {
            return null;
        }
        return null;
    }

    public boolean isJoinedWithMixer(String[] confId, boolean[] confirmed) {
        this.proxyId = this.getURI().toString();
        try {
            Joinable[] joinees;
            for (Joinable joinee : joinees = this.getJoinees()) {
                if (joinee instanceof DlgcMixerAdapter) {
                    DlgcMediaMixer mxj = ((DlgcMixerAdapter)joinee).getMixer();
                    confId[0] = mxj.getConfId();
                    confirmed[0] = mxj.mixerInReadyState();
                    return true;
                }
                if (!(joinee instanceof DlgcMediaMixer)) continue;
                confId[0] = ((DlgcMediaMixer)joinee).getConfId();
                confirmed[0] = ((DlgcMediaMixer)joinee).mixerInReadyState();
                return true;
            }
        }
        catch (JoinException e) {
            log.warn("\n " + "JoinException thrown in isJoinedWithMixer()");
            return false;
        }
        catch (MsControlException ms) {
            return false;
        }
        return false;
    }

    public static DlgcParameters loadSupportedParameters() {
        return supportedParameters;
    }

    public boolean sendMediaMessage(DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
        ((DlgcSdpPortManagerFSM)this.myFSM).sendMediaMessage(message, notifier);
        return false;
    }

    @Override
    public DlgcProxy getProxy() {
        DlgcMediaSession ms = (DlgcMediaSession)this.getMediaSession();
        String sasId = ms.getProxyId();
        String containerProxyId = this.getProxyId();
        String msObjId = ms.getMediaObject();
        return new DlgcNetworkConnectionProxy(sasId, containerProxyId, msObjId);
    }

    @Override
    public String toDebug() {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        String retStr = new String();
        retStr = retStr + appLogId + "\n $$$$$$ JMC Object DlgcNetworkConnection = " + " \n";
        retStr = retStr + "Debug ID = " + this.debugId.toString() + " \n";
        retStr = retStr + "$$$$$$";
        return retStr;
    }

    public void setMixerAdapter(DlgcMixerAdapter ma) {
        this.myMixerAdapter = ma;
    }

    public DlgcMixerAdapter getMixerAdapter() {
        return this.myMixerAdapter;
    }

    @Override
    public void setParameters(Parameters params) {
        for (Parameter paramKey : params.keySet()) {
            if (!this.parameters.containsKey(paramKey)) continue;
            this.parameters.put(paramKey, params.get((Object)paramKey));
            if (null == params.get((Object)paramKey) || !(params.get((Object)paramKey) instanceof HashMap)) continue;
            HashMap ncValues = (HashMap)params.get((Object)paramKey);
            Iterator keyIt = ncValues.keySet().iterator();
            if (this.sipReqAttributeMap == null) {
                this.sipReqAttributeMap = new HashMap<String, String>();
            }
            while (keyIt.hasNext()) {
                String actualVal;
                String ncKeyVal = (String)keyIt.next();
                String val = (String)ncValues.get(ncKeyVal);
                if (ncKeyVal.compareToIgnoreCase("webrtc") == 0) {
                    actualVal = (String)ncValues.get(ncKeyVal);
                    this.webRtcExternallyEnabled = actualVal.contentEquals("yes");
                    log.debug("webRtcExternallyEnabled = " + actualVal);
                } else if (ncKeyVal.compareToIgnoreCase("cpa") == 0) {
                    actualVal = (String)ncValues.get(ncKeyVal);
                    this.cpaEnabled = actualVal.contentEquals("yes");
                    log.debug("cpaEnabled = " + actualVal);
                } else if (ncKeyVal.compareToIgnoreCase("RTP-SECURITY") == 0) {
                    actualVal = (String)ncValues.get(ncKeyVal);
                    this.rtpSecurity = actualVal.contentEquals("SDES") ? RTP_SECURITY_E.SDES : (actualVal.contentEquals("DTLS") ? RTP_SECURITY_E.DTLS : (actualVal.contentEquals("RTP") ? RTP_SECURITY_E.RTP : RTP_SECURITY_E.RTP));
                    log.debug("RTP-SECURITY = " + actualVal);
                } else if (ncKeyVal.compareToIgnoreCase("NAT") == 0) {
                    actualVal = (String)ncValues.get(ncKeyVal);
                    if (actualVal.contentEquals("ICE")) {
                        this.nat = NAT_E.ICE;
                    } else if (actualVal.contentEquals("STUN")) {
                        this.nat = NAT_E.NONE;
                        log.warn("STUN MODE NOT SUPPORTED ignoring STUN configuration request");
                    } else {
                        this.nat = NAT_E.NONE;
                    }
                    log.debug("NAT = " + actualVal);
                } else {
                    this.sipReqAttributeMap.put(ncKeyVal, val);
                    log.debug("sipReqUriAttributes key: " + ncKeyVal + " attribute value: " + val);
                    this.sipReqUri = val;
                    log.debug("Setting SIP Username: " + this.sipReqUri);
                }
                if (ncKeyVal.compareToIgnoreCase("TONE_CLAMPING") == 0) {
                    actualVal = (String)ncValues.get(ncKeyVal);
                    this.toneClamping = new Boolean(actualVal);
                    log.debug("toneClamping = " + this.toneClamping);
                }
                if (this.nat != NAT_E.ICE || this.rtpSecurity != RTP_SECURITY_E.DTLS && this.rtpSecurity != RTP_SECURITY_E.SDES) continue;
                log.debug("Forcing webrtc flag to yes since NAT is set to ICE and rtpSecurity is set to either DTLS or SDES");
                this.webRtcExternallyEnabled = true;
            }
        }
    }

    public Boolean isFreeRangeRegion() {
        return this.freeRangeRegion;
    }

    public void setFreeRangeRegion(Boolean bFree) {
        this.freeRangeRegion = bFree;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String name) {
        this.regionName = name;
    }

    public Integer getRegionId() {
        return this.regionId;
    }

    public void setRegionId(Integer Id) {
        this.regionId = Id;
    }

    public String getSipReqUri() {
        return this.sipReqUri;
    }

    public Boolean getToneClamping() {
        return this.toneClamping;
    }

    public JoinableStreamMode getJoinableStreamMode() {
        return this.joinableStreamMode;
    }

    public void setJoinableStreamMode(JoinableStreamMode mode) {
        this.joinableStreamMode = mode;
    }

    public void resetJoinableStreamMode() {
        this.joinableStreamMode = JoinableStreamMode.AUDIO_VIDEO;
    }

    public DlgcMediaMixer getMixerControlLeg() {
        if (this.mixControlLeg == null) {
            return null;
        }
        return this.mixControlLeg.getMyMixer();
    }

    public void setMixerControlLeg(DlgcXConferenceControlLeg ctl) {
        this.mixControlLeg = ctl;
    }

    static {
        log = LoggerFactory.getLogger(DlgcNetworkConnection.class);
        supportedParameters = new DlgcParameters();
        supportedParameters.putAll(DlgcSdpPortManager.loadSupportedParameters());
    }

    public static enum NAT_E {
        NONE,
        STUN,
        ICE;

    }

    public static enum RTP_SECURITY_E {
        RTP,
        DTLS,
        SDES;

    }

    public static enum JoinableStreamMode {
        AUDIO,
        VIDEO,
        AUDIO_VIDEO;

    }
}

