/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import java.util.Queue;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventNotifier;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.JoinEvent;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.servlet.sip.SipServletRequest;

class DlgcModifyingLegState
extends DlgcSdpPortManagerStates {
    public DlgcModifyingLegState() {
        this.stateName = "DlgcModifyingLegState";
    }

    @Override
    public void evRelease(DlgcSdpPortManagerFSM fsm) {
        try {
            DlgcSdpPortManager portMgr = fsm.getResourceContainer().getSdpPortMgrResource();
            DlgcSipMessage message = new DlgcSipMessage((JoinableContainer)portMgr.getContainer(), "BYE", null, "none", null);
            portMgr.sendSipMessage(message);
            fsm.setState(fsm.getReleasingState());
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void evSipInfo(DlgcFSM fsm, MsmlDocument.Msml msmlMsg) throws MsControlException {
        DlgcSdpPortManager sdp = null;
        byte[] content = null;
        try {
            sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
        }
        catch (MsControlException e) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Error getting Sdp Port Manager while in DlgcModifyingLegState::evSipInfo Msml method.", (Throwable)e);
            throw new SdpPortManagerException(e.getMessage());
        }
        String resultResponse = msmlMsg.getResult().getResponse();
        Integer iResult = new Integer(resultResponse);
        log.debug("CXMS - DlgcModifyingLegState:evSipInfo GOT Msml Result of: " + iResult.toString());
        DlgcNetworkConnection nc = (DlgcNetworkConnection)sdp.getContainer();
        DlgcSync2AsyncMonitor monitor = nc.getMonitor();
        if (iResult > 200) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            if (monitor == null) {
                DlgcSdpPortManagerStates.log.error("SIP Response return error: " + resultResponse);
                String errMsg = "Fail to establish SIP Session...SIP error: " + resultResponse;
                sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, errMsg, null);
                String msg = "SIP Response return error: " + resultResponse;
                throw new SdpPortManagerException(msg);
            }
            boolean bStatus = false;
            String sStatus = "Join Unsuccessfully";
            log.debug("SYNC_2_ASYNC DlgcModifyingLegState::evSipInfo -  calling Monitor notifyRequestCompleted");
            monitor.notifyRequestCompleted(bStatus, sStatus);
            log.debug("SYNC_2_ASYNC DlgcModifyingLegState::evSipInfo -  returned from Monitor notifyRequestCompleted");
        } else {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getConfLegRdy());
            if (monitor == null) {
                sdp.sendApplicationEvent(JoinEvent.JOINED, null, MediaErr.NO_ERROR, "Join Direction Success", null);
            } else {
                boolean bStatus = true;
                String sStatus = "Join Succesfully";
                log.debug("SYNC_2_ASYNC DlgcModifyingLegState::evSipInfo -  calling Monitor notifyRequestCompleted");
                monitor.notifyRequestCompleted(bStatus, sStatus);
                log.debug("SYNC_2_ASYNC DlgcModifyingLegState::evSipInfo -  returned from Monitor notifyRequestCompleted");
            }
        }
    }

    @Override
    public void evPark(DlgcSdpPortManagerFSM fsm) {
        try {
            Joinable[] joinees;
            DlgcSdpPortManager sdp = fsm.getResourceContainer().getSdpPortMgrResource();
            for (Joinable j : joinees = ((NetworkConnection)sdp.getContainer()).getJoinees()) {
                if (!(j instanceof MediaMixer)) continue;
                DlgcMediaMixer mx = (DlgcMediaMixer)j;
                Queue<DlgcSdpPortManager.DlgcMediaMixerMessage> queue = sdp.mediaMixerMessageQueue;
                DlgcSdpPortManager dlgcSdpPortManager = sdp;
                dlgcSdpPortManager.getClass();
                queue.add(new DlgcSdpPortManager.DlgcMediaMixerMessage(dlgcSdpPortManager, mx, "PARK"));
            }
        }
        catch (MsControlException e) {
            log.error("Error to park", (Throwable)e);
        }
    }

    @Override
    public void evUnpark(DlgcSdpPortManagerFSM fsm) {
        try {
            Joinable[] joinees;
            DlgcSdpPortManager sdp = fsm.getResourceContainer().getSdpPortMgrResource();
            for (Joinable j : joinees = ((NetworkConnection)sdp.getContainer()).getJoinees()) {
                if (!(j instanceof MediaMixer)) continue;
                DlgcMediaMixer mx = (DlgcMediaMixer)j;
                Queue<DlgcSdpPortManager.DlgcMediaMixerMessage> queue = sdp.mediaMixerMessageQueue;
                DlgcSdpPortManager dlgcSdpPortManager = sdp;
                dlgcSdpPortManager.getClass();
                queue.add(new DlgcSdpPortManager.DlgcMediaMixerMessage(dlgcSdpPortManager, mx, "UNPARK"));
            }
        }
        catch (MsControlException e) {
            log.error("Error to park", (Throwable)e);
        }
    }

    @Override
    public void sendMediaMessage(DlgcSdpPortManagerFSM fsm, DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
        try {
            DlgcSdpPortManager portMgr = fsm.getResourceContainer().getSdpPortMgrResource();
            Queue<DlgcSdpPortManager.DlgcMediaMessage> queue = portMgr.messageQueue;
            DlgcSdpPortManager dlgcSdpPortManager = portMgr;
            dlgcSdpPortManager.getClass();
            queue.add(new DlgcSdpPortManager.DlgcMediaMessage(dlgcSdpPortManager, message, notifier));
            fsm.evPark();
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void evSipInvite(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        log.debug(" Entering DlgcModifyingLegState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
        DlgcModifyingLegState.evSipInviteSipTimerSendOK(fsm, request);
        log.debug(" Returning DlgcModifyingLegState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
    }
}

