/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManagerStates;
import java.io.IOException;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.networkconnection.SdpException;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;

class DlgcLegCreateJoinConfPendState
extends DlgcXSdpPortManagerStates {
    private static final long serialVersionUID = 7001555540299741337L;

    public DlgcLegCreateJoinConfPendState() {
        this.stateName = "DlgcLegCreateJoinConfPendState";
    }

    @Override
    public void evSipInvite(DlgcFSM fsm, SipServletResponse response) throws MsControlException {
        log.debug("STATE [DlgcLegCreateJoinConfPendState] EVENT =>  evSipInvite response");
        byte[] content = null;
        DlgcSdpPortManagerFSM.DlgcFSMAssociatedComponents c = DlgcSdpPortManagerFSM.getAssociatedComponents((DlgcSdpPortManagerFSM)fsm, "DlgcXConfLegRdyState class");
        DlgcXSdpPortManager sdp = (DlgcXSdpPortManager)c.sdp;
        DlgcXNetworkConnection nc = (DlgcXNetworkConnection)c.nc;
        DlgcXMediaMixer mx = (DlgcXMediaMixer)c.mx;
        try {
            int sipStatus = response.getStatus();
            content = response.getRawContent();
            if (sipStatus == 180) {
                log.debug("DlgcXSdpPortManagerState::DlgcXLegCreateJoinConfPendState->evSipInvite() - ignoring Ringing");
                return;
            }
            if (sipStatus >= 400 && sipStatus <= 599) {
                String SipStatusString = Integer.toString(sipStatus);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
                DlgcSdpPortManagerStates.log.error("SIP Response return error: " + SipStatusString);
                String errMsg = "Fail to establish SIP Session...SIP error: " + SipStatusString;
                sdp.sendApplicationEvent(SdpPortManagerEvent.ANSWER_GENERATED, content, SdpPortManagerEvent.RESOURCE_UNAVAILABLE, errMsg, null);
                log.debug(" DlgcXLegCreateJoinConfPendState::evSipInvite SipStatus Error =  " + errMsg);
            } else {
                sdp.setLocalSessionDescription(content);
                sdp.setMSSessionDesc(content);
                DlgcSdpPortManager.EARLY_MEDIA_TYPE emFlag = sdp.getEM();
                if (emFlag.compareTo(DlgcSdpPortManager.EARLY_MEDIA_TYPE.PRE_EM) == 0) {
                    log.debug("STATE [DlgcLegCreateJoinConfPendState] EVENT =>  evSipInvite response - Handling Early Media");
                    SipSession ss = response.getSession();
                    ss.setAttribute("OFFER_GENERATED_RESPONSE", (Object)response);
                } else {
                    log.debug("STATE [DlgcLegCreateJoinConfPendState] EVENT =>  evSipInvite response - Handling NON Early Media");
                    SipServletRequest ackRequest = response.createAck();
                    ackRequest.send();
                }
                sdp.processSipInvite(response);
                log.debug("STATE [DlgcLegCreateJoinConfPendState] EVENT =>  evSipInvite response... ack send back to XMS for the 200 OK");
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getIvrLegRdyState());
                if (mx != null) {
                    fsm.setState(DlgcXSdpPortManagerStates.xjoinConfCNCLPendingState);
                    log.debug("STATE [DlgcLegCreateJoinConfPendState] EVENT =>  evSipInvite response... adding this leg to the conf control list");
                    mx.addNewControlLegToList(nc);
                    log.debug("STATE [DlgcLegCreateJoinConfPendState] EVENT =>  evSipInvite response... joining leg to conference by calling joinToConferenceUsingNonControlLeg()");
                    mx.joinToConferenceUsingNonControlLeg(sdp);
                } else {
                    fsm.setState(DlgcXSdpPortManagerStates.xivrLegRdyState);
                    String msg = "Notice State mode that is to create a non control leg conference; however, NC not joined with Mixer; defaulting to LEG IVR Mode";
                    log.warn(msg);
                }
                sdp.sendApplicationEvent(SdpPortManagerEvent.ANSWER_GENERATED, content, null, null, null);
            }
        }
        catch (IOException e) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error(e.toString());
        }
    }

    @Override
    public void evRelease(DlgcSdpPortManagerFSM fsm) {
        log.debug("STATE [DlgcLegCreateJoinConfPendState] EVENT =>  evRelease");
        log.debug("Calling DlgcXSdpPortManagerState::DlgcLegCreateJoinConfPendState::evRelease call checkForConferenceAndRelease");
        this.checkForConferenceAndRelease(fsm);
    }

    @Override
    public void evSdpOffer(DlgcFSM fsm, String remoteSD) throws SdpException, SdpPortManagerException {
        log.debug("STATE [DlgcLegCreateJoinConfPendState] EVENT =>  evSdpOffer (HANDLING REINVITE REQUEST) supported in this state");
        this.helperConnectLeg(fsm, remoteSD, xreinvitePendingState, true);
    }
}

