/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.mixer.MixerAdapter;
import javax.media.mscontrol.networkconnection.SdpException;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import javax.servlet.sip.SipServletRequest;

class DlgcIvrRdyState
extends DlgcSdpPortManagerStates {
    public DlgcIvrRdyState() {
        this.stateName = "DlgcIvrRdyState";
    }

    @Override
    public void evJoin(DlgcFSM fsm, Joinable.Direction direction, Joinable joinee, MixerAdapter mxa) {
        if (joinee instanceof MediaMixer) {
            DlgcSdpPortManagerFSM sdppm_fsm = (DlgcSdpPortManagerFSM)fsm;
            DlgcNetworkConnection nc = (DlgcNetworkConnection)sdppm_fsm.getResourceContainer();
            DlgcMediaSession ms = (DlgcMediaSession)nc.getMediaSession();
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getConfTransitionState());
            try {
                this.connectToConference((DlgcMediaMixer)joinee, fsm, ((DlgcSdpPortManagerFSM)fsm).getConfTransitionState(), nc.getMixerAdapter());
            }
            catch (SdpException e) {
                e.printStackTrace();
            }
            catch (SdpPortManagerException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void evOnUnjoin(DlgcFSM fsm) throws SdpException, SdpPortManagerException {
        try {
            DlgcSdpPortManager portMgr = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
            portMgr.sendSipMessage(null, "BYE", "none", null);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
        }
        catch (MsControlException e) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Exeption found in evOnUnjoin event on state DlgcIverRdyState: ", (Throwable)e);
        }
    }

    @Override
    public void evSdpOffer(DlgcFSM fsm, String remoteSD) throws SdpException, SdpPortManagerException {
        block11: {
            try {
                DlgcSdpPortManager portMgr = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
                DlgcNetworkConnection nc = (DlgcNetworkConnection)((DlgcResourceContainerFSM)fsm).getResourceContainer();
                SessionDescription providedRemoteSdp = null;
                log.debug("DlgcIvrRdyState:: evSdpOffer with remoteSD ");
                try {
                    if (nc.getJoinees().length == 0) {
                        String errMsg = "Modify not allowed with no joinees";
                        log.error(errMsg);
                        throw new SdpPortManagerException(errMsg);
                    }
                }
                catch (MsControlException ex) {
                    fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                    log.error("Error getting Sdp Port Manager", (Throwable)ex);
                    return;
                }
                try {
                    providedRemoteSdp = sdpFactory.createSessionDescription(remoteSD);
                    portMgr.setRemoteSessionDescription(providedRemoteSdp);
                    portMgr.setUASessionDesc(remoteSD.getBytes());
                }
                catch (SdpParseException spe) {
                    fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                    log.error("Exception generated: Provided remote Session Description cannot be used: ", (Throwable)spe);
                    throw new SdpException("Provided remote Session Description cannot be used", (Throwable)spe);
                }
                try {
                    String[] confId = new String[1];
                    boolean[] confirmed = new boolean[1];
                    if (!nc.isJoinedWithMixer(confId, confirmed)) {
                        portMgr.sendSipMessage("ivr", "INVITE", "sdp", remoteSD);
                        fsm.setState(((DlgcSdpPortManagerFSM)fsm).getIvrLegPendingState());
                        break block11;
                    }
                    if (confirmed[0]) {
                        portMgr.sendSipMessage(null, "BYE", "none", null);
                        fsm.setState(((DlgcSdpPortManagerFSM)fsm).getParkTransitionState());
                        break block11;
                    }
                    String msg = "Mixer resource is not confirmed";
                    log.error(msg);
                    throw new SdpPortManagerException(msg);
                }
                catch (MsControlException e) {
                    fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                    log.error("Exception generated by sendSIPMsg call while trying to send a modify request - Cannot modify NetworkConnection:", (Throwable)e);
                    throw new SdpPortManagerException("Cannot modify NetworkConnection: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (MsControlException e) {
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                log.error("Error getting Sdp Port Manager Resource object from NetworkConnection Resource Container", (Throwable)e);
                throw new SdpPortManagerException("Error getting Sdp Port Manager Resource object from NetworkConnection Resource Container " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void evConnectToConference(DlgcFSM fsm, String confId) throws SdpException, SdpPortManagerException {
        this.connectToConference(fsm, ((DlgcSdpPortManagerFSM)fsm).getConfLegPendState());
    }

    @Override
    public void evRelease(DlgcSdpPortManagerFSM fsm) {
        log.debug("DlgcIvrRdyState:: evRelease ");
        try {
            DlgcSdpPortManager portMgr = fsm.getResourceContainer().getSdpPortMgrResource();
            DlgcSipMessage message = new DlgcSipMessage((JoinableContainer)portMgr.getContainer(), "BYE", null, "none", null);
            portMgr.sendSipMessage(message);
            fsm.setState(fsm.getReleasingState());
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void evSipInvite(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        log.debug(" Entering DlgcIvrRdyState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
        DlgcIvrRdyState.evSipInviteSipTimerSendOK(fsm, request);
        log.debug(" Returning DlgcIvrRdyState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
    }

    @Override
    public void evRejectSdpOffer(DlgcFSM fsm) {
        log.debug("DlgcIvrRdyState::evRejectSdpOffer ..sending BYE to release MS resource.");
        try {
            DlgcSdpPortManager portMgr = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
            DlgcSipMessage message = new DlgcSipMessage((JoinableContainer)portMgr.getContainer(), "BYE", null, "none", null);
            portMgr.sendSipMessage(message);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getRejectingSdpOfferState());
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }
}

