/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import java.io.IOException;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

class DlgcIvrLegPendWithNoDspState
extends DlgcSdpPortManagerStates {
    public DlgcIvrLegPendWithNoDspState() {
        this.stateName = "DlgcIvrLegPendWithNoDspState";
    }

    @Override
    public void evSipInvite(DlgcFSM fsm, SipServletResponse response) throws MsControlException {
        log.debug(" DlgcIvrLegPendWithNoDspState::evSipInvite Entering ");
        DlgcSdpPortManager portMgr = null;
        byte[] content = null;
        try {
            portMgr = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
        }
        catch (MsControlException e) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            DlgcSdpPortManagerStates.log.error("Error getting Sdp Port Manager Resource object from NetworkConnection Resource Container", (Throwable)e);
            throw new SdpPortManagerException("Error getting Sdp Port Manager Resource object from NetworkConnection Resource Container " + e.getMessage(), (Throwable)e);
        }
        int sipStatus = response.getStatus();
        try {
            content = response.getRawContent();
        }
        catch (IOException e) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            DlgcSdpPortManagerStates.log.error("Cant get response SDP content: ", (Throwable)e);
            portMgr.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, "Cant get response SDP content", null);
            throw new SdpPortManagerException("Cant get response SDP content:: " + e.getMessage(), (Throwable)e);
        }
        if (sipStatus >= 400 && sipStatus <= 599) {
            String SipStatusString = Integer.toString(sipStatus);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            DlgcSdpPortManagerStates.log.error("SIP Response return error: " + SipStatusString);
            String errMsg = "Fail to establish SIP Session...SIP error: " + SipStatusString;
            portMgr.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, errMsg, null);
            String msg = "SIP Response return error: " + SipStatusString;
            throw new SdpPortManagerException(msg);
        }
        if (response.getContentType().compareTo("sdp") != 0) {
            fsm.setState(DlgcSdpPortManagerStates.failState);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Exception incorrect content type received.");
            portMgr.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, "Exception incorrect content type received.", null);
            throw new SdpPortManagerException("Exception incorrect content type received.");
        }
        portMgr.setLocalSessionDescription(content);
        portMgr.setMSSessionDesc(content);
        portMgr.setResponseToAck(response);
        fsm.setState(((DlgcSdpPortManagerFSM)fsm).getIvrLegNoDspState());
        log.debug("OFFER-GENERATED: DlgcSdpPortManagerState::DlgcIvrLegPendWithNoDspState Invite Response -> Setting state to getIvrLegNoDspState...sending SdpPortManagerEvent.OFFER_GENERATED");
        portMgr.sendApplicationEvent(SdpPortManagerEvent.OFFER_GENERATED, content, null, null, null);
    }

    @Override
    public void evSipInvite(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        log.debug(" Entering DlgcIvrLegPendWithNoDspState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
        DlgcIvrLegPendWithNoDspState.evSipInviteSipTimerSendOK(fsm, request);
        log.debug(" Returning DlgcIvrLegPendWithNoDspState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
    }
}

