/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import java.io.IOException;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.networkconnection.SdpException;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import javax.servlet.sip.SipServletRequest;

class DlgcIvrLegNoDspState
extends DlgcSdpPortManagerStates {
    public DlgcIvrLegNoDspState() {
        this.stateName = "DlgcIvrLegNoDspState";
    }

    @Override
    public void evSdpOffer(DlgcFSM fsm, String remoteSD) throws SdpException, SdpPortManagerException {
        DlgcSdpPortManager portMgr = null;
        SessionDescription providedRemoteSdp = null;
        try {
            portMgr = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
            try {
                providedRemoteSdp = sdpFactory.createSessionDescription(remoteSD);
            }
            catch (SdpParseException spe) {
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                DlgcSdpPortManagerStates.log.error("Exception generated: Provided remote Session Description cannot be used", (Throwable)spe);
                throw new SdpException("Provided remote Session Description cannot be used", (Throwable)spe);
            }
            portMgr.setRemoteSessionDescription(providedRemoteSdp);
            SipServletRequest req = portMgr.getResponseToAck().createAck();
            portMgr.setRemoteSessionDescription(null);
            String sContent = "application/sdp";
            try {
                req.setContent((Object)remoteSD.getBytes(), sContent);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getIvrLegPendingState());
                req.send();
            }
            catch (IOException uex) {
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                DlgcSdpPortManagerStates.log.error("Exception generated: Cant create sdp offer encoding", (Throwable)uex);
                throw new SdpException("Exception generated: Cant create sdp offer encoding", (Throwable)uex);
            }
            portMgr.setUASessionDesc(remoteSD.getBytes());
        }
        catch (MsControlException e) {
            fsm.setState(failState);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Error getting Sdp Port Manager Resource object from NetworkConnection Resource Container", (Throwable)e);
            throw new SdpPortManagerException("Error getting Sdp Port Manager Resource object from NetworkConnection Resource Container " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void evSipInvite(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        log.debug(" Entering DlgcIvrLegNoDspState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
        DlgcIvrLegNoDspState.evSipInviteSipTimerSendOK(fsm, request);
        log.debug(" Returning DlgcIvrLegNoDspState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
    }
}

