/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapter;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.networkconnection.SdpException;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;

class DlgcCreatedState
extends DlgcSdpPortManagerStates {
    private static final long serialVersionUID = 155555777L;

    public DlgcCreatedState() {
        this.stateName = "DlgcCreatedState";
    }

    @Override
    public void evSdpOffer(DlgcFSM fsm, String remoteSD) throws SdpException, SdpPortManagerException {
        DlgcSdpPortManager portMgr = null;
        SessionDescription providedRemoteSdp = null;
        try {
            portMgr = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
            try {
                providedRemoteSdp = sdpFactory.createSessionDescription(remoteSD);
            }
            catch (SdpParseException spe) {
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                DlgcSdpPortManagerStates.log.error("Exception generated: Provided remote Session Description cannot be used", (Throwable)spe);
                throw new SdpException("Provided remote Session Description cannot be used", (Throwable)spe);
            }
            portMgr.setRemoteSessionDescription(providedRemoteSdp);
            portMgr.setUASessionDesc(remoteSD.getBytes());
        }
        catch (MsControlException e) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Error getting Sdp Port Manager Resource object from NetworkConnection Resource Container", (Throwable)e);
            throw new SdpPortManagerException("Error getting Sdp Port Manager Resource object from NetworkConnection Resource Container " + e.getMessage(), (Throwable)e);
        }
        try {
            DlgcNetworkConnection nc = (DlgcNetworkConnection)((DlgcResourceContainerFSM)fsm).getResourceContainer();
            JoinableContainer jc = nc.getPrimaryJoinee();
            if (jc != null) {
                log.debug("JOHN TRACE 1");
                if (jc instanceof DlgcMixerAdapter) {
                    log.debug("JOHN TRACE 2");
                    DlgcMediaMixer mxjc = ((DlgcMixerAdapter)jc).getMixer();
                    this.connectToConferenceImmediately((DlgcXMediaMixer)mxjc, fsm, confImmediatelyPendingState, (DlgcMixerAdapter)jc);
                    return;
                }
                if (jc instanceof DlgcMediaMixer) {
                    log.debug("JOHN TRACE 3");
                    this.connectToConferenceImmediately((DlgcXMediaMixer)jc, fsm, confImmediatelyPendingState, null);
                    return;
                }
            }
            log.debug("JOHN TRACE 4");
            DlgcSdpPortManagerStates.sendSipMessage(fsm, "ivr", "INVITE", "sdp", new String(remoteSD));
        }
        catch (MsControlException e) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            DlgcSdpPortManagerStates.log.error("Exception generated by sendSipMessage call while trying to send a SDP Offer to Media Server", (Throwable)e);
            throw new SdpPortManagerException("Exception generated by sendSipMessage call while trying to send a SDP Offer to Media Server " + e.getMessage(), (Throwable)e);
        }
        fsm.setState(((DlgcSdpPortManagerFSM)fsm).getIvrLegPendingState());
    }

    @Override
    public void evSdpOffer(DlgcFSM fsm) throws SdpException, SdpPortManagerException {
        try {
            DlgcSdpPortManagerStates.sendSipMessage(fsm, "ivr", "INVITE", "none", null);
        }
        catch (MsControlException e) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            DlgcSdpPortManagerStates.log.error("Exception generated by sendSipMessage call while trying to send a SDP Offer to Media Server with no SDP", (Throwable)e);
            throw new SdpPortManagerException("Exception generated by sendSipMessage call while trying to send a SDP Offer to Media Server " + e.getMessage(), (Throwable)e);
        }
        fsm.setState(((DlgcSdpPortManagerFSM)fsm).getIvrLegPendWithNoDspState());
    }

    public void evConnectToConference(DlgcFSM fsm) throws SdpException, SdpPortManagerException {
        this.connectToConference(fsm, ((DlgcSdpPortManagerFSM)fsm).getConfLegPendState());
    }
}

