/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinEvent;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServletRequestProxy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.JoinEvent;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

class DlgcConfTransitionState
extends DlgcSdpPortManagerStates {
    public DlgcConfTransitionState() {
        this.stateName = "DlgcConfTransitionState";
    }

    @Override
    public void evSipInvite(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        log.debug(" Entering DlgcConfTransitionState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
        DlgcConfTransitionState.evSipInviteSipTimerSendOK(fsm, request);
        log.debug(" Returning DlgcConfTransitionState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
    }

    @Override
    public void evSipInfo(DlgcFSM fsm, MsmlDocument.Msml msmlResponse) throws MsControlException {
        log.debug("Entering DlgcConfTransitionState::evSipInfo");
        MsmlDocument.Msml.Result r = msmlResponse.getResult();
        String status = r.getResponse();
        DlgcSdpPortManager portMgr = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
        DlgcNetworkConnection nc = (DlgcNetworkConnection)portMgr.getContainer();
        DlgcXMediaMixer mx = (DlgcXMediaMixer)nc.getMixerIfJoined();
        DlgcJoinEvent event = null;
        DlgcSync2AsyncMonitor monitor = nc.getMonitor();
        if (status.compareToIgnoreCase("200") == 0) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getConfLegRdy());
            if (mx != null) {
                log.debug("CONTROL LIST: DlgcConfTransitionState:: calling addNewConfLegToListIfNotAddedAlready()");
                mx.addNewConfLegToListIfNotAddedAlready(nc);
            } else {
                log.debug("CONTROL LIST: DlgcConfTransitionState:: not calling addNewConfLegToListIfNotAddedAlready()");
            }
            boolean bStatus = true;
            String sStatus = "Join Success";
            if (monitor == null) {
                log.debug("SYNC_2_ASYNC DlgcConfTransitionState::evSipInfo -  running Join in a synchronous mode but DlgcSync2AsyncMonitor is NULL..using eventing");
                log.debug("SYNC_2_ASYNC DlgcConfTransitionState::evSipInfo -  asynchronous method");
                event = new DlgcJoinEvent(JoinEvent.JOINED, (Joinable)nc);
                event.setError(MediaErr.NO_ERROR);
                event.setErrorText("SdpPort No Error: succesful joining to conference");
                log.debug("DlgcConfTransitionState::evSipInfo posting Join Event Notificaiton to application indicating successful join to conference");
            } else {
                log.debug("SYNC_2_ASYNC DlgcConfTransitionState::evSipInfo -  calling Monitor notifyRequestCompleted");
                monitor.notifyRequestCompleted(bStatus, sStatus);
                log.debug("SYNC_2_ASYNC DlgcConfTransitionState::evSipInfo -  returned from Monitor notifyRequestCompleted");
            }
        } else {
            boolean bStatus = false;
            String sStatus = "Error joining to conference";
            String msmlStatus = r.toString();
            log.error("Can't join call leg to confernce received the following error from XMS: " + msmlStatus);
            if (monitor == null) {
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getIvrLegRdyState());
                log.debug("DlgcConfTransitionState::evSipInfo posting Join Event Notificaiton to application indicating error joining conference..going back to ivrRdyState");
                event = new DlgcJoinEvent(JoinEvent.JOINED, (Joinable)nc);
                event.setError(MediaErr.SERVICE_NOT_DEFINED);
                event.setErrorText("SdpPort error joining to conference..resuming IVR ready state");
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getIvrLegRdyState());
                log.debug("DlgcConfTransitionState::evSipInfo posting Join Event Notificaiton to application indicating error joining conference..going back to ivrRdyState");
            } else {
                log.debug("SYNC_2_ASYNC DlgcJoinConfCNCLPendingState::evSipInfo -  calling Monitor notifyRequestCompleted");
                monitor.notifyRequestCompleted(bStatus, sStatus);
                log.debug("SYNC_2_ASYNC DlgcJoinConfCNCLPendingState::evSipInfo -  returned from Monitor notifyRequestCompleted");
            }
        }
        if (event != null) {
            nc.postJoinEvent(event);
        }
    }

    @Override
    public void evRelease(DlgcSdpPortManagerFSM fsm) {
        try {
            DlgcSdpPortManager portMgr = fsm.getResourceContainer().getSdpPortMgrResource();
            DlgcSipMessage message = new DlgcSipMessage((JoinableContainer)portMgr.getContainer(), "BYE", null, "none", null);
            portMgr.sendSipMessage(message);
            fsm.setState(fsm.getReleasingState());
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void evSdpAnswer(DlgcSdpPortManagerFSM fsm, String remoteSD) {
        log.debug("Inside DlgcConfTransitionState:evSdpAnswered");
        try {
            fsm.setState(fsm.getConfLegRdy());
            DlgcSdpPortManager sdp = fsm.getResourceContainer().getSdpPortMgrResource();
            sdp.sendApplicationEvent(SdpPortManagerEvent.ANSWER_PROCESSED, sdp.getMediaServerSessionDescription(), null, null, null);
        }
        catch (MsControlException ex) {
            fsm.setState(fsm.getFailState());
            log.error("Error getting Sdp Port Manager", (Throwable)ex);
            return;
        }
    }

    @Override
    public void evSipBye(DlgcFSM fsm, SipServletResponse response) throws MsControlException {
        DlgcSdpPortManager sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
        ((DlgcResourceContainer)sdp.getContainer()).stopSessionTimer();
        DlgcSipServletRequestProxy sipServletReqProxy = (DlgcSipServletRequestProxy)response.getRequest().getAttribute(response.getHeader("CSeq"));
        if (DlgcSipServlet.APP_SERVER_PLATFORM.compareToIgnoreCase("IBM") != 0) {
            response.getRequest().removeAttribute(response.getHeader("CSeq"));
        }
        DlgcSipConnectorContentIdsProxy proxyId = (DlgcSipConnectorContentIdsProxy)sipServletReqProxy.getAttribute("MIXER");
        proxyId.Load();
        DlgcMediaMixer mx = (DlgcMediaMixer)proxyId.getCachedContainer();
        DlgcNetworkConnection nc = (DlgcNetworkConnection)sdp.getContainer();
        this.connectToConference(mx, fsm, ((DlgcSdpPortManagerFSM)fsm).getConfTransitionState(), nc.getMixerAdapter());
    }

    @Override
    public void evSipInvite(DlgcFSM fsm, SipServletResponse response) throws MsControlException {
        log.debug("JJJJJJJJJJJJJJJJ DlgcConfTransitionState:: Entereing CCCCCCCCCCCC");
        byte[] content = null;
        DlgcSdpPortManager sdp = null;
        try {
            sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
        }
        catch (MsControlException ex) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Error getting Sdp Port Manager", (Throwable)ex);
            return;
        }
        int sipStatus = response.getStatus();
        try {
            content = response.getRawContent();
        }
        catch (IOException e) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            DlgcSdpPortManagerStates.log.error("Cant get response SDP content: ", (Throwable)e);
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, "Cant get response SDP content", null);
            throw new SdpPortManagerException("Cant get response SDP content:: " + e.getMessage(), (Throwable)e);
        }
        if (sipStatus >= 400 && sipStatus <= 599) {
            String SipStatusString = Integer.toString(sipStatus);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
            DlgcSdpPortManagerStates.log.error("SIP Response return error: " + SipStatusString);
            String errMsg = "Fail to establish SIP Session...SIP error: " + SipStatusString;
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, errMsg, null);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
            String msg = "SIP Response return error: " + SipStatusString;
            throw new SdpPortManagerException(msg);
        }
        if (response.getContentType().compareTo("sdp") == 0) {
            sdp.setLocalSessionDescription(content);
            sdp.setMSSessionDesc(content);
            sdp.setResponseToAck(response);
            SipServletRequest ackReq = response.createAck();
            try {
                ackReq.send();
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getConfLegRdy());
                log.debug("OFFER-GENERATED: DlgcSdpPortManager:DlgcConfTransitionState Invite Response -> Setting state to xconfLegRdy...sending SdpPortManagerEvent.OFFER_GENERATED");
                sdp.sendApplicationEvent(SdpPortManagerEvent.OFFER_GENERATED, content, null, null, null);
            }
            catch (IOException e) {
                log.error("Fail to send Ack: ", (Throwable)e);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            }
        } else if (response.getContentType().startsWith("multipart")) {
            try {
                MimeMultipart y = new MimeMultipart((DataSource)new ByteArrayDataSource(content, response.getContentType()));
                for (int i = 0; i < y.getCount(); ++i) {
                    MimeBodyPart mbp = (MimeBodyPart)y.getBodyPart(i);
                    if (!mbp.getContentType().contains("sdp")) continue;
                    ByteArrayInputStream stream = (ByteArrayInputStream)mbp.getContent();
                    byte[] sdpContentBytes = new byte[mbp.getSize()];
                    stream.read(sdpContentBytes, 0, mbp.getSize());
                    sdp.setLocalSessionDescription(sdpContentBytes);
                    sdp.setMSSessionDesc(sdpContentBytes);
                    sdp.setResponseToAck(response);
                    break;
                }
                response.createAck().send();
                ((DlgcResourceContainer)sdp.getContainer()).startSessionTimer(response);
                log.debug("OFFER-GENERATED: DlgcConfTransitionState:: calling sdp.sendApplicationEvent UNSOLICITED_OFFER_GENREATED");
                sdp.sendApplicationEvent(SdpPortManagerEvent.UNSOLICITED_OFFER_GENERATED, content, null, null, null);
            }
            catch (MessagingException e1) {
                log.error("Failed to send ack: ", (Throwable)e1);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            }
            catch (IOException e) {
                log.error("Failed to send ack: ", (Throwable)e);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            }
        } else {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Exception incorrect content type received.");
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, "Exception incorrect content type received.", null);
            throw new SdpPortManagerException("Exception incorrect content type received.");
        }
    }
}

