/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapter;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMixerConfig;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.video.DlgcVideoLayout;
import java.util.Queue;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventNotifier;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.mixer.MixerAdapter;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpException;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.media.mscontrol.resource.video.VideoLayout;
import javax.servlet.sip.SipServletRequest;

class DlgcConfLegRdyState
extends DlgcSdpPortManagerStates {
    public DlgcConfLegRdyState() {
        this.stateName = "DlgcConfLegRdyState";
    }

    @Override
    public void evJoin(DlgcFSM fsm, Joinable.Direction direction, Joinable joinee, MixerAdapter mxa) {
        if (joinee instanceof MediaMixer) {
            try {
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getModifyingLegState());
                DlgcSdpPortManager sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
                DlgcMediaMixer mx = (DlgcMediaMixer)joinee;
            }
            catch (MsControlException e) {
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                log.error("Exception found in evJoin event on state DlgcIvrRdyState: ", (Throwable)e);
            }
        }
    }

    @Override
    public void evOnUnjoin(DlgcFSM fsm) throws SdpException, SdpPortManagerException {
        DlgcSdpPortManager sdp = null;
        if (DlgcSipB2BUA.isMediaTypeIPMS()) {
            try {
                sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
            }
            catch (MsControlException ex) {
                log.error("Error getting Sdp Port Manager", (Throwable)ex);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                return;
            }
            sdp.sendSipMessage(null, "BYE", "none", null);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
        } else {
            try {
                sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
                DlgcNetworkConnection nc = (DlgcNetworkConnection)sdp.getContainer();
                DlgcMediaMixer mx = nc.getMixerIfJoined();
                if (mx != null) {
                    DlgcMixerAdapter ma = nc.myMixerAdapter;
                    fsm.setState(((DlgcSdpPortManagerFSM)fsm).getIvrLegPendingState());
                    mx.parkLeg(sdp);
                }
            }
            catch (MsControlException e) {
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                log.error("Exception found in evJoin event on state DlgcIvrRdyState: ", (Throwable)e);
            }
        }
    }

    @Override
    public void evPark(DlgcSdpPortManagerFSM fsm) {
        log.debug("DlgcSdpPortManagerState evPark aka unjoin leg");
        try {
            Joinable[] joinees;
            DlgcSdpPortManager sdp = fsm.getResourceContainer().getSdpPortMgrResource();
            for (Joinable j : joinees = ((NetworkConnection)sdp.getContainer()).getJoinees()) {
                if (!(j instanceof MediaMixer)) continue;
                fsm.setState(fsm.getParkTransitionState());
                DlgcMediaMixer mx = (DlgcMediaMixer)j;
                log.debug("DlgcSdpPortManagerState evPark: calling mx.parkLeg(sdp)");
                log.debug("DlgcSdpPortManagerState evPark: Joinable is: " + j.toString());
                mx.parkLeg(sdp);
            }
        }
        catch (MsControlException e) {
            log.error("Error to park", (Throwable)e);
        }
    }

    @Override
    public void evRelease(DlgcSdpPortManagerFSM fsm) {
        try {
            DlgcSdpPortManager portMgr = fsm.getResourceContainer().getSdpPortMgrResource();
            DlgcNetworkConnection nc = (DlgcNetworkConnection)portMgr.getContainer();
            DlgcXMediaMixer mx = (DlgcXMediaMixer)nc.getMixerIfJoined();
            if (mx != null) {
                mx.removeConfLegFromList(nc);
                mx.releaseRegionId(nc.getRegionId());
                DlgcXMixerConfig mc = (DlgcXMixerConfig)mx.getConfig();
                if (mc.getMyConfiguraiton() == MediaMixer.AUDIO_VIDEO_RENDERING) {
                    VideoLayout v = mx.getVideoLayout();
                    ((DlgcVideoLayout)v).releaseRegion(nc.getRegionName());
                }
            } else {
                log.debug("DlgcConfLegRdyState:: mixer found to be null...ignoring mx.revemoConfLegFromList()");
            }
            log.debug("DlgcConfLegRdyState:: *15 still sending BYE SIP request to release leg from the Media Server - NC OBJ ID: " + nc.getMediaObject() + "  NC String ID: " + nc.toString());
            DlgcSipMessage message = new DlgcSipMessage((JoinableContainer)portMgr.getContainer(), "BYE", null, "none", null);
            portMgr.sendSipMessage(message);
            fsm.setState(fsm.getReleasingState());
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void evSipInvite(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        log.debug(" Entering DlgcConfLegRdyState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
        DlgcConfLegRdyState.evSipInviteSipTimerSendOK(fsm, request);
        log.debug(" Returning DlgcConfLegRdyState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
    }

    @Override
    public void sendMediaMessage(DlgcSdpPortManagerFSM fsm, DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
        try {
            DlgcSdpPortManager portMgr = fsm.getResourceContainer().getSdpPortMgrResource();
            Queue<DlgcSdpPortManager.DlgcMediaMessage> queue = portMgr.messageQueue;
            DlgcSdpPortManager dlgcSdpPortManager = portMgr;
            dlgcSdpPortManager.getClass();
            queue.add(new DlgcSdpPortManager.DlgcMediaMessage(dlgcSdpPortManager, message, notifier));
            fsm.evPark();
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }
}

