/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

class DlgcConfLegPendState
extends DlgcSdpPortManagerStates {
    public DlgcConfLegPendState() {
        this.stateName = "DlgcConfLegPendState";
    }

    @Override
    public void evRelease(DlgcSdpPortManagerFSM fsm) {
        try {
            DlgcSdpPortManager portMgr = fsm.getResourceContainer().getSdpPortMgrResource();
            DlgcSipMessage message = new DlgcSipMessage((JoinableContainer)portMgr.getContainer(), "BYE", null, "none", null);
            portMgr.sendSipMessage(message);
            fsm.setState(fsm.getReleasingState());
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void evSipInvite(DlgcFSM fsm, SipServletResponse response) throws MsControlException {
        log.debug("JJJJJJJJJJJJJJJJ DlgcConfLegPendState::evSipInvite entering  CCCCCCCCCCCC");
        byte[] content = null;
        DlgcSdpPortManager sdp = null;
        try {
            sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
        }
        catch (MsControlException ex) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Error getting Sdp Port Manager", (Throwable)ex);
            return;
        }
        int sipStatus = response.getStatus();
        try {
            content = response.getRawContent();
        }
        catch (IOException e) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            DlgcSdpPortManagerStates.log.error("Cant get response SDP content: ", (Throwable)e);
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, "Cant get response SDP content", null);
            throw new SdpPortManagerException("Cant get response SDP content:: " + e.getMessage(), (Throwable)e);
        }
        if (sipStatus >= 400 && sipStatus <= 599) {
            String SipStatusString = Integer.toString(sipStatus);
            fsm.setState(DlgcSdpPortManagerStates.createdState);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
            DlgcSdpPortManagerStates.log.error("SIP Response return error: " + SipStatusString);
            String errMsg = "Fail to establish SIP Session...SIP error: " + SipStatusString;
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, errMsg, null);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
            String msg = "SIP Response return error: " + SipStatusString;
            throw new SdpPortManagerException(msg);
        }
        if (response.getContentType().compareTo("sdp") == 0) {
            sdp.setLocalSessionDescription(content);
            sdp.setMSSessionDesc(content);
            sdp.setResponseToAck(response);
            SipServletRequest ackReq = response.createAck();
            try {
                ackReq.send();
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getConfLegRdy());
                log.debug("OFFER-GENERATED: DlgcSdpPortManagerState::DlgcConfLegPendState Invite Response -> Setting state to getConfLegRdy...sending SdpPortManagerEvent.OFFER_GENERATED");
                sdp.sendApplicationEvent(SdpPortManagerEvent.OFFER_GENERATED, content, null, null, null);
            }
            catch (IOException e) {
                log.error("Fail to send Ack: ", (Throwable)e);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            }
        } else if (response.getContentType().startsWith("multipart")) {
            try {
                MimeMultipart y = new MimeMultipart((DataSource)new ByteArrayDataSource(content, response.getContentType()));
                for (int i = 0; i < y.getCount(); ++i) {
                    MimeBodyPart mbp = (MimeBodyPart)y.getBodyPart(i);
                    if (!mbp.getContentType().contains("sdp")) continue;
                    ByteArrayInputStream stream = (ByteArrayInputStream)mbp.getContent();
                    byte[] sdpContentBytes = new byte[mbp.getSize()];
                    stream.read(sdpContentBytes, 0, mbp.getSize());
                    sdp.setLocalSessionDescription(sdpContentBytes);
                    sdp.setMSSessionDesc(sdpContentBytes);
                    sdp.setResponseToAck(response);
                    break;
                }
                response.createAck().send();
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getConfLegRdy());
                sdp.sendApplicationEvent(SdpPortManagerEvent.ANSWER_GENERATED, content, null, null, null);
            }
            catch (MessagingException e1) {
                log.error("Failed to send ack: ", (Throwable)e1);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            }
            catch (IOException e) {
                log.error("Failed to send ack: ", (Throwable)e);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            }
        } else {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Exception incorrect content type received.");
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, "Exception incorrect content type received.", null);
            throw new SdpPortManagerException("Exception incorrect content type received.");
        }
    }

    @Override
    public void evSipInvite(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        log.debug(" Entering DlgcConfLegPendState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
        DlgcConfLegPendState.evSipInviteSipTimerSendOK(fsm, request);
        log.debug(" Returning DlgcConfLegPendState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
    }
}

