/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import java.io.IOException;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.networkconnection.SdpException;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

class DlgcConfLegNoDspState
extends DlgcSdpPortManagerStates {
    public DlgcConfLegNoDspState() {
        this.stateName = "DlgcConfLegNoDspState";
    }

    @Override
    public void evSdpOffer(DlgcFSM fsm, String remoteSD) throws SdpException, SdpPortManagerException {
        Object content = null;
        DlgcSdpPortManager sdp = null;
        try {
            sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
        }
        catch (MsControlException ex) {
            log.error("Error getting Sdp Port Manager", (Throwable)ex);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            return;
        }
        SipServletResponse responseToAck = sdp.getResponseToAck();
        if (responseToAck != null) {
            try {
                String contentType = "application/sdp";
                SipServletRequest ackReq = responseToAck.createAck();
                ackReq.setContent((Object)remoteSD.getBytes(), contentType);
                ackReq.send();
            }
            catch (IOException e) {
                log.error("Sending ack fail" + e);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                throw new SdpPortManagerException("Sending Ack fail: " + e);
            }
        } else {
            log.error("Prevbiously received response not available. State: " + this);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            throw new SdpPortManagerException("Prevbiously received response not avilabe. State: " + this);
        }
        sdp.setResponseToAck(null);
        fsm.setState(((DlgcSdpPortManagerFSM)fsm).getConfLegRdy());
    }

    @Override
    public void evSipInvite(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        log.debug(" Entering DlgcConfLegNoDspState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
        DlgcConfLegNoDspState.evSipInviteSipTimerSendOK(fsm, request);
        log.debug(" Returning DlgcConfLegNoDspState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
    }
}

