/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import java.io.IOException;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

class DlgcConfLegNoDspPendState
extends DlgcSdpPortManagerStates {
    public DlgcConfLegNoDspPendState() {
        this.stateName = "DlgcConfLegNoDspPendState";
    }

    @Override
    public void evRelease(DlgcSdpPortManagerFSM fsm) {
        try {
            DlgcSdpPortManager portMgr = fsm.getResourceContainer().getSdpPortMgrResource();
            DlgcSipMessage message = new DlgcSipMessage((JoinableContainer)portMgr.getContainer(), "BYE", null, "none", null);
            portMgr.sendSipMessage(message);
            fsm.setState(fsm.getReleasingState());
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void evSipInvite(DlgcFSM fsm, SipServletResponse response) throws MsControlException {
        log.debug("JJJJJJJJJJJJJJJJ DlgcConfLegNoDspPendState:: Entering CCCCCCCCCCCC");
        byte[] content = null;
        DlgcSdpPortManager sdp = null;
        try {
            sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
        }
        catch (MsControlException ex) {
            log.error("Error getting Sdp Port Manager", (Throwable)ex);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            return;
        }
        int sipStatus = response.getStatus();
        try {
            content = response.getRawContent();
        }
        catch (IOException e) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            DlgcSdpPortManagerStates.log.error("Cant get response SDP content: ", (Throwable)e);
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, "Cant get response SDP content", null);
            throw new SdpPortManagerException("Cant get response SDP content:: " + e.getMessage(), (Throwable)e);
        }
        if (sipStatus >= 400 && sipStatus <= 599) {
            String SipStatusString = Integer.toString(sipStatus);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
            DlgcSdpPortManagerStates.log.error("SIP Response return error: " + SipStatusString);
            String errMsg = "Fail to establish SIP Session...SIP error: " + SipStatusString;
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, errMsg, null);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            String msg = "SIP Response return error: " + SipStatusString;
            throw new SdpPortManagerException(msg);
        }
        if (response.getContentType().compareTo("sdp") != 0) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Exception incorrect content type received.");
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, "Exception incorrect content type received.", null);
            throw new SdpPortManagerException("Exception incorrect content type received.");
        }
        sdp.setLocalSessionDescription(content);
        sdp.setMSSessionDesc(content);
        sdp.setResponseToAck(response);
        fsm.setState(((DlgcSdpPortManagerFSM)fsm).getConfLegNoDsp());
    }

    @Override
    public void evSipInvite(DlgcSdpPortManagerFSM fsm, SipServletRequest request) {
        log.debug(" Entering DlgcConfLegNoDspPendState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
        DlgcConfLegNoDspPendState.evSipInviteSipTimerSendOK(fsm, request);
        log.debug(" Returning DlgcConfLegNoDspPendState::evSipInvite request... most likely handling IPMS SIP SESSION TIMER");
    }
}

