/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.networkconnection;

import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcFSM;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.msmlProtocol.DlgcSipB2BUAMSMLProtocol;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainerFSM;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

class DlgcConfImmediatelyPendingState
extends DlgcSdpPortManagerStates {
    private static final long serialVersionUID = 16709122377L;

    public DlgcConfImmediatelyPendingState() {
        this.stateName = "DlgcConfImmediatelyPendingState";
    }

    @Override
    public void evSipInvite(DlgcFSM fsm, SipServletResponse response) throws MsControlException {
        log.debug("DlgcConfImmediatelyPendingState::evSipInvite entering ");
        byte[] content = null;
        DlgcSdpPortManager sdp = null;
        int sipStatus = response.getStatus();
        if (sipStatus == 180) {
            log.debug("DlgcConfImmediatelyPendingState::evSipInvite response msg from IPMS = SIP 180 Ringing");
            return;
        }
        try {
            sdp = ((DlgcResourceContainerFSM)fsm).getResourceContainer().getSdpPortMgrResource();
        }
        catch (MsControlException ex) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Error getting Sdp Port Manager", (Throwable)ex);
            return;
        }
        try {
            content = response.getRawContent();
        }
        catch (IOException e) {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            DlgcSdpPortManagerStates.log.error("Cant get response SDP content: ", (Throwable)e);
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, "Cant get response SDP content", null);
            throw new SdpPortManagerException("Cant get response SDP content:: " + e.getMessage(), (Throwable)e);
        }
        if (sipStatus >= 400 && sipStatus <= 599) {
            String SipStatusString = Integer.toString(sipStatus);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
            DlgcSdpPortManagerStates.log.error("SIP Response return error: " + SipStatusString);
            String errMsg = "Fail to establish SIP Session...SIP error: " + SipStatusString;
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, errMsg, null);
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getCreatedState());
            String msg = "SIP Response return error: " + SipStatusString;
            throw new SdpPortManagerException(msg);
        }
        if (response.getContentType().compareTo("sdp") == 0) {
            log.debug("DlgcConfImmediatelyPendingState::evSipInvite response valid SDP response");
            sdp.setLocalSessionDescription(content);
            sdp.setMSSessionDesc(content);
            sdp.setResponseToAck(response);
            SipServletRequest ackReq = response.createAck();
            try {
                ackReq.send();
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getConfLegRdy());
                log.debug("OFFER-GENERATED: DlgcdpPortManagerState::DlgcConfImmediatelyPendingState Invite Response -> Setting state to xconfLegRdy...sending SdpPortManagerEvent.OFFER_GENERATED");
                sdp.sendApplicationEvent(SdpPortManagerEvent.OFFER_GENERATED, content, null, null, null);
            }
            catch (IOException e) {
                log.error("Fail to send Ack: ", (Throwable)e);
                fsm.setState(DlgcSdpPortManagerStates.failState);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            }
        } else if (response.getContentType().startsWith("multipart")) {
            log.debug("DlgcConfImmediatelyPendingState::evSipInvite response valid SMULTIPART DP response");
            try {
                MimeMultipart y = new MimeMultipart((DataSource)new ByteArrayDataSource(content, response.getContentType()));
                boolean successful = true;
                for (int i = 0; i < y.getCount(); ++i) {
                    ByteArrayInputStream stream;
                    MimeBodyPart mbp = (MimeBodyPart)y.getBodyPart(i);
                    if (mbp.getContentType().contains("sdp")) {
                        stream = (ByteArrayInputStream)mbp.getContent();
                        byte[] sdpContentBytes = new byte[mbp.getSize()];
                        stream.read(sdpContentBytes, 0, mbp.getSize());
                        sdp.setLocalSessionDescription(sdpContentBytes);
                        sdp.setMSSessionDesc(sdpContentBytes);
                        sdp.setResponseToAck(response);
                        continue;
                    }
                    stream = (ByteArrayInputStream)mbp.getContent();
                    BufferedReader br = new BufferedReader(new InputStreamReader(stream));
                    String msmlString = new String();
                    String result = new String();
                    while ((msmlString = br.readLine()) != null) {
                        result = result + msmlString;
                    }
                    MsmlDocument.Msml msmlMsg = DlgcSipB2BUAMSMLProtocol.extractMsmlResponseMessage(result);
                    String resultResponse = msmlMsg.getResult().getResponse();
                    Integer iResult = new Integer(resultResponse);
                    if (iResult == 200) {
                        log.debug("DlgcConfImmediatelyPendingState::evSipInvite create conference during the invite succesfull");
                        continue;
                    }
                    log.error("DlgcConfImmediatelyPendingState::evSipInvite create conference during the invite failure: " + msmlMsg.getResult().getDescription());
                    successful = false;
                    fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
                    sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, "Exception could not create or join to conference.", null);
                    throw new SdpPortManagerException("Exception incorrect content type received.");
                }
                if (successful) {
                    DlgcNetworkConnection nc = (DlgcNetworkConnection)sdp.getContainer();
                    DlgcXMediaMixer mx = (DlgcXMediaMixer)nc.getMixerIfJoined();
                    mx.addNewControlLegToList(nc);
                    response.createAck().send();
                    fsm.setState(((DlgcSdpPortManagerFSM)fsm).getConfLegRdy());
                    sdp.sendApplicationEvent(SdpPortManagerEvent.ANSWER_GENERATED, content, null, null, null);
                }
            }
            catch (MessagingException e1) {
                log.error("Failed to send ack: ", (Throwable)e1);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            }
            catch (IOException e) {
                log.error("Failed to send ack: ", (Throwable)e);
                fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            }
        } else {
            fsm.setState(((DlgcSdpPortManagerFSM)fsm).getFailState());
            log.error("Exception incorrect content type received.");
            sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, content, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, "Exception incorrect content type received.", null);
            throw new SdpPortManagerException("Exception incorrect content type received.");
        }
    }
}

