/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.msmlProtocol;

import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcRecorder;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXRecorder;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.msmlProtocol.DlgcMsmlDialogEventExitStatus;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcXSignalDetector;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.mediagroup.RecorderEvent;
import javax.media.mscontrol.mediagroup.signals.SignalConstants;
import javax.media.mscontrol.mediagroup.signals.SignalDetectorEvent;
import javax.media.mscontrol.resource.ResourceEvent;
import javax.media.mscontrol.resource.video.VideoRendererEvent;

public class DlgcMsmlProtocolMessageMappingAssistance {
    public static final String ivr = "ivr";
    public static final String conf = "msml=";
    public static final String dialog = "dialog";
    public static final String infinite = "infinite";
    public static final String immediate = "immediate";
    public static final String forever = "forever";
    private static final Map<Class<? extends Object>, Map<String, EventType>> ResourceMapMap;
    private static final Map<String, EventType> PlayerResourceMap;
    private static final Map<String, EventType> RecorderResourceMap;
    private static final Map<String, EventType> VideoRenderResourceMap;
    private static final Map<String, EventType> SignalDetectorResourceMap;
    private static final Map<String, Qualifier> commonReasonToQualifier;
    private static final Map<String, Qualifier> playReasonToQualifier;
    private static final Map<String, Qualifier> recordReasonToQualifier;
    private static final Map<String, Qualifier> SignalDetectorToQualifier;
    private static final Map<Character, Value> digitToValue;
    private static final Map<String, MediaErr> msmlSipResponseCodeToJsrMediaErr;
    private static final Map<String, MediaErr> msmlSipResponseTextToJsrMediaErr;
    public static final Vector<Character> msmlRegexAuthorizedCharacters;

    private static Qualifier getQualifier(String reason) {
        Qualifier result = commonReasonToQualifier.get(reason);
        if (result == null) {
            result = ResourceEvent.NO_QUALIFIER;
        }
        return result;
    }

    public static Qualifier getPlayQualifier(String reason) {
        Qualifier result = playReasonToQualifier.get(reason);
        if (result == null) {
            result = DlgcMsmlProtocolMessageMappingAssistance.getQualifier(reason);
        }
        return result;
    }

    public static Qualifier getRecordQualifier(String reason) {
        Qualifier result = recordReasonToQualifier.get(reason);
        if (result == null) {
            result = DlgcMsmlProtocolMessageMappingAssistance.getQualifier(reason);
        }
        return result;
    }

    public static Qualifier getSignalDetectorQualifier(String reason) {
        Qualifier result = SignalDetectorToQualifier.get(reason);
        if (result == null) {
            result = DlgcMsmlProtocolMessageMappingAssistance.getQualifier(reason);
        }
        return result;
    }

    public static Qualifier getCollectQualifier(String reason, String name, String digits) {
        Qualifier result = ResourceEvent.NO_QUALIFIER;
        if (reason.equalsIgnoreCase(collectReason.match.toString())) {
            result = SignalDetectorEvent.NUM_SIGNALS_DETECTED;
        } else if (!reason.equalsIgnoreCase(collectReason.returnkey.toString())) {
            Qualifier qualifier;
            if (reason.equalsIgnoreCase(collectReason.escapekey.toString())) {
                result = SignalDetectorEvent.STOPPED;
            } else if (reason.equalsIgnoreCase(collectReason.timeout.toString())) {
                result = !digits.equalsIgnoreCase("") ? SignalDetectorEvent.INTER_SIG_TIMEOUT_EXCEEDED : SignalDetectorEvent.INITIAL_TIMEOUT_EXCEEDED;
            } else if (reason.equalsIgnoreCase(collectReason.stopped.toString()) && (qualifier = commonReasonToQualifier.get(reason)) != null) {
                result = qualifier;
            }
        }
        return result;
    }

    public static Value[] getCollectSignalBuffer(String digits) {
        Value[] result = new Value[digits.length()];
        for (int i = 0; i < digits.length(); ++i) {
            result[i] = digitToValue.get(Character.valueOf(digits.charAt(i)));
            if (result[i] != null) continue;
            result[i] = SignalConstants.CED_TONE;
        }
        return result;
    }

    public static MediaErr getError(String code, String text) {
        MediaErr result = msmlSipResponseCodeToJsrMediaErr.get(code);
        if (result == null) {
            result = msmlSipResponseTextToJsrMediaErr.get(text);
        }
        if (result == null) {
            result = code.charAt(0) == '4' ? MediaErr.REFUSED : (code.charAt(0) == '5' ? MediaErr.BAD_SERVER : msmlSipResponseCodeToJsrMediaErr.get("200"));
        }
        return result;
    }

    public static EventType translateEventType(Class<?> resource, String msmlEventName) {
        EventType type = null;
        Map<String, EventType> resourceMap = ResourceMapMap.get(resource);
        if (resourceMap != null) {
            type = resourceMap.get(msmlEventName);
        }
        return type;
    }

    public static Qualifier translateQualifier(Class<?> resource, String reason) {
        Qualifier qualifier = ResourceEvent.NO_QUALIFIER;
        if (reason != null) {
            if (resource.equals(DlgcPlayer.class)) {
                qualifier = DlgcMsmlProtocolMessageMappingAssistance.getPlayQualifier(reason);
            } else if (resource.equals(DlgcRecorder.class)) {
                qualifier = DlgcMsmlProtocolMessageMappingAssistance.getRecordQualifier(reason);
            } else if (resource.equals(DlgcSignalDetector.class)) {
                qualifier = DlgcMsmlProtocolMessageMappingAssistance.getSignalDetectorQualifier(reason);
            }
        }
        return qualifier;
    }

    public static DlgcMsmlDialogEventExitStatus getExitDialogEventStatus(MsmlDocument.Msml message) {
        DlgcMsmlDialogEventExitStatus returnExitStatus = new DlgcMsmlDialogEventExitStatus();
        MsmlDocument.Msml.Event msmlEvent = message.getEvent();
        List nameList = msmlEvent.getNameList();
        List valueList = msmlEvent.getValueList();
        Iterator nameIt = nameList.iterator();
        int index = 0;
        while (nameIt.hasNext()) {
            String name = (String)nameIt.next();
            if (name.compareToIgnoreCase("dialog.exit.status") == 0) {
                returnExitStatus.status = (String)valueList.get(index);
            } else if (name.compareToIgnoreCase("dialog.exit.description") == 0) {
                returnExitStatus.description = (String)valueList.get(index);
            }
            ++index;
        }
        return returnExitStatus;
    }

    static {
        PlayerResourceMap = new HashMap<String, EventType>();
        PlayerResourceMap.put("PlayCompleted", PlayerEvent.PLAY_COMPLETED);
        RecorderResourceMap = new HashMap<String, EventType>();
        RecorderResourceMap.put("BaseResponseType.Request.INT_PLAYRECORD", RecorderEvent.RECORD_COMPLETED);
        RecorderResourceMap.put("INFO_ERROR", RecorderEvent.RECORD_COMPLETED);
        VideoRenderResourceMap = new HashMap<String, EventType>();
        VideoRenderResourceMap.put("none", VideoRendererEvent.RENDERING_COMPLETED);
        SignalDetectorResourceMap = new HashMap<String, EventType>();
        SignalDetectorResourceMap.put("BaseResponseType.Request.INT_PLAYCOLLECT", SignalDetectorEvent.RECEIVE_SIGNALS_COMPLETED);
        SignalDetectorResourceMap.put("BaseResponseType.Request.INT_CONFIGURE_LEG", SignalDetectorEvent.SIGNAL_DETECTED);
        ResourceMapMap = new HashMap<Class<? extends Object>, Map<String, EventType>>();
        ResourceMapMap.put(DlgcXPlayer.class, PlayerResourceMap);
        ResourceMapMap.put(DlgcXRecorder.class, RecorderResourceMap);
        ResourceMapMap.put(DlgcXSignalDetector.class, SignalDetectorResourceMap);
        ResourceMapMap.put(DlgcXSignalDetector.class, VideoRenderResourceMap);
        commonReasonToQualifier = new Hashtable<String, Qualifier>();
        commonReasonToQualifier.put("error", ResourceEvent.NO_QUALIFIER);
        commonReasonToQualifier.put("stopped", ResourceEvent.STOPPED);
        playReasonToQualifier = new Hashtable<String, Qualifier>();
        playReasonToQualifier.put("play.complete", PlayerEvent.END_OF_PLAY_LIST);
        playReasonToQualifier.put("duration", PlayerEvent.DURATION_EXCEEDED);
        recordReasonToQualifier = new Hashtable<String, Qualifier>();
        recordReasonToQualifier.put("end_silence", RecorderEvent.SILENCE);
        recordReasonToQualifier.put("init_silence", RecorderEvent.SILENCE);
        recordReasonToQualifier.put("digit", RecorderEvent.RTC_TRIGGERED);
        recordReasonToQualifier.put("max_duration", RecorderEvent.DURATION_EXCEEDED);
        SignalDetectorToQualifier = new Hashtable<String, Qualifier>();
        SignalDetectorToQualifier.put("timeout", SignalDetectorEvent.INITIAL_TIMEOUT_EXCEEDED);
        SignalDetectorToQualifier.put("timeout", SignalDetectorEvent.INTER_SIG_TIMEOUT_EXCEEDED);
        SignalDetectorToQualifier.put("timeout", SignalDetectorEvent.DURATION_EXCEEDED);
        SignalDetectorToQualifier.put("match", SignalDetectorEvent.NUM_SIGNALS_DETECTED);
        SignalDetectorToQualifier.put("returnkey", SignalDetectorEvent.RTC_TRIGGERED);
        SignalDetectorToQualifier.put("escapekey", SignalDetectorEvent.RTC_TRIGGERED);
        SignalDetectorToQualifier.put("interrupted", SignalDetectorEvent.RTC_TRIGGERED);
        SignalDetectorToQualifier.put("stopped", SignalDetectorEvent.STOPPED);
        digitToValue = new Hashtable<Character, Value>();
        digitToValue.put(Character.valueOf('0'), SignalConstants.DTMF_0);
        digitToValue.put(Character.valueOf('1'), SignalConstants.DTMF_1);
        digitToValue.put(Character.valueOf('2'), SignalConstants.DTMF_2);
        digitToValue.put(Character.valueOf('3'), SignalConstants.DTMF_3);
        digitToValue.put(Character.valueOf('4'), SignalConstants.DTMF_4);
        digitToValue.put(Character.valueOf('5'), SignalConstants.DTMF_5);
        digitToValue.put(Character.valueOf('6'), SignalConstants.DTMF_6);
        digitToValue.put(Character.valueOf('7'), SignalConstants.DTMF_7);
        digitToValue.put(Character.valueOf('8'), SignalConstants.DTMF_8);
        digitToValue.put(Character.valueOf('9'), SignalConstants.DTMF_9);
        digitToValue.put(Character.valueOf('A'), SignalConstants.DTMF_A);
        digitToValue.put(Character.valueOf('B'), SignalConstants.DTMF_B);
        digitToValue.put(Character.valueOf('C'), SignalConstants.DTMF_C);
        digitToValue.put(Character.valueOf('D'), SignalConstants.DTMF_D);
        digitToValue.put(Character.valueOf('#'), SignalConstants.DTMF_HASH);
        digitToValue.put(Character.valueOf('*'), SignalConstants.DTMF_STAR);
        msmlSipResponseCodeToJsrMediaErr = new Hashtable<String, MediaErr>();
        msmlSipResponseCodeToJsrMediaErr.put("200", MediaErr.NO_ERROR);
        msmlSipResponseCodeToJsrMediaErr.put("403", MediaErr.REFUSED);
        msmlSipResponseCodeToJsrMediaErr.put("404", MediaErr.NOT_FOUND);
        msmlSipResponseCodeToJsrMediaErr.put("408", MediaErr.TIMEOUT);
        msmlSipResponseCodeToJsrMediaErr.put("410", MediaErr.RESOURCE_UNAVAILABLE);
        msmlSipResponseCodeToJsrMediaErr.put("415", MediaErr.NOT_SUPPORTED);
        msmlSipResponseCodeToJsrMediaErr.put("480", MediaErr.RESOURCE_UNAVAILABLE);
        msmlSipResponseCodeToJsrMediaErr.put("481", MediaErr.NO_TERMINATION);
        msmlSipResponseCodeToJsrMediaErr.put("482", MediaErr.INFINITE_LOOP);
        msmlSipResponseCodeToJsrMediaErr.put("486", MediaErr.BUSY);
        msmlSipResponseCodeToJsrMediaErr.put("501", MediaErr.SERVICE_NOT_DEFINED);
        msmlSipResponseCodeToJsrMediaErr.put("503", MediaErr.RESOURCE_UNAVAILABLE);
        msmlSipResponseCodeToJsrMediaErr.put("504", MediaErr.TIMEOUT);
        msmlSipResponseTextToJsrMediaErr = new Hashtable<String, MediaErr>();
        msmlSipResponseTextToJsrMediaErr.put("BadArg", MediaErr.BAD_ARG);
        msmlSipResponseTextToJsrMediaErr.put("NotFound", MediaErr.NOT_FOUND);
        msmlSipResponseTextToJsrMediaErr.put("Forbidden", MediaErr.REFUSED);
        msmlSipResponseTextToJsrMediaErr.put("Gone", MediaErr.RESOURCE_UNAVAILABLE);
        msmlRegexAuthorizedCharacters = new Vector();
        msmlRegexAuthorizedCharacters.add(Character.valueOf('0'));
        msmlRegexAuthorizedCharacters.add(Character.valueOf('1'));
        msmlRegexAuthorizedCharacters.add(Character.valueOf('2'));
        msmlRegexAuthorizedCharacters.add(Character.valueOf('3'));
        msmlRegexAuthorizedCharacters.add(Character.valueOf('4'));
        msmlRegexAuthorizedCharacters.add(Character.valueOf('5'));
        msmlRegexAuthorizedCharacters.add(Character.valueOf('6'));
        msmlRegexAuthorizedCharacters.add(Character.valueOf('7'));
        msmlRegexAuthorizedCharacters.add(Character.valueOf('8'));
        msmlRegexAuthorizedCharacters.add(Character.valueOf('9'));
        msmlRegexAuthorizedCharacters.add(Character.valueOf('*'));
        msmlRegexAuthorizedCharacters.add(Character.valueOf('#'));
        msmlRegexAuthorizedCharacters.add(Character.valueOf('x'));
        msmlRegexAuthorizedCharacters.add(Character.valueOf('.'));
    }

    private static enum collectReason {
        match("match", 0),
        timeout("timeout", 1),
        stopped("stopped", 2),
        escapekey("escapekey", 3),
        returnkey("returnkey", 4);


        private collectReason(String s, int i) {
        }
    }
}

