/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mixer;

import com.vendor.dialogic.javax.media.mscontrol.DlgcSupportedFeatures;
import com.vendor.dialogic.javax.media.mscontrol.DlgcXMediaConfig;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.video.DlgcVideoRenderer;
import java.io.Serializable;
import java.util.HashSet;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.mixer.MixerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcXMixerConfig
extends DlgcXMediaConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static DlgcSupportedFeatures supportedFeatures;
    private static Logger log;

    public DlgcXMixerConfig() {
    }

    public DlgcXMixerConfig(Configuration<MediaMixer> mxConf) {
        this.resourceList.add(DlgcXSdpPortManager.class);
        if (mxConf != MediaMixer.AUDIO) {
            if (mxConf == MediaMixer.AUDIO_EVENTS) {
                log.warn("The Media Mixer Audio Events Configuration not supported in this release");
            } else if (mxConf != MediaMixer.AUDIO_VIDEO) {
                if (mxConf == MediaMixer.AUDIO_VIDEO_RENDERING) {
                    this.resourceList.add(DlgcVideoRenderer.class);
                } else {
                    log.warn("The Media Mixer Configuration not recognized");
                }
            }
        }
        this.myConfiguration = mxConf;
    }

    public static DlgcXMediaConfig configurationInstance(Configuration<MediaMixer> predefinedConfig) {
        return new DlgcXMixerConfig(predefinedConfig);
    }

    public static DlgcSupportedFeatures loadSupportedFeatures() {
        return supportedFeatures;
    }

    static {
        log = LoggerFactory.getLogger(DlgcXMixerConfig.class);
        supportedFeatures = new DlgcSupportedFeatures();
        HashSet<Parameter> sp = new HashSet<Parameter>();
        sp.add(MediaMixer.MAX_PORTS);
        sp.add(MediaMixer.ENABLED_EVENTS);
        supportedFeatures.setSfParameters(sp);
        HashSet<EventType> sev = new HashSet<EventType>();
        sev.add(MixerEvent.ACTIVE_INPUTS_CHANGED);
        sev.add(MixerEvent.MOST_ACTIVE_INPUT_CHANGED);
        supportedFeatures.setSfEventTypes(sev);
        HashSet<Qualifier> sq = new HashSet<Qualifier>();
        sq.add(MixerEvent.NO_QUALIFIER);
        sq.add(MixerEvent.STOPPED);
        supportedFeatures.setSfQualifiers(sq);
    }
}

