/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mixer;

import com.vendor.dialogic.javax.media.mscontrol.DlgcISipB2BUAMsProtocolBridge;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProtocolException;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.DlgcXMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXRecorder;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcActiveTalker;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapter;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerEvent;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerOverlay;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXConferenceControlLeg;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMixerAdapter;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMixerAdapterConfig;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMixerConfig;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnectionProxy;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import com.vendor.dialogic.javax.media.mscontrol.video.DlgcVideoLayout;
import com.vendor.dialogic.javax.media.mscontrol.video.DlgcVideoRenderEvent;
import com.vendor.dialogic.javax.media.mscontrol.video.DlgcVideoRenderer;
import commonj.work.Work;
import commonj.work.WorkItem;
import commonj.work.WorkManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaEventNotifier;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.WrongStateException;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.mixer.MixerAdapter;
import javax.media.mscontrol.mixer.MixerEvent;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.media.mscontrol.resource.AllocationEvent;
import javax.media.mscontrol.resource.video.VideoLayout;
import javax.media.mscontrol.resource.video.VideoRenderer;
import javax.servlet.sip.SipApplicationSession;
import org.mobicents.javax.servlet.sip.SipFactoryExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcXMediaMixer
extends DlgcMediaMixer {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcXMediaMixer.class);
    private DlgcNetworkConnection activeControlLeg;
    private List<DlgcNetworkConnection> controlLegList;
    private Lock controlLegLock;
    private DlgcVideoRenderer videoRenderer = null;
    private DlgcVideoLayout curVideoLayout = null;
    private Vector<DlgcMixerOverlay> preOverlayList = null;
    private Vector<DlgcMixerOverlay> curOverlayList = null;
    private Boolean bRemoveConference = null;
    protected Map<String, String> mediaObjectIdMap;
    private Boolean bVas = false;
    private boolean activeInputsChanged = false;
    private boolean mixerReleased = false;
    private Integer max_active_inputs = 2;
    private ConfRecordingState confRecordingState = null;
    private MixerOperationalMode mode;
    private EMixerDeleteWhen deleteWhenMode = EMixerDeleteWhen.NOCONTROL;
    private String nonControlConfLegSipReqURI;
    private DlgcNetworkConnection confNoControlLeg;
    private DlgcXConferenceControlLeg controlLeg;
    private MixerState mixerState = MixerState.INITIAL_STATE;

    public boolean isMixerReleased() {
        return this.mixerReleased;
    }

    public void setMixerReleased(boolean mixerReleased) {
        this.mixerReleased = mixerReleased;
    }

    public ConfRecordingState getConfRecordingState() {
        log.debug("DlgcXMediaMixer::getConfRecordingState: recording state: " + this.confRecordingState.toString());
        return this.confRecordingState;
    }

    public void setConfRecordingState(ConfRecordingState confRecordingState) {
        if (this.controlLeg != null) {
            this.confRecordingState = confRecordingState;
            log.debug("DlgcXMediaMixer::setConfRecordingState: recording state: " + confRecordingState.toString());
        }
    }

    public void setVas(Boolean bSet) {
        this.bVas = bSet;
    }

    public Boolean isVasSet() {
        return this.bVas;
    }

    public EMixerDeleteWhen getDeleteWhenMode() {
        return this.deleteWhenMode;
    }

    public DlgcNetworkConnection getNoControlLeg() {
        return this.confNoControlLeg;
    }

    @Override
    public void release() {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "DlgcXMediaMixer release()");
        if (this.controlLeg != null) {
            log.debug("FYI: Calling destroyConference via DlgcXMediaMixer based on mixer control leg");
            try {
                this.controlLeg.DestroyConference();
            }
            catch (MsControlException e) {
                log.error(e.toString());
            }
        } else {
            log.debug("FYI: NOT CALLING destroyConference via DlgcMediaMixer...");
        }
        log.debug(appLogId + "Calling Mixer destroyConference DONE");
    }

    public void changeAllConfPartiesToIVR_RDY_STATE() {
        this.controlLegLock.lock();
        log.debug("Entering changeAllConfPartiesToIVR_RDY_STATE METHOD");
        int numInList = this.controlLegList.size();
        log.debug("changeAllConfPartiesToIVR_RDY_STATE():: size of list: " + new Integer(numInList).toString());
        for (DlgcXNetworkConnection dlgcXNetworkConnection : this.controlLegList) {
            try {
                DlgcXSdpPortManager sxp = (DlgcXSdpPortManager)dlgcXNetworkConnection.getSdpPortManager();
                log.debug("changeAllConfPartiesToIVR_RDY_STATE():: change state to IVR RDY for leg:  " + dlgcXNetworkConnection.getMediaObject());
                sxp.forceStateChangeToIVR_RDY_STATE();
            }
            catch (MsControlException e) {
                e.printStackTrace();
                log.error("changeAllConfPartiesToIVR_RDY_STATE() exception: " + e.toString());
            }
        }
        this.controlLegLock.unlock();
    }

    public Integer getMax_active_inputs() {
        return this.max_active_inputs;
    }

    public List<DlgcNetworkConnection> getActiveLegList() {
        return this.controlLegList;
    }

    public DlgcXConferenceControlLeg getControlLeg() {
        return this.controlLeg;
    }

    public DlgcXMediaMixer(MediaConfig cfg, MediaSession ms) {
        super(cfg, ms, "XMX-");
        DlgcXMixerConfig mixerconfig = (DlgcXMixerConfig)cfg;
        this.curOverlayList = new Vector();
        this.preOverlayList = new Vector();
        this.confNoControlLeg = null;
        this.controlLeg = null;
        this.activeInputsChanged = false;
        this.mixerReleased = false;
        if (mixerconfig.getMyConfiguraiton() == MediaMixer.AUDIO_VIDEO_RENDERING) {
            this.videoRenderer = new DlgcVideoRenderer(this);
            this.resourceMap.put(VideoRenderer.class, this.videoRenderer);
        } else {
            this.videoRenderer = null;
        }
        this.activeControlLeg = null;
        this.controlLegList = new Vector<DlgcNetworkConnection>();
        this.controlLegLock = new ReentrantLock();
        this.bRemoveConference = new Boolean(false);
        if (DlgcInstrumentPropertyMgr.bConnectorMixerConferenceUse_Control_Leg.booleanValue()) {
            log.debug("DlgcXMediaMixer::CTOR: using mixer conference control leg mode: CONTROL_LEG_MODE_CONFIGURED");
            this.mode = MixerOperationalMode.CONTROL_LEG_MODE_CONFIGURED;
        } else {
            log.debug("DlgcXMediaMixer::CTOR: using call leg conference control leg mode: NON_CONTROl_LEG_CREATION_PENDING_MODE");
            this.mode = MixerOperationalMode.NON_CONTROl_LEG_CREATION_PENDING_MODE;
        }
        this.nonControlConfLegSipReqURI = null;
        this.mediaObjectIdMap = new HashMap<String, String>();
        this.confRecordingState = ConfRecordingState.NOT_RECORDING;
        this.deleteWhenMode = EMixerDeleteWhen.NOCONTROL;
        log.debug("DlgcXMediaMixer::CTOR: Conference DeleteWhen: " + this.deleteWhenMode.toString());
    }

    public void setDeleteConferenceWhenMode(EMixerDeleteWhen mode) {
        this.deleteWhenMode = mode;
    }

    public DlgcXMediaMixer(MediaConfig cfg, MediaSession ms, Parameters params) {
        super(cfg, ms, params, "XMX-");
        this.curOverlayList = new Vector();
        this.preOverlayList = new Vector();
        DlgcXMixerConfig mixerconfig = (DlgcXMixerConfig)cfg;
        this.videoRenderer = mixerconfig.getMyConfiguraiton() == MediaMixer.AUDIO_VIDEO_RENDERING ? new DlgcVideoRenderer(this) : null;
        this.activeInputsChanged = false;
        this.confNoControlLeg = null;
        this.controlLeg = null;
        this.mixerReleased = false;
        this.activeControlLeg = null;
        this.controlLegList = new Vector<DlgcNetworkConnection>();
        this.controlLegLock = new ReentrantLock();
        this.bRemoveConference = new Boolean(false);
        if (DlgcInstrumentPropertyMgr.bConnectorMixerConferenceUse_Control_Leg.booleanValue()) {
            log.debug("DlgcXMediaMixer::CTOR: using mixer conference control leg mode: CONTROL_LEG_MODE_CONFIGURED");
            this.mode = MixerOperationalMode.CONTROL_LEG_MODE_CONFIGURED;
        } else {
            log.debug("DlgcXMediaMixer::CTOR: using call leg conference control leg mode: ");
            this.mode = MixerOperationalMode.NON_CONTROl_LEG_CREATION_PENDING_MODE;
        }
        this.nonControlConfLegSipReqURI = null;
        this.mediaObjectIdMap = new HashMap<String, String>();
        this.deleteWhenMode = EMixerDeleteWhen.NOCONTROL;
        this.confRecordingState = ConfRecordingState.NOT_RECORDING;
        if (params == null) {
            log.debug("DlgcXMediaMixer::CTOR: No Parameters passed in");
        } else {
            EventType evType;
            if (!params.isEmpty() && params.containsKey((Object)MediaMixer.ENABLED_EVENTS) && (evType = (EventType)params.get((Object)MediaMixer.ENABLED_EVENTS)).equals(MixerEvent.ACTIVE_INPUTS_CHANGED)) {
                this.activeInputsChanged = true;
                log.debug("DlgxMediaMixer::CTOR - Active Inputs Changed Event Enabled");
            }
            if (!params.isEmpty() && params.containsKey((Object)MediaMixer.MAX_ACTIVE_INPUTS)) {
                this.max_active_inputs = (Integer)params.get((Object)MediaMixer.MAX_ACTIVE_INPUTS);
                log.debug("DlgxMediaMixer::CTOR - MAX_ACTIVE_INPUTS set to: " + this.max_active_inputs.toString());
            }
        }
        log.debug("DlgcXMediaMixer::CTOR: Conference DeleteWhen: " + this.deleteWhenMode.toString());
    }

    public boolean getActiveInputsChanged() {
        return this.activeInputsChanged;
    }

    public Boolean getRemoveConferenceStatus() {
        Boolean stat = null;
        this.controlLegLock.lock();
        stat = this.bRemoveConference;
        this.controlLegLock.unlock();
        return stat;
    }

    public void initMixer() {
        log.debug("DlgcXMediaMixer::initMixer()");
        this.confNoControlLeg = null;
        this.controlLeg = null;
        this.activeControlLeg = null;
        this.controlLegList = new Vector<DlgcNetworkConnection>();
        this.controlLegLock = new ReentrantLock();
        this.bRemoveConference = new Boolean(false);
        if (DlgcInstrumentPropertyMgr.bConnectorMixerConferenceUse_Control_Leg.booleanValue()) {
            log.debug("DlgcXMediaMixer::CTOR: using mixer conference control leg mode: CONTROL_LEG_MODE_CONFIGURED");
            this.mode = MixerOperationalMode.CONTROL_LEG_MODE_CONFIGURED;
        } else {
            log.debug("DlgcXMediaMixer::CTOR: using call leg conference control leg mode: NON_CONTROl_LEG_CREATION_PENDING_MODE");
            this.mode = MixerOperationalMode.NON_CONTROl_LEG_CREATION_PENDING_MODE;
        }
        this.deleteWhenMode = EMixerDeleteWhen.NOCONTROL;
        this.setMixerState(MixerState.INITIAL_STATE);
    }

    public void sendStop(DlgcSipMessage msg, DlgcXRecorder dlgcXRecorder) {
        log.debug("Entering DlgcXMediaMixer::sendStop");
        if (this.mode == MixerOperationalMode.CONTROL_LEG_MODE_CONFIRMED) {
            if (this.getConfRecordingState() == ConfRecordingState.RECORDING) {
                log.debug("DlgcXMediaMixer::sendRecordMessage:: Mixer Control Leg is Confirmed and In Conference - sending Recording Request");
                this.mixerState.stopRecording(this, msg, dlgcXRecorder);
            } else {
                String error = "Stop Recording operation can't be executed. Mixer is not in Conference Recording State";
                log.error(error);
            }
        } else {
            String error = "Stop Recording operation can't be executed. Mixer Control Leg Is not in Recording Mode";
            log.error(error);
        }
        log.debug("Leaving DlgcXMediaMixer::sendStop");
    }

    public String getProperControlLegConfIdForConfCommand(DlgcSdpPortManager sdpMgr) {
        log.debug("getProperControlLegConfIdForConfCommand:: conferenceFullID: " + this.conferenceId);
        return this.conferenceId;
    }

    @Override
    public <R> R getResource(Class<R> res) throws MsControlException {
        if (res == VideoRenderer.class) {
            return (R)this.videoRenderer;
        }
        return super.getResource(res);
    }

    public String getProperControlLegConfId(DlgcSdpPortManager sdpMgr) {
        String conferenceFullId;
        MixerOperationalMode opMode = this.getMixerControlMode();
        log.debug("OPMODE = " + opMode.toString());
        if (opMode == MixerOperationalMode.CONTROL_LEG_MODE_CONFIGURED || opMode == MixerOperationalMode.CONTROL_LEG_MODE_CONFIRMED) {
            conferenceFullId = "conf:" + this.getConfId();
        } else {
            conferenceFullId = "conf:" + this.conferenceId;
            log.debug("Conference ID: " + conferenceFullId);
        }
        return conferenceFullId;
    }

    public void setSipReqUri(String uri) {
        this.nonControlConfLegSipReqURI = uri;
    }

    public String getSipReqUri() {
        return this.nonControlConfLegSipReqURI;
    }

    public void sendActiveTalkerEvent(DlgcMixerEvent activeTalkerEvent) {
        if (!this.released && this.mediaMixerEventListenerList != null && !this.mediaMixerEventListenerList.isEmpty()) {
            Iterator iter = this.mediaMixerEventListenerList.iterator();
            if (iter == null) {
                return;
            }
            while (iter.hasNext()) {
                ((MediaEventListener)iter.next()).onEvent((MediaEvent)activeTalkerEvent);
            }
        }
    }

    public DlgcNetworkConnection getFromProxyNC(DlgcNetworkConnectionProxy ncp) throws MsControlException {
        try {
            SipApplicationSession appSession = ncp.getProxySAS(ncp.getProxyId());
            String containerProxyId = ncp.getContainerProxyId();
            String mediaId = ncp.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxyId);
            return nc;
        }
        catch (Exception e) {
            log.error("Failed to create getSdpPortManager", (Throwable)e);
            throw new MsControlException("Failed to create getSdpPortManager", (Throwable)e);
        }
    }

    public DlgcNetworkConnection getFromProxyNC() throws MsControlException {
        DlgcNetworkConnectionProxy ncp = (DlgcNetworkConnectionProxy)this.controlLeg.controlNC;
        try {
            SipApplicationSession appSession = ncp.getProxySAS(ncp.getProxyId());
            String containerProxyId = ncp.getContainerProxyId();
            String mediaId = ncp.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxyId);
            return nc;
        }
        catch (Exception e) {
            log.error("Failed to create getSdpPortManager", (Throwable)e);
            throw new MsControlException("Failed to create getSdpPortManager", (Throwable)e);
        }
    }

    public MixerState getMixerState() {
        return this.mixerState;
    }

    public void setMixerState(MixerState s) {
        this.mixerState = s;
    }

    public void addNewConfLegToListIfNotAddedAlready(DlgcNetworkConnection nc) {
        this.controlLegLock.lock();
        if (this.controlLegList.contains(nc)) {
            log.debug("CONTROL LIST: addNewConfLegToListIfNotAddedAlready: not adding leg already in list " + nc.getMediaObject());
        } else {
            log.debug("CONTROL LIST: addNewConfLegToListIfNotAddedAlready:  adding leg to list " + nc.getMediaObject());
            if (this.activeControlLeg == null) {
                this.activeControlLeg = nc;
            }
            if (this.deleteWhenMode.compareTo(EMixerDeleteWhen.NOCONTROL) == 0) {
                this.confNoControlLeg = this.activeControlLeg;
                log.debug("addNewConfLegToListIfNotAddedAlready():: Using Unique Conference Control msml configuration as nocontrol: Leg set to : " + this.confNoControlLeg.toString());
            }
            log.debug("CONTROL LIST: addNewConfLegToListIfNotAddedAlready: adding active leg: " + nc.getMediaObject());
            this.controlLegList.add(nc);
            log.debug("CONTROL LIST: addNewConfLegToListIfNotAddedAlready: list size after add: " + new Integer(this.controlLegList.size()).toString());
        }
        this.controlLegLock.unlock();
    }

    public void addNewControlLegToList(DlgcNetworkConnection nc) {
        this.controlLegLock.lock();
        if (this.activeControlLeg == null) {
            this.activeControlLeg = nc;
            if (this.deleteWhenMode.compareTo(EMixerDeleteWhen.NOCONTROL) == 0) {
                this.confNoControlLeg = this.activeControlLeg;
                log.debug("addNewControlLegToList():: Using Unique Conference Control msml configuration as nocontrol: Leg set to : " + this.confNoControlLeg.toString());
            }
        }
        log.debug("CONTROL LIST: addNewControlLegToList: adding active leg: " + nc.getMediaObject());
        this.controlLegList.add(nc);
        log.debug("CONTROL LIST: addNewControlLegToList: list size after add: " + new Integer(this.controlLegList.size()).toString());
        this.controlLegLock.unlock();
    }

    public int howManyPossibleNonControlConfLegRemaining() {
        int s = 0;
        this.controlLegLock.lock();
        s = this.controlLegList.size();
        log.debug("CONTROL LIST: howManyPossibleNonControlConfLegRemaining: list size: " + new Integer(s).toString());
        if (this.activeControlLeg != null) {
            log.debug("CONTROL LIST: howManyPossibleNonControlConfLegRemaining: activeControlLeg is: " + this.activeControlLeg.getMediaObject());
        } else {
            log.debug("CONTROL LIST: howManyPossibleNonControlConfLegRemaining: activeControlLeg is null ");
        }
        this.controlLegLock.unlock();
        return s;
    }

    public void removeControlLegFromList(DlgcNetworkConnection nc) {
        this.controlLegLock.lock();
        log.debug("CONTROL LIST: removeControlLegFromList: removed  leg: " + nc.toString());
        this.controlLegList.remove(nc);
        if (nc.equals(this.activeControlLeg)) {
            if (this.controlLegList.size() > 0) {
                this.activeControlLeg = this.controlLegList.get(0);
                log.debug("CONTROL LIST: removeControlLegFromList: new control  leg: " + this.activeControlLeg.getMediaObject());
                log.debug("CONTROL LIST: removeControlLegFromList: list size after remove: " + new Integer(this.controlLegList.size()).toString());
            } else {
                this.activeControlLeg = null;
                log.debug("CONTROL LIST: removeControlLegFromList: the last control leg was removed..no errors");
                log.debug("DlgcXMediaMixer::removeControlLegFromList calling etMixerControlMode(MixerOperationalMode.NON_CONTROl_LEG_CREATION_PENDING_MODE");
                this.setMixerControlMode(MixerOperationalMode.NON_CONTROl_LEG_CREATION_PENDING_MODE);
                this.setSipReqUri(null);
            }
        }
        this.controlLegLock.unlock();
    }

    public boolean equals(Object that) {
        boolean retStatus = false;
        if (!(that instanceof DlgcMediaMixer)) {
            retStatus = false;
        } else {
            DlgcMediaMixer mx = (DlgcMediaMixer)that;
            if (this.getMediaObject().compareToIgnoreCase(mx.getMediaObject()) == 0) {
                retStatus = true;
            }
        }
        return retStatus;
    }

    private void printActiveControlLegList() {
        DlgcNetworkConnection nc = null;
        Iterator<DlgcNetworkConnection> itNC = null;
        itNC = this.controlLegList.iterator();
        log.debug("===========================================================");
        while (itNC.hasNext()) {
            nc = itNC.next();
            log.debug("printActiveControlLegList: " + nc.getMediaObject());
        }
        log.debug("===========================================================");
    }

    public int checkAndRemoveControlLegFromList(DlgcNetworkConnection nc) {
        this.controlLegLock.lock();
        log.debug("CONTROL LIST: removeControlLegFromList: removed  leg: " + nc.toString() + " NC MSID: " + nc.getMediaObject());
        int numInList = this.controlLegList.size();
        log.debug("checkAndRemoveControlLegFromList():: size of list: " + new Integer(numInList).toString());
        if (numInList == 1) {
            this.bRemoveConference = true;
            log.debug("CONTROL LIST: removeControlLegFromList: only 1 control leg found");
        } else if (numInList > 1) {
            this.removeControlLegFromList(nc);
            if (nc.equals(this.activeControlLeg)) {
                if (this.controlLegList.size() > 0) {
                    this.activeControlLeg = this.controlLegList.get(0);
                    log.debug("CONTROL LIST: removeControlLegFromList: new control  leg: " + this.activeControlLeg.toString());
                    log.debug("CONTROL LIST: removeControlLegFromList: list size after remove: " + new Integer(this.controlLegList.size()).toString());
                } else {
                    this.activeControlLeg = null;
                    log.debug("CONTROL LIST: removeControlLegFromList: the last control leg was removed..no errors");
                    log.debug("DlgcXMediaMixer::checkAndRemoveControlLegFromList calling etMixerControlMode(MixerOperationalMode.NON_CONTROl_LEG_CREATION_PENDING_MODE");
                    this.setMixerControlMode(MixerOperationalMode.NON_CONTROl_LEG_CREATION_PENDING_MODE);
                    this.setSipReqUri(null);
                }
            }
        }
        this.controlLegLock.unlock();
        return numInList;
    }

    public DlgcNetworkConnection getActiveControlLeg() {
        return this.activeControlLeg;
    }

    public String getControlLegMsmlConferenceId() {
        String msmlConfId = null;
        try {
            DlgcIpmsSession msSession = ((DlgcNetworkConnection)this.getSdpPortMgrResource().getContainer()).getDlgIpmsSession();
            msmlConfId = msSession.calculateDialogTargetField();
        }
        catch (MsControlException e) {
            log.debug("An exception occured in DlgcXmediaMixer: getControlLegMsmlConferenceId" + (Object)((Object)e));
            e.printStackTrace();
        }
        return msmlConfId;
    }

    @Override
    public MixerAdapter createMixerAdapter(Configuration<MixerAdapter> config, Parameters params) throws MsControlException {
        DlgcXMediaSession ms = (DlgcXMediaSession)this.getMediaSession();
        if (config == MixerAdapter.DTMF_CLAMP) {
            log.debug("DTMF CLAMP ON");
        } else if (config == MixerAdapter.DTMFCLAMP_VOLUME) {
            log.debug("DTMF CLAMP AND VOLUME ON");
        }
        if (null != params && null != params.get((Object)MediaObject.MEDIAOBJECT_ID)) {
            if (!this.mediaObjectIdMap.isEmpty() && this.mediaObjectIdMap.containsKey(params.get((Object)MediaObject.MEDIAOBJECT_ID))) {
                throw new MsControlException("A mixer adapter exist with the same mediaobject id");
            }
            if (this.checkInvalidMediaobjectIdSyntax((String)params.get((Object)MediaObject.MEDIAOBJECT_ID))) {
                throw new MsControlException("A mixer adapter mediaobject id can not start with special character");
            }
        }
        if (this.released) {
            throw new WrongStateException("This MediaSession has been released");
        }
        DlgcXMixerAdapter mxa = new DlgcXMixerAdapter(this, (MediaSession)ms, config);
        this.addMediaObject(mxa);
        ms.getProxyIdMap().put(mxa.getProxyId(), mxa);
        if (null != params && !params.isEmpty() && null != params.get((Object)MediaObject.MEDIAOBJECT_ID)) {
            this.mediaObjectIdMap.put((String)params.get((Object)MediaObject.MEDIAOBJECT_ID), "MixerAdapter");
        }
        return mxa;
    }

    @Override
    public MixerAdapter createMixerAdapter(MediaConfig conf, Parameters params) throws MsControlException {
        DlgcXMediaSession ms = (DlgcXMediaSession)this.getMediaSession();
        Configuration mxc = (Configuration)conf;
        if (mxc == MixerAdapter.DTMF_CLAMP) {
            log.debug("DTMF CLAMP ON");
        } else if (mxc == MixerAdapter.DTMFCLAMP_VOLUME) {
            log.debug("DTMF CLAMP AND VOLUME ON");
        }
        DlgcXMixerAdapterConfig mxaConfig = null;
        try {
            mxaConfig = (DlgcXMixerAdapterConfig)conf;
        }
        catch (Exception e) {
            log.error("Error typcasting MediaConfig to DlgcXMixerAdapterConfig", (Throwable)e);
            return null;
        }
        if (null != params && null != params.get((Object)MediaObject.MEDIAOBJECT_ID)) {
            if (!this.mediaObjectIdMap.isEmpty() && this.mediaObjectIdMap.containsKey(params.get((Object)MediaObject.MEDIAOBJECT_ID))) {
                throw new MsControlException("A mixer adapter exist with the same mediaobject id");
            }
            if (this.checkInvalidMediaobjectIdSyntax((String)params.get((Object)MediaObject.MEDIAOBJECT_ID))) {
                throw new MsControlException("A mixer adapter mediaobject id can not start with special character");
            }
        }
        if (this.released) {
            throw new WrongStateException("This MediaSession has been released");
        }
        if (conf == null) {
            throw new MsControlException("MediaConfig parameter cannot be null");
        }
        DlgcXMixerAdapter mxa = new DlgcXMixerAdapter(this, (MediaSession)ms, mxaConfig);
        this.addMediaObject(mxa);
        ms.getProxyIdMap().put(mxa.getProxyId(), mxa);
        if (null != params && !params.isEmpty() && null != params.get((Object)MediaObject.MEDIAOBJECT_ID)) {
            this.mediaObjectIdMap.put((String)params.get((Object)MediaObject.MEDIAOBJECT_ID), "MixerAdapter");
        }
        return mxa;
    }

    private boolean checkInvalidMediaobjectIdSyntax(String mediaobjectId) {
        String s = mediaobjectId.substring(0, 1);
        if (Character.isWhitespace(s.charAt(0))) {
            return true;
        }
        return s == null ? false : s.matches("[^A-Za-z0-9 ]");
    }

    protected void sendDestroyConferenceMsg(DlgcSdpPortManager sdppm) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + ":sendDestroyNonControlConferenceLeg entering");
        String confSipReqUri = null;
        String thisSipReqUri = sdppm.getSipReqUri();
        DlgcNetworkConnection activeNC = this.getActiveControlLeg();
        if (activeNC == null) {
            log.error("Trying to Join a NC to a non Coference Control Leg...but Control Conference Leg NC not found : null..aborting request");
            return;
        }
        confSipReqUri = this.getSipReqUri();
        if (confSipReqUri.compareToIgnoreCase(thisSipReqUri) != 0) {
            log.warn("Note that the SipReqURIs do not match between the Non Control Conference Leg NC and this NC...using to Control Leg NC URI");
        }
        try {
            String conferenceFullId = this.getProperControlLegConfIdForConfCommand(sdppm);
            String user = confSipReqUri;
            String request = DlgcSipServlet.getProtocolBridge().destroyConfigureConferenceMsg(conferenceFullId);
            log.debug("DlgcXMediaMixer::sendDestroyConferenceMsg() sending destroyconference on the following active control leg: " + ((NetworkConnection)sdppm.getContainer()).toString());
            this.sendSipMessage(new DlgcSipMessage((JoinableContainer)sdppm.getContainer(), "INFO", user, "msml", request, null), sdppm);
        }
        catch (DlgcProtocolException e) {
            log.debug(appLogId + ":sendDestroyConference Error destroying conference MSML request - exception:", (Throwable)((Object)e));
            this.initMixer();
            this.setMixerState(MixerState.INITIAL_STATE);
        }
        log.debug(appLogId + ":sendDestroyConference Leaving");
    }

    protected void sendDestroyConferenceControlLegMsg(DlgcSdpPortManager sdppm) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + ":sendDestroyConferenceControlLegMsg entering");
        String confSipReqUri = null;
        String thisSipReqUri = sdppm.getSipReqUri();
        DlgcXNetworkConnection activeNC = (DlgcXNetworkConnection)this.controlLeg.getResourceContainerFromProxy((DlgcProxy)this.controlLeg.controlNC);
        DlgcXSdpPortManager sdpMgr = (DlgcXSdpPortManager)activeNC.getSdpPortMgrResource();
        if (activeNC == null) {
            log.error("Trying to Join a NC to a non Coference Control Leg...but Control Conference Leg NC not found : null..aborting request");
            return;
        }
        confSipReqUri = this.getSipReqUri();
        if (confSipReqUri.compareToIgnoreCase(thisSipReqUri) != 0) {
            log.warn("Note that the SipReqURIs do not match between the  Control Conference Leg NC and this NC...using to Control Leg NC URI");
        }
        try {
            this.controlLeg.changeAllControlLegJoinedConfPartiesToIVR_RDY_STATE();
            String conferenceFullId = this.getProperControlLegConfIdForConfCommand(sdppm);
            String user = confSipReqUri;
            String request = DlgcSipServlet.getProtocolBridge().destroyConfigureConferenceMsg(conferenceFullId);
            log.debug("DlgcXMediaMixer::sendDestroyConferenceMsg() sending destroyconference on the following active control leg: " + ((NetworkConnection)sdppm.getContainer()).toString());
            log.debug("DlgcXMediaMixer::sendDestroyConferenceMsg() settting SdpPortManager State to: xDestroyingMixerConfControlLegPendingState");
            ((DlgcXNetworkConnection)sdppm.getContainer()).getFSM().setState(DlgcXSdpPortManagerStates.xDestroyingMixerConfControlLegPendingState);
            this.setMixerReleased(true);
            this.sendSipMessage(new DlgcSipMessage((JoinableContainer)sdppm.getContainer(), "INFO", user, "msml", request, null), sdppm);
        }
        catch (DlgcProtocolException e) {
            log.debug(appLogId + ":sendDestroyConference Error destroying conference MSML request - exception:", (Throwable)((Object)e));
            this.initMixer();
            this.setMixerState(MixerState.INITIAL_STATE);
        }
        log.debug(appLogId + ":sendDestroyConference Leaving");
    }

    public void createNewConferenceUsingNonControlLeg(DlgcXSdpPortManager sdppm) throws DlgcProtocolException {
        DlgcNetworkConnection nc = (DlgcNetworkConnection)sdppm.getContainer();
        DlgcMediaSession ms = (DlgcMediaSession)nc.getMediaSession();
        String sipReqUri = sdppm.getSipReqUri();
        this.setSipReqUri(sipReqUri);
        String ncTransId = nc.getDlgIpmsSession().calculateDialogTargetField();
        String conferenceFullId = this.getProperControlLegConfIdForConfCommand(sdppm);
        String user = sipReqUri;
        Parameters params = this.getParameters(null);
        try {
            String request = DlgcSipServlet.getProtocolBridge().createConfigureConferenceMsg(this.config, (DlgcParameters)params, ncTransId, conferenceFullId, this);
            log.debug("DlgcXMediaMixer::createNewConferenceUsingNonControlLeg calling etMixerControlMode(MixerOperationalMode.NON_CONTROl_LEG_CREATION_PENDING_MODE");
            this.setMixerControlMode(MixerOperationalMode.NON_CONTROl_LEG_CREATION_PENDING_MODE);
            this.sendSipMessage(new DlgcSipMessage((JoinableContainer)sdppm.getContainer(), "INFO", user, "msml", request, null), sdppm);
            this.curOverlayList.clear();
            if (this.curVideoLayout != null) {
                Iterator<DlgcVideoLayout.displayRegion> itOverlay = this.curVideoLayout.displayRegionList.iterator();
                DlgcVideoLayout.displayRegion dr2 = null;
                for (DlgcVideoLayout.displayRegion dr2 : this.curVideoLayout.displayRegionList) {
                    if (dr2.type != "img" && dr2.type != "text") continue;
                    this.curOverlayList.add(new DlgcMixerOverlay(dr2.type, dr2.name, dr2.overlayId));
                }
            }
        }
        catch (DlgcProtocolException e) {
            log.debug("sendMSMLConferenceRequest Error creating conference MSML request - exception:", (Throwable)((Object)e));
            this.setMixerState(MixerState.INITIAL_STATE);
            throw e;
        }
    }

    public void createConferfenceUsingControlLeg(DlgcXSdpPortManager sdppm) throws DlgcProtocolException {
        log.debug("Entering createConferfenceUsingControlLeg");
        DlgcNetworkConnection nc = (DlgcNetworkConnection)sdppm.getContainer();
        DlgcMediaSession ms = (DlgcMediaSession)nc.getMediaSession();
        String sipReqUri = sdppm.getSipReqUri();
        this.setSipReqUri(sipReqUri);
        String ncTransId = nc.getDlgIpmsSession().calculateDialogTargetField();
        String conferenceFullId = this.getProperControlLegConfIdForConfCommand(sdppm);
        String user = sipReqUri;
        Parameters params = this.getParameters(null);
        try {
            String request = DlgcSipServlet.getProtocolBridge().createConfigureConferenceMsg(this.config, (DlgcParameters)params, ncTransId, conferenceFullId, this);
            log.debug("DlgcXMediaMixer::createConferfenceUsingControlLeg calling setMixerControlMode(MixerOperationalMode.CONTROL_LEG_MODE_CONFIGURED");
            this.setMixerControlMode(MixerOperationalMode.CONTROL_LEG_MODE_CONFIGURED);
            this.sendSipMessage(new DlgcSipMessage((JoinableContainer)sdppm.getContainer(), "INFO", user, "msml", request, null), sdppm);
            this.curOverlayList.clear();
            if (this.curVideoLayout != null) {
                Iterator<DlgcVideoLayout.displayRegion> itOverlay = this.curVideoLayout.displayRegionList.iterator();
                DlgcVideoLayout.displayRegion dr2 = null;
                for (DlgcVideoLayout.displayRegion dr2 : this.curVideoLayout.displayRegionList) {
                    if (dr2.type != "img" && dr2.type != "text") continue;
                    this.curOverlayList.add(new DlgcMixerOverlay(dr2.type, dr2.name, dr2.overlayId));
                }
            }
        }
        catch (DlgcProtocolException e) {
            log.debug("createConferfenceUsingControlLeg Error creating conference MSML request - exception:", (Throwable)((Object)e));
            this.setMixerState(MixerState.INITIAL_STATE);
            throw e;
        }
    }

    public boolean createMixerConferenceControlLeg(DlgcSdpPortManager portMgr) {
        log.debug("DlgcMediaMixer::createMixerConferenceControlLeg() sending INVITE to MS to create Mixer Control Conference leg");
        boolean status = true;
        this.createMixerSAS();
        DlgcXSdpPortManager xPortMgr = (DlgcXSdpPortManager)portMgr;
        String conferenceFullId = this.getProperControlLegConfIdForConfCommand(xPortMgr);
        try {
            String sdp = DlgcSipServlet.sipB2BUA.createNoMediaSDP();
            String user = "conf=" + conferenceFullId;
            MimeMultipart content = new MimeMultipart();
            InternetHeaders sdpHeader = new InternetHeaders();
            sdpHeader.addHeader("Content-Type", "application/sdp");
            MimeBodyPart sdpBodyPart = new MimeBodyPart(sdpHeader, sdp.getBytes());
            InternetHeaders msmlHeader = new InternetHeaders();
            msmlHeader.addHeader("Content-Type", "application/mediaservercontrol+xml");
            content.addBodyPart((BodyPart)sdpBodyPart);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            content.writeTo((OutputStream)stream);
            log.debug("DlgcXMediaMixer::createMixerConferenceControlLeg calling etMixerControlMode(MixerOperationalMode.NON_CONTROl_LEG_CREATION_PENDING_MODE");
            this.setMixerControlMode(MixerOperationalMode.NON_CONTROl_LEG_CREATION_PENDING_MODE);
            this.sendSipMessage(new DlgcSipMessage(this, "INVITE", user, content.getContentType(), stream.toString(), null), xPortMgr);
        }
        catch (MessagingException e) {
            log.error("Exception: " + e.toString());
            status = false;
        }
        catch (IOException e) {
            log.error("Exception: " + e.toString());
            status = false;
        }
        return status;
    }

    protected void destroyMixerConferenceControlLeg() {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "Entering MIXER destroyMixerConferenceControlLeg");
        if (this.conferenceCreated) {
            log.debug("MIXER destroyMixerConferenceControlLeg Sending BYE to MS to release the leg");
            DlgcSipMessage message = new DlgcSipMessage(this, "BYE", null, "none", null);
            this.sendSipMessage(message);
        }
        log.debug("Leaving MIXER destroyMixerConferenceControlLeg");
    }

    public void joinToConferenceUsingNonControlLeg(DlgcSdpPortManager sdppm) {
        DlgcNetworkConnection nc = (DlgcNetworkConnection)sdppm.getContainer();
        String confSipReqUri = null;
        String thisSipReqUri = sdppm.getSipReqUri();
        DlgcNetworkConnection activeNC = null;
        if (this.getDeleteWhenMode().compareTo(EMixerDeleteWhen.NEVER) == 0) {
            log.debug("joinToConferenceUsingNonControlLeg with Deletewhen.NEVER: using getActiveControlLeg method to get top QUEUED control leg...standard way");
            activeNC = this.getActiveControlLeg();
            log.debug("joinToConferenceUsingNonControlLeg with Deletewhen.NEVER: control Leg use: " + activeNC.getMediaObject());
        } else {
            log.debug("joinToConferenceUsingNonControlLeg with Deletewhen.NOCONTROL: using getNoControlLeg method to get the assigned control leg...");
            activeNC = this.getNoControlLeg();
            log.debug("joinToConferenceUsingNonControlLeg with Deletewhen.NOCONTROL: control Leg use: " + activeNC.getMediaObject());
        }
        if (activeNC == null) {
            log.error("Trying to Join a NC to a non Coference Control Leg...but Control Conference Leg NC not found : null..aborting request");
            return;
        }
        confSipReqUri = this.getSipReqUri();
        if (confSipReqUri.compareToIgnoreCase(thisSipReqUri) != 0) {
            log.warn("Note that the SipReqURIs do not match between the Non Control Conference Leg NC and this NC...using to Control Leg NC URI");
        }
        try {
            String ncTransId = nc.getDlgIpmsSession().calculateDialogTargetField();
            String conferenceFullId = this.getProperControlLegConfIdForConfCommand(sdppm);
            String user = confSipReqUri;
            DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode mode = DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode.FULL;
            DlgcMixerAdapter mxa = nc.getMixerAdapter();
            String request = DlgcSipServlet.getProtocolBridge().createJoinLegRequestMsg(ncTransId, mode, false, mxa, DlgcISipB2BUAMsProtocolBridge.DTMF_CLAMP_SETTINGS.USE_NEW_SETTING, conferenceFullId, this, nc);
            this.sendSipMessage(new DlgcSipMessage((JoinableContainer)sdppm.getContainer(), "INFO", user, "msml", request, null), sdppm);
        }
        catch (MsControlException ex) {
            ex.printStackTrace();
        }
    }

    public void sendDestroyNonControlConferenceLeg(DlgcSdpPortManager sdppm) {
        this.getMixerState().stateDestroyConference(this, sdppm);
    }

    public void sendDestroyControlConferenceLeg(DlgcSdpPortManager sdppm) {
        this.getMixerState().stateDestroyControlLegConference(this, sdppm);
    }

    @Override
    protected void destroyConference() {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + " Entering MIXER destoryConference");
        if (this.bRemoveConference.booleanValue()) {
            log.debug(appLogId + "  Mixer destoryConference() bRemoveConference flag is true so just return... destory conference in progress...");
        } else {
            MixerState mState = this.getMixerState();
            if (mState.compareTo(MixerState.INITIAL_STATE) == 0) {
                log.debug(appLogId + "  MIXER in INITIAL_STATE - destoryConference() doing nothing returning... destory conference in progress...");
            } else if (!this.getRemoveConferenceStatus().booleanValue()) {
                DlgcNetworkConnection activeNC = this.getActiveControlLeg();
                List<DlgcNetworkConnection> ncList = this.getActiveLegList();
                Object var5_5 = null;
                if (ncList != null) {
                    for (DlgcXNetworkConnection dlgcXNetworkConnection : ncList) {
                        DlgcXSdpPortManagerFSM fsm = (DlgcXSdpPortManagerFSM)dlgcXNetworkConnection.getFSM();
                        fsm.setState(fsm.getIvrLegRdyState());
                    }
                }
                if (activeNC != null) {
                    try {
                        DlgcSdpPortManager sdppm = (DlgcSdpPortManager)activeNC.getSdpPortManager();
                        ((DlgcXNetworkConnection)activeNC).destroyConferenceReply = true;
                        log.debug(appLogId + " destoryConference() calling mixer stateDestroyConference");
                        this.getMixerState().stateDestroyConference(this, sdppm);
                    }
                    catch (MsControlException e) {
                        log.debug(appLogId + " destoryConference() exception: " + e.toString());
                    }
                }
            } else {
                log.debug(appLogId + " destoryConference() will not be called since already trying to destory conference...");
            }
        }
        this.bVas = false;
        if (this.curVideoLayout != null) {
            this.curVideoLayout.resetAllRegions();
        }
        log.debug(appLogId + " Leaving MIXER destoryConference");
    }

    @Override
    public void addLeg(DlgcSdpPortManager sdppm, DlgcMixerAdapter mxa) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "DlgcXMediaMixer::addLeg");
        if (this.mixerState == MixerState.CONFERENCE_RDY_STATE) {
            log.debug(appLogId + "DlgcXMediaMixer::addLeg correct state: MixerState.CONFERENCE_RDY_STATE processing request");
            try {
                DlgcNetworkConnection nc = (DlgcNetworkConnection)sdppm.getContainer();
                String ncTransId = nc.getDlgIpmsSession().calculateDialogTargetField();
                String confSipReqUri = sdppm.getSipReqUri();
                String conferenceFullId = this.getProperControlLegConfIdForConfCommand(sdppm);
                String request = DlgcSipServlet.getProtocolBridge().createJoinLegRequestMsg(ncTransId, DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode.FULL, false, mxa, DlgcISipB2BUAMsProtocolBridge.DTMF_CLAMP_SETTINGS.USE_NEW_SETTING, conferenceFullId, this, nc);
                String user = confSipReqUri;
                log.debug("DlgcXMediaMixer::addLeg - Using Mixer non control Leg to request call leg join");
                this.sendSipMessage(new DlgcSipMessage((JoinableContainer)sdppm.getContainer(), "INFO", user, "msml", request, null), sdppm);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        } else {
            log.error(appLogId + "DlgcXMediaMixer::addLeg incorrect state: " + this.mixerState.toString() + " rejecting request.");
        }
    }

    @Override
    public void addLeg(DlgcMediaGroup mg) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "DlgcXMediaMixer::addLeg(mg) connecting the call leg to conference");
    }

    public void modifyLeg(DlgcSdpPortManager sdp, MixerAdapter mxa, DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode mode) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "DlgcXMediaMixer::modifyLeg");
        DlgcNetworkConnection nc = (DlgcNetworkConnection)sdp.getContainer();
        String transId = nc.getDlgIpmsSession().calculateDialogTargetField();
        String conferenceFullId = this.getProperControlLegConfIdForConfCommand(sdp);
        String request = DlgcSipServlet.getProtocolBridge().modifyLegMsg(transId, mode, true, null, DlgcISipB2BUAMsProtocolBridge.DTMF_CLAMP_SETTINGS.USE_PREV_SETTING, conferenceFullId, this, (DlgcNetworkConnection)sdp.getContainer());
        String user = "msml=" + this.conferenceId;
        this.sendSipMessage(new DlgcSipMessage((JoinableContainer)sdp.getContainer(), "INFO", user, "msml", request, transId), sdp);
    }

    @Override
    public void parkLeg(DlgcSdpPortManager sdppm) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "DlgcXMediaMixer::parkLeg(sdpPortMgr) sending INFO to MS to park leg");
        DlgcNetworkConnection nc = (DlgcNetworkConnection)sdppm.getContainer();
        String transId = nc.getDlgIpmsSession().calculateDialogTargetField();
        String confSipReqUri = this.getSipReqUri();
        String conferenceFullId = this.getProperControlLegConfIdForConfCommand(sdppm);
        String user = confSipReqUri;
        try {
            String request = DlgcSipServlet.getProtocolBridge().createJoinLegRequestMsg(transId, DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode.PARKED, false, null, DlgcISipB2BUAMsProtocolBridge.DTMF_CLAMP_SETTINGS.USE_PREV_SETTING, conferenceFullId, this, nc);
            this.sendSipMessage(new DlgcSipMessage((JoinableContainer)sdppm.getContainer(), "INFO", user, "msml", request, transId), sdppm);
        }
        catch (DlgcProtocolException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unparkLeg(DlgcSdpPortManager sdppm, MixerAdapter mxa) {
        this.doUunparkLeg(sdppm, mxa, DlgcISipB2BUAMsProtocolBridge.DTMF_CLAMP_SETTINGS.USE_NEW_SETTING);
    }

    @Override
    public void unparkLeg(DlgcSdpPortManager sdppm) {
        this.doUunparkLeg(sdppm, null, DlgcISipB2BUAMsProtocolBridge.DTMF_CLAMP_SETTINGS.USE_PREV_SETTING);
    }

    @Override
    public void doUunparkLeg(DlgcSdpPortManager sdppm, MixerAdapter mxa, DlgcISipB2BUAMsProtocolBridge.DTMF_CLAMP_SETTINGS tcs) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "DlgcMediaMixer::doUunparkLeg(sdpPortMgr) sending INFO to MS to unpark leg");
        try {
            DlgcNetworkConnection nc = (DlgcNetworkConnection)sdppm.getContainer();
            String transId = nc.getDlgIpmsSession().calculateDialogTargetField();
            String sipReqUri = sdppm.getSipReqUri();
            String conferenceFullId = this.getProperControlLegConfIdForConfCommand(sdppm);
            DlgcMixerAdapter max = nc.getMixerAdapter();
            String request = DlgcSipServlet.getProtocolBridge().createJoinLegRequestMsg(transId, DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode.FULL, false, max, DlgcISipB2BUAMsProtocolBridge.DTMF_CLAMP_SETTINGS.USE_PREV_SETTING, conferenceFullId, this, nc);
            String user = sipReqUri;
            this.sendSipMessage(new DlgcSipMessage((JoinableContainer)sdppm.getContainer(), "INFO", user, "msml", request, transId), sdppm);
        }
        catch (DlgcProtocolException e) {
            e.printStackTrace();
        }
    }

    public void sendConferenceCreatedEvent(MixerState theState, DlgcXMediaMixer mixer) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "XMS - " + theState.toString() + ": MIXER sendConferenceCreatedEvent via postAllocationEvent()");
        mixer.setMixerState(MixerState.CONFERENCE_RDY_STATE);
        mixer.isConfirmed = true;
        mixer.conferenceCreated = true;
        mixer.allocEventType = AllocationEvent.ALLOCATION_CONFIRMED;
        log.debug(appLogId + "XMS - " + theState.toString() + ": MIXER sendConferenceCreatedEvent via postAllocationEvent()");
        mixer.postAllocationEvent(mixer.allocEventType, "Conference Allocated");
        log.debug(appLogId + "XMS - " + theState.toString() + ": MIXER sendConferenceCreatedEvent via postAllocationEvent() returning");
    }

    public void sendConferenceCreatedEvent(MixerState theState, DlgcXMediaMixer mixer, EventType type, String status) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "XMS - " + theState.toString() + ": MIXER sendConferenceCreatedEvent via postAllocationEvent()");
        if (type == AllocationEvent.ALLOCATION_CONFIRMED) {
            mixer.isConfirmed = true;
            mixer.conferenceCreated = true;
            mixer.allocEventType = AllocationEvent.ALLOCATION_CONFIRMED;
            mixer.setMixerState(MixerState.CONFERENCE_RDY_STATE);
        } else {
            mixer.isConfirmed = false;
            mixer.conferenceCreated = false;
            mixer.allocEventType = AllocationEvent.IRRECOVERABLE_FAILURE;
            mixer.setMixerState(MixerState.INITIAL_STATE);
        }
        log.debug(appLogId + "XMS - " + theState.toString() + ": MIXER sendConferenceCreatedEvent via postAllocationEvent()");
        mixer.postAllocationEvent(mixer.allocEventType, status);
        log.debug(appLogId + "XMS - " + theState.toString() + ": MIXER sendConferenceCreatedEvent via postAllocationEvent() returning");
    }

    protected void sendConferenceErrorEvent(MixerState theState, DlgcXMediaMixer mixer) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "XMS - " + theState.toString() + ": MIXER sendConferenceErrorEvent via postAllocationEvent()");
        mixer.isConfirmed = true;
        mixer.conferenceCreated = false;
        mixer.allocEventType = AllocationEvent.IRRECOVERABLE_FAILURE;
        log.debug(appLogId + "XMS - " + theState.toString() + ": MIXER sendConferenceErrorEvent via postAllocationEvent()");
        mixer.postAllocationEvent();
        log.debug(appLogId + "XMS - " + theState.toString() + ": MIXER sendConferenceErrorEvent via postAllocationEvent() returning");
    }

    @Override
    public void confirm() throws MsControlException {
        log.info("JSR309 API REQUEST:Mixer confirm() MIXER MEDIA OBJID: " + this.getMediaObject());
        log.debug("DlgcXMediaMixer::confirm() using Control Conference Leg.");
        if (this.isReleased()) {
            throw new IllegalStateException("DlgcXMediaMixer has been released");
        }
        log.debug("DlgcXMediaMixer::confirm() creating a Control Leg Object.");
        log.debug("DlgcXMediaMixer::confirm() setting deleteWhenMode to NOCTL");
        this.deleteWhenMode = EMixerDeleteWhen.NOCONTROL;
        this.controlLeg = new DlgcXConferenceControlLeg(this);
        this.activeControlLeg = this.controlLeg.getControLeg();
        this.setMixerReleased(false);
        log.debug("DlgcXMediaMixer::confirm() calling controlLeg.CreateConference()");
        this.controlLeg.CreateConference();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sendRecordMessage(DlgcSipMessage msg, DlgcXRecorder dlgcXRecorder) throws MsControlException {
        log.debug("Entering DlgcXMediaMixer::sendRecordMessage");
        if (this.mode != MixerOperationalMode.CONTROL_LEG_MODE_CONFIRMED) {
            String error = "Recording operation can't be executed. Mixer Control Leg Is not Confirmed";
            log.error(error);
            throw new MsControlException(error);
        }
        if (this.mixerState != MixerState.CONFERENCE_RDY_STATE) {
            String error = "Recording operation can't be executed. Mixer is not in Conference Ready State";
            log.error(error);
            throw new MsControlException(error);
        }
        log.debug("DlgcXMediaMixer::sendRecordMessage:: Mixer Control Leg is Confirmed and In Conference - sending Recording Request");
        if (this.mixerState.startRecording(this, msg, dlgcXRecorder)) {
            log.debug("Started Recording of a conference");
            log.debug("Leaving DlgcXMediaMixer::sendRecordMessage");
            return;
        }
        throw new MsControlException("Can't start conference recording since a recording still in progress");
    }

    protected boolean isTCKEnabled() {
        String tckFlag = System.getenv("TCK_ENABLED");
        log.debug("Value of TCK_ENABLED flag is :" + tckFlag);
        boolean isTCKEnabled = false;
        if (null == tckFlag || tckFlag.equalsIgnoreCase("NO")) {
            log.warn("Environment Variable: " + "TCK_ENABLED" + " not set");
            log.warn("Assuming TCK is not enabled");
            isTCKEnabled = false;
        } else if (tckFlag.equalsIgnoreCase("YES")) {
            isTCKEnabled = true;
        }
        log.debug("Value of TCK_ENABLED flag is :" + isTCKEnabled);
        return isTCKEnabled;
    }

    public void setMixerControlMode(MixerOperationalMode controlMode) {
        this.mode = controlMode;
        log.debug("DlgcXMediaMixer::setMixerControlMode:: OPMODE=" + this.mode.toString());
    }

    public MixerOperationalMode getMixerControlMode() {
        log.debug("DlgcXMediaMixer::getMixerControlMode:: returning OPMODE=" + this.mode.toString());
        return this.mode;
    }

    @Override
    public void unjoin(Joinable joinee) throws MsControlException {
        Joinable j = joinee;
        if (joinee instanceof NetworkConnection) {
            super.unjoin(j);
        } else if (joinee instanceof MediaGroup) {
            log.info("JSR309 API REQUEST:Mixer unjoin() from MG: MIXER MEDIA OBJID: " + this.getMediaObject());
            super.unjoin(joinee);
        } else {
            throw new MsControlException("Unjoin failed invalid joinee");
        }
    }

    @Override
    public void join(Joinable.Direction direction, Joinable joinee) throws MsControlException {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        if (DlgcInstrumentPropertyMgr.bTraceJoin) {
            StackTraceElement[] seArr;
            log.debug("------------ Dump Stack to see who calls the MediaMixer join --------------");
            for (StackTraceElement e : seArr = Thread.currentThread().getStackTrace()) {
                log.debug("DlcXMediaMixer:: join() Stack Element : " + e.toString());
            }
            log.debug("----------- Dump Stack Completed for MediaMixer join ------------------");
        }
        if (joinee instanceof NetworkConnection) {
            log.debug(appLogId + " - " + "calling super join based on Mixer and MixerAdapter");
            super.join(direction, joinee);
        } else if (joinee instanceof MediaGroup) {
            log.info("JSR309 API REQUEST:Mixer join() from MG: MIXER MEDIA OBJID: " + this.getMediaObject());
            super.join(direction, joinee);
        }
    }

    private Joinable.Direction reverseDirection(Joinable.Direction direction) {
        Joinable.Direction dir = direction;
        if (direction.equals((Object)Joinable.Direction.SEND)) {
            dir = Joinable.Direction.RECV;
        } else if (direction.equals((Object)Joinable.Direction.RECV)) {
            dir = Joinable.Direction.SEND;
        }
        return dir;
    }

    public DlgcVideoRenderer getVideoRenderer() {
        return this.videoRenderer;
    }

    public VideoLayout getVideoLayout() {
        return this.curVideoLayout;
    }

    public void setVideoLayout(VideoLayout layout) {
        this.curVideoLayout = (DlgcVideoLayout)layout;
        this.getMixerState().setVideoLayout(this);
        log.debug("DlgcXmediaMixer::setVideoLayout Leaving");
    }

    public List<DlgcMixerOverlay> getCurOverlayList() {
        return this.curOverlayList;
    }

    public List<DlgcMixerOverlay> getPreOverlayList() {
        return this.preOverlayList;
    }

    public void resetVideoLayout(String removeRegion) {
        if (this.videoRenderer != null) {
            return;
        }
        if (this.controlLegList.size() < 1) {
            return;
        }
        try {
            DlgcNetworkConnection nc = this.activeControlLeg;
            DlgcMediaSession ms = (DlgcMediaSession)nc.getMediaSession();
            DlgcXSdpPortManager sdppm = (DlgcXSdpPortManager)nc.getSdpPortMgrResource();
            String sipReqUri = sdppm.getSipReqUri();
            this.setSipReqUri(sipReqUri);
            String ncTransId = nc.getDlgIpmsSession().calculateDialogTargetField();
            String conferenceFullId = this.getProperControlLegConfIdForConfCommand(sdppm);
            String user = sipReqUri;
            String request = DlgcSipServlet.getProtocolBridge().createResetVideoLayoutMsg(ncTransId, conferenceFullId, this, removeRegion);
            nc.getDlgIpmsSession().getSipSession().setAttribute("RESET_VIDEO_LAYOUT", (Object)Boolean.TRUE);
            this.sendSipMessage(new DlgcSipMessage((JoinableContainer)sdppm.getContainer(), "INFO", user, "msml", request, null), sdppm);
        }
        catch (DlgcProtocolException e) {
            log.debug("sendMSMLConferenceRequest Error creating conference MSML request - exception:", (Throwable)((Object)e));
        }
        catch (SdpPortManagerException e) {
            e.printStackTrace();
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ProcessVideoLayout() {
        Integer n;
        Serializable rlayout;
        Integer i;
        if (this.curVideoLayout != null) {
            i = 0;
            while (i < this.getConfLegList().size()) {
                rlayout = this.curVideoLayout.regionNameMap.get(this.getConfLegList().get(i).getRegionName());
                if (rlayout != null) {
                    rlayout.bAvail = false;
                }
                rlayout = i;
                n = i = Integer.valueOf(i + 1);
            }
            this.preOverlayList.clear();
        }
        i = 0;
        while (i < this.curOverlayList.size()) {
            this.preOverlayList.add(new DlgcMixerOverlay(this.curOverlayList.get(i)));
            rlayout = i;
            n = i = Integer.valueOf(i + 1);
        }
        try {
            DlgcMediaSession ms;
            DlgcNetworkConnection nc;
            if (this.getMixerControlMode().equals((Object)MixerOperationalMode.CONTROL_LEG_MODE_CONFIRMED)) {
                nc = this.getFromProxyNC((DlgcNetworkConnectionProxy)this.controlLeg.controlNC);
                ms = (DlgcMediaSession)nc.getMediaSession();
                log.debug("DlgcXMediaMixer::Using Control Leg to sendVideoLayout()");
                nc.getDlgIpmsSession().getSipSession().setAttribute("SET_VIDEO_LAYOUT", (Object)Boolean.TRUE);
                log.debug("DlgcXMediaMixer::ProcessVideoLayout using Mixer Control Leg...calling internal sendVideoLayoutUsingControlLeg method");
                this.sendVideoLayoutUsingControlLeg();
            } else {
                nc = this.activeControlLeg;
                ms = (DlgcMediaSession)nc.getMediaSession();
                DlgcXSdpPortManager sdppm = (DlgcXSdpPortManager)nc.getSdpPortMgrResource();
                String sipReqUri = sdppm.getSipReqUri();
                this.setSipReqUri(sipReqUri);
                String ncTransId = nc.getDlgIpmsSession().calculateDialogTargetField();
                String conferenceFullId = this.getProperControlLegConfIdForConfCommand(sdppm);
                String user = sipReqUri;
                String request = DlgcSipServlet.getProtocolBridge().setVideoLayoutMsg(ncTransId, conferenceFullId, this);
                nc.getDlgIpmsSession().getSipSession().setAttribute("SET_VIDEO_LAYOUT", (Object)Boolean.TRUE);
                this.sendSipMessage(new DlgcSipMessage((JoinableContainer)sdppm.getContainer(), "INFO", user, "msml", request, null), sdppm);
            }
            this.curOverlayList.clear();
            if (this.curVideoLayout != null) {
                Iterator<DlgcVideoLayout.displayRegion> itOverlay = this.curVideoLayout.displayRegionList.iterator();
                DlgcVideoLayout.displayRegion dr2 = null;
                for (DlgcVideoLayout.displayRegion dr2 : this.curVideoLayout.displayRegionList) {
                    if (dr2.type != "img" && dr2.type != "text") continue;
                    this.curOverlayList.add(new DlgcMixerOverlay(dr2.type, dr2.name, dr2.overlayId));
                }
            }
        }
        catch (DlgcProtocolException e) {
            log.debug("sendMSMLConferenceRequest Error creating conference MSML request - exception:", (Throwable)((Object)e));
        }
        catch (SdpPortManagerException e) {
            e.printStackTrace();
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    private void sendVideoLayoutUsingControlLeg() {
        log.debug("Entering DlgcXMediaMixer::sendVideoLayoutUsingControlLeg using Mixer Control Leg");
        try {
            DlgcNetworkConnection ncFromControlLeg = this.getFromProxyNC((DlgcNetworkConnectionProxy)this.controlLeg.controlNC);
            DlgcXSdpPortManager sdppm = (DlgcXSdpPortManager)ncFromControlLeg.getSdpPortMgrResource();
            String sipReqUri = sdppm.getSipReqUri();
            this.setSipReqUri(sipReqUri);
            String ncTransId = ncFromControlLeg.getDlgIpmsSession().calculateDialogTargetField();
            String conferenceFullId = this.getProperControlLegConfIdForConfCommand(sdppm);
            String user = sipReqUri;
            String request = DlgcSipServlet.getProtocolBridge().setVideoLayoutMsg(ncTransId, conferenceFullId, this);
            log.debug("DlgcXMediaMixer::createConferfenceUsingControlLeg calling setMixerControlMode(MixerOperationalMode.CONTROL_LEG_MODE_CONFIGURED sending the following MSML request: " + request);
            ncFromControlLeg.getDlgIpmsSession().getSipSession().setAttribute("SET_VIDEO_LAYOUT", (Object)Boolean.TRUE);
            this.sendSipMessage(new DlgcSipMessage((JoinableContainer)sdppm.getContainer(), "INFO", user, "msml", request, null), sdppm);
        }
        catch (MsControlException e) {
            log.error(e.toString());
        }
        log.debug("Leaving DlgcXMediaMixer::sendVideoLayout using Mixer Control Leg");
    }

    protected void createMixerSAS() {
        CreateMixerControlLegSASAction sasAction = new CreateMixerControlLegSASAction(this);
        sasAction.run();
    }

    class CreateMixerControlLegSASAction {
        private DlgcMediaMixer theMixer;

        public CreateMixerControlLegSASAction(DlgcXMediaMixer mx) {
            this.theMixer = mx;
        }

        public void run() {
            if (DlgcSipServlet.APP_SERVER_PLATFORM.equalsIgnoreCase("TELESTAX") && DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("CreateMixerControlLegSASAction::::run():: calling createMixerSASTelScale - creating MIXER CONTROL CONFERENCE LEG SAS.");
                this.createMixerSASTelScale();
            }
            if (DlgcSipServlet.APP_SERVER_PLATFORM.equalsIgnoreCase("OCCAS5") && DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("CreateMixerControlLegSASAction::::run():: calling createMixerSASOccas - creating MIXER CONTROL CONFERENCE LEG SAS.");
                this.createMixerSASOccas();
            } else {
                log.debug("CreateMixerControlLegSASAction::::run():: calling TROPO or OCCAS ASYNC - creating MIXER CONTROL CONFERENCE LEG SAS.");
                this.createMixerSASGeneral();
            }
        }

        protected void createMixerSASTelScale() {
            try {
                log.debug("***Entering createMixerSASTelScale***");
                SipFactoryExt f = (SipFactoryExt)DlgcSipServlet.getSipFactory();
                SipApplicationSession appSession = f.createApplicationSession(false);
                String sasId = appSession.getId();
                log.debug("createMixerSASTelScale:: Mixer Control Leg SASID: " + sasId);
                appSession.setExpires(0);
                appSession.setInvalidateWhenReady(false);
                this.theMixer.setControLLegSAS(appSession);
            }
            catch (Exception e) {
                this.theMixer.setControLLegSAS(null);
                log.error("Failed to create Media Session", (Throwable)e);
            }
        }

        protected void createMixerSASGeneral() {
            try {
                log.debug("***createMixerSASTelScale::createMediaSessionGeneral***");
                SipApplicationSession appSession = DlgcSipServlet.getSipFactory().createApplicationSession();
                String sasId = appSession.getId();
                log.debug("createMixerSASTelScale SASID: " + sasId);
                appSession.setExpires(0);
                appSession.setInvalidateWhenReady(false);
                this.theMixer.setControLLegSAS(appSession);
            }
            catch (Exception e) {
                log.error("Failed to create Media Session", (Throwable)e);
                this.theMixer.setControLLegSAS(null);
            }
        }

        protected void createMixerSASOccas() {
            try {
                log.debug("Entering DlgcXMsControlFactory::createMediaSessionForOccas");
                WorkManager aWorkMgr = DlgcSipServlet.wManager;
                WorkItem wItem = aWorkMgr.schedule((Work)new OccasMixerSASWork());
                if (wItem == null) {
                    log.error("DcreateMixerSASOccas: error creating SAS using Work Manager.. Work Item is Null");
                }
                log.debug("createMixerSASOccas: waiting for thread to finish creating the SAS");
                aWorkMgr.waitForAll(Arrays.asList(wItem), 5000L);
                log.debug("createMixerSASOccas: Returning from waiting for thread to finish creating the SAS");
            }
            catch (Exception e) {
                log.error("Failed to create Media Session", (Throwable)e);
            }
        }

        private class OccasMixerSASWork
        implements Work {
            private OccasMixerSASWork() {
            }

            public boolean isDaemon() {
                return false;
            }

            public void release() {
            }

            public void run() {
                log.debug("OccasMixerSASWork in work thread creating SAS");
                CreateMixerControlLegSASAction.this.createMixerSASGeneral();
                log.debug("OccasMixerSASWork in work thread creating SAS");
            }
        }
    }

    public static enum MixerState {
        INITIAL_STATE{

            @Override
            public boolean setVideoLayout(DlgcXMediaMixer mixer) {
                log.debug("Enter XMS DlgcXMediaMixer:: MixerState INITIAL_STATE sending initial DlgcVideoRenderEvent event to the application ");
                DlgcVideoRenderEvent renderEvent = new DlgcVideoRenderEvent(true, null, mixer.getVideoRenderer());
                renderEvent.print();
                mixer.getVideoRenderer().postMediaEvent(renderEvent);
                DlgcSync2AsyncMonitor monitor = mixer.getMonitor();
                if (monitor == null) {
                    log.debug("mmm INITIAL_STATE setLayout request - Monitor found to be null while handling setLayout XMS request mmm");
                } else {
                    log.debug("INITIAL_STATE setLayout request - Monitor found while receiving setLayout request from XMS unlocking monitor");
                    monitor.notifyRequestCompleted(true, "Initial Setlayout Request Completed");
                }
                return true;
            }
        }
        ,
        CONNECTING_STATE{}
        ,
        CONNECTED_STATE{}
        ,
        CONFERENCE_PENDING_STATE{}
        ,
        CONFERENCE_RDY_STATE{

            @Override
            public void stateDestroyConference(DlgcXMediaMixer mixer, DlgcSdpPortManager sdppm) {
                mixer.setMixerState(INITIAL_STATE);
                mixer.sendDestroyConferenceMsg(sdppm);
                mixer.initMixer();
            }

            @Override
            public void stateDestroyControlLegConference(DlgcXMediaMixer mixer, DlgcSdpPortManager sdppm) {
                log.debug("DlgcXMediaMixer::stateDestroyControlLegConference... ready to send destroy conference command using the control leg");
                log.debug("DlgcXMediaMixer::stateDestroyControlLegConference... setting MixerState to CONFERENCE_DESTROY_PENDING_STATE");
                mixer.setMixerState(CONFERENCE_DESTROY_PENDING_STATE);
                log.debug("DlgcXMediaMixer::stateDestroyControlLegConference... setting MixerState Control Leg Object State to ControlLegState.CONFERENCE_CONF_DESTROY_PENDING_STATE");
                ((DlgcXMediaMixer)mixer).controlLeg.controlState = DlgcXConferenceControlLeg.ControlLegState.CONFERENCE_CONF_DESTROY_PENDING_STATE;
                mixer.sendDestroyConferenceControlLegMsg(sdppm);
            }

            @Override
            public boolean startRecording(DlgcXMediaMixer mixer, DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
                log.debug("Entering XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE startRecording");
                ConfRecordingState crs = mixer.getConfRecordingState();
                if (crs != ConfRecordingState.NOT_RECORDING) {
                    log.warn("DlgcXMediaMixer::startRecording can't start conference recording since recording is already in progress");
                    return false;
                }
                mixer.setConfRecordingState(ConfRecordingState.RECORDING_PENDING);
                mixer.sendSipMessage(message, notifier);
                log.debug("Leaving XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE startRecording");
                return true;
            }

            @Override
            public boolean stopRecording(DlgcXMediaMixer mixer, DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
                log.debug("Entering XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE stopRecording");
                mixer.sendSipMessage(message, notifier);
                log.debug("Leaving XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE stopRecording");
                return true;
            }

            @Override
            public boolean stop(DlgcXMediaMixer mixer, DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
                log.debug("Enter XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE stop media");
                mixer.sendSipMessage(message, notifier);
                return true;
            }

            @Override
            public boolean playToConference(DlgcXMediaMixer mixer) {
                log.debug("Enter XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE playToConference");
                return true;
            }

            @Override
            public boolean stopPlayToConference(DlgcXMediaMixer mixer) {
                log.debug("Enter XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE stopPlayToConference");
                return true;
            }

            @Override
            public boolean setVideoLayout(DlgcXMediaMixer mixer) {
                log.debug("Enter XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE setVideoLayout..modifing MS conference layout ");
                mixer.ProcessVideoLayout();
                return true;
            }

            @Override
            public void handleASNEvent(DlgcXMediaMixer mixer, Vector<DlgcActiveTalker> activeTalkerList) {
                log.debug("Enter XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE handleASNEvent");
                log.debug("Sending MixerEvent EventType: ACTIVE_INPUTS_CHANGED");
                DlgcMixerEvent asnEvent = new DlgcMixerEvent(MixerEvent.ACTIVE_INPUTS_CHANGED, mixer);
                asnEvent.setActiveTalkerList(activeTalkerList);
                mixer.sendActiveTalkerEvent(asnEvent);
            }
        }
        ,
        CONFERENCE_DESTROY_PENDING_STATE{};


        public void stateDestroyConference(DlgcXMediaMixer mixer, DlgcSdpPortManager sdppm) {
            log.debug("XMS MixerState destroyConference default..nothing to do");
        }

        public boolean startRecording(DlgcXMediaMixer mixer, DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
            log.debug("XMS MixerState startRecording default..nothing to do");
            return false;
        }

        public boolean stopRecording(DlgcXMediaMixer mixer, DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
            log.debug("Enter XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE stopRecording");
            return true;
        }

        public boolean stopRecording(DlgcXMediaMixer mixer) {
            log.debug("Enter XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE stopRecording");
            return true;
        }

        public boolean stop(DlgcXMediaMixer mixer, DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
            log.debug("Enter XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE stopRecording");
            return true;
        }

        public boolean playToConference(DlgcXMediaMixer mixer) {
            log.debug("Enter XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE playToConference");
            return true;
        }

        public boolean stopPlayToConference(DlgcXMediaMixer mixer) {
            log.debug("Enter XMS DlgcXMediaMixer:: MixerState CONFERENCE_RDY_STATE stopPlayToConference");
            return true;
        }

        public boolean setVideoLayout(DlgcXMediaMixer mixer) {
            log.debug("Enter XMS DlgcXMediaMixer:: MixerState setVideoLayout default nothing to do");
            return true;
        }

        public void stateDestroyControlLegConference(DlgcXMediaMixer mixer, DlgcSdpPortManager sdppm) {
            log.debug("Enter XMS DlgcXMediaMixer:: stateDestroyControlLegConference default nothing to do");
        }

        public void handleASNEvent(DlgcXMediaMixer mixer, Vector<DlgcActiveTalker> activTalkerList) {
            log.debug("Enter XMS DlgcXMediaMixer:: handleASNEvent default nothing to do");
        }
    }

    public static enum EMixerDeleteWhen {
        NOCONTROL,
        NEVER;

    }

    public static enum MixerOperationalMode {
        CONTROL_LEG_MODE_CONFIGURED,
        CONTROL_LEG_MODE_CONFIRMED,
        NON_CONTROl_LEG_CREATION_PENDING_MODE,
        NON_CONTROL_LEG_RDY_MODE;

    }

    public static enum ConfRecordingState {
        NOT_RECORDING,
        RECORDING_PENDING,
        RECORDING;

    }
}

