/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mixer;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.DlgcXMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcXMsControlFactory;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnectionProxy;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManagerFSM;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManagerStates;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.io.Serializable;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManager;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.resource.AllocationEvent;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcXConferenceControlLeg
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected NetworkConnection controlNC;
    DlgcNetworkConnection ncImpl;
    protected MediaSession controlMS;
    protected ControlLegState controlState;
    private static Logger log = LoggerFactory.getLogger(DlgcXConferenceControlLeg.class);
    DlgcXMediaMixer mixer;
    DlgcSync2AsyncMonitor controlLegMonitor = null;

    public void lockConrolLeg() {
        this.controlLegMonitor.waitForRequestCompletion();
    }

    public void unlockControlLeg() {
        this.controlLegMonitor.doUnlock();
    }

    public void unlockViaNotifyControlLeg() {
        if (this.controlLegMonitor.getLockReason() == DlgcSync2AsyncMonitor.E_CONTROL_LEG_LOCK_REASONS.DESTROY_CONF || this.controlLegMonitor.getLockReason() == DlgcSync2AsyncMonitor.E_CONTROL_LEG_LOCK_REASONS.LAYOUT_CONF) {
            this.controlLegMonitor.notifyRequestCompleted(true, this.controlLegMonitor.getLockReason().toString());
        }
    }

    public DlgcXConferenceControlLeg(DlgcXMediaMixer m) throws MsControlException {
        try {
            this.mixer = m;
            this.mixer.setMixerControlMode(DlgcXMediaMixer.MixerOperationalMode.CONTROL_LEG_MODE_CONFIGURED);
            this.mixer.setDeleteConferenceWhenMode(DlgcXMediaMixer.EMixerDeleteWhen.NOCONTROL);
            DlgcXMediaSession mixerMS = (DlgcXMediaSession)this.mixer.getMediaSession();
            DlgcXMsControlFactory f = (DlgcXMsControlFactory)mixerMS.getFactory();
            this.controlMS = f.createMediaSession();
            this.controlNC = this.controlMS.createNetworkConnection(NetworkConnection.BASIC);
            log.debug("DlgcXConferenceControlLeg:: controlMS: " + this.controlMS.toString());
            log.debug("DlgcXConferenceControlLeg:: controlNC: " + this.controlNC.toString());
            this.controlNC.getMediaSession().setAttribute("DlgcXConferenceControlLeg", (Object)this);
            this.controlNC.getSdpPortManager().addListener((MediaEventListener)new ControlLegConnectionListener(this));
            this.ncImpl = this.getFromProxyNC((DlgcNetworkConnectionProxy)this.controlNC);
            this.ncImpl.setMixerControlLeg(this);
            this.controlState = ControlLegState.INIT;
            this.controlLegMonitor = new DlgcSync2AsyncMonitor("Control Leg Monitor");
        }
        catch (MsControlException e) {
            log.error(e.toString());
            throw e;
        }
    }

    public DlgcNetworkConnectionProxy getControlNCProxy() {
        return (DlgcNetworkConnectionProxy)this.controlNC;
    }

    public DlgcXMediaMixer getMyMixer() {
        return this.mixer;
    }

    public void CreateConference() throws MsControlException {
        this.controlState.sendConnectControlLeg(this);
    }

    public void DestroyConference() throws MsControlException {
        this.controlState.sendDestroyConference(this);
    }

    public void ProcessVideoLayout() throws MsControlException {
        this.controlState.ProcessVideoLayout(this);
    }

    public ControlLegState getControlState() {
        return this.controlState;
    }

    public void setControlState(ControlLegState s) {
        this.controlState = s;
    }

    public void ModifyConference(ControlLegState s) {
    }

    public void destroyConferenceInNoControlLegMode() throws MsControlException {
        log.debug("DlgcXConferenceControlLeg::destroyConferenceInNoControlLegMode");
        this.ncImpl.getFSM().setState(DlgcXSdpPortManagerStates.createdState);
        if (this.mixer != null) {
            this.mixer.removeControlLegFromList(this.ncImpl);
        } else {
            log.debug("DlgcXConferenceControlLeg::destroyConferenceInNoControlLegMode  Note mixer object found to be null...maybe was previously release...");
        }
        log.debug("DlgcXConferenceControlLeg destroyConferenceInNoControlLegMode():: calling evRelease to send bye to media server in order to finally release the leg");
        this.ncImpl.getSdpPortMgrResource().getMyFSM().getConfLegRdy().evRelease(this.ncImpl.getSdpPortMgrResource().getMyFSM());
    }

    public DlgcResourceContainer getResourceContainerFromProxy(DlgcProxy proxyResourceContainer) {
        String objId = proxyResourceContainer.getMsObjectId();
        String containerProxId = proxyResourceContainer.getContainerProxyId();
        SipApplicationSession appSession = proxyResourceContainer.getProxySAS();
        DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
        DlgcResourceContainer actualResourceContainer = (DlgcResourceContainer)session.getMediaObjectByProxyId(containerProxId);
        return actualResourceContainer;
    }

    public DlgcNetworkConnection getFromProxyNC(DlgcNetworkConnectionProxy ncp) throws MsControlException {
        try {
            SipApplicationSession appSession = ncp.getProxySAS(ncp.getProxyId());
            String containerProxyId = ncp.getContainerProxyId();
            String mediaId = ncp.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcNetworkConnection nc = (DlgcNetworkConnection)session.getMediaObjectByProxyId(containerProxyId);
            return nc;
        }
        catch (Exception e) {
            log.error("Failed to create getSdpPortManager", (Throwable)e);
            throw new MsControlException("Failed to create getSdpPortManager", (Throwable)e);
        }
    }

    public void changeAllControlLegJoinedConfPartiesToIVR_RDY_STATE() {
        log.debug("Entering DlgcXConferenceControlLeg::changeAllConfPartiesToIVR_RDY_STATE METHOD");
        try {
            Joinable[] ja = this.mixer.getJoinees();
            int numInList = ja.length;
            log.debug("DlgcXConferenceControlLeg::changeAllConfPartiesToIVR_RDY_STATE():: size of list: " + new Integer(numInList).toString());
            for (int i = 0; i < numInList; ++i) {
                Joinable j = ja[i];
                if (!(j instanceof DlgcXNetworkConnection)) continue;
                DlgcXNetworkConnection nxc = (DlgcXNetworkConnection)j;
                try {
                    DlgcXSdpPortManager sxp = (DlgcXSdpPortManager)nxc.getSdpPortManager();
                    log.debug("DlgcXConferenceControlLeg::changeAllConfPartiesToIVR_RDY_STATE():: change state to IVR RDY for leg:  " + nxc.getMediaObject());
                    sxp.forceStateChangeToIVR_RDY_STATE();
                    continue;
                }
                catch (Exception e) {
                    log.error("DlgcXConferenceControlLeg::changeAllConfPartiesToIVR_RDY_STATE() exception: " + e.toString());
                }
            }
        }
        catch (MsControlException e1) {
            log.error(e1.toString());
        }
        log.debug("Leaving DlgcXConferenceControlLeg::changeAllConfPartiesToIVR_RDY_STATE METHOD");
    }

    public DlgcNetworkConnection getControLeg() {
        return this.ncImpl;
    }

    public static enum ControlLegState {
        INIT{

            @Override
            public void sendConnectControlLeg(DlgcXConferenceControlLeg cl) throws MsControlException {
                if (cl.controlMS == null && cl.controlNC == null) {
                    log.error("DlgcXConferenceControlLeg: sendConnectControlLeg() - NULL MediaSession or NetworkConnection");
                    throw new MsControlException("INIT: ControlLegState: NULL MediaSession or NetworkConnection");
                }
                log.debug("DlgcXConferenceControlLeg:INIT State: sendConnectControlLeg()");
                String sdp = DlgcSipServlet.sipB2BUA.createNoMediaSDP();
                byte[] noRtpSdp = sdp.getBytes();
                cl.setControlState(CONNECTING_STATE);
                cl.mixer.setMixerControlMode(DlgcXMediaMixer.MixerOperationalMode.CONTROL_LEG_MODE_CONFIGURED);
                cl.controlNC.getSdpPortManager().processSdpOffer(noRtpSdp);
                log.debug("DlgcXConferenceControlLeg: sendConnectControlLeg() Waiting for Media Event.");
            }
        }
        ,
        CONNECTING_STATE{}
        ,
        CONNECTED_STATE{

            @Override
            public void sendCreateConference(DlgcXConferenceControlLeg cl) throws MsControlException {
                log.debug("DlgcXConferenceControlLeg:CONNECTED_STATE State: sendCreateConference()");
                DlgcXNetworkConnection nc = (DlgcXNetworkConnection)cl.getResourceContainerFromProxy((DlgcProxy)cl.controlNC);
                DlgcXSdpPortManager sdpMgr = (DlgcXSdpPortManager)nc.getSdpPortManager();
                cl.setControlState(CONFERENCE_CONF_PENDING_STATE);
                DlgcSdpPortManagerFSM fsm = sdpMgr.getMyFSM();
                cl.mixer.createConferfenceUsingControlLeg(sdpMgr);
            }
        }
        ,
        CONFERENCE_CONF_PENDING_STATE{}
        ,
        CONFERENCE_IN_CONF_STATE{

            @Override
            public void sendDestroyConference(DlgcXConferenceControlLeg cl) throws MsControlException {
                if (cl.mixer.getDeleteWhenMode() == DlgcXMediaMixer.EMixerDeleteWhen.NOCONTROL) {
                    log.debug("DlgcXConferenceControlLeg::sendDestroyConference using NOCONTROL CONFERENCE MODE");
                    cl.destroyConferenceInNoControlLegMode();
                } else {
                    log.debug("DlgcXConferenceControlLeg::sendDestroyConference using NEVER CONFERENCE CONTROL MODE");
                    cl.controlLegMonitor.doLock(DlgcSync2AsyncMonitor.E_CONTROL_LEG_LOCK_REASONS.DESTROY_CONF);
                    log.debug("DlgcXConferenceControlLeg:CONFERENCE_IN_CONF_STATE State: sendDestroyConference()");
                    DlgcXNetworkConnection nc = (DlgcXNetworkConnection)cl.getResourceContainerFromProxy((DlgcProxy)cl.controlNC);
                    DlgcXSdpPortManager sdpMgr = (DlgcXSdpPortManager)nc.getSdpPortManager();
                    cl.setControlState(CONFERENCE_CONF_DESTROY_PENDING_STATE);
                    cl.mixer.sendDestroyConferenceControlLegMsg(sdpMgr);
                    cl.controlLegMonitor.waitForRequestCompletionNoLock();
                }
            }

            @Override
            public void ProcessVideoLayout(DlgcXConferenceControlLeg cl) throws MsControlException {
                cl.controlLegMonitor.doLock(DlgcSync2AsyncMonitor.E_CONTROL_LEG_LOCK_REASONS.LAYOUT_CONF);
                log.debug("DlgcXConferenceControlLeg:CONFERENCE_IN_CONF_STATE State: ProcessVideoLayout()");
                cl.mixer.ProcessVideoLayout();
                cl.controlLegMonitor.waitForRequestCompletionNoLock();
            }
        }
        ,
        ERROR_STATE{}
        ,
        CONFERENCE_CONF_DESTROY_PENDING_STATE{

            @Override
            public void releaseControlLeg(DlgcXConferenceControlLeg cl) throws MsControlException {
                log.debug("DlgcXConferenceControlLeg:CONFERENCE_CONF_DESTROY_PENDING_STATE State: releaseControlLeg()");
                cl.controlMS.release();
                log.debug("DlgcXConferenceControlLeg:CONFERENCE_CONF_DESTROY_PENDING_STATE State: moving to INIT STATE");
            }
        };


        public void sendConnectControlLeg(DlgcXConferenceControlLeg cl) throws MsControlException {
            String msg = "sendConnectControlLeg not supported in this state: " + cl.getControlState().toString();
            log.debug(msg);
            throw new MsControlException(msg);
        }

        public void releaseControlLeg(DlgcXConferenceControlLeg cl) throws MsControlException {
            String msg = "releaseControlLeg not supported in this state: " + cl.getControlState().toString();
            log.debug(msg);
            throw new MsControlException(msg);
        }

        public void sendCreateConference(DlgcXConferenceControlLeg cl) throws MsControlException {
            String msg = "sendCreateConference not supported in this state: " + cl.getControlState().toString();
            log.debug(msg);
            throw new MsControlException(msg);
        }

        public void sendDestroyConference(DlgcXConferenceControlLeg cl) throws MsControlException {
            String msg = "sendDestroyConference not supported in this state: " + cl.getControlState().toString();
            log.debug(msg);
            throw new MsControlException(msg);
        }

        public void sendModifyConference(DlgcXConferenceControlLeg cl) throws MsControlException {
            String msg = "sendModifyConference not supported in this state: " + cl.getControlState().toString();
            log.debug(msg);
            throw new MsControlException(msg);
        }

        public void ProcessVideoLayout(DlgcXConferenceControlLeg cl) throws MsControlException {
            String msg = "ProcessVideoLayout not supported in this state: " + cl.getControlState().toString();
            log.debug(msg);
            throw new MsControlException(msg);
        }

        public void setError(DlgcXConferenceControlLeg cl, String msg) {
            cl.setControlState(INIT);
            log.debug(msg);
            DlgcXMediaMixer mx = cl.mixer;
            mx.sendConferenceCreatedEvent(mx.getMixerState(), mx, AllocationEvent.IRRECOVERABLE_FAILURE, msg);
        }
    }

    protected class ControlLegConnectionListener
    implements MediaEventListener<SdpPortManagerEvent>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected DlgcXConferenceControlLeg controlLeg;

        public ControlLegConnectionListener(DlgcXConferenceControlLeg cl) {
            this.controlLeg = cl;
        }

        public void onEvent(SdpPortManagerEvent event) {
            SdpPortManager sdpMgr = (SdpPortManager)event.getSource();
            NetworkConnection nc = (NetworkConnection)sdpMgr.getContainer();
            log.debug("ControlLegConnectionListener received event = " + event.getEventType());
            try {
                if (event.isSuccessful()) {
                    log.debug("DlgcXConferenceControlLeg: ControlLegConnectionListener onEvent() connection successfull with XMS");
                    this.controlLeg.setControlState(ControlLegState.CONNECTED_STATE);
                    this.controlLeg.controlState.sendCreateConference(this.controlLeg);
                } else {
                    this.controlLeg.setControlState(ControlLegState.ERROR_STATE);
                    String msg = "DlgcXConferenceControlLeg: ControlLegConnectionListener onEvent() connection fail with XMS Error: " + event.getErrorText();
                    this.controlLeg.controlState.setError(this.controlLeg, msg);
                }
            }
            catch (Exception e) {
                String msg = "DlgcXConferenceControlLeg: ControlLegConnectionListener onEvent() connection fail with XMS: " + e.toString();
                this.controlLeg.controlState.setError(this.controlLeg, msg);
            }
            log.debug("DlgcXConferenceControlLeg: ControlLegConnectionListener onEvent() returning");
        }
    }
}

