/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mixer;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaConfig;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameter;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapterProxy;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.mixer.MixerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcMixerAdapter
extends DlgcJoinableContainer
implements MixerAdapter {
    private static final long serialVersionUID = 17773403939L;
    private static DlgcParameters supportedParameters;
    private static Logger log;
    private DlgcMediaConfig myConfig;
    private DlgcMediaMixer myMixer;
    private String dtmfClamp;

    public DlgcMixerAdapter(DlgcMediaMixer mixer, MediaSession ms, MediaConfig config, String prefix) {
        super(ms, prefix);
        this.myConfig = (DlgcMediaConfig)config;
        this.myMixer = mixer;
        this.dtmfClamp = new String("yes");
        if (config == null) {
            log.debug("DlgcMixerAdapter::DlgcMixerAdapter note Adapter Configuration is null setting dtmf clamp to yes");
        } else if (config == MixerAdapter.DTMF_CLAMP) {
            log.debug("DlgcMixerAdapter::DlgcMixerAdapter note Adapter Configuration is null setting dtmf clamp to yes");
        } else if (config == MixerAdapter.DTMFCLAMP_VOLUME) {
            log.debug("DlgcMixerAdapter::DlgcMixerAdapter note Adapter Configuration is set to DTMF_CLAMP and Volume setting dtmf clamp to yes only Volume not supported.");
        } else if (config == MixerAdapter.EMPTY) {
            log.debug("DlgcMixerAdapter::DlgcMixerAdapter note Adapter Configuration is set to EMPTY setting dtmf clamp to no");
            this.dtmfClamp = new String("no");
        }
        this.buildUri(this.getClass().getName());
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "DlgcMixerAdapter CTOR - Mixer Adapter Created");
    }

    public DlgcMixerAdapter(DlgcMediaMixer mixer, MediaSession ms, Configuration<MixerAdapter> config, String prefix) {
        super(ms, prefix);
        this.myMixer = mixer;
        this.dtmfClamp = new String("yes");
        if (config == null) {
            log.debug("DlgcMixerAdapter::DlgcMixerAdapter note Adapter Configuration is null setting dtmf clamp to yes");
        } else if (config == MixerAdapter.DTMF_CLAMP) {
            log.debug("DlgcMixerAdapter::DlgcMixerAdapter note Adapter Configuration is null setting dtmf clamp to yes");
        } else if (config == MixerAdapter.DTMFCLAMP_VOLUME) {
            log.debug("DlgcMixerAdapter::DlgcMixerAdapter note Adapter Configuration is set to DTMF_CLAMP and VOLUME setting dtmf clamp to yes only volume not supported");
        } else if (config == MixerAdapter.EMPTY) {
            log.debug("DlgcMixerAdapter::DlgcMixerAdapter note Adapter Configuration is set to EMPTY setting dtmf clamp to no");
            this.dtmfClamp = new String("no");
        }
        this.buildUri(this.getClass().getName());
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "DlgcMixerAdapter CTOR - Mixer Adapter Created");
    }

    @Override
    public MediaConfig getConfig() {
        return this.myConfig;
    }

    public DlgcMediaMixer getMixer() {
        return this.myMixer;
    }

    public static DlgcParameters loadSupportedParameters() {
        return supportedParameters;
    }

    public Parameters getDefaultParameters() {
        DlgcParameters parameters = new DlgcParameters();
        for (Parameter param : supportedParameters.keySet()) {
            parameters.put(param, ((DlgcParameter)supportedParameters.get(param)).getValue());
        }
        return parameters;
    }

    public String getDtmfClamp() {
        return this.dtmfClamp;
    }

    public void setDtmfClamp(String val) {
        this.dtmfClamp = val;
    }

    @Override
    public JoinableContainer getMasterJoinable() {
        return this.myMixer;
    }

    @Override
    public DlgcMixerAdapterProxy getProxy() {
        DlgcMediaSession ms = (DlgcMediaSession)this.getMediaSession();
        String sasId = ms.getProxyId();
        String containerProxyId = this.getProxyId();
        String msId = ms.getMediaObject();
        return new DlgcMixerAdapterProxy(sasId, containerProxyId, msId);
    }

    static {
        log = LoggerFactory.getLogger(DlgcMixerAdapter.class);
        supportedParameters = new DlgcParameters();
    }
}

