/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mixer;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaConfig;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxyHelper;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapter;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapterProxy;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResource;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipB2BUA;
import java.io.Serializable;
import java.net.URI;
import java.util.Iterator;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.JoinEventListener;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableStream;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.mixer.MixerAdapter;
import javax.media.mscontrol.mixer.MixerEvent;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.AllocationEventListener;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcMediaMixerProxy
extends DlgcProxy
implements MediaMixer,
Serializable {
    private static final long serialVersionUID = 139393872L;
    private boolean bInstrument = false;
    private static Logger log = LoggerFactory.getLogger(DlgcMixerAdapterProxy.class);

    public DlgcMediaMixerProxy(String id, String mediaSessionId, String msId) {
        super(id, mediaSessionId, msId);
        String prop = DlgcSipB2BUA.myProperties.getProperty("instrument.mixerAdapter");
        if (prop != null && prop.equals("yes")) {
            this.bInstrument = true;
            log.debug("MixerAdapter Intrumentation enabled");
        }
    }

    public MixerAdapter createMixerAdapter(Configuration<MixerAdapter> preConfig) throws MsControlException {
        DlgcMediaConfig predefConf = null;
        if (DlgcSipB2BUA.isMediaTypeIPMS()) {
            predefConf = DlgcMediaConfig.getContainerSupportedConfiguration(preConfig);
            return this.createMixerAdapter(predefConf, Parameters.NO_PARAMETER);
        }
        if (preConfig == null) {
            throw new MsControlException("Cannot create createMixerAdapter MediaConfig parameter are null");
        }
        if (preConfig == MixerAdapter.DTMFCLAMP_VOLUME) {
            throw new MsControlException("MixerAdapter : DTMFCLAMP_VOLUME is not supported in this version of the connector.");
        }
        return this.createMixerAdapter(preConfig, Parameters.NO_PARAMETER);
    }

    public MixerAdapter createMixerAdapter(Configuration<MixerAdapter> preConfig, Parameters params) throws MsControlException {
        if (preConfig == null) {
            throw new MsControlException("Cannot create createMixerAdapter MediaConfig parameter are null");
        }
        if (this.bInstrument) {
            log.debug("III:  Entering DlgcMediaMixerProxy::createMixerAdapter with config =  " + preConfig.toString());
        }
        DlgcMixerAdapter mxa = null;
        if (this.bInstrument) {
            log.debug("III:  Entering DlgcMediaMixerProxy::createMixerAdapter ");
        }
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String containerProxyId = this.getContainerProxyId();
            String mediaId = this.getMsObjectId();
            String sasId = this.getProxyId();
            if (this.bInstrument) {
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter: appSession = " + appSession.toString());
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter: containerProxyId = " + containerProxyId);
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter: MediaSessionObjId = " + mediaId);
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter: sasId = " + sasId);
            }
            if (this.bInstrument) {
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter: ready to call appSession.doAction worker...");
            }
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaMixer lmx = (DlgcMediaMixer)session.getMediaObjectByProxyId(containerProxyId);
            if (this.bInstrument) {
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter:run(): session = " + session.toString());
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter:run(): MediaMixeObj = " + lmx.toString());
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter:run(): calling MediaMixeObj createMixerAdapter... ");
            }
            mxa = (DlgcMixerAdapter)lmx.createMixerAdapter(preConfig, params);
            DlgcMixerAdapterProxy pproxy = mxa.getProxy();
            pproxy.saveMediaSession(appSession, session);
            if (this.bInstrument) {
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter:run(): mixerAdapterObj = " + mxa.toString());
            }
            if (this.bInstrument) {
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter:out of run(): return mixerAdapterProxyObj = " + mxa.getProxy().toString());
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter: returning with no problems...");
            }
            return mxa.getProxy();
        }
        catch (Exception e) {
            log.error("Failed to create createMixerAdapter", (Throwable)e);
            throw new MsControlException("Failed to create createMixerAdapter", (Throwable)e);
        }
    }

    public MixerAdapter createMixerAdapter(MediaConfig arg0, Parameters arg1) throws MsControlException {
        DlgcMixerAdapter mxa = null;
        if (this.bInstrument) {
            log.debug("III:  Entering DlgcMediaMixerProxy::createMixerAdapter ");
        }
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String containerProxyId = this.getContainerProxyId();
            String mediaId = this.getMsObjectId();
            String sasId = this.getProxyId();
            if (this.bInstrument) {
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter: appSession = " + appSession.toString());
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter: containerProxyId = " + containerProxyId);
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter: MediaSessionObjId = " + mediaId);
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter: sasId = " + sasId);
            }
            if (this.bInstrument) {
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter: ready to call appSession.doAction worker...");
            }
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaMixer lmx = (DlgcMediaMixer)session.getMediaObjectByProxyId(containerProxyId);
            if (this.bInstrument) {
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter:run(): session = " + session.toString());
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter:run(): MediaMixeObj = " + lmx.toString());
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter:run(): calling MediaMixeObj createMixerAdapter... ");
            }
            mxa = (DlgcMixerAdapter)lmx.createMixerAdapter(arg0, arg1);
            DlgcMixerAdapterProxy pproxy = mxa.getProxy();
            pproxy.saveMediaSession(appSession, session);
            if (this.bInstrument) {
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter:run(): mixerAdapterObj = " + mxa.toString());
            }
            if (this.bInstrument) {
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter:out of run(): return mixerAdapterProxyObj = " + mxa.getProxy().toString());
                log.debug("III: DlgcMediaMixerProxy::createMixerAdapter: returning with no problems...");
            }
            return mxa.getProxy();
        }
        catch (Exception e) {
            log.error("Failed to create createMixerAdapter", (Throwable)e);
            throw new MsControlException("Failed to create createMixerAdapter", (Throwable)e);
        }
    }

    public JoinableStream getJoinableStream(JoinableStream.StreamType arg0) throws MsControlException {
        return DlgcProxyHelper.getJoinableStream(this, arg0);
    }

    public JoinableStream[] getJoinableStreams() throws MsControlException {
        return DlgcProxyHelper.getJoinableStreams(this);
    }

    public Joinable[] getJoinees() throws MsControlException {
        return DlgcProxyHelper.getJoinees(this);
    }

    public Joinable[] getJoinees(Joinable.Direction arg0) throws MsControlException {
        return DlgcProxyHelper.getJoinees(this, arg0);
    }

    public void join(Joinable.Direction arg0, Joinable arg1) throws MsControlException {
        DlgcProxyHelper.join(this, arg0, arg1);
    }

    public void joinInitiate(Joinable.Direction arg0, Joinable arg1, Serializable arg2) throws MsControlException {
        DlgcProxyHelper.joinInitiate(this, arg0, arg1, arg2);
    }

    public void unjoin(Joinable arg0) throws MsControlException {
        DlgcProxyHelper.unjoin(this, arg0);
    }

    public void unjoinInitiate(Joinable arg0, Serializable arg1) throws MsControlException {
        DlgcProxyHelper.unjoinInitiate(this, arg0, arg1);
    }

    public void addListener(JoinEventListener arg0) {
        DlgcProxyHelper.addListener((DlgcProxy)this, arg0);
    }

    public MediaSession getMediaSession() {
        return DlgcProxyHelper.getMediaSession(this);
    }

    public void removeListener(JoinEventListener arg0) {
        DlgcProxyHelper.removeListener((DlgcProxy)this, arg0);
    }

    protected boolean isTCKEnabled() {
        String tckFlag = System.getenv("TCK_ENABLED");
        log.debug("Value of TCK_ENABLED flag is :" + tckFlag);
        boolean isTCKEnabled = false;
        if (null == tckFlag || tckFlag.equalsIgnoreCase("NO")) {
            log.warn("Environment Variable: " + "TCK_ENABLED" + " not set");
            log.warn("Assuming TCK is not enabled");
            isTCKEnabled = false;
        } else if (tckFlag.equalsIgnoreCase("YES")) {
            isTCKEnabled = true;
        }
        log.debug("Value of TCK_ENABLED flag is :" + isTCKEnabled);
        return isTCKEnabled;
    }

    public void confirm() throws MsControlException {
        DlgcProxyHelper.confirm(this);
    }

    public MediaConfig getConfig() {
        return DlgcProxyHelper.getConfig(this);
    }

    public <R> R getResource(Class<R> arg0) throws MsControlException {
        R resource = DlgcProxyHelper.getResource(this, arg0);
        DlgcProxy p = null;
        if (resource != null) {
            p = ((DlgcResource)resource).getProxy();
        }
        return (R)p;
    }

    public void triggerAction(Action arg0) {
        DlgcProxyHelper.triggerAction(this, arg0);
    }

    public Parameters createParameters() {
        return DlgcProxyHelper.createParameters(this);
    }

    public Iterator<MediaObject> getMediaObjects() {
        return DlgcProxyHelper.getMediaObjects(this);
    }

    public <T extends MediaObject> Iterator<T> getMediaObjects(Class<T> arg0) {
        return DlgcProxyHelper.getMediaObjects(this, arg0);
    }

    public Parameters getParameters(Parameter[] arg0) {
        return DlgcProxyHelper.getParameters(this, arg0);
    }

    public URI getURI() {
        return DlgcProxyHelper.getURI(this);
    }

    public void release() {
        DlgcProxyHelper.release(this);
    }

    public void setParameters(Parameters arg0) {
        DlgcProxyHelper.setParameters(this, arg0);
    }

    public void addListener(AllocationEventListener arg0) {
        DlgcProxyHelper.addListener((DlgcProxy)this, arg0);
    }

    public void removeListener(AllocationEventListener arg0) {
        DlgcProxyHelper.removeListener((DlgcProxy)this, arg0);
    }

    public void addListener(MediaEventListener<MixerEvent> arg0) {
        DlgcProxyHelper.addListener((DlgcProxy)this, arg0);
    }

    public void removeListener(MediaEventListener<MixerEvent> arg0) {
        DlgcProxyHelper.removeListener((DlgcProxy)this, arg0);
    }
}

