/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mixer;

import com.vendor.dialogic.javax.media.mscontrol.DlgcISipB2BUAMsProtocolBridge;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameter;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProtocolException;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableStream;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixerProxy;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapter;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapterConfig;
import com.vendor.dialogic.javax.media.mscontrol.mixer.parameters.DlgcEnabledEventsParameter;
import com.vendor.dialogic.javax.media.mscontrol.mixer.parameters.DlgcMaxPortsParameter;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.WrongStateException;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.join.JoinableStream;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.mixer.MixerAdapter;
import javax.media.mscontrol.mixer.MixerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.media.mscontrol.resource.AllocationEvent;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcMediaMixer
extends DlgcJoinableContainer
implements MediaMixer {
    private List<DlgcNetworkConnection> confLegList;
    private List<DlgcNetworkConnection> confVideoLegList;
    private Lock confLegLock;
    private Lock regionMapLock;
    private Map<Integer, Boolean> regionIdMap;
    private static int maxRegions = 10;
    protected List<MediaEventListener<MixerEvent>> mediaMixerEventListenerList = new ArrayList<MediaEventListener<MixerEvent>>();
    private static DlgcParameters supportedParameters;
    private static Logger log;
    private static final long serialVersionUID = -2708197083894881414L;
    protected String conferenceId;
    protected boolean conferenceCreated = false;
    protected String mixerControlLegSASID = null;

    public Integer getAvailableRegionId() {
        this.regionMapLock.lock();
        Integer Id = 0;
        for (Map.Entry<Integer, Boolean> entry : this.regionIdMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            Id = entry.getKey();
            this.regionIdMap.put(Id, false);
            break;
        }
        this.regionMapLock.unlock();
        return Id;
    }

    public void releaseRegionId(Integer Id) {
        this.regionMapLock.lock();
        if (Id != 0 && Id <= maxRegions) {
            this.regionIdMap.put(Id, true);
        }
        this.regionMapLock.unlock();
    }

    public List<DlgcNetworkConnection> getConfLegList() {
        return this.confLegList;
    }

    public List<DlgcNetworkConnection> getConfVideoLegList() {
        return this.confVideoLegList;
    }

    public void getConfLegLock() {
        this.confLegLock.lock();
    }

    public void releaseConfLegLock() {
        this.confLegLock.unlock();
    }

    public void addNewConfLegToList(DlgcNetworkConnection nc) {
        this.confLegLock.lock();
        this.confLegList.add(nc);
        DlgcNetworkConnection.JoinableStreamMode iStreamMode = nc.getJoinableStreamMode();
        if (iStreamMode.equals((Object)DlgcNetworkConnection.JoinableStreamMode.AUDIO_VIDEO) || iStreamMode.equals((Object)DlgcNetworkConnection.JoinableStreamMode.VIDEO)) {
            this.confVideoLegList.add(nc);
        }
        this.confLegLock.unlock();
    }

    public void removeConfLegFromList(DlgcNetworkConnection nc) {
        this.confLegLock.lock();
        this.confLegList.remove(nc);
        this.confVideoLegList.remove(nc);
        this.confLegLock.unlock();
    }

    public DlgcMediaMixer(MediaConfig cfg, MediaSession ms, String prefix) {
        super(ms, prefix);
        this.init1(cfg, ms);
    }

    public DlgcMediaMixer(MediaConfig cfg, MediaSession ms) {
        super(ms, "MX-");
        this.init1(cfg, ms);
    }

    private void init1(MediaConfig cfg, MediaSession ms) {
        Integer nextI;
        this.buildUri(this.getClass().getName());
        this.joinMasterPriority = 1;
        Random randomGenerator = new Random();
        Integer confNumber = nextI = Integer.valueOf(randomGenerator.nextInt(Integer.MAX_VALUE));
        Integer secondSeed = new Integer((int)System.nanoTime());
        this.conferenceId = ("dlgcjmc-" + confNumber).concat(secondSeed.toString());
        log.debug("DlgcMediaMixer::init1: conferenceId: " + this.conferenceId);
        this.setDefaultParameters(this.getDefaultParameters());
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "\n Creating conference = " + this.conferenceId);
        this.confLegList = new Vector<DlgcNetworkConnection>();
        this.confVideoLegList = new Vector<DlgcNetworkConnection>();
        this.confLegLock = new ReentrantLock();
        this.regionMapLock = new ReentrantLock();
        this.regionIdMap = new HashMap<Integer, Boolean>();
        for (int i = 1; i < maxRegions + 1; ++i) {
            this.regionIdMap.put(i, true);
        }
        this.config = cfg;
    }

    public DlgcMediaMixer(MediaConfig cfg, MediaSession ms, Parameters params, String prefix) {
        super(ms, prefix);
        this.init2(cfg, ms, params);
    }

    public DlgcMediaMixer(MediaConfig cfg, MediaSession ms, Parameters params) {
        super(ms, "MX-");
        this.init2(cfg, ms, params);
    }

    private void init2(MediaConfig cfg, MediaSession ms, Parameters params) {
        String mediaMixerId = null;
        if (null != params && !params.isEmpty()) {
            Set paramSet = params.entrySet();
            Iterator paramIt = paramSet.iterator();
            Map.Entry pair = null;
            while (paramIt.hasNext()) {
                pair = (Map.Entry)paramIt.next();
                if (!((Parameter)pair.getKey()).toString().equalsIgnoreCase("MEDIAOBJECT_ID")) continue;
                mediaMixerId = pair.getValue().toString();
            }
        }
        if (null != mediaMixerId) {
            this.buildUri(this.getClass().getName() + "/" + mediaMixerId);
        } else {
            this.buildUri(this.getClass().getName());
        }
        this.joinMasterPriority = 1;
        Random randomGenerator = new Random();
        Integer nextI = randomGenerator.nextInt(Integer.MAX_VALUE);
        Integer secondSeed = new Integer((int)System.nanoTime());
        Integer confNumber = nextI;
        this.conferenceId = ("dlgcjmc-" + confNumber).concat(secondSeed.toString());
        log.debug("DlgcMediaMixer::init2: conferenceId: " + this.conferenceId);
        this.setDefaultParameters(this.getDefaultParameters());
        if (params != null) {
            this.setParameters(params);
        }
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "\n Creating conference = " + this.conferenceId);
        this.config = cfg;
        this.confLegList = new Vector<DlgcNetworkConnection>();
        this.confVideoLegList = new Vector<DlgcNetworkConnection>();
        this.confLegLock = new ReentrantLock();
        this.regionMapLock = new ReentrantLock();
        this.regionIdMap = new HashMap<Integer, Boolean>();
        for (int i = 1; i < maxRegions + 1; ++i) {
            this.regionIdMap.put(i, true);
        }
    }

    public void addLeg(DlgcSdpPortManager sdppm, DlgcMixerAdapter mxa) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "DlgcMediaMixer::addLeg");
        try {
            DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode mode = this.translateMixMode((JoinableContainer)sdppm.getContainer());
            String sdp = new String(sdppm.getUserAgentSessionDescription());
            String request = DlgcSipServlet.getProtocolBridge().createConfigureLegMsg(mode, false, mxa, DlgcISipB2BUAMsProtocolBridge.DTMF_CLAMP_SETTINGS.USE_NEW_SETTING, null);
            String user = "conf=" + this.conferenceId;
            MimeMultipart content = new MimeMultipart();
            InternetHeaders sdpHeader = new InternetHeaders();
            sdpHeader.addHeader("Content-Type", "application/sdp");
            MimeBodyPart sdpBodyPart = new MimeBodyPart(sdpHeader, sdp.getBytes());
            InternetHeaders mscmlHeader = new InternetHeaders();
            mscmlHeader.addHeader("Content-Type", "application/mediaservercontrol+xml");
            MimeBodyPart mscmlBodyPart = new MimeBodyPart(mscmlHeader, request.getBytes());
            content.addBodyPart((BodyPart)sdpBodyPart);
            content.addBodyPart((BodyPart)mscmlBodyPart);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            content.writeTo((OutputStream)stream);
            this.sendSipMessage(new DlgcSipMessage((JoinableContainer)sdppm.getContainer(), "INVITE", user, content.getContentType(), stream.toString(), null));
        }
        catch (SdpPortManagerException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    public void addLeg(DlgcMediaGroup mg) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "DlgcMediaMixer::addLeg(mg)");
        try {
            DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode mode = this.translateMixMode(mg);
            String sdp = DlgcSipServlet.sipB2BUA.createNoMediaSDP();
            String request = DlgcSipServlet.getProtocolBridge().createConfigureLegMsg(mode, true, null, DlgcISipB2BUAMsProtocolBridge.DTMF_CLAMP_SETTINGS.USE_PREV_SETTING, null);
            String user = "conf=" + this.conferenceId;
            MimeMultipart content = new MimeMultipart();
            InternetHeaders sdpHeader = new InternetHeaders();
            sdpHeader.addHeader("Content-Type", "application/sdp");
            MimeBodyPart sdpBodyPart = new MimeBodyPart(sdpHeader, sdp.getBytes());
            InternetHeaders mscmlHeader = new InternetHeaders();
            mscmlHeader.addHeader("Content-Type", "application/mediaservercontrol+xml");
            MimeBodyPart mscmlBodyPart = new MimeBodyPart(mscmlHeader, request.getBytes());
            content.addBodyPart((BodyPart)sdpBodyPart);
            content.addBodyPart((BodyPart)mscmlBodyPart);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            content.writeTo((OutputStream)stream);
            this.sendSipMessage(new DlgcSipMessage(mg, "INVITE", user, content.getContentType(), stream.toString(), null));
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    protected DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode translateMixMode(JoinableContainer peer) throws MsControlException {
        Joinable.Direction dir;
        DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode mode = null;
        boolean bTrace = DlgcInstrumentPropertyMgr.bTraceJoin;
        if (bTrace) {
            log.debug("TranslateMixMode peer JoinableConchristainer passed in = " + ((DlgcJoinableContainer)peer).getMediaObject());
        }
        DlgcJoinableContainer jc = (DlgcJoinableContainer)peer;
        DlgcJoinableStream djs = (DlgcJoinableStream)jc.getJoinableStream(JoinableStream.StreamType.audio);
        if (bTrace) {
            if (djs != null) {
                DlgcJoinableContainer djsc = (DlgcJoinableContainer)djs.getContainer();
                log.debug("peer.getJoinableStream(StreamType.audio); returned NOT NULL JoinableConainer Container = " + djsc.getMediaObject());
            } else {
                log.debug("peer.getJoinableStream(StreamType.audio); returned NULL NULL");
            }
        }
        mode = (dir = this.getStreamDirection(djs)) == null ? DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode.FULL : (dir.equals((Object)Joinable.Direction.DUPLEX) ? DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode.FULL : (dir.equals((Object)Joinable.Direction.RECV) ? DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode.PARKED : DlgcISipB2BUAMsProtocolBridge.ConfLegMixMode.MUTE));
        return mode;
    }

    public void removeLeg(DlgcMediaGroup mg) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "DlgcMediaMixer::removeLeg(mg) sending BYE to MS to remove leg");
        DlgcSipMessage message = new DlgcSipMessage(mg, "BYE", null, "none", null);
        this.sendSipMessage(message);
    }

    public void parkLeg(DlgcSdpPortManager sdppm) {
    }

    public void unparkLeg(DlgcSdpPortManager sdppm, MixerAdapter mxa) {
    }

    public void unparkLeg(DlgcSdpPortManager sdppm) {
    }

    public void doUunparkLeg(DlgcSdpPortManager sdppm, MixerAdapter mxa, DlgcISipB2BUAMsProtocolBridge.DTMF_CLAMP_SETTINGS tcs) {
    }

    public Parameters getDefaultParameters() {
        DlgcParameters parameters = new DlgcParameters();
        for (Parameter param : supportedParameters.keySet()) {
            parameters.put(param, ((DlgcParameter)supportedParameters.get(param)).getValue());
        }
        return parameters;
    }

    public MixerAdapter createMixerAdapter(Configuration<MixerAdapter> preConfig) throws MsControlException {
        return this.createMixerAdapter(preConfig, Parameters.NO_PARAMETER);
    }

    public MixerAdapter createMixerAdapter(Configuration<MixerAdapter> preConfig, Parameters params) throws MsControlException {
        if (this.released) {
            throw new WrongStateException("This MediaSession has been released");
        }
        DlgcMediaSession ms = (DlgcMediaSession)this.getMediaSession();
        MediaConfig mixerAdapterConfig = ms.getFactory().getMediaConfig(preConfig);
        return this.createMixerAdapter(mixerAdapterConfig, Parameters.NO_PARAMETER);
    }

    public MixerAdapter createMixerAdapter(MediaConfig conf, Parameters params) throws MsControlException {
        DlgcMediaSession ms = (DlgcMediaSession)this.getMediaSession();
        DlgcMixerAdapterConfig mxaConfig = (DlgcMixerAdapterConfig)conf;
        if (this.released) {
            throw new WrongStateException("This MediaSession has been released");
        }
        if (conf == null) {
            throw new MsControlException("MediaConfig parameter cannot be null");
        }
        DlgcMixerAdapterConfig mixerAdapterConfig = (DlgcMixerAdapterConfig)mxaConfig.createCustomizedClone(params);
        DlgcMixerAdapter mxa = new DlgcMixerAdapter(this, (MediaSession)ms, mixerAdapterConfig, "MXA-");
        this.addMediaObject(mxa);
        ms.getProxyIdMap().put(mxa.getProxyId(), mxa);
        return mxa;
    }

    public void addListener(MediaEventListener<MixerEvent> mediaMixerEvent) {
        try {
            this.mediaMixerEventListenerList.add(mediaMixerEvent);
        }
        catch (Exception e) {
            log.error("Failed to Add Media Mixer Event Listener", (Throwable)e);
        }
    }

    public void removeListener(MediaEventListener<MixerEvent> mediaMixerEvent) {
        try {
            this.mediaMixerEventListenerList.remove(mediaMixerEvent);
        }
        catch (Exception e) {
            log.error("Failed to Remove Media Mixer Event Listener", (Throwable)e);
        }
    }

    public String getConfId() {
        return this.conferenceId;
    }

    public boolean mixerInReadyState() {
        return true;
    }

    public static DlgcParameters loadSupportedParameters() {
        return supportedParameters;
    }

    protected void createConference() {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "DlgcMediaMixer::createConference() sending INVITE to MS to createConference leg");
        Parameters params = this.getParameters(null);
        try {
            String sdp = DlgcSipServlet.sipB2BUA.createNoMediaSDP();
            String request = DlgcSipServlet.getProtocolBridge().createConfigureConferenceMsg(this.config, (DlgcParameters)params, null, this.conferenceId, this);
            String user = "conf=" + this.conferenceId;
            MimeMultipart content = new MimeMultipart();
            InternetHeaders sdpHeader = new InternetHeaders();
            sdpHeader.addHeader("Content-Type", "application/sdp");
            MimeBodyPart sdpBodyPart = new MimeBodyPart(sdpHeader, sdp.getBytes());
            InternetHeaders mscmlHeader = new InternetHeaders();
            mscmlHeader.addHeader("Content-Type", "application/mediaservercontrol+xml");
            MimeBodyPart mscmlBodyPart = new MimeBodyPart(mscmlHeader, request.getBytes());
            content.addBodyPart((BodyPart)sdpBodyPart);
            content.addBodyPart((BodyPart)mscmlBodyPart);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            content.writeTo((OutputStream)stream);
            this.sendSipMessage(new DlgcSipMessage(this, "INVITE", user, content.getContentType(), stream.toString(), null));
        }
        catch (DlgcProtocolException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void destroyConference() {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "Entering MIXER destoryConference");
        if (this.conferenceCreated) {
            log.debug("MIXER destoryConference Sending BYE to MS ");
            DlgcSipMessage message = new DlgcSipMessage(this, "BYE", null, "none", null);
            this.sendSipMessage(message);
        }
        log.debug("Leaving MIXER destoryConference");
    }

    @Override
    public JoinableContainer getMasterJoinable() {
        return this;
    }

    @Override
    public void processSipBye(SipServletRequest request) {
        this.conferenceCreated = false;
        super.processSipBye(request);
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "MIXER processSipBye invalidating the SAS");
        SipApplicationSession sas = ((DlgcMediaSession)this.getMediaSession()).getSAS();
        if (sas != null && sas.isValid()) {
            sas.setExpires(5);
            log.debug(appLogId + "MIXER processSipBye invalidating the SAS DONE");
        }
    }

    @Override
    public void processSipBye(SipServletResponse response) {
        this.conferenceCreated = false;
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "MIXER processSipBye invalidating the SAS  got SipServletResponse");
        SipApplicationSession sas = ((DlgcMediaSession)this.getMediaSession()).getSAS();
        if (sas != null && sas.isValid()) {
            sas.setExpires(5);
            log.debug(appLogId + "MIXER processSipBye invalidating the SAS DONE");
        }
    }

    @Override
    public void processSipInvite(SipServletResponse response) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "MIXER processSipInvite got SipServletResponse");
        try {
            if (response.getStatus() == 200) {
                log.debug(appLogId + "MIXER Conference was created");
                this.allocEventType = AllocationEvent.ALLOCATION_CONFIRMED;
                SipServletRequest request = response.createAck();
                request.send();
                this.conferenceCreated = true;
                this.startSessionTimer(response);
            } else {
                log.error(appLogId + "Conference could not be created at Media Server - response error: status = " + response.toString());
                this.allocEventType = AllocationEvent.IRRECOVERABLE_FAILURE;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.isConfirmed = true;
        log.debug(appLogId + "MIXER Conference Created Notificaiton calling postAllocationEvent()");
        this.postAllocationEvent();
    }

    @Override
    public void release() {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "MIXER Calling Mixer object release");
        super.release();
        log.debug(appLogId + "removing calling Mixer destroyConference() for now");
        if (DlgcSipB2BUA.getMixerConferenceDestroy()) {
            log.debug("FYI: Calling destroyConference via DlgcMediaMixer...");
            this.destroyConference();
            SipApplicationSession sas = ((DlgcMediaSession)this.getMediaSession()).getSAS();
            if (sas != null && sas.isValid()) {
                sas.invalidate();
                log.debug(appLogId + "MIXER release invalidating the SAS DONE ");
            } else {
                log.warn(appLogId + "MIXER release invalidating the SAS CANT BE DONE SAS NOT FOUND");
            }
        } else {
            log.debug("FYI: NOT CALLING destroyConference via DlgcMediaMixer...");
        }
        log.debug(appLogId + "Calling Mixer destroyConference DONE");
    }

    @Override
    public DlgcMediaMixerProxy getProxy() {
        DlgcMediaSession ms = (DlgcMediaSession)this.getMediaSession();
        String sasId = ms.getProxyId();
        String containerProxyId = this.getProxyId();
        String msId = ms.getMediaObject();
        return new DlgcMediaMixerProxy(sasId, containerProxyId, msId);
    }

    @Override
    public String toDebug() {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        String retStr = new String();
        retStr = retStr + appLogId + "\n $$$$$$ JMC Object DlgcMediaMixer = " + " \n";
        retStr = retStr + "Debug ID = " + this.debugId.toString() + " \n";
        retStr = retStr + "Conference ID = " + this.conferenceId + " \n";
        retStr = retStr + "$$$$$$";
        return retStr;
    }

    public void setControLLegSAS(SipApplicationSession appSession) {
        this.mixerControlLegSASID = appSession.getId();
    }

    public SipApplicationSession getControlLegSAS() {
        SipApplicationSession sas = null;
        try {
            sas = DlgcSipServlet.getSSU().getApplicationSessionById(this.mixerControlLegSASID);
            if (sas.getExpirationTime() != 0L) {
                sas.setExpires(0);
            }
        }
        catch (NullPointerException nullEx) {
            log.error("getControlLegSAS:: loadSas() Exception: Could Nof find ApplicationSession Key call to sessionUtil returns null.");
        }
        return sas;
    }

    static {
        log = LoggerFactory.getLogger(DlgcMediaMixer.class);
        supportedParameters = new DlgcParameters();
        supportedParameters.put(MediaMixer.ENABLED_EVENTS, DlgcEnabledEventsParameter.instance);
        supportedParameters.put(MediaMixer.MAX_PORTS, DlgcMaxPortsParameter.instance);
    }
}

