/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mixer;

import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcActiveTalker
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String conferenceId;
    protected String speakerId;
    protected DlgcXNetworkConnection speakerNC = null;
    protected DlgcXMediaMixer myMixer = null;
    private static Logger log = LoggerFactory.getLogger(DlgcActiveTalker.class);

    public DlgcActiveTalker(String eventName, String speaker, DlgcXMediaMixer mixer) {
        this.speakerId = speaker;
        this.myMixer = mixer;
        this.findSpeakerNC();
    }

    public String getConferenceId() {
        return this.conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getSpeakerId() {
        return this.speakerId;
    }

    public void setSpeakerId(String speakerId) {
        this.speakerId = speakerId;
    }

    private void findSpeakerNC() {
        List<DlgcNetworkConnection> connectionList = this.myMixer.getConfLegList();
        if (connectionList.isEmpty()) {
            log.debug("The Mixer Connection List is empty thus can't process the Active Talker Request... this should never happen unless with have a raise condition.");
        } else {
            log.debug("The Mixer Connection List contains connections to the mixer thus mapping the speaker conn::id to the actual JSR 309 NetworkConnection Object");
            for (DlgcNetworkConnection nc : connectionList) {
                String msmlDialogTag;
                if (nc == null || nc.getDlgIpmsSession() == null || (msmlDialogTag = "conn:" + nc.getDlgIpmsSession().getSipTag()).compareToIgnoreCase(this.speakerId) != 0) continue;
                log.debug("Found network connection match: " + this.speakerId.toString());
                this.speakerNC = (DlgcXNetworkConnection)nc;
                break;
            }
        }
    }
}

