/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mediagroup;

import com.vendor.dialogic.javax.media.mscontrol.DlgcISipB2BUAMsProtocolBridge;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProtocolException;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcRecorder;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcRecorderEvent;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.recorder.states.DlgcRecorderState;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXConferenceControlLeg;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.msmlProtocol.DlgcMsmlDialogEventExitStatus;
import com.vendor.dialogic.javax.media.mscontrol.msmlProtocol.DlgcMsmlProtocolMessageMappingAssistance;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.RecorderEvent;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.RTC;
import javax.servlet.sip.SipServletResponse;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcXRecorder
extends DlgcRecorder {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcXRecorder.class);
    private String dialogId = null;

    public DlgcXRecorder(MediaGroup mg) {
        super(mg);
    }

    @Override
    public void sendRecordMsg(URI streamID, RTC[] rtcs, Parameters parameters) {
        try {
            Parameters params = this.getParameters(parameters);
            String dialogTarget = null;
            JoinableContainer transContainer = null;
            Joinable[] joinableArray = ((MediaGroup)this.container).getJoinees();
            DlgcMediaGroup mg = (DlgcMediaGroup)this.getContainer();
            DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode recorderMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
            String modeStr = (String)mg.getMediaSession().getAttribute("RECORDER_MODE");
            if (modeStr == null) {
                recorderMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
            } else if (modeStr.equalsIgnoreCase("audio")) {
                recorderMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO;
            } else if (modeStr.equalsIgnoreCase("video")) {
                recorderMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO;
            } else if (modeStr.equalsIgnoreCase("audio_video")) {
                recorderMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
            }
            DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode playerMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
            modeStr = (String)mg.getMediaSession().getAttribute("PLAYER_MODE");
            if (modeStr == null) {
                playerMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
            } else if (modeStr.equalsIgnoreCase("audio")) {
                playerMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO;
            } else if (modeStr.equalsIgnoreCase("video")) {
                playerMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO;
            } else if (modeStr.equalsIgnoreCase("audio_video")) {
                playerMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
            }
            log.debug("*16 sendRecordMsg Recorder MG: " + ((DlgcXMediaGroup)this.container).getMediaObject());
            for (Joinable j : joinableArray) {
                if (j instanceof NetworkConnection) {
                    log.debug("DlgcXRecorder::sendRecordMsg calling record on the call leg");
                    dialogTarget = ((DlgcNetworkConnection)j).getDlgIpmsSession().calculateDialogTargetField();
                    ((DlgcNetworkConnection)j).getDlgIpmsSession().addRequest("record");
                    transContainer = (JoinableContainer)this.container;
                    boolean bargeIn = this.determineBargIn(rtcs);
                    String dlgName = DlgcIpmsSession.getNewDialogName();
                    String request = DlgcSipServlet.getProtocolBridge().createRecordMsg(dialogTarget, dlgName, streamID, rtcs, (DlgcParameters)params, bargeIn, playerMode, recorderMode);
                    DlgcSipMessage msg = new DlgcSipMessage(transContainer, "INFO", null, "msml", request, dialogTarget);
                    msg.dialogName = dlgName;
                    DlgcXMediaGroup xmg = (DlgcXMediaGroup)this.container;
                    xmg.sendRecordMessage(msg, this);
                    this.setState(ACTIVATING);
                    continue;
                }
                if (!(j instanceof MediaMixer)) continue;
                DlgcXMediaMixer mx = (DlgcXMediaMixer)j;
                log.debug("DlgcXRecorder::sendRecordMsg calling recordConfernce()");
                this.recordConference(mx, streamID, rtcs, parameters);
            }
        }
        catch (DlgcProtocolException e) {
            e.printStackTrace();
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    private void recordConference(DlgcXMediaMixer mx, URI streamID, RTC[] rtcs, Parameters parameters) throws MsControlException {
        if (mx.getControlLeg() != null) {
            this.recordConferenceViaConfControlLeg(mx, streamID, rtcs, parameters);
        } else {
            this.recordConferenceViaNCLeg(mx, streamID, rtcs, parameters);
        }
    }

    private void recordConferenceViaConfControlLeg(DlgcXMediaMixer mx, URI streamID, RTC[] rtcs, Parameters parameters) {
        try {
            log.debug("Entering DlgcXRecorder::recordConferenceViaConfControlLeg");
            Parameters params = this.getParameters(parameters);
            String dialogTarget = null;
            Object transContainer = null;
            dialogTarget = mx.getProperControlLegConfId(null);
            DlgcIpmsSession dlgcSession = null;
            DlgcXConferenceControlLeg ctl = mx.getControlLeg();
            dlgcSession = ctl.getFromProxyNC(ctl.getControlNCProxy()).getDlgIpmsSession();
            dlgcSession.addRequest("record");
            boolean bargeIn = this.determineBargIn(rtcs);
            String dlgName = DlgcIpmsSession.getNewDialogName();
            DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode mode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
            DlgcMediaGroup mg = (DlgcMediaGroup)this.getContainer();
            DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode recorderMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
            String modeStr = (String)mg.getMediaSession().getAttribute("RECORDER_MODE");
            if (modeStr == null) {
                recorderMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
            } else if (modeStr.equalsIgnoreCase("audio")) {
                recorderMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO;
            } else if (modeStr.equalsIgnoreCase("video")) {
                recorderMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO;
            } else if (modeStr.equalsIgnoreCase("audio_video")) {
                recorderMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
            }
            DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode playerMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
            modeStr = (String)mg.getMediaSession().getAttribute("PLAYER_MODE");
            if (modeStr == null) {
                playerMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
            } else if (modeStr.equalsIgnoreCase("audio")) {
                playerMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO;
            } else if (modeStr.equalsIgnoreCase("video")) {
                playerMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO;
            } else if (modeStr.equalsIgnoreCase("audio_video")) {
                playerMode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
            }
            String request = DlgcSipServlet.getProtocolBridge().createRecordMsg(dialogTarget, dlgName, streamID, rtcs, (DlgcParameters)params, bargeIn, playerMode, recorderMode);
            DlgcSipMessage msg = new DlgcSipMessage(mx.getFromProxyNC(), "INFO", null, "msml", request, dialogTarget);
            msg.dialogName = dlgName;
            mx.sendRecordMessage(msg, this);
            this.setState(ACTIVATING);
        }
        catch (MsControlException e) {
            log.error(e.toString());
        }
        log.debug("Leaving DlgcXRecorder::recordConferenceViaConfControlLeg");
    }

    public boolean determineBargIn(RTC[] rtcs) {
        boolean bargeIn = false;
        if (rtcs != null) {
            for (RTC r : rtcs) {
                Action ca = MediaGroup.SIGDET_STOPPLAY.getAction();
                if (r.getAction() != ca) continue;
                bargeIn = true;
                break;
            }
        }
        if (bargeIn) {
            log.debug("DlgcXRecorder:: BargeIN set to true");
        } else {
            log.debug("DlgcXRecorder:: BargeIN set to false");
        }
        return bargeIn;
    }

    private void recordConferenceViaNCLeg(DlgcXMediaMixer mx, URI streamID, RTC[] rtcs, Parameters parameters) throws MsControlException {
        throw new MsControlException("Conference Recording only supported in conference control leg. This means that the application must use mixer.confirm()");
    }

    public String getRecorderPresentState() {
        return this.state.getName();
    }

    public void setRecorderStateToIdle() {
        this.setState(IDLE);
    }

    public void setRecorderStateToActive() {
        this.setState(ACTIVE);
    }

    @Override
    public void sendStopMsg() {
        if (this.dialogId == null) {
            return;
        }
        try {
            Joinable[] joinableArray;
            for (Joinable j : joinableArray = ((MediaGroup)this.container).getJoinees()) {
                if (j instanceof NetworkConnection) {
                    this.sendIvrLegRecordStopMsg((DlgcNetworkConnection)j);
                    continue;
                }
                if (!(j instanceof MediaMixer)) continue;
                this.sendConfControlLegRecordStopMsg((DlgcXMediaMixer)j);
            }
        }
        catch (DlgcProtocolException e) {
            log.error(e.toString());
        }
        catch (MsControlException e) {
            log.error(e.toString());
        }
    }

    public void sendIvrLegRecordStopMsg(DlgcNetworkConnection nc) {
        log.debug("Entering DlgcXRecorder::sendIvrLegRecordStopMsg");
        try {
            String dialogTarget = this.dialogId;
            nc.getDlgIpmsSession().addRequest("stop");
            String request = DlgcSipServlet.getProtocolBridge().createStopMsg(dialogTarget);
            DlgcSipMessage msg = new DlgcSipMessage((JoinableContainer)this.container, "INFO", null, "msml", request, dialogTarget);
            this.sendSipMessage(msg);
        }
        catch (DlgcProtocolException e) {
            log.error(e.toString());
        }
        log.debug("Leaving DlgcXRecorder::sendIvrLegRecordStopMsg");
    }

    public void sendConfControlLegRecordStopMsg(DlgcXMediaMixer mx) {
        try {
            log.debug("Entering DlgcXRecorder::sendConfControlLegRecordStopMsg");
            String dialogTarget = this.dialogId;
            DlgcIpmsSession dlgcSession = null;
            DlgcXConferenceControlLeg ctl = mx.getControlLeg();
            dlgcSession = ctl.getFromProxyNC(ctl.getControlNCProxy()).getDlgIpmsSession();
            dlgcSession.addRequest("stop");
            String request = DlgcSipServlet.getProtocolBridge().createStopMsg(dialogTarget);
            DlgcSipMessage msg = new DlgcSipMessage(mx.getFromProxyNC(), "INFO", null, "msml", request, dialogTarget);
            mx.sendStop(msg, this);
            this.setState(STOPPING);
        }
        catch (MsControlException e) {
            log.error(e.toString());
        }
        log.debug("Leaving DlgcXRecorder::sendConfControlLegRecordStopMsg");
    }

    @Override
    public void processSipInfoRequest(MsmlDocument.Msml message, DlgcSipConnectorContentIdsProxy sipReqProxy) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "ENTER DlgcXRecorder:: processSipInfoRequest mediaServer Message ");
        DlgcIpmsSession dlgSession = null;
        DlgcNetworkConnection dlgcNetworkConnection = null;
        try {
            Joinable[] joinableArray = ((MediaGroup)this.container).getJoinees();
            DlgcXMediaMixer mx = null;
            for (Joinable j : joinableArray) {
                if (j instanceof NetworkConnection) {
                    dlgcNetworkConnection = (DlgcNetworkConnection)j;
                    dlgSession = ((DlgcNetworkConnection)j).getDlgIpmsSession();
                    continue;
                }
                if (!(j instanceof MediaMixer)) continue;
                mx = (DlgcXMediaMixer)j;
                dlgSession = mx.getActiveControlLeg().getDlgIpmsSession();
                mx.setConfRecordingState(DlgcXMediaMixer.ConfRecordingState.NOT_RECORDING);
            }
        }
        catch (MsControlException e) {
            e.printStackTrace();
            return;
        }
        if (message != null) {
            String eventName = new String("undefine");
            String cmd = null;
            DlgcRecorderEvent event = null;
            MsmlDocument.Msml.Event msmlEvent = message.getEvent();
            String eventValue = null;
            if (msmlEvent != null) {
                eventName = msmlEvent.getName2();
                List eventValueList = msmlEvent.getValueList();
                if (eventValueList.size() >= 1) {
                    eventValue = (String)eventValueList.get(0);
                }
            } else {
                log.error(appLogId + "MSML EVENT IS NULL");
            }
            cmd = eventName.equalsIgnoreCase("msml.dialog.exit") ? dlgSession.removePayloadRequest() : dlgSession.getPayloadRequest();
            if (cmd == null) {
                log.debug("*18 CMD IS NULL");
            } else {
                log.debug("*18 CMD: " + cmd);
            }
            if (eventName == null) {
                log.debug("*18 Event Name IS NULL");
            } else {
                log.debug("*18 Event Name: " + eventName);
            }
            if (eventName.equalsIgnoreCase("msml.record.complete")) {
                log.debug(appLogId + "msml.record.complete Event received. Queing up event");
                event = new DlgcRecorderEvent(message, this);
                if (null != eventValue && eventValue.equalsIgnoreCase("record.terminate")) {
                    event.setQualifier(RecorderEvent.STOPPED);
                } else if (null != eventValue && eventValue.equalsIgnoreCase("record.complete.maxlength")) {
                    event.setQualifier(RecorderEvent.DURATION_EXCEEDED);
                } else if (null != eventValue && eventValue.equalsIgnoreCase("record.failed.prespeech")) {
                    event.setQualifier(RecorderEvent.SILENCE);
                }
                event.setEventType(RecorderEvent.RECORD_COMPLETED);
                if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                    DlgcSync2AsyncMonitor monitor = this.getMonitor();
                    if (monitor == null) {
                        log.debug("SYNC_2_ASYNC DlgcXRecorder::processSipInfoRequest:stop running Recorder Stop in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
                    } else {
                        boolean bStatus = true;
                        log.debug("SYNC_2_ASYNC DlgcXRecorder::processSipInfoRequest:stop calling Monitor notifyRequestCompleted due to " + eventValue);
                        monitor.notifyRequestCompleted(bStatus, "Recorder Stopped");
                        log.debug("SYNC_2_ASYNC DlgcXRecorder::processSipInfoRequest:stop returned from Monitor notifyRequestCompleted due to " + eventValue);
                    }
                }
                List vl = msmlEvent.getValueList();
                Iterator vli = vl.iterator();
                String sv = null;
                while (vli.hasNext()) {
                    sv = (String)vli.next();
                    if (!sv.equalsIgnoreCase("record.complete.postspeech")) continue;
                    event.setQualifier(RecorderEvent.SILENCE);
                    break;
                }
                dlgSession.addRequest(event);
            } else if (eventName.equalsIgnoreCase("msml.dialog.exit")) {
                log.debug(appLogId + "DlgcXRecorder Receive Dialog Exit Event");
                DlgcMsmlDialogEventExitStatus dlgExitEventStatus = DlgcMsmlProtocolMessageMappingAssistance.getExitDialogEventStatus(message);
                if (dlgExitEventStatus.status == null) {
                    event = (DlgcRecorderEvent)dlgSession.removeEvent();
                    if (event != null) {
                        log.debug("*18 DlgcXRecorder:: Record Dialog Exit Received pull out event to send: " + event.getEventType().toString());
                    } else {
                        log.debug("*18 DlgcXRecorder:: Record Dialog Exit Received pull out event to send IS NULL");
                    }
                    if (event == null) {
                        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                            DlgcSync2AsyncMonitor monitor = this.getMonitor();
                            if (monitor == null) {
                                log.debug("SYNC_2_ASYNC DlgcXRecorder::processSipInfoRequest:stop running Recorder Stop in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
                            } else {
                                boolean bStatus = true;
                                log.debug("SYNC_2_ASYNC DlgcXRecorder::processSipInfoRequest:stop calling Monitor notifyRequestCompleted");
                                monitor.notifyRequestCompleted(bStatus, "Recorder Stopped");
                                log.debug("SYNC_2_ASYNC DlgcXRecorder::processSipInfoRequest:stop returned from Monitor notifyRequestCompleted");
                            }
                        }
                        event = new DlgcRecorderEvent(message, this);
                        event.setQualifier(RecorderEvent.STOPPED);
                        event.setError(MediaErr.NO_ERROR);
                        event.duration = 0;
                        event.setErrorText("");
                        ((DlgcRecorderState)this.getState()).recordCmpltEvent(this, event);
                        log.debug("Even tought recording never was executed; we still need to send a STOPPED Termination Event to the Application - Sending EVENT Type: " + event.getEventType().toString());
                    } else if (event.getEventType().equals(RecorderEvent.RECORD_COMPLETED)) {
                        DlgcRecorderState recorderPresentState;
                        DlgcSync2AsyncMonitor monitor;
                        log.debug("Sending record completed event");
                        if (cmd != null && cmd.compareToIgnoreCase("stop") == 0 && DlgcInstrumentPropertyMgr.bSync309ApiSupport && (monitor = this.getMonitor()) != null) {
                            boolean bStatus = true;
                            log.debug("SYNC_2_ASYNC DlgcXRecorder::processSipInfoRequest:stop calling Monitor notifyRequestCompleted due to record completed stop");
                            monitor.notifyRequestCompleted(bStatus, "Recorder Stopped");
                            log.debug("SYNC_2_ASYNC DlgcXRecorder::processSipInfoRequest:stop returned from Monitor notifyRequestCompleted due to record completed stop");
                        }
                        if ((recorderPresentState = (DlgcRecorderState)this.getState()) == null) {
                            log.debug("*18 recorderPresentState IS NULL");
                        } else {
                            log.debug("*18 recorderPresentState is " + recorderPresentState.toString());
                            recorderPresentState.recordCmpltEvent(this, event);
                        }
                    } else {
                        log.debug(appLogId + "MSML Dialog EXIT Recorder Event is not of Play Completed Event...doing nothing");
                    }
                } else {
                    log.debug("*18 DlgcXRecorder ELSE SECTION");
                    dlgSession.removeEvent();
                    event = new DlgcRecorderEvent(message, this);
                    event.setErrorText(dlgExitEventStatus.description);
                    event.setError(MediaErr.RESOURCE_UNAVAILABLE);
                    ((DlgcRecorderState)this.getState()).recordCmpltEvent(this, event);
                }
            }
        }
    }

    @Override
    public void processSipInfoResponse(SipServletResponse sipResponse, DlgcSipConnectorContentIdsProxy sipReqProxy) {
        if (sipResponse != null) {
            MsmlDocument.Msml requestMessage = this.extractMsmlResonseRequestMessage(sipResponse);
            int responseStatus = sipResponse.getStatus();
            if (responseStatus == 200) {
                try {
                    MsmlDocument.Msml.Dialogstart dlg = requestMessage.getDialogstartArray(0);
                    XmlObject[] r = dlg.selectPath("./group/record");
                    this.dialogId = dlg.getTarget() + "/dialog:" + dlg.getName();
                    if (r.length != 0) {
                        ((DlgcRecorderState)this.getState()).recordAckMsg(this, requestMessage, sipResponse);
                    }
                }
                catch (Exception e) {
                    try {
                        requestMessage.getDialogendArray(0);
                        this.dialogId = null;
                        ((DlgcRecorderState)this.getState()).stopAckMsg(this, requestMessage);
                    }
                    catch (Exception ex) {
                        log.error("DlgcXPlayer::handlePlayInfoResponse: Error exception: ", (Throwable)ex);
                    }
                }
            } else {
                this.setState(IDLE);
                String evErrMsg = "Media Server info response with error to a Record request: Internal Status: " + new Integer(responseStatus).toString();
                DlgcRecorderEvent event = new DlgcRecorderEvent(requestMessage, this, MediaErr.REFUSED, evErrMsg);
                event.setQualifier(RecorderEvent.NO_QUALIFIER);
                this.postMediaEvent(event);
            }
        }
    }
}

