/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mediagroup;

import com.vendor.dialogic.javax.media.mscontrol.DlgcISipB2BUAMsProtocolBridge;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaEvent;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProtocolException;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayerEvent;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.player.states.DlgcPlayerState;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.msmlProtocol.DlgcMsmlDialogEventExitStatus;
import com.vendor.dialogic.javax.media.mscontrol.msmlProtocol.DlgcMsmlProtocolMessageMappingAssistance;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceEvent;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSigDetectorFSM;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.net.URI;
import java.util.List;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.resource.RTC;
import javax.servlet.sip.SipServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcXPlayer
extends DlgcPlayer {
    private static final long serialVersionUID = 1L;
    private PLAYER_DETECTOR_MODE playerDetectorMode = PLAYER_DETECTOR_MODE.NONE;
    private static Logger log = LoggerFactory.getLogger(DlgcXPlayer.class);

    public DlgcXPlayer(MediaGroup mg) {
        super(mg);
        this.setDetectorMode(PLAYER_DETECTOR_MODE.NONE);
    }

    @Override
    public void sendPlayMsg(URI[] streamIds, RTC[] rtcs, Parameters parameters) throws MsControlException {
        if (streamIds == null || streamIds.length < 1) {
            throw new MsControlException("XMS Invalid streamIds - null or empty list");
        }
        Parameters params = this.getParameters(parameters);
        boolean barge = false;
        if (rtcs != null) {
            for (RTC r : rtcs) {
                if (r.toString().compareToIgnoreCase(MediaGroup.SIGDET_STOPPLAY.toString()) != 0) continue;
                barge = true;
                break;
            }
        }
        DlgcMediaGroup mg = (DlgcMediaGroup)this.getContainer();
        log.debug("DlgcXPlayer::mg OBJID: " + mg.getMediaObject());
        DlgcNetworkConnection jnc = mg.joinedWithNetworkConnectionX();
        String dialogTarget = null;
        if (jnc != null) {
            dialogTarget = jnc.getDlgIpmsSession().calculateDialogTargetField();
        } else {
            DlgcXMediaMixer mx = (DlgcXMediaMixer)mg.joinedWithMixer();
            if (mx != null) {
                log.debug("Mixer OBJID: " + mx.getMediaObject());
                jnc = mx.getActiveControlLeg();
                dialogTarget = mx.getProperControlLegConfId(jnc.getSdpPortMgrResource());
            } else {
                log.debug("Mixer is null");
            }
        }
        String dlgName = DlgcIpmsSession.getNewDialogName();
        DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode mode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
        String modeStr = (String)mg.getMediaSession().getAttribute("PLAYER_MODE");
        if (modeStr == null) {
            mode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
        } else if (modeStr.equalsIgnoreCase("audio")) {
            mode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO;
        } else if (modeStr.equalsIgnoreCase("video")) {
            mode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO;
        } else if (modeStr.equalsIgnoreCase("audio_video")) {
            mode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
        }
        String request = DlgcSipServlet.getProtocolBridge().createPlayMsg(dialogTarget, dlgName, streamIds, (DlgcParameters)params, barge, mode);
        jnc.getDlgIpmsSession().addRequest("play");
        DlgcSipMessage message = new DlgcSipMessage((JoinableContainer)this.container, "INFO", null, "msml", request, dialogTarget);
        message.dialogName = dlgName;
        mg.sendMediaMessage(message, this);
        this.setState(ACTIVATING);
    }

    @Override
    public void sendPlayCollectMsg(int numOfSignals, Parameter[] pattern, Parameters parameters, boolean bargeEnabled) throws MsControlException {
        this.setDetectorMode(PLAYER_DETECTOR_MODE.PLAY_AND_COLLECT);
        DlgcMediaGroup mg = (DlgcMediaGroup)this.getContainer();
        String dialogTarget = mg.joinedWithNetworkConnection().getDlgIpmsSession().calculateDialogTargetField();
        String dlgName = DlgcIpmsSession.getNewDialogName();
        DlgcSignalDetector sd = this.mySignalDetectorFSM.getSignalDetector();
        DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode mode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
        String modeStr = (String)mg.getMediaSession().getAttribute("PLAYER_MODE");
        if (modeStr == null) {
            mode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
        } else if (modeStr.equalsIgnoreCase("audio")) {
            mode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO;
        } else if (modeStr.equalsIgnoreCase("video")) {
            mode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO;
        } else if (modeStr.equalsIgnoreCase("audio_video")) {
            mode = DlgcISipB2BUAMsProtocolBridge.PlayerRecorderMode.AUDIO_VIDEO;
        }
        String requestStr = DlgcSipServlet.getProtocolBridge().createPlayCollectMsg(dialogTarget, dlgName, numOfSignals, pattern, (DlgcParameters)parameters, bargeEnabled, sd.isClearBufferFlag(), mode);
        sd.setClearBufferFlag(false);
        DlgcSipMessage message = new DlgcSipMessage((JoinableContainer)this.container, "INFO", null, "msml", requestStr, dialogTarget);
        message.dialogName = dlgName;
        mg.sendMediaMessage(message, this);
        this.setState(ACTIVATING);
    }

    public void setPlayerStateToIdle() {
        this.setState(IDLE);
    }

    public void setPlayerStateToActive() {
        this.setState(ACTIVE);
    }

    public String getPlayerPresentState() {
        return this.state.getName();
    }

    @Override
    public void sendCollectMsg(int numOfSignals, Parameter[] pattern, Parameters parameters, boolean bargeEnabled) throws MsControlException {
        this.setDetectorMode(PLAYER_DETECTOR_MODE.COLLECT_ONLY);
        log.debug("Entering DlgcXPlayer:;sendCollectMsg setting player detector mode to Collect Only");
        DlgcMediaGroup mg = (DlgcMediaGroup)this.getContainer();
        DlgcXNetworkConnection ncx = (DlgcXNetworkConnection)mg.joinedWithNetworkConnection();
        String dialogTarget = null;
        boolean workingWithMixer = false;
        if (ncx instanceof NetworkConnection) {
            dialogTarget = mg.joinedWithNetworkConnection().getDlgIpmsSession().calculateDialogTargetField();
        } else {
            workingWithMixer = true;
            dialogTarget = mg.joinedWithMixer().getConfId();
        }
        String dlgName = DlgcIpmsSession.getNewDialogName();
        log.debug("DlgcXPlayer::sendCollectMsg - dialogTarget: " + dialogTarget);
        DlgcSignalDetector sd = this.mySignalDetectorFSM.getSignalDetector();
        String requestStr = DlgcSipServlet.getProtocolBridge().createCollectMsg(dialogTarget, dlgName, numOfSignals, pattern, (DlgcParameters)parameters, bargeEnabled, sd.isClearBufferFlag());
        sd.setClearBufferFlag(false);
        DlgcSipMessage message = new DlgcSipMessage((JoinableContainer)this.container, "INFO", null, "msml", requestStr, dialogTarget);
        message.dialogName = dlgName;
        ncx.sendMediaMessage(message, this);
        this.setState(ACTIVATING);
    }

    @Override
    public void sendStopMsg(boolean stopAll) {
        try {
            if (stopAll) {
                DlgcPlayer.DlgcPlayRequest request;
                while ((request = (DlgcPlayer.DlgcPlayRequest)this.requestQueue.poll()) != null) {
                    this.stoppedQueue.add(request);
                }
            }
            DlgcMediaGroup mg = (DlgcMediaGroup)this.getContainer();
            DlgcIpmsSession sess = mg.joinedWithNetworkConnection().getDlgIpmsSession();
            String dialogTarget = sess.calculateDialogTargetField();
            log.debug("IN DlgcXPlayer::sendStopMsg... calling removeActiveResourceId");
            String fullDialogId = sess.removeActiveResourceId(this.getResourceId());
            String request = DlgcSipServlet.getProtocolBridge().createStopMsg(fullDialogId);
            mg.joinedWithNetworkConnection().getDlgIpmsSession().addRequest("stop");
            DlgcSipMessage message = new DlgcSipMessage((JoinableContainer)this.container, "INFO", null, "msml", request, dialogTarget);
            this.sendSipMessage(message);
            log.debug("OUT DlgcXPlayer::sendStopMsg...");
        }
        catch (DlgcProtocolException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processSipInfoRequest(MsmlDocument.Msml message, DlgcSipConnectorContentIdsProxy proxy) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "ENTER DLgcPlayer:: processSipInfoRequest mediaServer Message ");
        DlgcMediaGroup mg = (DlgcMediaGroup)this.getContainer();
        if (message != null) {
            log.debug("DlgcXPlayer:: processSipInfoRequest mediaServer Message = " + message.toString());
            if (this.mySignalDetectorFSM != null) {
                log.debug("DLgcXPlayer:: processSipInfoRequest mySignalDetectorFSM not null  Message ");
                try {
                    String eventName = new String("undefine");
                    MsmlDocument.Msml.Event msmlEvent = message.getEvent();
                    if (msmlEvent != null) {
                        eventName = msmlEvent.getName2();
                    } else {
                        log.error(appLogId + "MSML EVENT IS NULL");
                    }
                    if (eventName.equalsIgnoreCase("msml.dialog.exit")) {
                        this.mySignalDetectorFSM.evSipInfo(message);
                        this.mySignalDetectorFSM = null;
                        ((DlgcPlayerState)this.getState()).playCollectCmpltEvent(this);
                    } else if (eventName.equalsIgnoreCase("noInput")) {
                        this.mySignalDetectorFSM.evSipInfo(message);
                    } else if (eventName.equalsIgnoreCase("noMatch")) {
                        this.mySignalDetectorFSM.evSipInfo(message);
                    } else if (eventName.contains("matchFound")) {
                        this.mySignalDetectorFSM.evSipInfo(message);
                    }
                }
                catch (MsControlException ex) {
                    this.mySignalDetectorFSM = null;
                    log.error(appLogId + "processSipInfoRequest fail for playCollect due to : ", (Throwable)ex);
                }
            } else if (this.sigGenObj != null) {
                log.debug("TO BE DEFINE FOR SIGNAL GENERATOR FOR MSML");
            } else {
                String eventName = new String("undefine");
                String eventValue = null;
                MsmlDocument.Msml.Event msmlEvent = message.getEvent();
                if (msmlEvent != null) {
                    eventName = msmlEvent.getName2();
                    List eventValueList = msmlEvent.getValueList();
                    if (eventValueList.size() >= 2) {
                        eventValue = (String)eventValueList.get(1);
                    }
                } else {
                    log.error(appLogId + "MSML EVENT IS NULL");
                }
                if (eventName.equalsIgnoreCase("PlayCompleted")) {
                    DlgcNetworkConnection theNC;
                    log.debug(appLogId + "PlayCompleted Event received create and que up event");
                    DlgcPlayerEvent event = new DlgcPlayerEvent(message, this);
                    if (null != eventValue && eventValue.equalsIgnoreCase("play.terminate")) {
                        log.debug("PlayCompleted Setting Qualifier to PlayerEvent.STOPPED");
                        event.setQualifier(PlayerEvent.STOPPED);
                    } else if (null != eventValue && eventValue.equalsIgnoreCase("play.complete.maxtime")) {
                        log.debug("PlayCompleted Setting Qualifier to PlayerEvent.DURATION_EXCEEDED");
                        event.setQualifier(PlayerEvent.DURATION_EXCEEDED);
                    }
                    if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                        DlgcSync2AsyncMonitor monitor = this.getMonitor();
                        if (monitor == null) {
                            log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayCmpltEvent:stop Player Stop in a synchronous mode but note DlgcSync2AsyncMonitor is NULL");
                        } else {
                            boolean bStatus = true;
                            log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayCmpltEvent:stop calling Monitor notifyRequestCompleted");
                            monitor.notifyRequestCompleted(bStatus, "Player Stopped");
                            log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayCmpltEvent:stop returned from Monitor notifyRequestCompleted");
                        }
                    }
                    if ((theNC = mg.joinedWithNetworkConnection()) == null) {
                        log.debug("DlgcXPlayer::processSipInfoRequest can't store PlayCompleted Event since NC is NULL...not good");
                    } else {
                        DlgcIpmsSession dss = theNC.getDlgIpmsSession();
                        if (dss == null) {
                            log.debug("DlgcXPlayer::processSipInfoRequest can't store PlayCompleted Event since NC DlgcIpmsSession is NULL...not good");
                        } else {
                            log.debug("DlgcXPlayer::processSipInfoRequest Storing Request PlayCompleted Event based on DlgcIpmsSession: " + dss.toDebug());
                            dss.addRequest(event);
                        }
                    }
                } else if (eventName.equalsIgnoreCase("msml.dialog.exit")) {
                    DlgcMediaEvent event;
                    DlgcNetworkConnection theNC;
                    log.debug(appLogId + "Receive Dialog Exit Event");
                    DlgcMsmlDialogEventExitStatus dlgExitEventStatus = DlgcMsmlProtocolMessageMappingAssistance.getExitDialogEventStatus(message);
                    if (dlgExitEventStatus.status == null) {
                        theNC = mg.joinedWithNetworkConnection();
                        event = null;
                        if (theNC == null) {
                            log.debug("DlgcXPlayer::processSipInfoRequest can't Remove Event since NC is NULL...not good");
                        } else {
                            DlgcIpmsSession dss = theNC.getDlgIpmsSession();
                            if (dss == null) {
                                log.debug("DlgcXPlayer::processSipInfoRequest can't  Remove Event since NC DlgcIpmsSession is NULL...not good");
                            } else {
                                log.debug("DlgcXPlayer::processSipInfoRequest Remove Event based on DlgcIpmsSession: " + dss.toDebug());
                                event = (DlgcPlayerEvent)dss.removeEvent();
                            }
                        }
                        if (event == null) {
                            log.error("DlgcXPlayer:: Major Error the pending event is NULL cant generate Play Completed Event");
                        } else if (event.getEventType().equals(PlayerEvent.PLAY_COMPLETED)) {
                            log.debug("DlgcXPlayer:: Found Play Complete Pending Event getting ready to deliver it to application");
                            try {
                                if (null == ((DlgcResourceEvent)event).getQualifier() || ((DlgcResourceEvent)event).getQualifier().equals(PlayerEvent.NO_QUALIFIER)) {
                                    ((DlgcResourceEvent)event).setQualifier(PlayerEvent.END_OF_PLAY_LIST);
                                }
                                String state = ((DlgcPlayerState)this.getState()).getName();
                                log.debug("DlgcXPlayer:: State ready to call playCompleteEvent: " + state);
                                ((DlgcPlayerState)this.getState()).playCmpltEvent(this, (DlgcPlayerEvent)event);
                            }
                            catch (MsControlException e) {
                                e.printStackTrace();
                            }
                        } else {
                            log.debug(appLogId + "MSML Dialog EXIT Play Event is not of Play Completed Event...doing nothing");
                        }
                    } else {
                        theNC = mg.joinedWithNetworkConnection();
                        if (theNC == null) {
                            log.debug("DlgcXPlayer::processSipInfoRequest can't Remove Event since NC is NULL...not good");
                        } else {
                            DlgcIpmsSession dss = theNC.getDlgIpmsSession();
                            if (dss == null) {
                                log.debug("DlgcXPlayer::processSipInfoRequest can't  Remove Event since NC DlgcIpmsSession is NULL...not good");
                            } else {
                                log.debug("DlgcXPlayer::processSipInfoRequest Remove Event based on DlgcIpmsSession: " + dss.toDebug());
                                dss.removeEvent();
                            }
                        }
                        event = new DlgcPlayerEvent(message, this);
                        event.setErrorText(dlgExitEventStatus.description);
                        if (null != eventValue && eventValue.contains("[play]: 3 No file found for audio uri: error")) {
                            ((DlgcResourceEvent)event).setQualifier(PlayerEvent.NO_QUALIFIER);
                            event.setError(MediaErr.NOT_FOUND);
                        } else if (null != eventValue && eventValue.contains("[play]: 1 Unknown uri scheme")) {
                            ((DlgcResourceEvent)event).setQualifier(PlayerEvent.NO_QUALIFIER);
                            event.setError(MediaErr.BAD_ARG);
                        } else {
                            event.setError(MediaErr.RESOURCE_UNAVAILABLE);
                        }
                        event.setEventType(PlayerEvent.PLAY_COMPLETED);
                        try {
                            ((DlgcPlayerState)this.getState()).playCmpltEvent(this, (DlgcPlayerEvent)event);
                        }
                        catch (MsControlException e) {
                            e.printStackTrace();
                        }
                    }
                    if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                        DlgcSync2AsyncMonitor monitor = this.getMonitor();
                        if (monitor == null) {
                            log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayCmpltEvent:stop Player Stop in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
                        } else {
                            boolean bStatus = true;
                            log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayCmpltEvent:stop calling Monitor notifyRequestCompleted");
                            monitor.notifyRequestCompleted(bStatus, "Player Stopped");
                            log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayCmpltEvent:stop returned from Monitor notifyRequestCompleted");
                        }
                    }
                } else {
                    log.debug(appLogId + "Expecting msml dialog exit but eventName is not of this type...doing nothing");
                }
            }
        }
    }

    @Override
    public void processPlayCmpltEvent(DlgcPlayerEvent event) {
        DlgcMediaGroup mg;
        DlgcNetworkConnection nc;
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        boolean dueToAStopRequest = false;
        log.debug(appLogId + "Entering DlgcXPlayer::processPlayCmpltEvent");
        this.setState(IDLE);
        log.debug("DlgcXPlayer::processPlayCompltEvent: event: " + event.getEventType().toString() + " Qualifier: " + event.getQualifier().toString());
        if (event.getQualifier().equals(PlayerEvent.STOPPED)) {
            if (!DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                while (this.stoppedQueue.poll() != null) {
                    DlgcPlayerEvent stoppedRequestEvent = event;
                    stoppedRequestEvent.setQualifier(PlayerEvent.STOPPED);
                    stoppedRequestEvent.setOffset(0);
                    dueToAStopRequest = true;
                    this.postMediaEvent(stoppedRequestEvent);
                }
            }
        } else {
            DlgcPlayer.DlgcPlayRequest request = (DlgcPlayer.DlgcPlayRequest)this.requestQueue.poll();
            if (request != null) {
                try {
                    this.play(request.streamIds, request.rtcs, request.parameters);
                }
                catch (MsControlException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((nc = (mg = (DlgcMediaGroup)this.getContainer()).joinedWithNetworkConnection()) instanceof MediaMixer) {
            log.debug(appLogId + "DlgcXPlayer::Received Player Complete nc leg is a mediaMixer control leg sending event up to application");
            this.postMediaEvent(event);
        } else if (nc != null) {
            String ncState = nc.getPresentState();
            log.debug(appLogId + "DlgcXPlayer::Received Player Play Stop NC State Present State= " + ncState);
            if (ncState.compareTo("DlgcXParkedState") != 0) {
                log.debug(appLogId + "DlgcXPlayer::Received Player Play Stop and calling application play stop listener");
                nc.unpark();
                log.debug("DlgcXPlayer::processPlayCompltEvent: event: SENDING EVENT: " + event.getEventType().toString() + " Qualifier: " + event.getQualifier().toString());
                this.postMediaEvent(event);
            } else {
                log.debug(appLogId + "DlgcXPlayer::Received Player Play Stop and DELAYING calling application play stop listener until back in conference");
                DlgcIpmsSession dlgsession = mg.joinedWithNetworkConnection().getDlgIpmsSession();
                dlgsession.getSipSession().setAttribute("DlgcPlayerEvent", (Object)event);
                dlgsession.getSipSession().setAttribute("DlgcPlayer", (Object)this);
                nc.unpark();
            }
        } else {
            log.warn(appLogId + "MG Player not joined with Network connection");
        }
        if (mg.getActiveResources() > 0) {
            log.debug("DlgcXPlayer::processPlayCmpltEvent - calling media group resourceStopNotifier(PLAYER) ");
            mg.resourceStopNotifier("PLAYER");
        } else if (DlgcInstrumentPropertyMgr.bSync309ApiSupport && dueToAStopRequest) {
            DlgcSync2AsyncMonitor monitor = this.getMonitor();
            if (monitor == null) {
                log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayCmpltEvent:running Player Stop in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
            } else {
                boolean bStatus = true;
                log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayCmpltEvent:stop calling Monitor notifyRequestCompleted");
                monitor.notifyRequestCompleted(bStatus, "Player Stopped");
                log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayCmpltEvent:stop returned from Monitor notifyRequestCompleted");
            }
        }
    }

    @Override
    public void processPlayAckMsg(SipServletResponse sipResponse) {
        log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayAckMsg Entering with response: " + sipResponse.toString());
        int responseStatus = sipResponse.getStatus();
        MsmlDocument.Msml message = null;
        DlgcPlayerEvent event = new DlgcPlayerEvent(message, this);
        message = this.extractMsmlResponseMessage(sipResponse);
        String msgResponse = null;
        boolean responseError = false;
        try {
            msgResponse = message.getResult().getResponse();
            if (msgResponse != null && msgResponse.compareToIgnoreCase("200") != 0) {
                responseError = true;
            }
        }
        catch (Exception e) {
            log.debug(e.toString());
        }
        if (!DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            log.debug("Handling Player Play Acknowledge (start) asynchronous");
            if (responseStatus == 200 && !responseError) {
                this.setState(ACTIVE);
                event.setEventType(PlayerEvent.RESUMED);
                event.setError(MediaErr.NO_ERROR);
                event.setErrorText("No error - the play command has started");
                if (!this.isTCKEnabled()) {
                    this.postMediaEvent(event);
                }
            } else {
                this.setState(IDLE);
                event.setEventType(PlayerEvent.PLAY_COMPLETED);
                event.setQualifier(PlayerEvent.NO_QUALIFIER);
                event.setError(MediaErr.REFUSED);
                if (!responseError) {
                    event.setErrorText("Media Server info response with error to a Play request: Internal Status: " + new Integer(responseStatus).toString());
                } else {
                    event.setErrorText("Media Server info response with error to a Play request:  " + message);
                }
                this.postMediaEvent(event);
            }
        } else {
            String sStatus;
            DlgcSync2AsyncMonitor monitor = null;
            boolean bStatus = false;
            if (this.playerDetectorMode == PLAYER_DETECTOR_MODE.COLLECT_ONLY) {
                log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayAckMsg Handling Collect Acknowledge (start) in synchronous way");
            } else if (this.playerDetectorMode == PLAYER_DETECTOR_MODE.PLAY_AND_COLLECT) {
                log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayAckMsg Handling Play and Collect Acknowledge (start) in synchronous way");
            } else {
                log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayAckMsg Handling Play Acknowledge (start) in synchronous way");
            }
            if (responseStatus == 200 && !responseError) {
                if (this.playerDetectorMode == PLAYER_DETECTOR_MODE.COLLECT_ONLY) {
                    sStatus = "Detector Collect Request Started";
                    log.debug(sStatus);
                    DlgcSigDetectorFSM sdFSM = this.getAssociatedSignalDetectorFSM();
                    DlgcSignalDetector sd = sdFSM.getSignalDetector();
                    monitor = sd.getMonitor();
                } else if (this.playerDetectorMode == PLAYER_DETECTOR_MODE.PLAY_AND_COLLECT) {
                    sStatus = "Detector Play And Collect Request Started";
                    log.debug(sStatus);
                    DlgcSigDetectorFSM sdFSM = this.getAssociatedSignalDetectorFSM();
                    DlgcSignalDetector sd = sdFSM.getSignalDetector();
                    monitor = sd.getMonitor();
                } else {
                    sStatus = "Player Play Started";
                    log.debug(sStatus);
                    monitor = this.getMonitor();
                }
                bStatus = true;
                this.setState(ACTIVE);
            } else if (this.playerDetectorMode == PLAYER_DETECTOR_MODE.COLLECT_ONLY) {
                sStatus = "Detector Collect Request Fail to Start";
                log.debug(sStatus);
                DlgcSigDetectorFSM sdFSM = this.getAssociatedSignalDetectorFSM();
                DlgcSignalDetector sd = sdFSM.getSignalDetector();
                monitor = sd.getMonitor();
            } else if (this.playerDetectorMode == PLAYER_DETECTOR_MODE.PLAY_AND_COLLECT) {
                sStatus = "Detector Play And Collect Request Fail to Start";
                log.debug(sStatus);
                DlgcSigDetectorFSM sdFSM = this.getAssociatedSignalDetectorFSM();
                DlgcSignalDetector sd = sdFSM.getSignalDetector();
                monitor = sd.getMonitor();
            } else {
                sStatus = "Player Play Fail to start: " + message.getResult().getResponse();
                log.debug(sStatus);
                monitor = this.getMonitor();
            }
            if (monitor == null) {
                log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayAckMsg found Player Play in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
            } else {
                log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayAckMsg calling Monitor notifyRequestCompleted");
                monitor.notifyRequestCompleted(bStatus, sStatus);
                log.debug("SYNC_2_ASYNC DlgcXPlayer::processPlayAckMsg returned from Monitor notifyRequestCompleted");
            }
        }
    }

    protected boolean isTCKEnabled() {
        String tckFlag = System.getenv("TCK_ENABLED");
        log.debug("Value of TCK_ENABLED flag is :" + tckFlag);
        boolean isTCKEnabled = false;
        if (null == tckFlag || tckFlag.equalsIgnoreCase("NO")) {
            log.warn("Environment Variable: " + "TCK_ENABLED" + " not set");
            log.warn("Assuming TCK is not enabled");
            isTCKEnabled = false;
        } else if (tckFlag.equalsIgnoreCase("YES")) {
            isTCKEnabled = true;
        }
        log.debug("Value of TCK_ENABLED flag is :" + isTCKEnabled);
        return isTCKEnabled;
    }

    @Override
    public void handlePlayInfoResponse(SipServletResponse sipResponse) {
        int responseStatus = sipResponse.getStatus();
        log.debug("SYNC_2_ASYNC Entering DlgcXPlayer::handlePlayInfoResponse");
        MsmlDocument.Msml requestMessage = this.extractMsmlResonseRequestMessage(sipResponse);
        MsmlDocument.Msml message = this.extractMsmlResponseMessage(sipResponse);
        boolean responseError = false;
        String msgResponse = null;
        try {
            msgResponse = message.getResult().getResponse();
            if (msgResponse != null && msgResponse.compareToIgnoreCase("200") != 0) {
                log.debug("handlePlayInfoResponse:: MSML response status: " + msgResponse.toString());
                log.debug("handlePlayInfoResponse:: MSML message: " + message.toString());
                responseError = true;
            }
        }
        catch (Exception e) {
            log.debug(e.toString());
        }
        try {
            MsmlDocument.Msml.Dialogstart dlg = requestMessage.getDialogstartArray(0);
            String s = dlg.toString();
            String[] a = s.split("<play ");
            if (null != a && a.length > 1) {
                try {
                    ((DlgcPlayerState)this.getState()).playAckMsg(this, sipResponse);
                }
                catch (MsControlException e) {
                    e.printStackTrace();
                    log.error(e.toString());
                }
            } else {
                log.debug("It should never get here...");
            }
        }
        catch (Exception e) {
            if (responseStatus == 200 && !responseError) {
                log.debug("handlePlayInfoResponse:: calling stopAckMsg() sipResponse = OK and no MSML error");
            } else {
                log.debug("handlePlayInfoResponse:: calling stopAckMsg() sipResponse = OK but with MSML error: " + msgResponse.toString());
            }
            try {
                ((DlgcPlayerState)this.getState()).stopAckMsg(this, null);
                if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                    DlgcSync2AsyncMonitor monitor = this.getMonitor();
                    if (monitor == null) {
                        log.error("SYNC_2_ASYNC DlgcXPlayer::handlePlayInfoResponse:stop Major error running Player Stop in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
                    } else {
                        boolean bStatus = true;
                        String sStatus = "Stop Play Successful";
                        log.debug("SYNC_2_ASYNC DlgcXPlayer::handlePlayInfoResponse:stop calling Monitor notifyRequestCompleted");
                        monitor.notifyRequestCompleted(bStatus, "Player Stopped");
                        log.debug("SYNC_2_ASYNC DlgcXPlayer::handlePlayInfoResponse:stop returned from Monitor notifyRequestCompleted");
                    }
                }
            }
            catch (MsControlException ex) {
                log.error(ex.toString());
                e.printStackTrace();
            }
        }
        log.debug("Leaving DlgcXPlayer::handlePlayInfoResponse");
    }

    public void setDetectorMode(PLAYER_DETECTOR_MODE mode) {
        this.playerDetectorMode = mode;
    }

    public PLAYER_DETECTOR_MODE getDetectorMode() {
        return this.playerDetectorMode;
    }

    public static enum PLAYER_DETECTOR_MODE {
        NONE,
        PLAY_AND_COLLECT,
        COLLECT_ONLY;

    }
}

