/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mediagroup;

import com.vendor.dialogic.javax.media.mscontrol.DlgcSupportedFeatures;
import com.vendor.dialogic.javax.media.mscontrol.DlgcXMediaConfig;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXRecorder;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcXSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcXSignalGenerator;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.mediagroup.MediaGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcXMediaGroupConfig
extends DlgcXMediaConfig {
    private DlgcSupportedFeatures supportedFeatures = new DlgcSupportedFeatures();
    private static Logger log = LoggerFactory.getLogger(DlgcXMediaGroupConfig.class);

    public DlgcXMediaGroupConfig() {
    }

    public DlgcXMediaGroupConfig(Configuration<MediaGroup> mgConf) {
        if (mgConf == MediaGroup.PLAYER) {
            this.myConfiguration = MediaGroup.PLAYER;
            this.resourceList.add(DlgcXPlayer.class);
            this.loadMediaGroupFeatures(mgConf);
        } else if (mgConf == MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR) {
            this.myConfiguration = MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR;
            this.resourceList.add(DlgcXPlayer.class);
            this.resourceList.add(DlgcXRecorder.class);
            this.resourceList.add(DlgcXSignalDetector.class);
            this.loadMediaGroupFeatures(mgConf);
        } else if (mgConf == MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR_SIGNALGENERATOR) {
            this.myConfiguration = MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR_SIGNALGENERATOR;
            this.resourceList.add(DlgcXPlayer.class);
            this.resourceList.add(DlgcXRecorder.class);
            this.resourceList.add(DlgcXSignalDetector.class);
            this.resourceList.add(DlgcXSignalGenerator.class);
            this.loadMediaGroupFeatures(mgConf);
        } else if (mgConf == MediaGroup.PLAYER_SIGNALDETECTOR) {
            this.myConfiguration = MediaGroup.PLAYER_SIGNALDETECTOR;
            this.resourceList.add(DlgcXPlayer.class);
            this.resourceList.add(DlgcXSignalDetector.class);
            this.loadMediaGroupFeatures(mgConf);
        } else if (mgConf == MediaGroup.SIGNALDETECTOR) {
            this.myConfiguration = MediaGroup.SIGNALDETECTOR;
            this.resourceList.add(DlgcXSignalDetector.class);
            this.loadMediaGroupFeatures(mgConf);
        } else {
            log.error("The Media Group Configuration is recognized");
        }
    }

    public static DlgcXMediaConfig configurationInstance(Configuration<MediaGroup> predefinedConfig) {
        return new DlgcXMediaGroupConfig(predefinedConfig);
    }

    public DlgcSupportedFeatures loadSupportedFeatures() {
        return this.supportedFeatures;
    }

    public void loadMediaGroupFeatures(Configuration<MediaGroup> mgConf) {
        if (mgConf == MediaGroup.PLAYER) {
            DlgcXPlayer.loadSupportedFeatures(this.supportedFeatures);
        } else if (mgConf == MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR) {
            DlgcXPlayer.loadSupportedFeatures(this.supportedFeatures);
            DlgcXSignalDetector.loadSupportedFeatures(this.supportedFeatures);
            DlgcXRecorder.loadSupportedFeatures(this.supportedFeatures);
        } else if (mgConf == MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR_SIGNALGENERATOR) {
            DlgcXPlayer.loadSupportedFeatures(this.supportedFeatures);
            DlgcXSignalDetector.loadSupportedFeatures(this.supportedFeatures);
            DlgcXRecorder.loadSupportedFeatures(this.supportedFeatures);
            DlgcXSignalGenerator.loadSupportedFeatures(this.supportedFeatures);
        } else if (mgConf == MediaGroup.PLAYER_SIGNALDETECTOR) {
            DlgcXPlayer.loadSupportedFeatures(this.supportedFeatures);
            DlgcXSignalDetector.loadSupportedFeatures(this.supportedFeatures);
        } else if (mgConf == MediaGroup.SIGNALDETECTOR) {
            DlgcXSignalDetector.loadSupportedFeatures(this.supportedFeatures);
        }
    }
}

