/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mediagroup;

import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcXMediaConfig;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXRecorder;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcXSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcXSignalGenerator;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventNotifier;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.Recorder;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.mediagroup.signals.SignalGenerator;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.resource.Resource;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcXMediaGroup
extends DlgcMediaGroup {
    private static final long serialVersionUID = 2122938102837498L;
    private static Logger log = LoggerFactory.getLogger(DlgcXMediaGroup.class);
    private MGState mgState = MGState.INITIAL_STATE;

    public DlgcXMediaGroup(MediaConfig cfg, MediaSession ms, Parameters params) {
        super(cfg, ms, params, "XMG-");
        this.initMediaGroupResourceTypes(cfg, params);
    }

    @Override
    protected void initMediaGroupResourceTypes(MediaConfig cfg, Parameters params) {
        Iterator<Class<?>> iter = ((DlgcXMediaConfig)cfg).getResourceList();
        while (iter.hasNext()) {
            try {
                Class<?> resourceClass = iter.next();
                Constructor<?> ctr = resourceClass.getConstructor(MediaGroup.class);
                Resource resource = (Resource)ctr.newInstance(this);
                this.resourceMap.put(resourceClass, resource);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.setDefaultParameters(this.getDefaultParameters());
        Parameters customCloneParams = ((DlgcXMediaConfig)cfg).getCustomCloneParams();
        if (null != customCloneParams && !customCloneParams.isEmpty()) {
            if (params != null) {
                params.putAll((Map)customCloneParams);
            } else {
                params = new DlgcParameters();
                params.putAll((Map)customCloneParams);
            }
        }
        if (params != null) {
            this.setParameters(params);
        }
    }

    @Override
    public void setParameters(Parameters params) {
        Set paramSet = params.entrySet();
        Iterator paramIt = paramSet.iterator();
        Map.Entry pair = null;
        Parameters nonSignalTableParams = this.createParameters();
        while (paramIt.hasNext()) {
            pair = (Map.Entry)paramIt.next();
            if (DlgcSignalDetector.SignalConstantNameTable.containsKey(((Parameter)pair.getKey()).toString())) {
                DlgcSignalDetector.SignalConstantNameTable.put(((Parameter)pair.getKey()).toString(), pair.getValue().toString());
                continue;
            }
            nonSignalTableParams.put(pair.getKey(), pair.getValue());
        }
        if (!nonSignalTableParams.isEmpty()) {
            super.setParameters(nonSignalTableParams);
        }
    }

    @Override
    public Player getPlayer() throws MsControlException {
        return this.getResource(DlgcXPlayer.class);
    }

    @Override
    public Recorder getRecorder() throws MsControlException {
        return this.getResource(DlgcXRecorder.class);
    }

    @Override
    public SignalDetector getSignalDetector() throws MsControlException {
        return this.getResource(DlgcXSignalDetector.class);
    }

    @Override
    public SignalGenerator getSignalGenerator() throws MsControlException {
        return this.getResource(DlgcXSignalGenerator.class);
    }

    @Override
    public void processSipBye(SipServletRequest request) {
        log.debug("XMS DlgcXMediaGroup::processSipBye(request) TO DO");
    }

    @Override
    public void processSipBye(SipServletResponse response) {
        log.debug("XMS DlgcXMediaGroup::processSipBye TO DO");
    }

    @Override
    public void processSipInvite(SipServletRequest request) {
        log.debug("XMS DlgcXMediaGroup::processSipInvite TO DO");
    }

    @Override
    public void processSipInvite(SipServletResponse response) {
        log.debug("XMS DlgcXMediaGroup::processSipInvite TO DO");
    }

    @Override
    public void processSipInfo(SipServletResponse response, DlgcSipConnectorContentIdsProxy proxy) {
        log.debug("XMS DlgcXMediaGroup::processSipInfo calling parent class");
        super.processSipInfo(response, proxy);
        log.debug("Leaving XMS DlgcXMediaGroup::processSipInfo");
    }

    public void sendRecordMessage(DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
        try {
            Joinable[] joinableArray;
            for (Joinable j : joinableArray = this.getJoinees()) {
                DlgcXMediaMixer mx;
                if (j instanceof NetworkConnection) {
                    DlgcNetworkConnection nc = (DlgcNetworkConnection)j;
                    this.setMGState(MGState.RECORDING_STATE);
                    nc.sendMediaMessage(message, notifier);
                    continue;
                }
                if (!(j instanceof MediaMixer) || !(mx = (DlgcXMediaMixer)j).getMixerState().startRecording(mx, message, notifier)) continue;
                this.setMGState(MGState.RECORDING_STATE);
            }
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    public MGState getMGState() {
        return this.mgState;
    }

    public void setMGState(MGState s) {
        this.mgState = s;
    }

    public static enum MGState {
        INITIAL_STATE{

            @Override
            public void play(DlgcXMediaGroup mg) {
            }

            @Override
            public void record(DlgcXMediaGroup mg, DlgcSipMessage msg, DlgcXRecorder rec) {
                mg.sendRecordMessage(msg, rec);
            }
        }
        ,
        PLAYING_STATE{

            @Override
            public void stopPlaying(DlgcXMediaGroup mg) {
            }
        }
        ,
        STOPPING_PLAY_STATE{}
        ,
        RECORDING_STATE{

            @Override
            public void stopRecording(DlgcXMediaGroup mg) {
            }
        }
        ,
        STOPPING_RECORD_STATE{};


        public void record(DlgcXMediaGroup mg, DlgcSipMessage msg, DlgcXRecorder rec) {
            log.debug("XMS DlgcXMediaGroup record not allowed in this state.");
        }

        public void stopRecording(DlgcXMediaGroup mg) {
            log.debug("XMS DlgcXMediaGroup stopRecording not allowed in this state.");
        }

        public void play(DlgcXMediaGroup mg) {
            log.debug("XMS DlgcXMediaGroup play not allowed in this state.");
        }

        public void stopPlaying(DlgcXMediaGroup mg) {
            log.debug("XMS DlgcXMediaGroup stopPlaying not allowed in this state.");
        }
    }
}

