/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mediagroup;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynCallbackImpl;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynDispatcher;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcRecorder;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXRecorder;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import java.io.Serializable;
import java.net.URI;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.UnsupportedException;
import javax.media.mscontrol.join.JoinException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.Recorder;
import javax.media.mscontrol.mediagroup.RecorderEvent;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.RTC;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcRecorderProxy
extends DlgcProxy
implements Recorder,
Serializable {
    private static final long serialVersionUID = 1111000009282737L;
    private static Logger log = LoggerFactory.getLogger(DlgcRecorderProxy.class);

    public DlgcRecorderProxy(String id, String mediaSessionId, String msObjId) {
        super(id, mediaSessionId, msObjId);
    }

    public void record(URI arg0, RTC[] arg1, Parameters arg2) throws MsControlException {
        log.debug("DlgcRecorderProxy::record  using recordAsync");
        boolean validRtc = false;
        if (null != arg1 && arg1.length > 0) {
            for (int i = 0; i < arg1.length; ++i) {
                Action a = arg1[i].getAction();
                if (a != MediaGroup.SIGDET_STOPPLAY.getAction() && a != MediaGroup.SIGDET_STOPRECORD.getAction()) continue;
                validRtc = true;
                break;
            }
        }
        if (null != arg1 && arg1.length > 0) {
            if (arg1[0].getAction() == Player.STOP && arg1[0].getTrigger() == Player.PLAY_START) {
                throw new UnsupportedException("Recorder : RTC combination RTC(Player.PLAY_START, Player.STOP) is not supported.");
            }
            if (!(arg1.length == 2 && arg1[0].getAction() == Recorder.STOP && arg1[0].getTrigger() == SignalDetector.DETECTION_OF_ONE_SIGNAL && arg1[1] == MediaGroup.SIGDET_STOPPLAY || validRtc)) {
                throw new MsControlException("Recorder : RTC is not supported in this version of the connector.");
            }
        }
        this.recordAsync(arg0, arg1, arg2);
    }

    public void recordAsync(final URI arg0, final RTC[] arg1, final Parameters arg2) throws MsControlException {
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("Recorder:Recorder Request");
            String sasId = this.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        Recorder recorder = mg.getRecorder();
                        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                            ((DlgcXRecorder)recorder).setMonitor(monitor);
                        }
                        recorder.record(arg0, arg1, arg2);
                        DlgcRecorderProxy pproxy = ((DlgcRecorder)recorder).getProxy();
                        pproxy.saveMediaSession(appSession, session);
                    }
                    catch (MsControlException e) {
                        // empty catch block
                    }
                }
            });
            if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("SYNC_2_ASYNC recordAsync:: OUTSIDE Waiting synchronously for Recorder record request to return");
                monitor.waitForRequestCompletion();
                log.debug("SYNC_2_ASYNC recordAsync: OUTSIDE Recorder Monitor returned with the following status: " + monitor.getStatusString());
                boolean status = monitor.getStatus();
                String statusMsg = monitor.getStatusString();
                DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS extype = monitor.getExceptionType();
                DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                ((DlgcXRecorder)mg.getRecorder()).setMonitor(null);
                if (!status) {
                    if (extype.compareTo(DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS.JOIN_EXCEPTION) == 0) {
                        log.debug("DlgcRecorderProxy-Exception ... executing Monitor Notify JOIN method");
                        throw new JoinException(statusMsg);
                    }
                    if (extype.compareTo(DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS.UNSUPPORTED_EXCEPTION) == 0) {
                        log.debug("DlgcRecorderProxy-Exception ... executing Monitor Notify UNSUPPORTED method");
                        throw new UnsupportedException(statusMsg);
                    }
                    log.debug("DlgcRecorderProxy-Exception ... executing Monitor Notify MsControl method");
                    throw new MsControlException(statusMsg);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof UnsupportedException) {
                throw new UnsupportedException(e.getMessage());
            }
            if (e instanceof JoinException) {
                throw new JoinException(e.getMessage());
            }
            throw new MsControlException(e.getMessage());
        }
    }

    public void stop() {
        log.debug("DlgcRecorderProxy::record  using recordAsync");
        this.stopAsync();
    }

    public void stopAsync() {
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("Recorder:Stop Request");
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        Recorder recorder = mg.getRecorder();
                        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                            ((DlgcXRecorder)recorder).setMonitor(monitor);
                        }
                        recorder.stop();
                        DlgcRecorderProxy pproxy = ((DlgcRecorder)recorder).getProxy();
                        pproxy.saveMediaSession(appSession, session);
                    }
                    catch (MsControlException e) {
                        e.printStackTrace();
                    }
                }
            });
            if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("SYNC_2_ASYNC stopAsync:: OUTSIDE Waiting synchronously for Recorder Stop request to return");
                monitor.waitForRequestCompletion();
                log.debug("SYNC_2_ASYNC Player: OUTSIDE Recorder Stop Monitor returned with the following status: " + monitor.getStatusString());
                DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                ((DlgcXRecorder)mg.getRecorder()).setMonitor(null);
            }
        }
        catch (Exception e) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.error(appLogId + "Failed to stop", (Throwable)e);
        }
    }

    public MediaGroup getContainer() {
        DlgcMediaGroup mgImpl = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            mgImpl = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
        }
        catch (Exception e) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.error(appLogId + "Failed to getContainer", (Throwable)e);
        }
        return (MediaGroup)mgImpl.getProxy();
    }

    public void addListener(MediaEventListener<RecorderEvent> arg0) {
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
            Recorder recorder = mg.getRecorder();
            recorder.addListener(arg0);
            DlgcRecorderProxy pproxy = ((DlgcRecorder)recorder).getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.error(appLogId + "Failed to addListener", (Throwable)e);
        }
    }

    public MediaSession getMediaSession() {
        DlgcMediaSession ms = null;
        SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
        String mediaId = this.getMsObjectId();
        try {
            ms = (DlgcMediaSession)appSession.getAttribute(mediaId);
        }
        catch (Exception e) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.error(appLogId + "Failed to GetProxyMediaSession", (Throwable)e);
        }
        return ms.getProxy();
    }

    public void removeListener(MediaEventListener<RecorderEvent> arg0) {
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
            Recorder recorder = mg.getRecorder();
            recorder.removeListener(arg0);
            DlgcRecorderProxy pproxy = ((DlgcRecorder)recorder).getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.error(appLogId + "Failed to removeListener", (Throwable)e);
        }
    }
}

