/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mediagroup;

import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceEvent;
import java.util.Iterator;
import java.util.List;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.mediagroup.Recorder;
import javax.media.mscontrol.mediagroup.RecorderEvent;
import javax.media.mscontrol.resource.ResourceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcRecorderEvent
extends DlgcResourceEvent<Recorder>
implements RecorderEvent {
    private static Logger log = LoggerFactory.getLogger(DlgcRecorderEvent.class);
    int duration = 0;

    public DlgcRecorderEvent(MsmlDocument.Msml message, Recorder source) {
        super(message, source);
        this.setEventType(RecorderEvent.RECORD_COMPLETED);
        DlgcRecorderEvent.getMsmlRecorderEventValues(message, this);
        if (this.reason.equals("Not_found")) {
            this.setError(MediaErr.UNKNOWN_ERROR);
            this.setQualifier(NO_QUALIFIER);
            this.setErrorText("Invalid URI media file target");
        } else if (this.reason.equals("record.terminate")) {
            this.setQualifier(ResourceEvent.STOPPED);
        } else if (this.reason.equals("Error")) {
            this.setError(MediaErr.UNKNOWN_ERROR);
            this.setQualifier(NO_QUALIFIER);
            this.setErrorText("Generic Player Error");
        }
    }

    public DlgcRecorderEvent(MsmlDocument.Msml message, Recorder source, MediaErr error, String errorString) {
        super(message, source);
        this.setEventType(RecorderEvent.RECORD_COMPLETED);
        this.setErrorText(errorString);
        this.setError(error);
    }

    public int getDuration() {
        return this.duration;
    }

    public static void getMsmlRecorderEventValues(MsmlDocument.Msml message, DlgcRecorderEvent recorderEventObj) {
        MsmlDocument.Msml.Event msmlEvent = message.getEvent();
        List nameList = msmlEvent.getNameList();
        List valueList = msmlEvent.getValueList();
        Iterator nameIt = nameList.iterator();
        int index = 0;
        while (nameIt.hasNext()) {
            String name = (String)nameIt.next();
            if (name.compareToIgnoreCase("record.end") == 0) {
                recorderEventObj.reason = (String)valueList.get(index);
            } else if (name.compareToIgnoreCase("record.len") == 0) {
                recorderEventObj.duration = Integer.valueOf((String)valueList.get(index));
            }
            ++index;
        }
    }
}

